# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ChannelName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ALEXA_CHANNEL = "AlexaChannel"
    FACEBOOK_CHANNEL = "FacebookChannel"
    EMAIL_CHANNEL = "EmailChannel"
    KIK_CHANNEL = "KikChannel"
    TELEGRAM_CHANNEL = "TelegramChannel"
    SLACK_CHANNEL = "SlackChannel"
    MS_TEAMS_CHANNEL = "MsTeamsChannel"
    SKYPE_CHANNEL = "SkypeChannel"
    WEB_CHAT_CHANNEL = "WebChatChannel"
    DIRECT_LINE_CHANNEL = "DirectLineChannel"
    SMS_CHANNEL = "SmsChannel"
    LINE_CHANNEL = "LineChannel"
    DIRECT_LINE_SPEECH_CHANNEL = "DirectLineSpeechChannel"

class Key(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Determines which key is to be regenerated
    """

    KEY1 = "key1"
    KEY2 = "key2"

class Kind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates the type of bot service
    """

    SDK = "sdk"
    DESIGNER = "designer"
    BOT = "bot"
    FUNCTION = "function"
    AZUREBOT = "azurebot"

class RegenerateKeysChannelName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    WEB_CHAT_CHANNEL = "WebChatChannel"
    DIRECT_LINE_CHANNEL = "DirectLineChannel"

class SkuName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of SKU.
    """

    F0 = "F0"
    S1 = "S1"

class SkuTier(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the sku tier. This is based on the SKU name.
    """

    FREE = "Free"
    STANDARD = "Standard"
