--TEST--
Symbol: three-byte UTF-8 (☆)
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$canonicalBson = hex2bin('190000000E61000D000000E29886E29886E29886E298860000');
$convertedBson = hex2bin('190000000261000D000000E29886E29886E29886E298860000');
$canonicalExtJson = '{"a": {"$symbol": "☆☆☆☆"}}';
$convertedExtJson = '{"a": "☆☆☆☆"}';

// Canonical BSON -> Native -> Canonical BSON
echo bin2hex(fromPHP(toPHP($canonicalBson))), "\n";

// Canonical BSON -> Canonical extJSON
echo json_canonicalize(toCanonicalExtendedJSON($canonicalBson)), "\n";

// Canonical extJSON -> Canonical BSON
echo bin2hex(fromJSON($canonicalExtJson)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
190000000e61000d000000e29886e29886e29886e298860000
{"a":{"$symbol":"\u2606\u2606\u2606\u2606"}}
190000000e61000d000000e29886e29886e29886e298860000
===DONE===