####################################################################################
#
#
# This script was written by Noam Rathaus
#
# GPLv2
#
# From: Chintan Trivedi [chesschintan@hotmail.com]
# Subject: XSS vulnerability in XOOPS 2.0.5.1
# Date: Sunday 21/12/2003 16:45
#
# Updated: 05/07/2009
# Antu Sanadi <santu@secpod.com>
#
#
#
#
#################################################################################

if(description)
{
  script_id(11962);
  script_bugtraq_id(9269);
  script_version("$Revision: 4341$");
  script_tag(name:"risk_factor", value:"Medium");
  name = "Xoops myheader.php URL Cross Site Scripting Vulnerability";
  script_name(name);

  desc = "
  The weblinks module of XOOPS contains a file named 'myheader.php'
  in /modules/mylinks/ directory. The code of the module insufficently
  filters out user provided data. The URL parameter used by 'myheader.php'
  can be used to insert malicious HTML and/or JavaScript in to the web
  page.

  Solution : Upgrade to the latest version of XOOPS.
  Risk factor : Medium";

  script_description(desc);

  summary = "Detect Xoops myheader.php URL XSS";
  script_summary(summary);

  script_category(ACT_GATHER_INFO);

  script_copyright("This script is Copyright (C) 2003 Noam Rathaus");

  family = "General";
  script_family(family);
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");

xoopsPort = get_http_port(default:80);
if(!xoopsPort){
  exit(0);
}

expRes = raw_string(0x22);

foreach path (make_list("/", "/xoops/htdocs", "/xoops/htdocs/install", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:xoopsPort);
  rcvRes = http_send_recv(port:xoopsPort, data:sndReq);
  if("XOOPS" >< rcvRes)
  {
    sndReq = http_get(item:string(path, "/modules/mylinks/myheader.php?url=" +
                                        "javascript:foo"), port:xoopsPort);
    rcvRes = http_send_recv(port:xoopsPort, data:sndReq);
    if(rcvRes != NULL )
    {
      expRes = string("href=", expRes, "javascript:foo", expRes);
      if(expRes >< rcvRes )
      {
        security_warning(xoopsport);
        exit(0);
      }
    }
  }
}
