###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mp123_player_dos_vuln_lin.nasl 1787 2009-04-20 11:45:02Z apr $
#
# mpg123 Player Denial of Service Vulnerability (Linux).
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900538);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1301");
  script_bugtraq_id(34381);
  script_name("mpg123 Player Denial of Service Vulnerability (Linux)");
  desc = "

  Overview: This host is running mpg123 Player which is prone to denial of
  service vulnerability.

  Vulnerability Insight:
  This flaw is due to integer signedness error in the store_id3_text function
  in the ID3v2 code when processing ID3v2 tags with negative encoding values.

  Impact: Successful exploitation will let the attacker trigger out of bounds
  memory access and thus execute arbitrary code and possibly crash the
  application.

  Impact level: Application

  Affected Software/OS:
  mpg123 Player prior to 1.7.2 on Linux.

  Fix: Update to version 1.7.2
  http://www.mpg123.de/download.shtml

  References:
  http://secunia.com/advisories/34587
  http://www.vupen.com/english/advisories/2009/0936

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High ";

  script_description(desc);
  script_summary("Check for the version of mpg123 Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_mpg123_detect_lin.nasl");
  script_require_keys("mpg123/Linux/Ver");
  exit(0);
}


include("version_func.inc");

mpgVer = get_kb_item("mpg123/Linux/Ver");
if(mpgVer == NULL){
  exit(0);
}

if(version_is_less(version:mpgVer, test_version:"1.7.2")){
  security_hole(0);
}
