###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_hplip_detect_lin.nasl 852 2009-01-23 12:20:29Z jan $
#
# HP Linux Imaging and Printing System Version Detection (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900428);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("HP Linux Imaging and Printing System Version Detection (Linux)");
  desc = "

  Overview: The script detects the version of HP Linux Imaging and Printing 
  System and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set the KB for the version of HP LIP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

hplipPath = find_file(file_name:"hp-setup", file_path:"/", useregex:TRUE,
                      regexpar:"$", sock:sock);
foreach hplipBin (hplipPath)
{
  hplipVer = get_bin_version(full_prog_name:chomp(hplipBin), sock:sock,
                             version_argv:"--version",
                             ver_pattern:"ver. ([0-9]\.[0-9.]+)");
  if(hplipVer[1] != NULL)
  {
    set_kb_item(name:"HP-LIP/Linux/Ver", value:hplipVer[1]);
    security_note(data:"HP Linux Imaging and Printing System Version "  +
                       hplipVer[1] + " running at location " + hplipBin + 
                      " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
