###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_chromehtml_dos_vuln.nasl 4347 2009-08-28 12:52:29Z aug $
#
# Google Chrome 'chromehtml: URI Denial Of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900833);
  script_version("$Revision: 7922 $");
  script_tag(name:"cvss_base", value:"7.1");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2974");
  script_name("Google Chrome 'chromehtml: URI' Denial Of Service Vulnerability");
  desc = "
  Overview: This host is installed with Google Chrome and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  Error occurs when vectors involving a series of function calls that set a
  'chromehtml:' URI value for the document.location property.

  Impact:
  Successful attacks could allows remote attackers to cause application hang
  and CPU consumption which may result in Denial of Service condition.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version 1.0.154.65 and prior on Windows.

  Fix: Upgrade to Google Chrome version 4.1.249.1064 or later.
  For updates refer, http://www.google.com/chrome

  References:
  http://websecurity.com.ua/3435/
  http://archives.neohapsis.com/archives/bugtraq/2009-08/0236.html
  http://archives.neohapsis.com/archives/bugtraq/2009-08/0217.html

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Get for Chrome Version
chromeVer = get_kb_item("GoogleChrome/Win/Ver");

if(isnull(chromeVer)){
  exit(0);
}

# Check for Google Chrome version < 1.0.154.65
if(version_is_less_equal(version:chromeVer, test_version:"1.0.154.65")){
  security_hole(0);
  exit(0);
}
