###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for pidgin vulnerabilities USN-902-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840393);
  script_version("$Revision: 8167 $: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "USN", value: "902-1");
  script_cve_id("CVE-2010-0277", "CVE-2010-0420", "CVE-2010-0423");
  script_name("Ubuntu Update for pidgin vulnerabilities USN-902-1");
  desc = "

  Vulnerability Insight:

  Fabian Yamaguchi discovered that Pidgin incorrectly validated all fields of
  an incoming message in the MSN protocol handler. A remote attacker could
  send a specially crafted message and cause Pidgin to crash, leading to a
  denial of service. (CVE-2010-0277)
  
  Sadrul Habib Chowdhury discovered that Pidgin incorrectly handled certain
  nicknames in Finch group chat rooms. A remote attacker could use a
  specially crafted nickname and cause Pidgin to crash, leading to a denial
  of service. (CVE-2010-0420)
  
  Antti Hayrynen discovered that Pidgin incorrectly handled large numbers of
  smileys. A remote attacker could send a specially crafted message and cause
  Pidgin to become unresponsive, leading to a denial of service.
  (CVE-2010-0423)

  Affected Software/OS:
  pidgin vulnerabilities on Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001050.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of pidgin vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"finch", ver:"2.5.5-1ubuntu8.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple0", ver:"2.5.5-1ubuntu8.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.5.5-1ubuntu8.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin", ver:"2.5.5-1ubuntu8.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"finch-dev", ver:"2.5.5-1ubuntu8.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.5.5-1ubuntu8.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.5.5-1ubuntu8.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-data", ver:"2.5.5-1ubuntu8.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.5.5-1ubuntu8.6", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"finch", ver:"2.5.2-0ubuntu1.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple0", ver:"2.5.2-0ubuntu1.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.5.2-0ubuntu1.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin", ver:"2.5.2-0ubuntu1.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"finch-dev", ver:"2.5.2-0ubuntu1.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.5.2-0ubuntu1.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.5.2-0ubuntu1.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-data", ver:"2.5.2-0ubuntu1.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.5.2-0ubuntu1.7", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"finch", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple0", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"finch-dev", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-data", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gaim", ver:"2.4.1-1ubuntu2.9", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"finch", ver:"2.6.2-1ubuntu7.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple0", ver:"2.6.2-1ubuntu7.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.6.2-1ubuntu7.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin", ver:"2.6.2-1ubuntu7.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"finch-dev", ver:"2.6.2-1ubuntu7.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.6.2-1ubuntu7.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.6.2-1ubuntu7.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-data", ver:"2.6.2-1ubuntu7.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.6.2-1ubuntu7.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}