###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_strongswan_dos_vuln_aug09.nasl 3798 2009-08-05 15:05:27Z aug $
#
# strongSwan Denial Of Service Vulnerability - Aug09
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800673);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2661");
  script_name("strongSwan Denial Of Service Vulnerability  - Aug09");
  desc = "

  Overview: This host has strongSwan and is prone to Denial of
  Service Vulnerability.

  Vulnerability Insight:
  The flaw is due to an error in 'asn1_length()' function in the
  'libstrongswan/asn1/asn1.c' script. It does not properly handle
  X.509 certificates with crafted Relative Distinguished Names (RDNs).

  Impact:
  Successful exploitation allows attackers to crash pluto IKE daemon,
  corrupt memory and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  strongSwan version 2.8 before 2.8.11, 4.2 before 4.2.17 and
  4.3 before 4.3.3

  Fix: Upgrade to version 2.8.11, 4.2.17, and 4.3.3 or apply patches.
  http://download.strongswan.org/patches/
  http://www.strongswan.org/download.htm

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://en.securitylab.ru/nvd/383254.php
  http://www.openwall.com/lists/oss-security/2009/07/27/1

 CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check the version of strongSwan");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_strongswan_detect.nasl");
  script_require_keys("StrongSwan/Ver");
  exit(0);
}


include("version_func.inc");

ssVer = get_kb_item("StrongSwan/Ver");
if(!ssVer){
  exit(0);
}
# Check version 2.8 to 2.8.10, 4.2 to 4.2.16, 4.3 to 4.3.2
if(version_in_range(version:ssVer, test_version:"2.8.0",test_version2:"2.8.10") ||
   version_in_range(version:ssVer, test_version:"4.2.0",test_version2:"4.2.16") ||
   version_in_range(version:ssVer, test_version:"4.3.0",test_version2:"4.3.2")){
  security_warning(0);
}
