###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for filezilla FEDORA-2008-6865
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860376);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-6865");
  script_name( "Fedora Update for filezilla FEDORA-2008-6865");
  desc = "

  Vulnerability Insight:
  FileZilla is a FTP, FTPS and SFTP client for Linux with a lot of features.
  - Supports FTP, FTP over SSL/TLS (FTPS) and SSH File Transfer Protocol (SFTP)
  - Cross-platform
  - Available in many languages
  - Supports resume and transfer of large files &gt;4GB
  - Easy to use Site Manager and transfer queue
  - Drag &amp; drop support
  - Speed limits
  - Filename filters
  - Network configuration wizard


  Affected Software/OS:
  filezilla on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-August/msg00039.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of filezilla");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"filezilla", rpm:"filezilla~3.1.0.1~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}