# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-11491 (qt)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66267);
 script_cve_id("CVE-2009-3384", "CVE-2009-2816", "CVE-2009-2700", "CVE-2009-1725");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 11 FEDORA-2009-11491 (qt)");

 desc = "The remote host is missing an update to qt
announced via advisory FEDORA-2009-11491.

Update Information:

A security flaw was found in the WebKit's Cross-Origin Resource Sharing (CORS)
implementation.    Multiple security flaws (integer underflow, invalid pointer
dereference, buffer underflow and a denial of service) were found in the way
WebKit's FTP parser used to process remote FTP directory listings.
ChangeLog:

* Thu Nov 12 2009 Jaroslav Reznik  - 4.5.3-9
- CVE-2009-3384 - WebKit, ftp listing handling (#525788)
- CVE-2009-2816 - WebKit, MITM Cross-Origin Resource Sharing (#525789)
* Sun Nov  8 2009 Rex Dieter  - 4.5.3-8
- -x11: Requires: %{name}-sqlite(ppc-32)

References:

[ 1 ] Bug #525788 - CVE-2009-3384 WebKit, qt: Multiple security issues while handling FTP directory listings
https://bugzilla.redhat.com/show_bug.cgi?id=525788
[ 2 ] Bug #525789 - CVE-2009-2816 WebKit, qt: MITM in the WebKit's Cross-Origin Resource Sharing (CORS) implementation
https://bugzilla.redhat.com/show_bug.cgi?id=525789

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update qt' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-11491

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-11491 (qt)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"qt", rpm:"qt~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-demos", rpm:"qt-demos~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-devel", rpm:"qt-devel~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-examples", rpm:"qt-examples~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-mysql", rpm:"qt-mysql~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-odbc", rpm:"qt-odbc~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-postgresql", rpm:"qt-postgresql~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-sqlite", rpm:"qt-sqlite~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-x11", rpm:"qt-x11~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-debuginfo", rpm:"qt-debuginfo~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-doc", rpm:"qt-doc~4.5.3~9.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
