# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 819-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55410);
 script_cve_id("CVE-2005-2491");
 script_bugtraq_id(14620);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 819-1 (python2.1)";
 script_name(name);

 desc = "The remote host is missing an update to python2.1
announced via advisory DSA 819-1.

An integer overflow with a subsequent buffer overflow has been detected
in PCRE, the Perl Compatible Regular Expressions library, which allows
an attacker to execute arbitrary code, and is also present in Python.
Exploiting this vulnerability requires an attacker to specify the used
regular expression.

For the old stable distribution (woody) this problem has been fixed in
version 2.1.3-3.4.

For the stable distribution (sarge) this problem has been fixed in
version 2.1.3dfsg-1sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 2.1.3dfsg-3.

We recommend that you upgrade your python2.1 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20819-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 819-1 (python2.1)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"idle-python2.1", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"idle", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-dev", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-doc", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-elisp", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-examples", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-gdbm", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-mpz", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-tk", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-xmlbase", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-doc", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-elisp", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-examples", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-dev", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-gdbm", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-mpz", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-tk", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-xmlbase", ver:"2.1.3-3.4", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"idle-python2.1", ver:"2.1.3dfsg-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-doc", ver:"2.1.3dfsg-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-examples", ver:"2.1.3dfsg-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1", ver:"2.1.3dfsg-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-dev", ver:"2.1.3dfsg-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-gdbm", ver:"2.1.3dfsg-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-mpz", ver:"2.1.3dfsg-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-tk", ver:"2.1.3dfsg-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.1-xmlbase", ver:"2.1.3dfsg-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
