# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 351-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53640);
 script_bugtraq_id(7761);
 script_cve_id("CVE-2003-0442");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 351-1 (php4)";
 script_name(name);

 desc = "The remote host is missing an update to php4
announced via advisory DSA 351-1.

The transparent session ID feature in the php4 package does not
properly escape user-supplied input before inserting it into the
generated HTML page.  An attacker could use this vulnerability to
execute embedded scripts within the context of the generated page.

For the stable distribution (woody) this problem has been fixed in
version 4:4.1.2-6woody3.

For the unstable distribution (sid) this problem will be fixed soon.
Refer to Debian bug #200736.

We recommend that you update your php4 package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20351-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 351-1 (php4)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php4-dev", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-pear", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"caudium-php4", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-cgi", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-curl", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-domxml", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-gd", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-imap", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-ldap", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mcal", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mhash", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-mysql", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-odbc", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-recode", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-snmp", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-sybase", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php4-xslt", ver:"4.1.2-6woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
