if (description)
{
 script_id(10780);
 script_version ("$Revision: 8097 $");
 script_tag(name:"cvss_base", value:"3.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("CGIEmail's Cross Site Scripting Vulnerability (cgicso)");
 desc = "
Synopsis :

The remote web server contains a CGI which is vulnerable to a cross site
scripting vulnerability.

Description :

The remote web server contains the 'CGIEmail' CGI, a web based form to
send emails.

The remote version of this software contains a vulnerability caused by 
inadequate processing of queries by CGIEmail's cgicso  that results in a 
cross site scripting condition.

Solution :

Modify cgilib.c to contain a stripper function that will remove any HTML 
or JavaScript tags.

Risk factor :

Low / CVSS Base Score : 3 
(AV:R/AC:H/Au:NR/C:P/A:N/I:N/B:C)";

 script_description(desc);
 script_summary("Determine if a remote host is vulnerable to the cgicso vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2001 SecurITeam");
 script_dependencie("find_service.nes", "http_version.nasl","cross_site_scripting.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

if ( get_kb_item("www/" + port + "/generic_xss") ) exit(0);
if ( get_kb_item("www/no404/" + port )) exit(0);



check = string("<script>vulnerable</script>");


foreach d (cgi_dirs())
{
 url = string(d, "/cgicso");
 data = string(url, "?query=<script>alert('foo')</script>");
 req = http_get(item:data, port:port);
 buf = http_keepalive_send_recv(port:port, data:req);
 if( buf == NULL ) exit(0);
 if(!ereg(pattern:"<script>alert('foo')</script>", string:buf))exit(0);

 if (check >< buf)
   {
    security_note(port:port);
    exit(0);
   }
}
