
/*
 * $Header: /cvsroot/mpdist/mpdist/mptool/main.c,v 1.2 2002/10/15 19:09:32 richbastard Exp $
 * 
 * Copyright (c) 1987-2002 Rich Burridge, Sun Microsystems Inc.
 * All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "help.h"
#include "main.h"
#include "text.h"
#include "support.h"
#include "xutil.h"
#include <stdio.h>

void fix_frame_widget (GtkWidget *main_frame);

GtkWidget *main_frame_widget     = NULL;
GtkWidget *header_frame_widget   = NULL;
GtkWidget *input_frame_widget    = NULL;
GtkWidget *output_frame_widget   = NULL;
GtkWidget *printing_frame_widget = NULL;
GtkWidget *username_frame_widget = NULL;
GtkWidget *help_frame_widget     = NULL;
GtkWidget *notice_widget         = NULL;
GtkWidget *file_widget           = NULL;
GtkTooltips *tips;

int
main (int argc, char *argv[])
{
    gtk_set_locale();
    gtk_init(&argc, &argv);
    tips = gtk_tooltips_new();

    main_frame_widget = create_main_frame_widget();

#ifndef NO_DND
    init_dnd(lookup_widget(main_frame_widget, "filename"));
#endif /* !NO_DND */

    do_startup(argc, argv);

    add_help(F_MAIN, tips, "main_form",           wi_main_frame_help);
    add_help(F_MAIN, tips, "filename_label",      wi_filename_help);
    add_help(F_MAIN, tips, "filename",            wi_filename_help);
    add_help(F_MAIN, tips, "headers_item",        wi_headers_help);
    add_help(F_MAIN, tips, "file_type",           wi_file_type_help);
    add_help(F_MAIN, tips, "organiser",           wi_org_type_help);
    add_help(F_MAIN, tips, "out_label",           wi_output_help);
    add_help(F_MAIN, tips, "out_type",            wi_output_help);
    add_help(F_MAIN, tips, "paper_size_label",    wi_paper_size_help);
    add_help(F_MAIN, tips, "paper_size",          wi_paper_size_help);
    add_help(F_MAIN, tips, "subject_label",       wi_subject_help);
    add_help(F_MAIN, tips, "subject",             wi_subject_help);
    add_help(F_MAIN, tips, "copies_label",        wi_copies_help);
    add_help(F_MAIN, tips, "copies",              wi_copies_help);
    add_help(F_MAIN, tips, "no_sides_label",      wi_no_sides_help);
    add_help(F_MAIN, tips, "no_sides",            wi_no_sides_help);
    add_help(F_MAIN, tips, "print_button",        wi_print_help);
    add_help(F_MAIN, tips, "reset_button",        wi_reset_help);
    add_help(F_MAIN, tips, "save_as_defaults1",   wi_props_defs_help);
    add_help(F_MAIN, tips, "menu_bar",            wi_menu_bar_help);
    add_help(F_MAIN, tips, "input_item",          wi_input_frame_help);
    add_help(F_MAIN, tips, "output_item",         wi_output_frame_help);
    add_help(F_MAIN, tips, "print_layout",        wi_props_frame_help);
    add_help(F_MAIN, tips, "user_name_item",      wi_un_form_help);
    add_help(F_MAIN, tips, "general_item",        wi_main_frame_help);
    add_help(F_MAIN, tips, "header_options_item", wi_header_frame_help);
    add_help(F_MAIN, tips, "input_options_item",  wi_input_frame_help);

    gtk_widget_show(main_frame_widget);
    create_and_set_icons();

    set_help_state(int_opt_val(O_TOOLTIP));
    gtk_main();
    return(0);
}
