/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import sharpen.core.framework.ASTResolver;
import sharpen.core.framework.CompilationUnitPair;
import sharpen.core.framework.DefaultASTResolver;

public abstract class ConversionBatch {
    private ICompilationUnit[] _source;
    private IProgressMonitor _progressMonitor = new NullProgressMonitor();
    private final ASTParser _parser = ASTParser.newParser((int)3);

    public ConversionBatch() {
        this._parser.setKind(8);
    }

    public void setSource(ICompilationUnit ... source) {
        if (source == null || source.length == 0) {
            throw new IllegalArgumentException("source");
        }
        this._source = source;
    }

    public void setSource(List<ICompilationUnit> source) {
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source");
        }
        this._source = source.toArray(new ICompilationUnit[source.size()]);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException("monitor");
        }
        this._progressMonitor = monitor;
    }

    public void run() throws CoreException, IOException {
        if (this._source == null) {
            throw new IllegalStateException("source was not set");
        }
        ArrayList<CompilationUnitPair> pairs = this.parseCompilationUnits();
        DefaultASTResolver resolver = new DefaultASTResolver(pairs);
        this._progressMonitor.beginTask("converting", pairs.size());
        for (CompilationUnitPair pair : pairs) {
            if (this._progressMonitor.isCanceled()) {
                return;
            }
            this.convertPair(resolver, pair);
        }
    }

    private void convertPair(ASTResolver resolver, CompilationUnitPair pair) throws CoreException, IOException {
        try {
            this._progressMonitor.subTask(pair.source.getElementName());
            this.convertCompilationUnit(resolver, pair.source, pair.ast);
        }
        finally {
            this._progressMonitor.worked(1);
        }
    }

    protected abstract void convertCompilationUnit(ASTResolver var1, ICompilationUnit var2, CompilationUnit var3) throws CoreException, IOException;

    private ArrayList<CompilationUnitPair> parseCompilationUnits() {
        final ArrayList<CompilationUnitPair> pairs = new ArrayList<CompilationUnitPair>(this._source.length);
        ASTRequestor requestor = new ASTRequestor(){

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                pairs.add(new CompilationUnitPair(source, ast));
            }
        };
        this._parser.setProject(this._source[0].getJavaProject());
        this._parser.setResolveBindings(true);
        this._parser.createASTs(this._source, new String[0], requestor, this._progressMonitor);
        return pairs;
    }
}

