
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \filePageIDAttributes.h
    \brief Definition of PageID Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef PageIDAttributes_H
#define PageIDAttributes_H

#include "magics.h"
#include "Colour.h"
#include "LogoPlotting.h"
namespace magics {

class XmlNode;
class PageIDAttributes 
{
public:
//  --  constructor
    PageIDAttributes();
    
//  --  destructor
    virtual ~PageIDAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const PageIDAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double height_;
	bool magics_;
	string user_text_;
	bool system_;
	bool date_;
	bool errors_;
	bool text_;
	string font_;
	string font_style_;
	unique_ptr<Colour> colour_;
	unique_ptr<NoLogoPlotting> logo_;
	 

private:
	friend ostream& operator<<(ostream& s,const PageIDAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

