/**************************************************************************\
 ibtk (Insomnia's Basic ToolKit)

  By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef ISTATBAR_H
#define ISTATBAR_H

#include <X11/X.h>   
#include <X11/Xlib.h>
#include "idodad.h"
#include "iwindow.h"

class IStatBar : public IDoDad  {
public:
  IStatBar(IWindow *w, int xp, int yp, int xs, int ys);
  virtual ~IStatBar();
  virtual int Type()  { return DODAD_STATBAR; };
  virtual void Redraw();
  int Progress() { return progress; };
  int TotalWork() { return total; };
  void SetProgress(int p) { progress = p; Redraw(); };
  void SetTotalWork(int t) { total = t; Redraw(); };
  void SetStatus(int p, int t) { progress = p; total = t; Redraw(); };
protected:
  IStatBar() {};
  void Init(IWindow *w, int xp, int yp, int xs, int ys);
  Pixmap Img;
  int xpos, ypos, xsize, ysize;
  int progress, total;
  };

#endif
