# From 8.3 to 8.4

### 1. Stop server

    sudo service gitlab stop

### 2. Backup

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

### 3. Get latest code

```bash
sudo -u git -H git fetch --all
sudo -u git -H git checkout -- db/schema.rb # local changes will be restored automatically
```

For GitLab Community Edition:

```bash
sudo -u git -H git checkout 8-4-stable
```

OR

For GitLab Enterprise Edition:

```bash
sudo -u git -H git checkout 8-4-stable-ee
```

### 4. Update gitlab-shell

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch --all
sudo -u git -H git checkout v2.6.10
```

### 5. Update gitlab-workhorse

Install and compile gitlab-workhorse. This requires [Go 1.5](https://golang.org/dl)
which should already be on your system from GitLab 8.1.

```bash
cd /home/git/gitlab-workhorse
sudo -u git -H git fetch --all
sudo -u git -H git checkout 0.6.2
sudo -u git -H make
```

### 6. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL installations (note: the line below states '--without postgres')
sudo -u git -H bundle install --without postgres development test --deployment

# PostgreSQL installations (note: the line below states '--without mysql')
sudo -u git -H bundle install --without mysql development test --deployment

# Run database migrations
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

# Clean up assets and cache
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production

```

### 7. Update configuration files

#### New configuration options for `gitlab.yml`

There are new configuration options available for [`gitlab.yml`](config/gitlab.yml.example). View them with the command below and apply them manually to your current `gitlab.yml`:

```sh
git diff origin/8-3-stable:config/gitlab.yml.example origin/8-4-stable:config/gitlab.yml.example
```

#### Nginx configuration

GitLab 8.3 introduced major changes in the NGINX configuration. Ensure you're
still up-to-date with the latest changes:

```sh
# For HTTPS configurations
git diff origin/8-3-stable:lib/support/nginx/gitlab-ssl origin/8-4-stable:lib/support/nginx/gitlab-ssl

# For HTTP configurations
git diff origin/8-3-stable:lib/support/nginx/gitlab origin/8-4-stable:lib/support/nginx/gitlab
```

If you are using Apache instead of NGINX please see the updated [Apache templates].
Also note that because Apache does not support upstreams behind Unix sockets you
will need to let gitlab-workhorse listen on a TCP port. You can do this
via [/etc/default/gitlab].

[Apache templates]: https://gitlab.com/gitlab-org/gitlab-recipes/tree/master/web-server/apache
[/etc/default/gitlab]: https://gitlab.com/gitlab-org/gitlab-ce/blob/8-4-stable/lib/support/init.d/gitlab.default.example#L34

#### Init script

We updated the init script for GitLab in order to set a specific PATH for gitlab-workhorse.

```
cd /home/git/gitlab
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
```

### 8. Start application

    sudo service gitlab start
    sudo service nginx restart

### 9. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations, the upgrade is complete!

## Things went south? Revert to previous version (8.3)

### 1. Revert the code to the previous version

Follow the [upgrade guide from 8.2 to 8.3](8.2-to-8.3.md), except for the
database migration (the backup is already migrated to the previous version).

### 2. Restore from the backup

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```

If you have more than one backup `*.tar` file(s) please add `BACKUP=timestamp_of_backup` to the command above.
