DESC="Generate dependencies"
runtest()
{
  mkdir -p dep
  
  DepFile1=dep/Test1.d
  DepFile2=dep/Test2.d

  EXEC="${AGCC} --path ${TestSrcDir} -v2  -MF ${DepFile1} -M ${TestSrcDir}/*.cc"
  echo "Executing '${EXEC}'"
  if  ( ${EXEC} );then true;else
    ERR_MSG="Failed executing  '${EXEC}'"
    return 1
  fi

  if [ ! -f ${DepFile1} ];then
    ERR_MSG="File with dependency information was not generated"
    return 1
  fi


  EXEC="${AGCC} -a ${TestSrcDir}/trace.ah -v2  -MF ${DepFile2} -M ${TestSrcDir}/*.cc"
  echo "Executing '${EXEC}'"
  if  ( ${EXEC} );then true;else
    ERR_MSG="Failed executing  '${EXEC}'"
    return 1
  fi

  if [ ! -f ${DepFile2} ];then
    ERR_MSG="File with dependency information was not generated"
    return 1
  fi

  DepRefFile=dep/Test.ref.d

  g++ -include "${TestSrcDir}/trace.ah" -M -MF ${DepRefFile}  "${TestSrcDir}"/*.cc

  echo -e "\nDIFF BETWEEN FILES '${DepRefFile}' and '${DepFile1}': \n"
  if ( diff ${DepRefFile} ${DepFile1});then 
    echo -e " none"
  else
    ERR_MSG="Dependency information differs between 'g++' and 'ag++' (files: '${DepRefFile}' and '${DepFile1}')"
    return 1
  fi

  echo -e "\nDIFF BETWEEN FILES '${DepRefFile}' and '${DepFile2}': \n"
  if ( diff ${DepRefFile} ${DepFile2});then 
    echo -e " none"
  else
    ERR_MSG="Dependency information differs between 'g++' and 'ag++' (files: '${DepRefFile}' and '${DepFile2}')"
    return 1
  fi

  return 0
}

