##############################################################################
#
# Library:   VMTK
#
##############################################################################
include( ExternalProject )

set( base "${CMAKE_BINARY_DIR}" )
set_property( DIRECTORY PROPERTY EP_BASE ${base} )

#set( shared ON )
#if ( BUILD_SHARED_LIBS )
#  set( shared "${BUILD_SHARED_LIBS}" )
#endif()
#set( testing OFF )
#set( examples OFF )
#set( build_type "Debug" )
#if( CMAKE_BUILD_TYPE )
#  set( build_type "${CMAKE_BUILD_TYPE}" )
#endif()

set( VMTK_DEPENDS "" )

set( gen "${CMAKE_GENERATOR}" )

##
## Check if sytem ITK or superbuild ITK
##
if( NOT USE_SYSTEM_ITK )

  ##
  ## ITK
  ##
  set( proj ITK )
  ExternalProject_Add( ${proj}
    GIT_REPOSITORY "${GIT_PROTOCOL}://github.com/Kitware/ITK.git"
    GIT_TAG "v3.20.1"
    SOURCE_DIR "${CMAKE_BINARY_DIR}/ITK"
    BINARY_DIR ITK-Build
    CMAKE_GENERATOR ${gen}
    CMAKE_ARGS
      -Dgit_EXECUTABLE:FILEPATH=${GIT_EXECUTABLE}
      -DCMAKE_OSX_ARCHITECTURES:STRING=${CMAKE_OSX_ARCHITECTURES}
      -DCMAKE_CXX_COMPILER:STRING=${CMAKE_CXX_COMPILER}
      -DCMAKE_CXX_FLAGS:STRING=${CMAKE_CXX_FLAGS}
      -DCMAKE_C_FLAGS:STRING=${CMAKE_C_FLAGS}
      -DCMAKE_EXE_LINKER_FLAGS:STRING=${CMAKE_EXE_LINKER_FLAGS}
      -DCMAKE_SHARED_LINKER_FLAGS:STRING=${CMAKE_SHARED_LINKER_FLAGS}
      -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
      -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_BINARY_DIR}/Install
      -DITK_USE_FLAT_DIRECTORY_INSTALL:BOOL=${ITK_USE_FLAT_DIRECTORY_INSTALL}
      -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
      -DBUILD_EXAMPLES:BOOL=OFF
      -DBUILD_TESTING:BOOL=OFF
      -DITK_USE_REVIEW:BOOL=ON
      -DITK_USE_OPTIMIZED_REGISTRATION_METHODS:BOOL=ON
    #INSTALL_DIR "Install/ITK"
    )
  set( ITK_DIR "${base}/ITK-Build" )

  set( VMTK_DEPENDS ${VMTK_DEPENDS} "ITK" )

endif( NOT USE_SYSTEM_ITK )

##
## Check if sytem VTK or superbuild VTK
##
if( NOT USE_SYSTEM_VTK )

  ##
  ## VTK
  ##
  set( proj VTK )
  ExternalProject_Add( VTK
    GIT_REPOSITORY "${GIT_PROTOCOL}://github.com/lantiga/VTK.git"
    GIT_TAG "v5.8.0-vmtk"
    SOURCE_DIR "${CMAKE_BINARY_DIR}/VTK"
    BINARY_DIR VTK-Build
    CMAKE_GENERATOR ${gen}
    CMAKE_ARGS
      -Dgit_EXECUTABLE:FILEPATH=${GIT_EXECUTABLE}
      -DCMAKE_OSX_ARCHITECTURES:STRING=${CMAKE_OSX_ARCHITECTURES}
      -DCMAKE_CXX_COMPILER:STRING=${CMAKE_CXX_COMPILER}
      -DCMAKE_CXX_FLAGS:STRING=${CMAKE_CXX_FLAGS}
      -DCMAKE_C_FLAGS:STRING=${CMAKE_C_FLAGS}
      -DCMAKE_EXE_LINKER_FLAGS:STRING=${CMAKE_EXE_LINKER_FLAGS}
      -DCMAKE_SHARED_LINKER_FLAGS:STRING=${CMAKE_SHARED_LINKER_FLAGS}
      -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
      -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_BINARY_DIR}/Install
      -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
      -DVTK_WRAP_PYTHON:BOOL=${VTK_VMTK_WRAP_PYTHON}
      -DVTK_USE_TK:BOOL=OFF
      -DVTK_USE_CARBON:BOOL=${VTK_USE_CARBON}
      -DVTK_USE_COCOA:BOOL=${VTK_VMTK_USE_COCOA}
      -DVTK_USE_INFOVIS:BOOL=${VTK_USE_INFOVIS}
      -DVTK_USE_N_WAY_ARRAYS:BOOL=${VTK_USE_N_WAY_ARRAYS}
      -DVTK_USE_PARALLEL:BOOL=${VTK_USE_PARALLEL}
      -DVTK_USE_QT:BOOL=${VTK_USE_QT}
      -DVTK_USE_RENDERING:BOOL=${VTK_USE_RENDERING}
      -DVTK_USE_HYBRID:BOOL=${VTK_USE_HYBRID}
      -DVTK_USE_TEXT_ANALYSIS:BOOL=${VTK_USE_TEXT_ANALYSIS}
      -DVTK_USE_X:BOOL=${VTK_USE_X}
      -DBUILD_EXAMPLES:BOOL=OFF
      -DBUILD_TESTING:BOOL=OFF
      -DVTK_USE_GUISUPPORT:BOOL=OFF
      -DVTK_INSTALL_PYTHON_USING_CMAKE:BOOL=ON
    #INSTALL_DIR "Install/VTK"
    )
  set( VTK_DIR "${base}/VTK-Build" )

  set( VMTK_DEPENDS ${VMTK_DEPENDS} "VTK" )

endif( NOT USE_SYSTEM_VTK )

##
## VMTK - Normal Build
##
set( proj VMTK )
ExternalProject_Add( ${proj}
  DOWNLOAD_COMMAND ""
  SOURCE_DIR "${CMAKE_CURRENT_SOURCE_DIR}"
  BINARY_DIR VMTK-Build
  CMAKE_GENERATOR ${gen}
  CMAKE_ARGS
    -DBUILDNAME:STRING=${BUILDNAME}
    -DSITE:STRING=${SITE}
    -DMAKECOMMAND:STRING=${MAKECOMMAND}
    -DCMAKE_CXX_COMPILER:STRING=${CMAKE_CXX_COMPILER}
    -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
    -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
    -DBUILD_EXAMPLES:BOOL=${BUILD_EXAMPLES}
    -DBUILD_TESTING:BOOL=${BUILD_TESTING}
    -DBUILD_DOCUMENTATION:BOOL=${BUILD_DOCUMENTATION}
    -DCMAKE_SHARED_LINKER_FLAGS:STRING=${CMAKE_SHARED_LINKER_FLAGS}
    -DCMAKE_EXE_LINKER_FLAGS:STRING=${CMAKE_EXE_LINKER_FLAGS}
    -DCMAKE_OSX_ARCHITECTURES:STRING=${CMAKE_OSX_ARCHITECTURES}
    -DCMAKE_CXX_FLAGS:STRING=${CMAKE_CXX_FLAGS}
    -DCMAKE_C_FLAGS:STRING=${CMAKE_C_FLAGS}
    -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_BINARY_DIR}/Install
    -DVTK_VMTK_WRAP_PYTHON:BOOL=${VTK_VMTK_WRAP_PYTHON}
    -DVMTK_USE_SUPERBUILD:BOOL=OFF
    -DVMTK_CONTRIB_SCRIPTS:BOOL=${VMTK_CONTRIB_SCRIPTS}
    -DVTK_VMTK_CONTRIB:BOOL=${VTK_VMTK_CONTRIB}
    -DVMTK_SCRIPTS_ENABLED:BOOL=${VMTK_SCRIPTS_ENABLED}
    -DVMTK_MINIMAL_INSTALL:BOOL=OFF
    -DVMTK_ENABLE_DISTRIBUTION:BOOL=${VMTK_ENABLE_DISTRIBUTION}
    -DVMTK_WITH_LIBRARY_VERSION:BOOL=OFF
    -DVMTK_BUILD_TETGEN:BOOL=${VMTK_BUILD_TETGEN}
    -DVTK_VMTK_USE_COCOA:BOOL=${VTK_VMTK_USE_COCOA}
    -DVMTK_BUILD_STREAMTRACER:BOOL=${VMTK_BUILD_STREAMTRACER}
    -DVTK_REQUIRED_OBJCXX_FLAGS:STRING=${VTK_REQUIRED_OBJCXX_FLAGS}
    -DITK_DIR:PATH=${ITK_DIR}
    -DVTK_DIR:PATH=${VTK_DIR}
  #INSTALL_DIR "Install/vmtk"
  DEPENDS
    ${VMTK_DEPENDS}
 )

