/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.logging.LogConfigurationException;

public class LoadTestCase
extends TestCase {
    private static String[] LOG_PCKG = new String[]{"org.apache.commons.logging", "org.apache.commons.logging.impl"};
    private ClassLoader origContextClassLoader;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$commons$logging$UserClass;
    static /* synthetic */ Class class$org$apache$commons$logging$LoadTestCase;

    private void setAllowFlawedContext(Class c, String state) throws Exception {
        Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LoadTestCase.class$("java.lang.String")) : class$java$lang$String};
        Method m = c.getDeclaredMethod("setAllowFlawedContext", params);
        m.invoke(null, state);
    }

    public void testInContainer() throws Exception {
        Class cls = this.reload();
        Thread.currentThread().setContextClassLoader(cls.getClassLoader());
        this.execute(cls);
        cls = this.reload();
        Thread.currentThread().setContextClassLoader(null);
        this.execute(cls);
        cls = this.reload();
        Thread.currentThread().setContextClassLoader(null);
        try {
            this.setAllowFlawedContext(cls, "false");
            this.execute(cls);
            Assert.fail((String)"Logging config succeeded when context classloader was null!");
        }
        catch (LogConfigurationException ex) {
            // empty catch block
        }
        cls = this.reload();
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        this.execute(cls);
        cls = this.reload();
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        try {
            this.setAllowFlawedContext(cls, "false");
            this.execute(cls);
            Assert.fail((String)"Error: somehow downcast a Logger loaded via system classloader to the Log interface loaded via a custom classloader");
        }
        catch (LogConfigurationException logConfigurationException) {
            // empty catch block
        }
    }

    private Class reload() throws Exception {
        Class testObjCls = null;
        AppClassLoader appLoader = new AppClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            testObjCls = appLoader.loadClass((class$org$apache$commons$logging$UserClass == null ? (class$org$apache$commons$logging$UserClass = LoadTestCase.class$("org.apache.commons.logging.UserClass")) : class$org$apache$commons$logging$UserClass).getName());
        }
        catch (ClassNotFoundException cnfe) {
            throw cnfe;
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)"AppClassLoader failed ");
        }
        Assert.assertTrue((String)"app isolated", (testObjCls.getClassLoader() == appLoader ? 1 : 0) != 0);
        return testObjCls;
    }

    private void execute(Class cls) throws Exception {
        cls.newInstance();
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{(class$org$apache$commons$logging$LoadTestCase == null ? (class$org$apache$commons$logging$LoadTestCase = LoadTestCase.class$("org.apache.commons.logging.LoadTestCase")) : class$org$apache$commons$logging$LoadTestCase).getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void setUp() {
        this.origContextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void tearDown() {
        Thread.currentThread().setContextClassLoader(this.origContextClassLoader);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AppClassLoader
    extends ClassLoader {
        Map classes = new HashMap();

        AppClassLoader(ClassLoader parent) {
            super(parent);
        }

        private Class def(String name) throws ClassNotFoundException {
            Class<?> result = (Class<?>)this.classes.get(name);
            if (result != null) {
                return result;
            }
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                String classFileName = name.replace('.', '/') + ".class";
                InputStream is = cl.getResourceAsStream(classFileName);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while (is.available() > 0) {
                    out.write(is.read());
                }
                byte[] data = out.toByteArray();
                result = super.defineClass(name, data, 0, data.length);
                this.classes.put(name, result);
                return result;
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException(name + " caused by " + ioe.getMessage());
            }
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            for (int i = 0; i < LOG_PCKG.length; ++i) {
                if (!name.startsWith(LOG_PCKG[i]) || name.indexOf("Exception") != -1) continue;
                return this.def(name);
            }
            return super.loadClass(name);
        }
    }
}

