/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef PDXLZ77STREAM_H_INCLUDED
#define PDXLZ77STREAM_H_INCLUDED

#include <boost/scoped_ptr.hpp>

#include <libwpd-stream/libwpd-stream.h>

namespace libebook
{

class PDXLZ77Stream : public WPXInputStream
{
// disable copying
  PDXLZ77Stream(const PDXLZ77Stream &other);
  PDXLZ77Stream &operator=(const PDXLZ77Stream &other);

public:
  PDXLZ77Stream(WPXInputStream *stream);
  virtual ~PDXLZ77Stream();

  virtual bool isOLEStream();
  virtual WPXInputStream *getDocumentOLEStream(const char *name);

  virtual const unsigned char *read(unsigned long numBytes, unsigned long &numBytesRead);
  virtual int seek(long offset, WPX_SEEK_TYPE seekType);
  virtual long tell();
  virtual bool atEOS();

private:
  boost::scoped_ptr<WPXInputStream> m_stream;
};

}

#endif // PDXLZ77STREAM_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
