# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccessInformationCollection(msrest.serialization.Model):
    """Paged AccessInformation list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.AccessInformationContract]
    :param count: Total record count number across all pages.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AccessInformationContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessInformationCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class Resource(msrest.serialization.Model):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AccessInformationContract(Resource):
    """Tenant Settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param id_properties_id: Access Information type ('access' or 'gitAccess').
    :type id_properties_id: str
    :param principal_id: Principal (User) Identifier.
    :type principal_id: str
    :param enabled: Determines whether direct access is enabled.
    :type enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessInformationContract, self).__init__(**kwargs)
        self.id_properties_id = kwargs.get('id_properties_id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.enabled = kwargs.get('enabled', None)


class AccessInformationCreateParameters(msrest.serialization.Model):
    """Tenant access information update parameters.

    :param principal_id: Principal (User) Identifier.
    :type principal_id: str
    :param primary_key: Primary access key. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :type primary_key: str
    :param secondary_key: Secondary access key. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :type secondary_key: str
    :param enabled: Determines whether direct access is enabled.
    :type enabled: bool
    """

    _attribute_map = {
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessInformationCreateParameters, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.enabled = kwargs.get('enabled', None)


class AccessInformationSecretsContract(msrest.serialization.Model):
    """Tenant access information contract of the API Management service.

    :param id: Access Information type ('access' or 'gitAccess').
    :type id: str
    :param principal_id: Principal (User) Identifier.
    :type principal_id: str
    :param primary_key: Primary access key. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :type primary_key: str
    :param secondary_key: Secondary access key. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :type secondary_key: str
    :param enabled: Determines whether direct access is enabled.
    :type enabled: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessInformationSecretsContract, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.principal_id = kwargs.get('principal_id', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.enabled = kwargs.get('enabled', None)


class AccessInformationUpdateParameters(msrest.serialization.Model):
    """Tenant access information update parameters.

    :param enabled: Determines whether direct access is enabled.
    :type enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessInformationUpdateParameters, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class AdditionalLocation(msrest.serialization.Model):
    """Description of an additional API Management resource location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The location name of the additional region among Azure Data center
     regions.
    :type location: str
    :param sku: Required. SKU properties of the API Management service.
    :type sku: ~azure.mgmt.apimanagement.models.ApiManagementServiceSkuProperties
    :param zones: A list of availability zones denoting where the resource needs to come from.
    :type zones: list[str]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in the additional location. Available only for Basic, Standard, Premium and Isolated
     SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service which is deployed in an Internal Virtual Network in a particular additional location.
     Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :param virtual_network_configuration: Virtual network configuration for the location.
    :type virtual_network_configuration:
     ~azure.mgmt.apimanagement.models.VirtualNetworkConfiguration
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Region.
    :vartype gateway_regional_url: str
    :param disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in this additional location.
    :type disable_gateway: bool
    """

    _validation = {
        'location': {'required': True},
        'sku': {'required': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ApiManagementServiceSkuProperties'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'privateIPAddresses', 'type': '[str]'},
        'virtual_network_configuration': {'key': 'virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'gateway_regional_url': {'key': 'gatewayRegionalUrl', 'type': 'str'},
        'disable_gateway': {'key': 'disableGateway', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdditionalLocation, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.sku = kwargs['sku']
        self.zones = kwargs.get('zones', None)
        self.public_ip_addresses = None
        self.private_ip_addresses = None
        self.virtual_network_configuration = kwargs.get('virtual_network_configuration', None)
        self.gateway_regional_url = None
        self.disable_gateway = kwargs.get('disable_gateway', False)


class ApiCollection(msrest.serialization.Model):
    """Paged Api list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.ApiContract]
    :param count: Total record count number across all pages.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class ApiContract(Resource):
    """Api details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Description of the API. May include HTML formatting tags.
    :type description: str
    :param authentication_settings: Collection of authentication settings included into this API.
    :type authentication_settings: ~azure.mgmt.apimanagement.models.AuthenticationSettingsContract
    :param subscription_key_parameter_names: Protocols over which API is made available.
    :type subscription_key_parameter_names:
     ~azure.mgmt.apimanagement.models.SubscriptionKeyParameterNamesContract
    :param api_type: Type of API. Possible values include: "http", "soap".
    :type api_type: str or ~azure.mgmt.apimanagement.models.ApiType
    :param api_revision: Describes the Revision of the Api. If no value is provided, default
     revision 1 is created.
    :type api_revision: str
    :param api_version: Indicates the Version identifier of the API if the API is versioned.
    :type api_version: str
    :param is_current: Indicates if API revision is current api revision.
    :type is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :param api_revision_description: Description of the Api Revision.
    :type api_revision_description: str
    :param api_version_description: Description of the Api Version.
    :type api_version_description: str
    :param api_version_set_id: A resource identifier for the related ApiVersionSet.
    :type api_version_set_id: str
    :param subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :type subscription_required: bool
    :param source_api_id: API identifier of the source API.
    :type source_api_id: str
    :param display_name: API name. Must be 1 to 300 characters long.
    :type display_name: str
    :param service_url: Absolute URL of the backend service implementing this API. Cannot be more
     than 2000 characters long.
    :type service_url: str
    :param path: Relative URL uniquely identifying this API and all of its resource paths within
     the API Management service instance. It is appended to the API endpoint base URL specified
     during the service instance creation to form a public URL for this API.
    :type path: str
    :param protocols: Describes on which protocols the operations in this API can be invoked.
    :type protocols: list[str or ~azure.mgmt.apimanagement.models.Protocol]
    :param api_version_set: Version set details.
    :type api_version_set: ~azure.mgmt.apimanagement.models.ApiVersionSetContractDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 0},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'authentication_settings': {'key': 'properties.authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'properties.subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'properties.type', 'type': 'str'},
        'api_revision': {'key': 'properties.apiRevision', 'type': 'str'},
        'api_version': {'key': 'properties.apiVersion', 'type': 'str'},
        'is_current': {'key': 'properties.isCurrent', 'type': 'bool'},
        'is_online': {'key': 'properties.isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'properties.apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'properties.apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'properties.apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'source_api_id': {'key': 'properties.sourceApiId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'service_url': {'key': 'properties.serviceUrl', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'protocols': {'key': 'properties.protocols', 'type': '[str]'},
        'api_version_set': {'key': 'properties.apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.authentication_settings = kwargs.get('authentication_settings', None)
        self.subscription_key_parameter_names = kwargs.get('subscription_key_parameter_names', None)
        self.api_type = kwargs.get('api_type', None)
        self.api_revision = kwargs.get('api_revision', None)
        self.api_version = kwargs.get('api_version', None)
        self.is_current = kwargs.get('is_current', None)
        self.is_online = None
        self.api_revision_description = kwargs.get('api_revision_description', None)
        self.api_version_description = kwargs.get('api_version_description', None)
        self.api_version_set_id = kwargs.get('api_version_set_id', None)
        self.subscription_required = kwargs.get('subscription_required', None)
        self.source_api_id = kwargs.get('source_api_id', None)
        self.display_name = kwargs.get('display_name', None)
        self.service_url = kwargs.get('service_url', None)
        self.path = kwargs.get('path', None)
        self.protocols = kwargs.get('protocols', None)
        self.api_version_set = kwargs.get('api_version_set', None)


class ApiEntityBaseContract(msrest.serialization.Model):
    """API base contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the API. May include HTML formatting tags.
    :type description: str
    :param authentication_settings: Collection of authentication settings included into this API.
    :type authentication_settings: ~azure.mgmt.apimanagement.models.AuthenticationSettingsContract
    :param subscription_key_parameter_names: Protocols over which API is made available.
    :type subscription_key_parameter_names:
     ~azure.mgmt.apimanagement.models.SubscriptionKeyParameterNamesContract
    :param api_type: Type of API. Possible values include: "http", "soap".
    :type api_type: str or ~azure.mgmt.apimanagement.models.ApiType
    :param api_revision: Describes the Revision of the Api. If no value is provided, default
     revision 1 is created.
    :type api_revision: str
    :param api_version: Indicates the Version identifier of the API if the API is versioned.
    :type api_version: str
    :param is_current: Indicates if API revision is current api revision.
    :type is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :param api_revision_description: Description of the Api Revision.
    :type api_revision_description: str
    :param api_version_description: Description of the Api Version.
    :type api_version_description: str
    :param api_version_set_id: A resource identifier for the related ApiVersionSet.
    :type api_version_set_id: str
    :param subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :type subscription_required: bool
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiEntityBaseContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.authentication_settings = kwargs.get('authentication_settings', None)
        self.subscription_key_parameter_names = kwargs.get('subscription_key_parameter_names', None)
        self.api_type = kwargs.get('api_type', None)
        self.api_revision = kwargs.get('api_revision', None)
        self.api_version = kwargs.get('api_version', None)
        self.is_current = kwargs.get('is_current', None)
        self.is_online = None
        self.api_revision_description = kwargs.get('api_revision_description', None)
        self.api_version_description = kwargs.get('api_version_description', None)
        self.api_version_set_id = kwargs.get('api_version_set_id', None)
        self.subscription_required = kwargs.get('subscription_required', None)


class ApiContractProperties(ApiEntityBaseContract):
    """Api Entity Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param description: Description of the API. May include HTML formatting tags.
    :type description: str
    :param authentication_settings: Collection of authentication settings included into this API.
    :type authentication_settings: ~azure.mgmt.apimanagement.models.AuthenticationSettingsContract
    :param subscription_key_parameter_names: Protocols over which API is made available.
    :type subscription_key_parameter_names:
     ~azure.mgmt.apimanagement.models.SubscriptionKeyParameterNamesContract
    :param api_type: Type of API. Possible values include: "http", "soap".
    :type api_type: str or ~azure.mgmt.apimanagement.models.ApiType
    :param api_revision: Describes the Revision of the Api. If no value is provided, default
     revision 1 is created.
    :type api_revision: str
    :param api_version: Indicates the Version identifier of the API if the API is versioned.
    :type api_version: str
    :param is_current: Indicates if API revision is current api revision.
    :type is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :param api_revision_description: Description of the Api Revision.
    :type api_revision_description: str
    :param api_version_description: Description of the Api Version.
    :type api_version_description: str
    :param api_version_set_id: A resource identifier for the related ApiVersionSet.
    :type api_version_set_id: str
    :param subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :type subscription_required: bool
    :param source_api_id: API identifier of the source API.
    :type source_api_id: str
    :param display_name: API name. Must be 1 to 300 characters long.
    :type display_name: str
    :param service_url: Absolute URL of the backend service implementing this API. Cannot be more
     than 2000 characters long.
    :type service_url: str
    :param path: Required. Relative URL uniquely identifying this API and all of its resource paths
     within the API Management service instance. It is appended to the API endpoint base URL
     specified during the service instance creation to form a public URL for this API.
    :type path: str
    :param protocols: Describes on which protocols the operations in this API can be invoked.
    :type protocols: list[str or ~azure.mgmt.apimanagement.models.Protocol]
    :param api_version_set: Version set details.
    :type api_version_set: ~azure.mgmt.apimanagement.models.ApiVersionSetContractDetails
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 0},
        'path': {'required': True, 'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'source_api_id': {'key': 'sourceApiId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
        'api_version_set': {'key': 'apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiContractProperties, self).__init__(**kwargs)
        self.source_api_id = kwargs.get('source_api_id', None)
        self.display_name = kwargs.get('display_name', None)
        self.service_url = kwargs.get('service_url', None)
        self.path = kwargs['path']
        self.protocols = kwargs.get('protocols', None)
        self.api_version_set = kwargs.get('api_version_set', None)


class ApiContractUpdateProperties(ApiEntityBaseContract):
    """API update contract properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the API. May include HTML formatting tags.
    :type description: str
    :param authentication_settings: Collection of authentication settings included into this API.
    :type authentication_settings: ~azure.mgmt.apimanagement.models.AuthenticationSettingsContract
    :param subscription_key_parameter_names: Protocols over which API is made available.
    :type subscription_key_parameter_names:
     ~azure.mgmt.apimanagement.models.SubscriptionKeyParameterNamesContract
    :param api_type: Type of API. Possible values include: "http", "soap".
    :type api_type: str or ~azure.mgmt.apimanagement.models.ApiType
    :param api_revision: Describes the Revision of the Api. If no value is provided, default
     revision 1 is created.
    :type api_revision: str
    :param api_version: Indicates the Version identifier of the API if the API is versioned.
    :type api_version: str
    :param is_current: Indicates if API revision is current api revision.
    :type is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :param api_revision_description: Description of the Api Revision.
    :type api_revision_description: str
    :param api_version_description: Description of the Api Version.
    :type api_version_description: str
    :param api_version_set_id: A resource identifier for the related ApiVersionSet.
    :type api_version_set_id: str
    :param subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :type subscription_required: bool
    :param display_name: API name.
    :type display_name: str
    :param service_url: Absolute URL of the backend service implementing this API.
    :type service_url: str
    :param path: Relative URL uniquely identifying this API and all of its resource paths within
     the API Management service instance. It is appended to the API endpoint base URL specified
     during the service instance creation to form a public URL for this API.
    :type path: str
    :param protocols: Describes on which protocols the operations in this API can be invoked.
    :type protocols: list[str or ~azure.mgmt.apimanagement.models.Protocol]
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 1},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiContractUpdateProperties, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.service_url = kwargs.get('service_url', None)
        self.path = kwargs.get('path', None)
        self.protocols = kwargs.get('protocols', None)


class ApiCreateOrUpdateParameter(msrest.serialization.Model):
    """API Create or Update Parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the API. May include HTML formatting tags.
    :type description: str
    :param authentication_settings: Collection of authentication settings included into this API.
    :type authentication_settings: ~azure.mgmt.apimanagement.models.AuthenticationSettingsContract
    :param subscription_key_parameter_names: Protocols over which API is made available.
    :type subscription_key_parameter_names:
     ~azure.mgmt.apimanagement.models.SubscriptionKeyParameterNamesContract
    :param api_type: Type of API. Possible values include: "http", "soap".
    :type api_type: str or ~azure.mgmt.apimanagement.models.ApiType
    :param api_revision: Describes the Revision of the Api. If no value is provided, default
     revision 1 is created.
    :type api_revision: str
    :param api_version: Indicates the Version identifier of the API if the API is versioned.
    :type api_version: str
    :param is_current: Indicates if API revision is current api revision.
    :type is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :param api_revision_description: Description of the Api Revision.
    :type api_revision_description: str
    :param api_version_description: Description of the Api Version.
    :type api_version_description: str
    :param api_version_set_id: A resource identifier for the related ApiVersionSet.
    :type api_version_set_id: str
    :param subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :type subscription_required: bool
    :param source_api_id: API identifier of the source API.
    :type source_api_id: str
    :param display_name: API name. Must be 1 to 300 characters long.
    :type display_name: str
    :param service_url: Absolute URL of the backend service implementing this API. Cannot be more
     than 2000 characters long.
    :type service_url: str
    :param path: Relative URL uniquely identifying this API and all of its resource paths within
     the API Management service instance. It is appended to the API endpoint base URL specified
     during the service instance creation to form a public URL for this API.
    :type path: str
    :param protocols: Describes on which protocols the operations in this API can be invoked.
    :type protocols: list[str or ~azure.mgmt.apimanagement.models.Protocol]
    :param api_version_set: Version set details.
    :type api_version_set: ~azure.mgmt.apimanagement.models.ApiVersionSetContractDetails
    :param value: Content value when Importing an API.
    :type value: str
    :param format: Format of the Content in which the API is getting imported. Possible values
     include: "wadl-xml", "wadl-link-json", "swagger-json", "swagger-link-json", "wsdl",
     "wsdl-link", "openapi", "openapi+json", "openapi-link", "openapi+json-link".
    :type format: str or ~azure.mgmt.apimanagement.models.ContentFormat
    :param wsdl_selector: Criteria to limit import of WSDL to a subset of the document.
    :type wsdl_selector: ~azure.mgmt.apimanagement.models.ApiCreateOrUpdatePropertiesWsdlSelector
    :param soap_api_type: Type of Api to create.
    
    
     * ``http`` creates a SOAP to REST API
     * ``soap`` creates a SOAP pass-through API . Possible values include: "http", "soap".
    :type soap_api_type: str or ~azure.mgmt.apimanagement.models.SoapApiType
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 0},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'authentication_settings': {'key': 'properties.authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'properties.subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'properties.type', 'type': 'str'},
        'api_revision': {'key': 'properties.apiRevision', 'type': 'str'},
        'api_version': {'key': 'properties.apiVersion', 'type': 'str'},
        'is_current': {'key': 'properties.isCurrent', 'type': 'bool'},
        'is_online': {'key': 'properties.isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'properties.apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'properties.apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'properties.apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'source_api_id': {'key': 'properties.sourceApiId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'service_url': {'key': 'properties.serviceUrl', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'protocols': {'key': 'properties.protocols', 'type': '[str]'},
        'api_version_set': {'key': 'properties.apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'wsdl_selector': {'key': 'properties.wsdlSelector', 'type': 'ApiCreateOrUpdatePropertiesWsdlSelector'},
        'soap_api_type': {'key': 'properties.apiType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiCreateOrUpdateParameter, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.authentication_settings = kwargs.get('authentication_settings', None)
        self.subscription_key_parameter_names = kwargs.get('subscription_key_parameter_names', None)
        self.api_type = kwargs.get('api_type', None)
        self.api_revision = kwargs.get('api_revision', None)
        self.api_version = kwargs.get('api_version', None)
        self.is_current = kwargs.get('is_current', None)
        self.is_online = None
        self.api_revision_description = kwargs.get('api_revision_description', None)
        self.api_version_description = kwargs.get('api_version_description', None)
        self.api_version_set_id = kwargs.get('api_version_set_id', None)
        self.subscription_required = kwargs.get('subscription_required', None)
        self.source_api_id = kwargs.get('source_api_id', None)
        self.display_name = kwargs.get('display_name', None)
        self.service_url = kwargs.get('service_url', None)
        self.path = kwargs.get('path', None)
        self.protocols = kwargs.get('protocols', None)
        self.api_version_set = kwargs.get('api_version_set', None)
        self.value = kwargs.get('value', None)
        self.format = kwargs.get('format', None)
        self.wsdl_selector = kwargs.get('wsdl_selector', None)
        self.soap_api_type = kwargs.get('soap_api_type', None)


class ApiCreateOrUpdateProperties(ApiContractProperties):
    """Api Create or Update Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param description: Description of the API. May include HTML formatting tags.
    :type description: str
    :param authentication_settings: Collection of authentication settings included into this API.
    :type authentication_settings: ~azure.mgmt.apimanagement.models.AuthenticationSettingsContract
    :param subscription_key_parameter_names: Protocols over which API is made available.
    :type subscription_key_parameter_names:
     ~azure.mgmt.apimanagement.models.SubscriptionKeyParameterNamesContract
    :param api_type: Type of API. Possible values include: "http", "soap".
    :type api_type: str or ~azure.mgmt.apimanagement.models.ApiType
    :param api_revision: Describes the Revision of the Api. If no value is provided, default
     revision 1 is created.
    :type api_revision: str
    :param api_version: Indicates the Version identifier of the API if the API is versioned.
    :type api_version: str
    :param is_current: Indicates if API revision is current api revision.
    :type is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :param api_revision_description: Description of the Api Revision.
    :type api_revision_description: str
    :param api_version_description: Description of the Api Version.
    :type api_version_description: str
    :param api_version_set_id: A resource identifier for the related ApiVersionSet.
    :type api_version_set_id: str
    :param subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :type subscription_required: bool
    :param source_api_id: API identifier of the source API.
    :type source_api_id: str
    :param display_name: API name. Must be 1 to 300 characters long.
    :type display_name: str
    :param service_url: Absolute URL of the backend service implementing this API. Cannot be more
     than 2000 characters long.
    :type service_url: str
    :param path: Required. Relative URL uniquely identifying this API and all of its resource paths
     within the API Management service instance. It is appended to the API endpoint base URL
     specified during the service instance creation to form a public URL for this API.
    :type path: str
    :param protocols: Describes on which protocols the operations in this API can be invoked.
    :type protocols: list[str or ~azure.mgmt.apimanagement.models.Protocol]
    :param api_version_set: Version set details.
    :type api_version_set: ~azure.mgmt.apimanagement.models.ApiVersionSetContractDetails
    :param value: Content value when Importing an API.
    :type value: str
    :param format: Format of the Content in which the API is getting imported. Possible values
     include: "wadl-xml", "wadl-link-json", "swagger-json", "swagger-link-json", "wsdl",
     "wsdl-link", "openapi", "openapi+json", "openapi-link", "openapi+json-link".
    :type format: str or ~azure.mgmt.apimanagement.models.ContentFormat
    :param wsdl_selector: Criteria to limit import of WSDL to a subset of the document.
    :type wsdl_selector: ~azure.mgmt.apimanagement.models.ApiCreateOrUpdatePropertiesWsdlSelector
    :param soap_api_type: Type of Api to create.
    
    
     * ``http`` creates a SOAP to REST API
     * ``soap`` creates a SOAP pass-through API . Possible values include: "http", "soap".
    :type soap_api_type: str or ~azure.mgmt.apimanagement.models.SoapApiType
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 0},
        'path': {'required': True, 'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'source_api_id': {'key': 'sourceApiId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
        'api_version_set': {'key': 'apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
        'value': {'key': 'value', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
        'wsdl_selector': {'key': 'wsdlSelector', 'type': 'ApiCreateOrUpdatePropertiesWsdlSelector'},
        'soap_api_type': {'key': 'apiType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiCreateOrUpdateProperties, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.format = kwargs.get('format', None)
        self.wsdl_selector = kwargs.get('wsdl_selector', None)
        self.soap_api_type = kwargs.get('soap_api_type', None)


class ApiCreateOrUpdatePropertiesWsdlSelector(msrest.serialization.Model):
    """Criteria to limit import of WSDL to a subset of the document.

    :param wsdl_service_name: Name of service to import from WSDL.
    :type wsdl_service_name: str
    :param wsdl_endpoint_name: Name of endpoint(port) to import from WSDL.
    :type wsdl_endpoint_name: str
    """

    _attribute_map = {
        'wsdl_service_name': {'key': 'wsdlServiceName', 'type': 'str'},
        'wsdl_endpoint_name': {'key': 'wsdlEndpointName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiCreateOrUpdatePropertiesWsdlSelector, self).__init__(**kwargs)
        self.wsdl_service_name = kwargs.get('wsdl_service_name', None)
        self.wsdl_endpoint_name = kwargs.get('wsdl_endpoint_name', None)


class ApiExportResult(msrest.serialization.Model):
    """API Export result.

    :param id: ResourceId of the API which was exported.
    :type id: str
    :param export_result_format: Format in which the Api Details are exported to the Storage Blob
     with Sas Key valid for 5 minutes. Possible values include: "swagger-link-json",
     "wsdl-link+xml", "wadl-link-json", "openapi-link".
    :type export_result_format: str or ~azure.mgmt.apimanagement.models.ExportResultFormat
    :param value: The object defining the schema of the exported Api Detail.
    :type value: ~azure.mgmt.apimanagement.models.ApiExportResultValue
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'export_result_format': {'key': 'format', 'type': 'str'},
        'value': {'key': 'value', 'type': 'ApiExportResultValue'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiExportResult, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.export_result_format = kwargs.get('export_result_format', None)
        self.value = kwargs.get('value', None)


class ApiExportResultValue(msrest.serialization.Model):
    """The object defining the schema of the exported Api Detail.

    :param link: Link to the Storage Blob containing the result of the export operation. The Blob
     Uri is only valid for 5 minutes.
    :type link: str
    """

    _attribute_map = {
        'link': {'key': 'link', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiExportResultValue, self).__init__(**kwargs)
        self.link = kwargs.get('link', None)


class ApiManagementServiceApplyNetworkConfigurationParameters(msrest.serialization.Model):
    """Parameter supplied to the Apply Network configuration operation.

    :param location: Location of the Api Management service to update for a multi-region service.
     For a service deployed in a single region, this parameter is not required.
    :type location: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceApplyNetworkConfigurationParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)


class ApiManagementServiceBackupRestoreParameters(msrest.serialization.Model):
    """Parameters supplied to the Backup/Restore of an API Management service operation.

    All required parameters must be populated in order to send to Azure.

    :param storage_account: Required. Azure Cloud Storage account (used to place/retrieve the
     backup) name.
    :type storage_account: str
    :param access_key: Required. Azure Cloud Storage account (used to place/retrieve the backup)
     access key.
    :type access_key: str
    :param container_name: Required. Azure Cloud Storage blob container name used to place/retrieve
     the backup.
    :type container_name: str
    :param backup_name: Required. The name of the backup file to create.
    :type backup_name: str
    """

    _validation = {
        'storage_account': {'required': True},
        'access_key': {'required': True},
        'container_name': {'required': True},
        'backup_name': {'required': True},
    }

    _attribute_map = {
        'storage_account': {'key': 'storageAccount', 'type': 'str'},
        'access_key': {'key': 'accessKey', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'backup_name': {'key': 'backupName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceBackupRestoreParameters, self).__init__(**kwargs)
        self.storage_account = kwargs['storage_account']
        self.access_key = kwargs['access_key']
        self.container_name = kwargs['container_name']
        self.backup_name = kwargs['backup_name']


class ApiManagementServiceBaseProperties(msrest.serialization.Model):
    """Base Properties of an API Management service resource description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param notification_sender_email: Email address from which the notification will be sent.
    :type notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :param hostname_configurations: Custom hostname configuration of the API Management service.
    :type hostname_configurations: list[~azure.mgmt.apimanagement.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :param virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :type virtual_network_configuration:
     ~azure.mgmt.apimanagement.models.VirtualNetworkConfiguration
    :param additional_locations: Additional datacenter locations of the API Management service.
    :type additional_locations: list[~azure.mgmt.apimanagement.models.AdditionalLocation]
    :param custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :type custom_properties: dict[str, str]
    :param certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :type certificates: list[~azure.mgmt.apimanagement.models.CertificateConfiguration]
    :param enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :type enable_client_certificate: bool
    :param disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :type disable_gateway: bool
    :param virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :type virtual_network_type: str or ~azure.mgmt.apimanagement.models.VirtualNetworkType
    :param api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :type api_version_constraint: ~azure.mgmt.apimanagement.models.ApiVersionConstraint
    :param restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :type restore: bool
    """

    _validation = {
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
    }

    _attribute_map = {
        'notification_sender_email': {'key': 'notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'privateIPAddresses', 'type': '[str]'},
        'virtual_network_configuration': {'key': 'virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'customProperties', 'type': '{str}'},
        'certificates': {'key': 'certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'restore', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceBaseProperties, self).__init__(**kwargs)
        self.notification_sender_email = kwargs.get('notification_sender_email', None)
        self.provisioning_state = None
        self.target_provisioning_state = None
        self.created_at_utc = None
        self.gateway_url = None
        self.gateway_regional_url = None
        self.portal_url = None
        self.management_api_url = None
        self.scm_url = None
        self.developer_portal_url = None
        self.hostname_configurations = kwargs.get('hostname_configurations', None)
        self.public_ip_addresses = None
        self.private_ip_addresses = None
        self.virtual_network_configuration = kwargs.get('virtual_network_configuration', None)
        self.additional_locations = kwargs.get('additional_locations', None)
        self.custom_properties = kwargs.get('custom_properties', None)
        self.certificates = kwargs.get('certificates', None)
        self.enable_client_certificate = kwargs.get('enable_client_certificate', False)
        self.disable_gateway = kwargs.get('disable_gateway', False)
        self.virtual_network_type = kwargs.get('virtual_network_type', "None")
        self.api_version_constraint = kwargs.get('api_version_constraint', None)
        self.restore = kwargs.get('restore', False)


class ApiManagementServiceCheckNameAvailabilityParameters(msrest.serialization.Model):
    """Parameters supplied to the CheckNameAvailability operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name to check for availability.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceCheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = kwargs['name']


class ApiManagementServiceGetDomainOwnershipIdentifierResult(msrest.serialization.Model):
    """Response of the GetDomainOwnershipIdentifier operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar domain_ownership_identifier: The domain ownership identifier value.
    :vartype domain_ownership_identifier: str
    """

    _validation = {
        'domain_ownership_identifier': {'readonly': True},
    }

    _attribute_map = {
        'domain_ownership_identifier': {'key': 'domainOwnershipIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceGetDomainOwnershipIdentifierResult, self).__init__(**kwargs)
        self.domain_ownership_identifier = None


class ApiManagementServiceGetSsoTokenResult(msrest.serialization.Model):
    """The response of the GetSsoToken operation.

    :param redirect_uri: Redirect URL to the Publisher Portal containing the SSO token.
    :type redirect_uri: str
    """

    _attribute_map = {
        'redirect_uri': {'key': 'redirectUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceGetSsoTokenResult, self).__init__(**kwargs)
        self.redirect_uri = kwargs.get('redirect_uri', None)


class ApiManagementServiceIdentity(msrest.serialization.Model):
    """Identity properties of the Api Management service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of identity used for the resource. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user assigned
     identities. The type 'None' will remove any identities from the service. Possible values
     include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.apimanagement.models.ApimIdentityType
    :ivar principal_id: The principal id of the identity.
    :vartype principal_id: str
    :ivar tenant_id: The client tenant id of the identity.
    :vartype tenant_id: str
    :param user_assigned_identities: The list of user identities associated with the resource. The
     user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
         providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.apimanagement.models.UserIdentityProperties]
    """

    _validation = {
        'type': {'required': True},
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceIdentity, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.principal_id = None
        self.tenant_id = None
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class ApiManagementServiceListResult(msrest.serialization.Model):
    """The response of the List API Management services operation.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Result of the List API Management services operation.
    :type value: list[~azure.mgmt.apimanagement.models.ApiManagementServiceResource]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of API Management services.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiManagementServiceResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceListResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class ApiManagementServiceNameAvailabilityResult(msrest.serialization.Model):
    """Response of the CheckNameAvailability operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: True if the name is available and can be used to create a new API
     Management service; otherwise false.
    :vartype name_available: bool
    :ivar message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that :code:`<resourceName>` is already in use, and direct
     them to select a different name.
    :vartype message: str
    :param reason: Invalid indicates the name provided does not match the resource provider’s
     naming requirements (incorrect length, unsupported characters, etc.)  AlreadyExists indicates
     that the name is already in use and is therefore unavailable. Possible values include: "Valid",
     "Invalid", "AlreadyExists".
    :type reason: str or ~azure.mgmt.apimanagement.models.NameAvailabilityReason
    """

    _validation = {
        'name_available': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'message': {'key': 'message', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.message = None
        self.reason = kwargs.get('reason', None)


class ApiManagementServiceProperties(ApiManagementServiceBaseProperties):
    """Properties of an API Management service resource description.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param notification_sender_email: Email address from which the notification will be sent.
    :type notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :param hostname_configurations: Custom hostname configuration of the API Management service.
    :type hostname_configurations: list[~azure.mgmt.apimanagement.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :param virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :type virtual_network_configuration:
     ~azure.mgmt.apimanagement.models.VirtualNetworkConfiguration
    :param additional_locations: Additional datacenter locations of the API Management service.
    :type additional_locations: list[~azure.mgmt.apimanagement.models.AdditionalLocation]
    :param custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :type custom_properties: dict[str, str]
    :param certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :type certificates: list[~azure.mgmt.apimanagement.models.CertificateConfiguration]
    :param enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :type enable_client_certificate: bool
    :param disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :type disable_gateway: bool
    :param virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :type virtual_network_type: str or ~azure.mgmt.apimanagement.models.VirtualNetworkType
    :param api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :type api_version_constraint: ~azure.mgmt.apimanagement.models.ApiVersionConstraint
    :param restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :type restore: bool
    :param publisher_email: Required. Publisher email.
    :type publisher_email: str
    :param publisher_name: Required. Publisher name.
    :type publisher_name: str
    """

    _validation = {
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'publisher_email': {'required': True, 'max_length': 100, 'min_length': 0},
        'publisher_name': {'required': True, 'max_length': 100, 'min_length': 0},
    }

    _attribute_map = {
        'notification_sender_email': {'key': 'notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'privateIPAddresses', 'type': '[str]'},
        'virtual_network_configuration': {'key': 'virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'customProperties', 'type': '{str}'},
        'certificates': {'key': 'certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'restore', 'type': 'bool'},
        'publisher_email': {'key': 'publisherEmail', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceProperties, self).__init__(**kwargs)
        self.publisher_email = kwargs['publisher_email']
        self.publisher_name = kwargs['publisher_name']


class ApimResource(msrest.serialization.Model):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource is set to Microsoft.ApiManagement.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApimResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = kwargs.get('tags', None)


class ApiManagementServiceResource(ApimResource):
    """A single API Management service resource in List or Get response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource is set to Microsoft.ApiManagement.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. SKU properties of the API Management service.
    :type sku: ~azure.mgmt.apimanagement.models.ApiManagementServiceSkuProperties
    :param identity: Managed service identity of the Api Management service.
    :type identity: ~azure.mgmt.apimanagement.models.ApiManagementServiceIdentity
    :param location: Required. Resource location.
    :type location: str
    :ivar etag: ETag of the resource.
    :vartype etag: str
    :param zones: A list of availability zones denoting where the resource needs to come from.
    :type zones: list[str]
    :param notification_sender_email: Email address from which the notification will be sent.
    :type notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :param hostname_configurations: Custom hostname configuration of the API Management service.
    :type hostname_configurations: list[~azure.mgmt.apimanagement.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :param virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :type virtual_network_configuration:
     ~azure.mgmt.apimanagement.models.VirtualNetworkConfiguration
    :param additional_locations: Additional datacenter locations of the API Management service.
    :type additional_locations: list[~azure.mgmt.apimanagement.models.AdditionalLocation]
    :param custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :type custom_properties: dict[str, str]
    :param certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :type certificates: list[~azure.mgmt.apimanagement.models.CertificateConfiguration]
    :param enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :type enable_client_certificate: bool
    :param disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :type disable_gateway: bool
    :param virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :type virtual_network_type: str or ~azure.mgmt.apimanagement.models.VirtualNetworkType
    :param api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :type api_version_constraint: ~azure.mgmt.apimanagement.models.ApiVersionConstraint
    :param restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :type restore: bool
    :param publisher_email: Required. Publisher email.
    :type publisher_email: str
    :param publisher_name: Required. Publisher name.
    :type publisher_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sku': {'required': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'publisher_email': {'required': True, 'max_length': 100, 'min_length': 0},
        'publisher_name': {'required': True, 'max_length': 100, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ApiManagementServiceSkuProperties'},
        'identity': {'key': 'identity', 'type': 'ApiManagementServiceIdentity'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'notification_sender_email': {'key': 'properties.notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'properties.targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'properties.createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'properties.gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'properties.gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'properties.portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'properties.managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'properties.scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'properties.developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'properties.hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'properties.publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'properties.privateIPAddresses', 'type': '[str]'},
        'virtual_network_configuration': {'key': 'properties.virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'properties.additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'properties.customProperties', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'properties.enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'properties.disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'properties.virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'properties.apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'properties.restore', 'type': 'bool'},
        'publisher_email': {'key': 'properties.publisherEmail', 'type': 'str'},
        'publisher_name': {'key': 'properties.publisherName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceResource, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.identity = kwargs.get('identity', None)
        self.location = kwargs['location']
        self.etag = None
        self.zones = kwargs.get('zones', None)
        self.notification_sender_email = kwargs.get('notification_sender_email', None)
        self.provisioning_state = None
        self.target_provisioning_state = None
        self.created_at_utc = None
        self.gateway_url = None
        self.gateway_regional_url = None
        self.portal_url = None
        self.management_api_url = None
        self.scm_url = None
        self.developer_portal_url = None
        self.hostname_configurations = kwargs.get('hostname_configurations', None)
        self.public_ip_addresses = None
        self.private_ip_addresses = None
        self.virtual_network_configuration = kwargs.get('virtual_network_configuration', None)
        self.additional_locations = kwargs.get('additional_locations', None)
        self.custom_properties = kwargs.get('custom_properties', None)
        self.certificates = kwargs.get('certificates', None)
        self.enable_client_certificate = kwargs.get('enable_client_certificate', False)
        self.disable_gateway = kwargs.get('disable_gateway', False)
        self.virtual_network_type = kwargs.get('virtual_network_type', "None")
        self.api_version_constraint = kwargs.get('api_version_constraint', None)
        self.restore = kwargs.get('restore', False)
        self.publisher_email = kwargs['publisher_email']
        self.publisher_name = kwargs['publisher_name']


class ApiManagementServiceSkuProperties(msrest.serialization.Model):
    """API Management service resource SKU properties.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the Sku. Possible values include: "Developer", "Standard",
     "Premium", "Basic", "Consumption", "Isolated".
    :type name: str or ~azure.mgmt.apimanagement.models.SkuType
    :param capacity: Required. Capacity of the SKU (number of deployed units of the SKU). For
     Consumption SKU capacity must be specified as 0.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceSkuProperties, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.capacity = kwargs['capacity']


class ApiManagementServiceUpdateParameters(ApimResource):
    """Parameter supplied to Update Api Management Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource is set to Microsoft.ApiManagement.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: SKU properties of the API Management service.
    :type sku: ~azure.mgmt.apimanagement.models.ApiManagementServiceSkuProperties
    :param identity: Managed service identity of the Api Management service.
    :type identity: ~azure.mgmt.apimanagement.models.ApiManagementServiceIdentity
    :ivar etag: ETag of the resource.
    :vartype etag: str
    :param notification_sender_email: Email address from which the notification will be sent.
    :type notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :param hostname_configurations: Custom hostname configuration of the API Management service.
    :type hostname_configurations: list[~azure.mgmt.apimanagement.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :param virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :type virtual_network_configuration:
     ~azure.mgmt.apimanagement.models.VirtualNetworkConfiguration
    :param additional_locations: Additional datacenter locations of the API Management service.
    :type additional_locations: list[~azure.mgmt.apimanagement.models.AdditionalLocation]
    :param custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :type custom_properties: dict[str, str]
    :param certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :type certificates: list[~azure.mgmt.apimanagement.models.CertificateConfiguration]
    :param enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :type enable_client_certificate: bool
    :param disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :type disable_gateway: bool
    :param virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :type virtual_network_type: str or ~azure.mgmt.apimanagement.models.VirtualNetworkType
    :param api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :type api_version_constraint: ~azure.mgmt.apimanagement.models.ApiVersionConstraint
    :param restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :type restore: bool
    :param publisher_email: Publisher email.
    :type publisher_email: str
    :param publisher_name: Publisher name.
    :type publisher_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'publisher_email': {'max_length': 100, 'min_length': 0},
        'publisher_name': {'max_length': 100, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ApiManagementServiceSkuProperties'},
        'identity': {'key': 'identity', 'type': 'ApiManagementServiceIdentity'},
        'etag': {'key': 'etag', 'type': 'str'},
        'notification_sender_email': {'key': 'properties.notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'properties.targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'properties.createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'properties.gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'properties.gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'properties.portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'properties.managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'properties.scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'properties.developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'properties.hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'properties.publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'properties.privateIPAddresses', 'type': '[str]'},
        'virtual_network_configuration': {'key': 'properties.virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'properties.additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'properties.customProperties', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'properties.enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'properties.disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'properties.virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'properties.apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'properties.restore', 'type': 'bool'},
        'publisher_email': {'key': 'properties.publisherEmail', 'type': 'str'},
        'publisher_name': {'key': 'properties.publisherName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceUpdateParameters, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.identity = kwargs.get('identity', None)
        self.etag = None
        self.notification_sender_email = kwargs.get('notification_sender_email', None)
        self.provisioning_state = None
        self.target_provisioning_state = None
        self.created_at_utc = None
        self.gateway_url = None
        self.gateway_regional_url = None
        self.portal_url = None
        self.management_api_url = None
        self.scm_url = None
        self.developer_portal_url = None
        self.hostname_configurations = kwargs.get('hostname_configurations', None)
        self.public_ip_addresses = None
        self.private_ip_addresses = None
        self.virtual_network_configuration = kwargs.get('virtual_network_configuration', None)
        self.additional_locations = kwargs.get('additional_locations', None)
        self.custom_properties = kwargs.get('custom_properties', None)
        self.certificates = kwargs.get('certificates', None)
        self.enable_client_certificate = kwargs.get('enable_client_certificate', False)
        self.disable_gateway = kwargs.get('disable_gateway', False)
        self.virtual_network_type = kwargs.get('virtual_network_type', "None")
        self.api_version_constraint = kwargs.get('api_version_constraint', None)
        self.restore = kwargs.get('restore', False)
        self.publisher_email = kwargs.get('publisher_email', None)
        self.publisher_name = kwargs.get('publisher_name', None)


class ApiManagementServiceUpdateProperties(ApiManagementServiceBaseProperties):
    """Properties of an API Management service resource description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param notification_sender_email: Email address from which the notification will be sent.
    :type notification_sender_email: str
    :ivar provisioning_state: The current provisioning state of the API Management service which
     can be one of the following:
     Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
    :vartype provisioning_state: str
    :ivar target_provisioning_state: The provisioning state of the API Management service, which is
     targeted by the long running operation started on the service.
    :vartype target_provisioning_state: str
    :ivar created_at_utc: Creation UTC date of the API Management service.The date conforms to the
     following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_at_utc: ~datetime.datetime
    :ivar gateway_url: Gateway URL of the API Management service.
    :vartype gateway_url: str
    :ivar gateway_regional_url: Gateway URL of the API Management service in the Default Region.
    :vartype gateway_regional_url: str
    :ivar portal_url: Publisher portal endpoint Url of the API Management service.
    :vartype portal_url: str
    :ivar management_api_url: Management API endpoint URL of the API Management service.
    :vartype management_api_url: str
    :ivar scm_url: SCM endpoint URL of the API Management service.
    :vartype scm_url: str
    :ivar developer_portal_url: DEveloper Portal endpoint URL of the API Management service.
    :vartype developer_portal_url: str
    :param hostname_configurations: Custom hostname configuration of the API Management service.
    :type hostname_configurations: list[~azure.mgmt.apimanagement.models.HostnameConfiguration]
    :ivar public_ip_addresses: Public Static Load Balanced IP addresses of the API Management
     service in Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
    :vartype public_ip_addresses: list[str]
    :ivar private_ip_addresses: Private Static Load Balanced IP addresses of the API Management
     service in Primary region which is deployed in an Internal Virtual Network. Available only for
     Basic, Standard, Premium and Isolated SKU.
    :vartype private_ip_addresses: list[str]
    :param virtual_network_configuration: Virtual network configuration of the API Management
     service.
    :type virtual_network_configuration:
     ~azure.mgmt.apimanagement.models.VirtualNetworkConfiguration
    :param additional_locations: Additional datacenter locations of the API Management service.
    :type additional_locations: list[~azure.mgmt.apimanagement.models.AdditionalLocation]
    :param custom_properties: Custom properties of the API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168`` will disable the
     cipher TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11`` can be used to
     disable just TLS 1.1.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10`` can be used to
     disable TLS 1.0 on an API Management service.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11`` can be used
     to disable just TLS 1.1 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10`` can be used
     to disable TLS 1.0 for communications with backends.</br>Setting
     ``Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2`` can be used to enable
     HTTP2 protocol on an API Management service.</br>Not specifying any of these properties on
     PATCH operation will reset omitted properties' values to their defaults. For all the settings
     except Http2 the default value is ``True`` if the service was created on or before April 1st
     2018 and ``False`` otherwise. Http2 setting's default value is ``False``.</br></br>You can
     disable any of next ciphers by using settings
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA,
     TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,
     TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA.
     For example,
     `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:\
     ``false``. The default value is ``true`` for them.  Note: next ciphers can't be disabled since
     they are required by Azure CloudService internal components:
     TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256,TLS_RSA_WITH_AES_256_GCM_SHA384.
    :type custom_properties: dict[str, str]
    :param certificates: List of Certificates that need to be installed in the API Management
     service. Max supported certificates that can be installed is 10.
    :type certificates: list[~azure.mgmt.apimanagement.models.CertificateConfiguration]
    :param enable_client_certificate: Property only meant to be used for Consumption SKU Service.
     This enforces a client certificate to be presented on each request to the gateway. This also
     enables the ability to authenticate the certificate in the policy on the gateway.
    :type enable_client_certificate: bool
    :param disable_gateway: Property only valid for an Api Management service deployed in multiple
     locations. This can be used to disable the gateway in master region.
    :type disable_gateway: bool
    :param virtual_network_type: The type of VPN in which API Management service needs to be
     configured in. None (Default Value) means the API Management service is not part of any Virtual
     Network, External means the API Management deployment is set up inside a Virtual Network having
     an Internet Facing Endpoint, and Internal means that API Management deployment is setup inside
     a Virtual Network having an Intranet Facing Endpoint only. Possible values include: "None",
     "External", "Internal". Default value: "None".
    :type virtual_network_type: str or ~azure.mgmt.apimanagement.models.VirtualNetworkType
    :param api_version_constraint: Control Plane Apis version constraint for the API Management
     service.
    :type api_version_constraint: ~azure.mgmt.apimanagement.models.ApiVersionConstraint
    :param restore: Undelete Api Management Service if it was previously soft-deleted. If this flag
     is specified and set to True all other properties will be ignored.
    :type restore: bool
    :param publisher_email: Publisher email.
    :type publisher_email: str
    :param publisher_name: Publisher name.
    :type publisher_name: str
    """

    _validation = {
        'notification_sender_email': {'max_length': 100, 'min_length': 0},
        'provisioning_state': {'readonly': True},
        'target_provisioning_state': {'readonly': True},
        'created_at_utc': {'readonly': True},
        'gateway_url': {'readonly': True},
        'gateway_regional_url': {'readonly': True},
        'portal_url': {'readonly': True},
        'management_api_url': {'readonly': True},
        'scm_url': {'readonly': True},
        'developer_portal_url': {'readonly': True},
        'public_ip_addresses': {'readonly': True},
        'private_ip_addresses': {'readonly': True},
        'publisher_email': {'max_length': 100, 'min_length': 0},
        'publisher_name': {'max_length': 100, 'min_length': 0},
    }

    _attribute_map = {
        'notification_sender_email': {'key': 'notificationSenderEmail', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'target_provisioning_state': {'key': 'targetProvisioningState', 'type': 'str'},
        'created_at_utc': {'key': 'createdAtUtc', 'type': 'iso-8601'},
        'gateway_url': {'key': 'gatewayUrl', 'type': 'str'},
        'gateway_regional_url': {'key': 'gatewayRegionalUrl', 'type': 'str'},
        'portal_url': {'key': 'portalUrl', 'type': 'str'},
        'management_api_url': {'key': 'managementApiUrl', 'type': 'str'},
        'scm_url': {'key': 'scmUrl', 'type': 'str'},
        'developer_portal_url': {'key': 'developerPortalUrl', 'type': 'str'},
        'hostname_configurations': {'key': 'hostnameConfigurations', 'type': '[HostnameConfiguration]'},
        'public_ip_addresses': {'key': 'publicIPAddresses', 'type': '[str]'},
        'private_ip_addresses': {'key': 'privateIPAddresses', 'type': '[str]'},
        'virtual_network_configuration': {'key': 'virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
        'additional_locations': {'key': 'additionalLocations', 'type': '[AdditionalLocation]'},
        'custom_properties': {'key': 'customProperties', 'type': '{str}'},
        'certificates': {'key': 'certificates', 'type': '[CertificateConfiguration]'},
        'enable_client_certificate': {'key': 'enableClientCertificate', 'type': 'bool'},
        'disable_gateway': {'key': 'disableGateway', 'type': 'bool'},
        'virtual_network_type': {'key': 'virtualNetworkType', 'type': 'str'},
        'api_version_constraint': {'key': 'apiVersionConstraint', 'type': 'ApiVersionConstraint'},
        'restore': {'key': 'restore', 'type': 'bool'},
        'publisher_email': {'key': 'publisherEmail', 'type': 'str'},
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementServiceUpdateProperties, self).__init__(**kwargs)
        self.publisher_email = kwargs.get('publisher_email', None)
        self.publisher_name = kwargs.get('publisher_name', None)


class ApiManagementSku(msrest.serialization.Model):
    """Describes an available ApiManagement SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU.
    :vartype name: str
    :ivar tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
     **Basic**.
    :vartype tier: str
    :ivar size: The Size of the SKU.
    :vartype size: str
    :ivar family: The Family of this particular SKU.
    :vartype family: str
    :ivar kind: The Kind of resources that are supported in this SKU.
    :vartype kind: str
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~azure.mgmt.apimanagement.models.ApiManagementSkuCapacity
    :ivar locations: The set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar location_info: A list of locations and availability zones in those locations where the
     SKU is available.
    :vartype location_info: list[~azure.mgmt.apimanagement.models.ApiManagementSkuLocationInfo]
    :ivar api_versions: The api versions that support this SKU.
    :vartype api_versions: list[str]
    :ivar costs: Metadata for retrieving price info.
    :vartype costs: list[~azure.mgmt.apimanagement.models.ApiManagementSkuCosts]
    :ivar capabilities: A name value pair to describe the capability.
    :vartype capabilities: list[~azure.mgmt.apimanagement.models.ApiManagementSkuCapabilities]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.apimanagement.models.ApiManagementSkuRestrictions]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'tier': {'readonly': True},
        'size': {'readonly': True},
        'family': {'readonly': True},
        'kind': {'readonly': True},
        'capacity': {'readonly': True},
        'locations': {'readonly': True},
        'location_info': {'readonly': True},
        'api_versions': {'readonly': True},
        'costs': {'readonly': True},
        'capabilities': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'ApiManagementSkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[ApiManagementSkuLocationInfo]'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
        'costs': {'key': 'costs', 'type': '[ApiManagementSkuCosts]'},
        'capabilities': {'key': 'capabilities', 'type': '[ApiManagementSkuCapabilities]'},
        'restrictions': {'key': 'restrictions', 'type': '[ApiManagementSkuRestrictions]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementSku, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.tier = None
        self.size = None
        self.family = None
        self.kind = None
        self.capacity = None
        self.locations = None
        self.location_info = None
        self.api_versions = None
        self.costs = None
        self.capabilities = None
        self.restrictions = None


class ApiManagementSkuCapabilities(msrest.serialization.Model):
    """Describes The SKU capabilities object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: An invariant to describe the feature.
    :vartype name: str
    :ivar value: An invariant if the feature is measured by quantity.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementSkuCapabilities, self).__init__(**kwargs)
        self.name = None
        self.value = None


class ApiManagementSkuCapacity(msrest.serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The scale type applicable to the sku. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~azure.mgmt.apimanagement.models.ApiManagementSkuCapacityScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class ApiManagementSkuCosts(msrest.serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Used for querying price from commerce.
    :vartype meter_id: str
    :ivar quantity: The multiplier is needed to extend the base metered cost.
    :vartype quantity: long
    :ivar extended_unit: An invariant to show the extended unit.
    :vartype extended_unit: str
    """

    _validation = {
        'meter_id': {'readonly': True},
        'quantity': {'readonly': True},
        'extended_unit': {'readonly': True},
    }

    _attribute_map = {
        'meter_id': {'key': 'meterID', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'long'},
        'extended_unit': {'key': 'extendedUnit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementSkuCosts, self).__init__(**kwargs)
        self.meter_id = None
        self.quantity = None
        self.extended_unit = None


class ApiManagementSkuLocationInfo(msrest.serialization.Model):
    """ApiManagementSkuLocationInfo.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location of the SKU.
    :vartype location: str
    :ivar zones: List of availability zones where the SKU is supported.
    :vartype zones: list[str]
    :ivar zone_details: Details of capabilities available to a SKU in specific zones.
    :vartype zone_details: list[~azure.mgmt.apimanagement.models.ApiManagementSkuZoneDetails]
    """

    _validation = {
        'location': {'readonly': True},
        'zones': {'readonly': True},
        'zone_details': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'zone_details': {'key': 'zoneDetails', 'type': '[ApiManagementSkuZoneDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementSkuLocationInfo, self).__init__(**kwargs)
        self.location = None
        self.zones = None
        self.zone_details = None


class ApiManagementSkuRestrictionInfo(msrest.serialization.Model):
    """ApiManagementSkuRestrictionInfo.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar locations: Locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: List of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    _validation = {
        'locations': {'readonly': True},
        'zones': {'readonly': True},
    }

    _attribute_map = {
        'locations': {'key': 'locations', 'type': '[str]'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementSkuRestrictionInfo, self).__init__(**kwargs)
        self.locations = None
        self.zones = None


class ApiManagementSkuRestrictions(msrest.serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. Possible values include: "Location", "Zone".
    :vartype type: str or ~azure.mgmt.apimanagement.models.ApiManagementSkuRestrictionsType
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar restriction_info: The information about the restriction where the SKU cannot be used.
    :vartype restriction_info: ~azure.mgmt.apimanagement.models.ApiManagementSkuRestrictionInfo
    :ivar reason_code: The reason for restriction. Possible values include: "QuotaId",
     "NotAvailableForSubscription".
    :vartype reason_code: str or
     ~azure.mgmt.apimanagement.models.ApiManagementSkuRestrictionsReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
        'restriction_info': {'readonly': True},
        'reason_code': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'restriction_info': {'key': 'restrictionInfo', 'type': 'ApiManagementSkuRestrictionInfo'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementSkuRestrictions, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.restriction_info = None
        self.reason_code = None


class ApiManagementSkusResult(msrest.serialization.Model):
    """The List Resource Skus operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of skus available for the subscription.
    :type value: list[~azure.mgmt.apimanagement.models.ApiManagementSku]
    :ivar next_link: The URI to fetch the next page of Resource Skus. Call ListNext() with this URI
     to fetch the next page of Resource Skus.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiManagementSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementSkusResult, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ApiManagementSkuZoneDetails(msrest.serialization.Model):
    """Describes The zonal capabilities of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The set of zones that the SKU is available in with the specified capabilities.
    :vartype name: list[str]
    :ivar capabilities: A list of capabilities that are available for the SKU in the specified list
     of zones.
    :vartype capabilities: list[~azure.mgmt.apimanagement.models.ApiManagementSkuCapabilities]
    """

    _validation = {
        'name': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[ApiManagementSkuCapabilities]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementSkuZoneDetails, self).__init__(**kwargs)
        self.name = None
        self.capabilities = None


class ApiReleaseCollection(msrest.serialization.Model):
    """Paged ApiRelease list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.ApiReleaseContract]
    :param count: Total record count number across all pages.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiReleaseContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiReleaseCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class ApiReleaseContract(Resource):
    """ApiRelease details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param api_id: Identifier of the API the release belongs to.
    :type api_id: str
    :ivar created_date_time: The time the API was released. The date conforms to the following
     format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype created_date_time: ~datetime.datetime
    :ivar updated_date_time: The time the API release was updated.
    :vartype updated_date_time: ~datetime.datetime
    :param notes: Release Notes.
    :type notes: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date_time': {'readonly': True},
        'updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'api_id': {'key': 'properties.apiId', 'type': 'str'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'updated_date_time': {'key': 'properties.updatedDateTime', 'type': 'iso-8601'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiReleaseContract, self).__init__(**kwargs)
        self.api_id = kwargs.get('api_id', None)
        self.created_date_time = None
        self.updated_date_time = None
        self.notes = kwargs.get('notes', None)


class ApiRevisionCollection(msrest.serialization.Model):
    """Paged Api Revision list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.ApiRevisionContract]
    :param count: Total record count number across all pages.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiRevisionContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiRevisionCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class ApiRevisionContract(msrest.serialization.Model):
    """Summary of revision metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar api_id: Identifier of the API Revision.
    :vartype api_id: str
    :ivar api_revision: Revision number of API.
    :vartype api_revision: str
    :ivar created_date_time: The time the API Revision was created. The date conforms to the
     following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype created_date_time: ~datetime.datetime
    :ivar updated_date_time: The time the API Revision were updated. The date conforms to the
     following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype updated_date_time: ~datetime.datetime
    :ivar description: Description of the API Revision.
    :vartype description: str
    :ivar private_url: Gateway URL for accessing the non-current API Revision.
    :vartype private_url: str
    :ivar is_online: Indicates if API revision is the current api revision.
    :vartype is_online: bool
    :ivar is_current: Indicates if API revision is accessible via the gateway.
    :vartype is_current: bool
    """

    _validation = {
        'api_id': {'readonly': True},
        'api_revision': {'readonly': True, 'max_length': 100, 'min_length': 1},
        'created_date_time': {'readonly': True},
        'updated_date_time': {'readonly': True},
        'description': {'readonly': True, 'max_length': 256, 'min_length': 0},
        'private_url': {'readonly': True},
        'is_online': {'readonly': True},
        'is_current': {'readonly': True},
    }

    _attribute_map = {
        'api_id': {'key': 'apiId', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'updated_date_time': {'key': 'updatedDateTime', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'private_url': {'key': 'privateUrl', 'type': 'str'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiRevisionContract, self).__init__(**kwargs)
        self.api_id = None
        self.api_revision = None
        self.created_date_time = None
        self.updated_date_time = None
        self.description = None
        self.private_url = None
        self.is_online = None
        self.is_current = None


class ApiRevisionInfoContract(msrest.serialization.Model):
    """Object used to create an API Revision or Version based on an existing API Revision.

    :param source_api_id: Resource identifier of API to be used to create the revision from.
    :type source_api_id: str
    :param api_version_name: Version identifier for the new API Version.
    :type api_version_name: str
    :param api_revision_description: Description of new API Revision.
    :type api_revision_description: str
    :param api_version_set: Version set details.
    :type api_version_set: ~azure.mgmt.apimanagement.models.ApiVersionSetContractDetails
    """

    _validation = {
        'api_version_name': {'max_length': 100, 'min_length': 0},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'source_api_id': {'key': 'sourceApiId', 'type': 'str'},
        'api_version_name': {'key': 'apiVersionName', 'type': 'str'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_set': {'key': 'apiVersionSet', 'type': 'ApiVersionSetContractDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiRevisionInfoContract, self).__init__(**kwargs)
        self.source_api_id = kwargs.get('source_api_id', None)
        self.api_version_name = kwargs.get('api_version_name', None)
        self.api_revision_description = kwargs.get('api_revision_description', None)
        self.api_version_set = kwargs.get('api_version_set', None)


class ApiTagResourceContractProperties(ApiEntityBaseContract):
    """API contract properties for the Tag Resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the API. May include HTML formatting tags.
    :type description: str
    :param authentication_settings: Collection of authentication settings included into this API.
    :type authentication_settings: ~azure.mgmt.apimanagement.models.AuthenticationSettingsContract
    :param subscription_key_parameter_names: Protocols over which API is made available.
    :type subscription_key_parameter_names:
     ~azure.mgmt.apimanagement.models.SubscriptionKeyParameterNamesContract
    :param api_type: Type of API. Possible values include: "http", "soap".
    :type api_type: str or ~azure.mgmt.apimanagement.models.ApiType
    :param api_revision: Describes the Revision of the Api. If no value is provided, default
     revision 1 is created.
    :type api_revision: str
    :param api_version: Indicates the Version identifier of the API if the API is versioned.
    :type api_version: str
    :param is_current: Indicates if API revision is current api revision.
    :type is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :param api_revision_description: Description of the Api Revision.
    :type api_revision_description: str
    :param api_version_description: Description of the Api Version.
    :type api_version_description: str
    :param api_version_set_id: A resource identifier for the related ApiVersionSet.
    :type api_version_set_id: str
    :param subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :type subscription_required: bool
    :param id: API identifier in the form /apis/{apiId}.
    :type id: str
    :param name: API name.
    :type name: str
    :param service_url: Absolute URL of the backend service implementing this API.
    :type service_url: str
    :param path: Relative URL uniquely identifying this API and all of its resource paths within
     the API Management service instance. It is appended to the API endpoint base URL specified
     during the service instance creation to form a public URL for this API.
    :type path: str
    :param protocols: Describes on which protocols the operations in this API can be invoked.
    :type protocols: list[str or ~azure.mgmt.apimanagement.models.Protocol]
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 1},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authentication_settings': {'key': 'authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'type', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'protocols': {'key': 'protocols', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiTagResourceContractProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.service_url = kwargs.get('service_url', None)
        self.path = kwargs.get('path', None)
        self.protocols = kwargs.get('protocols', None)


class ApiUpdateContract(msrest.serialization.Model):
    """API update contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the API. May include HTML formatting tags.
    :type description: str
    :param authentication_settings: Collection of authentication settings included into this API.
    :type authentication_settings: ~azure.mgmt.apimanagement.models.AuthenticationSettingsContract
    :param subscription_key_parameter_names: Protocols over which API is made available.
    :type subscription_key_parameter_names:
     ~azure.mgmt.apimanagement.models.SubscriptionKeyParameterNamesContract
    :param api_type: Type of API. Possible values include: "http", "soap".
    :type api_type: str or ~azure.mgmt.apimanagement.models.ApiType
    :param api_revision: Describes the Revision of the Api. If no value is provided, default
     revision 1 is created.
    :type api_revision: str
    :param api_version: Indicates the Version identifier of the API if the API is versioned.
    :type api_version: str
    :param is_current: Indicates if API revision is current api revision.
    :type is_current: bool
    :ivar is_online: Indicates if API revision is accessible via the gateway.
    :vartype is_online: bool
    :param api_revision_description: Description of the Api Revision.
    :type api_revision_description: str
    :param api_version_description: Description of the Api Version.
    :type api_version_description: str
    :param api_version_set_id: A resource identifier for the related ApiVersionSet.
    :type api_version_set_id: str
    :param subscription_required: Specifies whether an API or Product subscription is required for
     accessing the API.
    :type subscription_required: bool
    :param display_name: API name.
    :type display_name: str
    :param service_url: Absolute URL of the backend service implementing this API.
    :type service_url: str
    :param path: Relative URL uniquely identifying this API and all of its resource paths within
     the API Management service instance. It is appended to the API endpoint base URL specified
     during the service instance creation to form a public URL for this API.
    :type path: str
    :param protocols: Describes on which protocols the operations in this API can be invoked.
    :type protocols: list[str or ~azure.mgmt.apimanagement.models.Protocol]
    """

    _validation = {
        'api_revision': {'max_length': 100, 'min_length': 1},
        'api_version': {'max_length': 100, 'min_length': 0},
        'is_online': {'readonly': True},
        'api_revision_description': {'max_length': 256, 'min_length': 0},
        'api_version_description': {'max_length': 256, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'service_url': {'max_length': 2000, 'min_length': 1},
        'path': {'max_length': 400, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'authentication_settings': {'key': 'properties.authenticationSettings', 'type': 'AuthenticationSettingsContract'},
        'subscription_key_parameter_names': {'key': 'properties.subscriptionKeyParameterNames', 'type': 'SubscriptionKeyParameterNamesContract'},
        'api_type': {'key': 'properties.type', 'type': 'str'},
        'api_revision': {'key': 'properties.apiRevision', 'type': 'str'},
        'api_version': {'key': 'properties.apiVersion', 'type': 'str'},
        'is_current': {'key': 'properties.isCurrent', 'type': 'bool'},
        'is_online': {'key': 'properties.isOnline', 'type': 'bool'},
        'api_revision_description': {'key': 'properties.apiRevisionDescription', 'type': 'str'},
        'api_version_description': {'key': 'properties.apiVersionDescription', 'type': 'str'},
        'api_version_set_id': {'key': 'properties.apiVersionSetId', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'service_url': {'key': 'properties.serviceUrl', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'protocols': {'key': 'properties.protocols', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiUpdateContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.authentication_settings = kwargs.get('authentication_settings', None)
        self.subscription_key_parameter_names = kwargs.get('subscription_key_parameter_names', None)
        self.api_type = kwargs.get('api_type', None)
        self.api_revision = kwargs.get('api_revision', None)
        self.api_version = kwargs.get('api_version', None)
        self.is_current = kwargs.get('is_current', None)
        self.is_online = None
        self.api_revision_description = kwargs.get('api_revision_description', None)
        self.api_version_description = kwargs.get('api_version_description', None)
        self.api_version_set_id = kwargs.get('api_version_set_id', None)
        self.subscription_required = kwargs.get('subscription_required', None)
        self.display_name = kwargs.get('display_name', None)
        self.service_url = kwargs.get('service_url', None)
        self.path = kwargs.get('path', None)
        self.protocols = kwargs.get('protocols', None)


class ApiVersionConstraint(msrest.serialization.Model):
    """Control Plane Apis version constraint for the API Management service.

    :param min_api_version: Limit control plane API calls to API Management service with version
     equal to or newer than this value.
    :type min_api_version: str
    """

    _attribute_map = {
        'min_api_version': {'key': 'minApiVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiVersionConstraint, self).__init__(**kwargs)
        self.min_api_version = kwargs.get('min_api_version', None)


class ApiVersionSetCollection(msrest.serialization.Model):
    """Paged Api Version Set list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.ApiVersionSetContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiVersionSetContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiVersionSetCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class ApiVersionSetContract(Resource):
    """Api Version Set Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Description of API Version Set.
    :type description: str
    :param version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :type version_query_name: str
    :param version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :type version_header_name: str
    :param display_name: Name of API Version Set.
    :type display_name: str
    :param versioning_scheme: An value that determines where the API Version identifier will be
     located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :type versioning_scheme: str or ~azure.mgmt.apimanagement.models.VersioningScheme
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
        'display_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version_query_name': {'key': 'properties.versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'properties.versionHeaderName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'versioning_scheme': {'key': 'properties.versioningScheme', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiVersionSetContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.version_query_name = kwargs.get('version_query_name', None)
        self.version_header_name = kwargs.get('version_header_name', None)
        self.display_name = kwargs.get('display_name', None)
        self.versioning_scheme = kwargs.get('versioning_scheme', None)


class ApiVersionSetContractDetails(msrest.serialization.Model):
    """An API Version Set contains the common configuration for a set of API Versions relating.

    :param id: Identifier for existing API Version Set. Omit this value to create a new Version
     Set.
    :type id: str
    :param name: The display Name of the API Version Set.
    :type name: str
    :param description: Description of API Version Set.
    :type description: str
    :param versioning_scheme: An value that determines where the API Version identifier will be
     located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :type versioning_scheme: str or
     ~azure.mgmt.apimanagement.models.ApiVersionSetContractDetailsVersioningScheme
    :param version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :type version_query_name: str
    :param version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :type version_header_name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'versioning_scheme': {'key': 'versioningScheme', 'type': 'str'},
        'version_query_name': {'key': 'versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'versionHeaderName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiVersionSetContractDetails, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.versioning_scheme = kwargs.get('versioning_scheme', None)
        self.version_query_name = kwargs.get('version_query_name', None)
        self.version_header_name = kwargs.get('version_header_name', None)


class ApiVersionSetEntityBase(msrest.serialization.Model):
    """Api Version set base parameters.

    :param description: Description of API Version Set.
    :type description: str
    :param version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :type version_query_name: str
    :param version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :type version_header_name: str
    """

    _validation = {
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'version_query_name': {'key': 'versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'versionHeaderName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiVersionSetEntityBase, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.version_query_name = kwargs.get('version_query_name', None)
        self.version_header_name = kwargs.get('version_header_name', None)


class ApiVersionSetContractProperties(ApiVersionSetEntityBase):
    """Properties of an API Version Set.

    All required parameters must be populated in order to send to Azure.

    :param description: Description of API Version Set.
    :type description: str
    :param version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :type version_query_name: str
    :param version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :type version_header_name: str
    :param display_name: Required. Name of API Version Set.
    :type display_name: str
    :param versioning_scheme: Required. An value that determines where the API Version identifier
     will be located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :type versioning_scheme: str or ~azure.mgmt.apimanagement.models.VersioningScheme
    """

    _validation = {
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
        'display_name': {'required': True, 'max_length': 100, 'min_length': 1},
        'versioning_scheme': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'version_query_name': {'key': 'versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'versionHeaderName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'versioning_scheme': {'key': 'versioningScheme', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiVersionSetContractProperties, self).__init__(**kwargs)
        self.display_name = kwargs['display_name']
        self.versioning_scheme = kwargs['versioning_scheme']


class ApiVersionSetUpdateParameters(msrest.serialization.Model):
    """Parameters to update or create an Api Version Set Contract.

    :param description: Description of API Version Set.
    :type description: str
    :param version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :type version_query_name: str
    :param version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :type version_header_name: str
    :param display_name: Name of API Version Set.
    :type display_name: str
    :param versioning_scheme: An value that determines where the API Version identifier will be
     located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :type versioning_scheme: str or ~azure.mgmt.apimanagement.models.VersioningScheme
    """

    _validation = {
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
        'display_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'version_query_name': {'key': 'properties.versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'properties.versionHeaderName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'versioning_scheme': {'key': 'properties.versioningScheme', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiVersionSetUpdateParameters, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.version_query_name = kwargs.get('version_query_name', None)
        self.version_header_name = kwargs.get('version_header_name', None)
        self.display_name = kwargs.get('display_name', None)
        self.versioning_scheme = kwargs.get('versioning_scheme', None)


class ApiVersionSetUpdateParametersProperties(ApiVersionSetEntityBase):
    """Properties used to create or update an API Version Set.

    :param description: Description of API Version Set.
    :type description: str
    :param version_query_name: Name of query parameter that indicates the API Version if
     versioningScheme is set to ``query``.
    :type version_query_name: str
    :param version_header_name: Name of HTTP header parameter that indicates the API Version if
     versioningScheme is set to ``header``.
    :type version_header_name: str
    :param display_name: Name of API Version Set.
    :type display_name: str
    :param versioning_scheme: An value that determines where the API Version identifier will be
     located in a HTTP request. Possible values include: "Segment", "Query", "Header".
    :type versioning_scheme: str or ~azure.mgmt.apimanagement.models.VersioningScheme
    """

    _validation = {
        'version_query_name': {'max_length': 100, 'min_length': 1},
        'version_header_name': {'max_length': 100, 'min_length': 1},
        'display_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'version_query_name': {'key': 'versionQueryName', 'type': 'str'},
        'version_header_name': {'key': 'versionHeaderName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'versioning_scheme': {'key': 'versioningScheme', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiVersionSetUpdateParametersProperties, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.versioning_scheme = kwargs.get('versioning_scheme', None)


class AssociationContract(Resource):
    """Association entity details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param provisioning_state: Provisioning state. The only acceptable values to pass in are None
     and "created". The default value is None.
    :type provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssociationContract, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class AuthenticationSettingsContract(msrest.serialization.Model):
    """API Authentication Settings.

    :param o_auth2: OAuth2 Authentication settings.
    :type o_auth2: ~azure.mgmt.apimanagement.models.OAuth2AuthenticationSettingsContract
    :param openid: OpenID Connect Authentication Settings.
    :type openid: ~azure.mgmt.apimanagement.models.OpenIdAuthenticationSettingsContract
    """

    _attribute_map = {
        'o_auth2': {'key': 'oAuth2', 'type': 'OAuth2AuthenticationSettingsContract'},
        'openid': {'key': 'openid', 'type': 'OpenIdAuthenticationSettingsContract'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthenticationSettingsContract, self).__init__(**kwargs)
        self.o_auth2 = kwargs.get('o_auth2', None)
        self.openid = kwargs.get('openid', None)


class AuthorizationServerCollection(msrest.serialization.Model):
    """Paged OAuth2 Authorization Servers list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.AuthorizationServerContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AuthorizationServerContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationServerCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class AuthorizationServerContract(Resource):
    """External OAuth authorization server settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Description of the authorization server. Can contain HTML formatting tags.
    :type description: str
    :param authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :type authorization_methods: list[str or ~azure.mgmt.apimanagement.models.AuthorizationMethod]
    :param client_authentication_method: Method of authentication supported by the token endpoint
     of this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :type client_authentication_method: list[str or
     ~azure.mgmt.apimanagement.models.ClientAuthenticationMethod]
    :param token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :type token_body_parameters: list[~azure.mgmt.apimanagement.models.TokenBodyParameterContract]
    :param token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :type token_endpoint: str
    :param support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :type support_state: bool
    :param default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :type default_scope: str
    :param bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :type bearer_token_sending_methods: list[str or
     ~azure.mgmt.apimanagement.models.BearerTokenSendingMethod]
    :param resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :type resource_owner_username: str
    :param resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :type resource_owner_password: str
    :param display_name: User-friendly authorization server name.
    :type display_name: str
    :param client_registration_endpoint: Optional reference to a page where client or app
     registration for this authorization server is performed. Contains absolute URL to entity being
     referenced.
    :type client_registration_endpoint: str
    :param authorization_endpoint: OAuth authorization endpoint. See
     http://tools.ietf.org/html/rfc6749#section-3.2.
    :type authorization_endpoint: str
    :param grant_types: Form of an authorization grant, which the client uses to request the access
     token.
    :type grant_types: list[str or ~azure.mgmt.apimanagement.models.GrantType]
    :param client_id: Client or app id registered with this authorization server.
    :type client_id: str
    :param client_secret: Client or app secret registered with this authorization server. This
     property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
     value.
    :type client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 50, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'authorization_methods': {'key': 'properties.authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'properties.clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'properties.tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'properties.tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'properties.supportState', 'type': 'bool'},
        'default_scope': {'key': 'properties.defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'properties.bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'properties.resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'properties.resourceOwnerPassword', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'client_registration_endpoint': {'key': 'properties.clientRegistrationEndpoint', 'type': 'str'},
        'authorization_endpoint': {'key': 'properties.authorizationEndpoint', 'type': 'str'},
        'grant_types': {'key': 'properties.grantTypes', 'type': '[str]'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationServerContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.authorization_methods = kwargs.get('authorization_methods', None)
        self.client_authentication_method = kwargs.get('client_authentication_method', None)
        self.token_body_parameters = kwargs.get('token_body_parameters', None)
        self.token_endpoint = kwargs.get('token_endpoint', None)
        self.support_state = kwargs.get('support_state', None)
        self.default_scope = kwargs.get('default_scope', None)
        self.bearer_token_sending_methods = kwargs.get('bearer_token_sending_methods', None)
        self.resource_owner_username = kwargs.get('resource_owner_username', None)
        self.resource_owner_password = kwargs.get('resource_owner_password', None)
        self.display_name = kwargs.get('display_name', None)
        self.client_registration_endpoint = kwargs.get('client_registration_endpoint', None)
        self.authorization_endpoint = kwargs.get('authorization_endpoint', None)
        self.grant_types = kwargs.get('grant_types', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class AuthorizationServerContractBaseProperties(msrest.serialization.Model):
    """External OAuth authorization server Update settings contract.

    :param description: Description of the authorization server. Can contain HTML formatting tags.
    :type description: str
    :param authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :type authorization_methods: list[str or ~azure.mgmt.apimanagement.models.AuthorizationMethod]
    :param client_authentication_method: Method of authentication supported by the token endpoint
     of this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :type client_authentication_method: list[str or
     ~azure.mgmt.apimanagement.models.ClientAuthenticationMethod]
    :param token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :type token_body_parameters: list[~azure.mgmt.apimanagement.models.TokenBodyParameterContract]
    :param token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :type token_endpoint: str
    :param support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :type support_state: bool
    :param default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :type default_scope: str
    :param bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :type bearer_token_sending_methods: list[str or
     ~azure.mgmt.apimanagement.models.BearerTokenSendingMethod]
    :param resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :type resource_owner_username: str
    :param resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :type resource_owner_password: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authorization_methods': {'key': 'authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'supportState', 'type': 'bool'},
        'default_scope': {'key': 'defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'resourceOwnerPassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationServerContractBaseProperties, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.authorization_methods = kwargs.get('authorization_methods', None)
        self.client_authentication_method = kwargs.get('client_authentication_method', None)
        self.token_body_parameters = kwargs.get('token_body_parameters', None)
        self.token_endpoint = kwargs.get('token_endpoint', None)
        self.support_state = kwargs.get('support_state', None)
        self.default_scope = kwargs.get('default_scope', None)
        self.bearer_token_sending_methods = kwargs.get('bearer_token_sending_methods', None)
        self.resource_owner_username = kwargs.get('resource_owner_username', None)
        self.resource_owner_password = kwargs.get('resource_owner_password', None)


class AuthorizationServerContractProperties(AuthorizationServerContractBaseProperties):
    """External OAuth authorization server settings Properties.

    All required parameters must be populated in order to send to Azure.

    :param description: Description of the authorization server. Can contain HTML formatting tags.
    :type description: str
    :param authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :type authorization_methods: list[str or ~azure.mgmt.apimanagement.models.AuthorizationMethod]
    :param client_authentication_method: Method of authentication supported by the token endpoint
     of this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :type client_authentication_method: list[str or
     ~azure.mgmt.apimanagement.models.ClientAuthenticationMethod]
    :param token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :type token_body_parameters: list[~azure.mgmt.apimanagement.models.TokenBodyParameterContract]
    :param token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :type token_endpoint: str
    :param support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :type support_state: bool
    :param default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :type default_scope: str
    :param bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :type bearer_token_sending_methods: list[str or
     ~azure.mgmt.apimanagement.models.BearerTokenSendingMethod]
    :param resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :type resource_owner_username: str
    :param resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :type resource_owner_password: str
    :param display_name: Required. User-friendly authorization server name.
    :type display_name: str
    :param client_registration_endpoint: Required. Optional reference to a page where client or app
     registration for this authorization server is performed. Contains absolute URL to entity being
     referenced.
    :type client_registration_endpoint: str
    :param authorization_endpoint: Required. OAuth authorization endpoint. See
     http://tools.ietf.org/html/rfc6749#section-3.2.
    :type authorization_endpoint: str
    :param grant_types: Required. Form of an authorization grant, which the client uses to request
     the access token.
    :type grant_types: list[str or ~azure.mgmt.apimanagement.models.GrantType]
    :param client_id: Required. Client or app id registered with this authorization server.
    :type client_id: str
    :param client_secret: Client or app secret registered with this authorization server. This
     property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
     value.
    :type client_secret: str
    """

    _validation = {
        'display_name': {'required': True, 'max_length': 50, 'min_length': 1},
        'client_registration_endpoint': {'required': True},
        'authorization_endpoint': {'required': True},
        'grant_types': {'required': True},
        'client_id': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authorization_methods': {'key': 'authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'supportState', 'type': 'bool'},
        'default_scope': {'key': 'defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'resourceOwnerPassword', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'client_registration_endpoint': {'key': 'clientRegistrationEndpoint', 'type': 'str'},
        'authorization_endpoint': {'key': 'authorizationEndpoint', 'type': 'str'},
        'grant_types': {'key': 'grantTypes', 'type': '[str]'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationServerContractProperties, self).__init__(**kwargs)
        self.display_name = kwargs['display_name']
        self.client_registration_endpoint = kwargs['client_registration_endpoint']
        self.authorization_endpoint = kwargs['authorization_endpoint']
        self.grant_types = kwargs['grant_types']
        self.client_id = kwargs['client_id']
        self.client_secret = kwargs.get('client_secret', None)


class AuthorizationServerSecretsContract(msrest.serialization.Model):
    """OAuth Server Secrets Contract.

    :param client_secret: oAuth Authorization Server Secrets.
    :type client_secret: str
    :param resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :type resource_owner_username: str
    :param resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :type resource_owner_password: str
    """

    _attribute_map = {
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
        'resource_owner_username': {'key': 'resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'resourceOwnerPassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationServerSecretsContract, self).__init__(**kwargs)
        self.client_secret = kwargs.get('client_secret', None)
        self.resource_owner_username = kwargs.get('resource_owner_username', None)
        self.resource_owner_password = kwargs.get('resource_owner_password', None)


class AuthorizationServerUpdateContract(Resource):
    """External OAuth authorization server settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Description of the authorization server. Can contain HTML formatting tags.
    :type description: str
    :param authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :type authorization_methods: list[str or ~azure.mgmt.apimanagement.models.AuthorizationMethod]
    :param client_authentication_method: Method of authentication supported by the token endpoint
     of this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :type client_authentication_method: list[str or
     ~azure.mgmt.apimanagement.models.ClientAuthenticationMethod]
    :param token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :type token_body_parameters: list[~azure.mgmt.apimanagement.models.TokenBodyParameterContract]
    :param token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :type token_endpoint: str
    :param support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :type support_state: bool
    :param default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :type default_scope: str
    :param bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :type bearer_token_sending_methods: list[str or
     ~azure.mgmt.apimanagement.models.BearerTokenSendingMethod]
    :param resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :type resource_owner_username: str
    :param resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :type resource_owner_password: str
    :param display_name: User-friendly authorization server name.
    :type display_name: str
    :param client_registration_endpoint: Optional reference to a page where client or app
     registration for this authorization server is performed. Contains absolute URL to entity being
     referenced.
    :type client_registration_endpoint: str
    :param authorization_endpoint: OAuth authorization endpoint. See
     http://tools.ietf.org/html/rfc6749#section-3.2.
    :type authorization_endpoint: str
    :param grant_types: Form of an authorization grant, which the client uses to request the access
     token.
    :type grant_types: list[str or ~azure.mgmt.apimanagement.models.GrantType]
    :param client_id: Client or app id registered with this authorization server.
    :type client_id: str
    :param client_secret: Client or app secret registered with this authorization server. This
     property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
     value.
    :type client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 50, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'authorization_methods': {'key': 'properties.authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'properties.clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'properties.tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'properties.tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'properties.supportState', 'type': 'bool'},
        'default_scope': {'key': 'properties.defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'properties.bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'properties.resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'properties.resourceOwnerPassword', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'client_registration_endpoint': {'key': 'properties.clientRegistrationEndpoint', 'type': 'str'},
        'authorization_endpoint': {'key': 'properties.authorizationEndpoint', 'type': 'str'},
        'grant_types': {'key': 'properties.grantTypes', 'type': '[str]'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationServerUpdateContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.authorization_methods = kwargs.get('authorization_methods', None)
        self.client_authentication_method = kwargs.get('client_authentication_method', None)
        self.token_body_parameters = kwargs.get('token_body_parameters', None)
        self.token_endpoint = kwargs.get('token_endpoint', None)
        self.support_state = kwargs.get('support_state', None)
        self.default_scope = kwargs.get('default_scope', None)
        self.bearer_token_sending_methods = kwargs.get('bearer_token_sending_methods', None)
        self.resource_owner_username = kwargs.get('resource_owner_username', None)
        self.resource_owner_password = kwargs.get('resource_owner_password', None)
        self.display_name = kwargs.get('display_name', None)
        self.client_registration_endpoint = kwargs.get('client_registration_endpoint', None)
        self.authorization_endpoint = kwargs.get('authorization_endpoint', None)
        self.grant_types = kwargs.get('grant_types', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class AuthorizationServerUpdateContractProperties(AuthorizationServerContractBaseProperties):
    """External OAuth authorization server Update settings contract.

    :param description: Description of the authorization server. Can contain HTML formatting tags.
    :type description: str
    :param authorization_methods: HTTP verbs supported by the authorization endpoint. GET must be
     always present. POST is optional.
    :type authorization_methods: list[str or ~azure.mgmt.apimanagement.models.AuthorizationMethod]
    :param client_authentication_method: Method of authentication supported by the token endpoint
     of this authorization server. Possible values are Basic and/or Body. When Body is specified,
     client credentials and other parameters are passed within the request body in the
     application/x-www-form-urlencoded format.
    :type client_authentication_method: list[str or
     ~azure.mgmt.apimanagement.models.ClientAuthenticationMethod]
    :param token_body_parameters: Additional parameters required by the token endpoint of this
     authorization server represented as an array of JSON objects with name and value string
     properties, i.e. {"name" : "name value", "value": "a value"}.
    :type token_body_parameters: list[~azure.mgmt.apimanagement.models.TokenBodyParameterContract]
    :param token_endpoint: OAuth token endpoint. Contains absolute URI to entity being referenced.
    :type token_endpoint: str
    :param support_state: If true, authorization server will include state parameter from the
     authorization request to its response. Client may use state parameter to raise protocol
     security.
    :type support_state: bool
    :param default_scope: Access token scope that is going to be requested by default. Can be
     overridden at the API level. Should be provided in the form of a string containing
     space-delimited values.
    :type default_scope: str
    :param bearer_token_sending_methods: Specifies the mechanism by which access token is passed to
     the API.
    :type bearer_token_sending_methods: list[str or
     ~azure.mgmt.apimanagement.models.BearerTokenSendingMethod]
    :param resource_owner_username: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner username.
    :type resource_owner_username: str
    :param resource_owner_password: Can be optionally specified when resource owner password grant
     type is supported by this authorization server. Default resource owner password.
    :type resource_owner_password: str
    :param display_name: User-friendly authorization server name.
    :type display_name: str
    :param client_registration_endpoint: Optional reference to a page where client or app
     registration for this authorization server is performed. Contains absolute URL to entity being
     referenced.
    :type client_registration_endpoint: str
    :param authorization_endpoint: OAuth authorization endpoint. See
     http://tools.ietf.org/html/rfc6749#section-3.2.
    :type authorization_endpoint: str
    :param grant_types: Form of an authorization grant, which the client uses to request the access
     token.
    :type grant_types: list[str or ~azure.mgmt.apimanagement.models.GrantType]
    :param client_id: Client or app id registered with this authorization server.
    :type client_id: str
    :param client_secret: Client or app secret registered with this authorization server. This
     property will not be filled on 'GET' operations! Use '/listSecrets' POST request to get the
     value.
    :type client_secret: str
    """

    _validation = {
        'display_name': {'max_length': 50, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'authorization_methods': {'key': 'authorizationMethods', 'type': '[str]'},
        'client_authentication_method': {'key': 'clientAuthenticationMethod', 'type': '[str]'},
        'token_body_parameters': {'key': 'tokenBodyParameters', 'type': '[TokenBodyParameterContract]'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'support_state': {'key': 'supportState', 'type': 'bool'},
        'default_scope': {'key': 'defaultScope', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'bearerTokenSendingMethods', 'type': '[str]'},
        'resource_owner_username': {'key': 'resourceOwnerUsername', 'type': 'str'},
        'resource_owner_password': {'key': 'resourceOwnerPassword', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'client_registration_endpoint': {'key': 'clientRegistrationEndpoint', 'type': 'str'},
        'authorization_endpoint': {'key': 'authorizationEndpoint', 'type': 'str'},
        'grant_types': {'key': 'grantTypes', 'type': '[str]'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationServerUpdateContractProperties, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.client_registration_endpoint = kwargs.get('client_registration_endpoint', None)
        self.authorization_endpoint = kwargs.get('authorization_endpoint', None)
        self.grant_types = kwargs.get('grant_types', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class BackendAuthorizationHeaderCredentials(msrest.serialization.Model):
    """Authorization header information.

    All required parameters must be populated in order to send to Azure.

    :param scheme: Required. Authentication Scheme name.
    :type scheme: str
    :param parameter: Required. Authentication Parameter value.
    :type parameter: str
    """

    _validation = {
        'scheme': {'required': True, 'max_length': 100, 'min_length': 1},
        'parameter': {'required': True, 'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'scheme': {'key': 'scheme', 'type': 'str'},
        'parameter': {'key': 'parameter', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendAuthorizationHeaderCredentials, self).__init__(**kwargs)
        self.scheme = kwargs['scheme']
        self.parameter = kwargs['parameter']


class BackendBaseParameters(msrest.serialization.Model):
    """Backend entity base Parameter set.

    :param title: Backend Title.
    :type title: str
    :param description: Backend Description.
    :type description: str
    :param resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or Api Apps.
    :type resource_id: str
    :param properties: Backend Properties contract.
    :type properties: ~azure.mgmt.apimanagement.models.BackendProperties
    :param credentials: Backend Credentials Contract Properties.
    :type credentials: ~azure.mgmt.apimanagement.models.BackendCredentialsContract
    :param proxy: Backend Proxy Contract Properties.
    :type proxy: ~azure.mgmt.apimanagement.models.BackendProxyContract
    :param tls: Backend TLS Properties.
    :type tls: ~azure.mgmt.apimanagement.models.BackendTlsProperties
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'tls', 'type': 'BackendTlsProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendBaseParameters, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.properties = kwargs.get('properties', None)
        self.credentials = kwargs.get('credentials', None)
        self.proxy = kwargs.get('proxy', None)
        self.tls = kwargs.get('tls', None)


class BackendCollection(msrest.serialization.Model):
    """Paged Backend list representation.

    :param value: Backend values.
    :type value: list[~azure.mgmt.apimanagement.models.BackendContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackendContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class BackendContract(Resource):
    """Backend details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param title: Backend Title.
    :type title: str
    :param description: Backend Description.
    :type description: str
    :param resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or Api Apps.
    :type resource_id: str
    :param properties: Backend Properties contract.
    :type properties: ~azure.mgmt.apimanagement.models.BackendProperties
    :param credentials: Backend Credentials Contract Properties.
    :type credentials: ~azure.mgmt.apimanagement.models.BackendCredentialsContract
    :param proxy: Backend Proxy Contract Properties.
    :type proxy: ~azure.mgmt.apimanagement.models.BackendProxyContract
    :param tls: Backend TLS Properties.
    :type tls: ~azure.mgmt.apimanagement.models.BackendTlsProperties
    :param url: Runtime Url of the Backend.
    :type url: str
    :param protocol: Backend communication protocol. Possible values include: "http", "soap".
    :type protocol: str or ~azure.mgmt.apimanagement.models.BackendProtocol
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
        'url': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'properties.credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'properties.proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'properties.tls', 'type': 'BackendTlsProperties'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendContract, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.properties = kwargs.get('properties', None)
        self.credentials = kwargs.get('credentials', None)
        self.proxy = kwargs.get('proxy', None)
        self.tls = kwargs.get('tls', None)
        self.url = kwargs.get('url', None)
        self.protocol = kwargs.get('protocol', None)


class BackendContractProperties(BackendBaseParameters):
    """Parameters supplied to the Create Backend operation.

    All required parameters must be populated in order to send to Azure.

    :param title: Backend Title.
    :type title: str
    :param description: Backend Description.
    :type description: str
    :param resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or Api Apps.
    :type resource_id: str
    :param properties: Backend Properties contract.
    :type properties: ~azure.mgmt.apimanagement.models.BackendProperties
    :param credentials: Backend Credentials Contract Properties.
    :type credentials: ~azure.mgmt.apimanagement.models.BackendCredentialsContract
    :param proxy: Backend Proxy Contract Properties.
    :type proxy: ~azure.mgmt.apimanagement.models.BackendProxyContract
    :param tls: Backend TLS Properties.
    :type tls: ~azure.mgmt.apimanagement.models.BackendTlsProperties
    :param url: Required. Runtime Url of the Backend.
    :type url: str
    :param protocol: Required. Backend communication protocol. Possible values include: "http",
     "soap".
    :type protocol: str or ~azure.mgmt.apimanagement.models.BackendProtocol
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
        'url': {'required': True, 'max_length': 2000, 'min_length': 1},
        'protocol': {'required': True},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'tls', 'type': 'BackendTlsProperties'},
        'url': {'key': 'url', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendContractProperties, self).__init__(**kwargs)
        self.url = kwargs['url']
        self.protocol = kwargs['protocol']


class BackendCredentialsContract(msrest.serialization.Model):
    """Details of the Credentials used to connect to Backend.

    :param certificate_ids: List of Client Certificate Ids.
    :type certificate_ids: list[str]
    :param certificate: List of Client Certificate Thumbprints. Will be ignored if certificatesIds
     are provided.
    :type certificate: list[str]
    :param query: Query Parameter description.
    :type query: dict[str, list[str]]
    :param header: Header Parameter description.
    :type header: dict[str, list[str]]
    :param authorization: Authorization header authentication.
    :type authorization: ~azure.mgmt.apimanagement.models.BackendAuthorizationHeaderCredentials
    """

    _validation = {
        'certificate_ids': {'max_items': 32, 'min_items': 0},
        'certificate': {'max_items': 32, 'min_items': 0},
    }

    _attribute_map = {
        'certificate_ids': {'key': 'certificateIds', 'type': '[str]'},
        'certificate': {'key': 'certificate', 'type': '[str]'},
        'query': {'key': 'query', 'type': '{[str]}'},
        'header': {'key': 'header', 'type': '{[str]}'},
        'authorization': {'key': 'authorization', 'type': 'BackendAuthorizationHeaderCredentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendCredentialsContract, self).__init__(**kwargs)
        self.certificate_ids = kwargs.get('certificate_ids', None)
        self.certificate = kwargs.get('certificate', None)
        self.query = kwargs.get('query', None)
        self.header = kwargs.get('header', None)
        self.authorization = kwargs.get('authorization', None)


class BackendProperties(msrest.serialization.Model):
    """Properties specific to the Backend Type.

    :param service_fabric_cluster: Backend Service Fabric Cluster Properties.
    :type service_fabric_cluster:
     ~azure.mgmt.apimanagement.models.BackendServiceFabricClusterProperties
    """

    _attribute_map = {
        'service_fabric_cluster': {'key': 'serviceFabricCluster', 'type': 'BackendServiceFabricClusterProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendProperties, self).__init__(**kwargs)
        self.service_fabric_cluster = kwargs.get('service_fabric_cluster', None)


class BackendProxyContract(msrest.serialization.Model):
    """Details of the Backend WebProxy Server to use in the Request to Backend.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. WebProxy Server AbsoluteUri property which includes the entire URI stored
     in the Uri instance, including all fragments and query strings.
    :type url: str
    :param username: Username to connect to the WebProxy server.
    :type username: str
    :param password: Password to connect to the WebProxy Server.
    :type password: str
    """

    _validation = {
        'url': {'required': True, 'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendProxyContract, self).__init__(**kwargs)
        self.url = kwargs['url']
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)


class BackendReconnectContract(Resource):
    """Reconnect request parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param after: Duration in ISO8601 format after which reconnect will be initiated. Minimum
     duration of the Reconnect is PT2M.
    :type after: ~datetime.timedelta
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'after': {'key': 'properties.after', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendReconnectContract, self).__init__(**kwargs)
        self.after = kwargs.get('after', None)


class BackendServiceFabricClusterProperties(msrest.serialization.Model):
    """Properties of the Service Fabric Type Backend.

    All required parameters must be populated in order to send to Azure.

    :param client_certificate_id: The client certificate id for the management endpoint.
    :type client_certificate_id: str
    :param client_certificatethumbprint: The client certificate thumbprint for the management
     endpoint. Will be ignored if certificatesIds are provided.
    :type client_certificatethumbprint: str
    :param max_partition_resolution_retries: Maximum number of retries while attempting resolve the
     partition.
    :type max_partition_resolution_retries: int
    :param management_endpoints: Required. The cluster management endpoint.
    :type management_endpoints: list[str]
    :param server_certificate_thumbprints: Thumbprints of certificates cluster management service
     uses for tls communication.
    :type server_certificate_thumbprints: list[str]
    :param server_x509_names: Server X509 Certificate Names Collection.
    :type server_x509_names: list[~azure.mgmt.apimanagement.models.X509CertificateName]
    """

    _validation = {
        'management_endpoints': {'required': True},
    }

    _attribute_map = {
        'client_certificate_id': {'key': 'clientCertificateId', 'type': 'str'},
        'client_certificatethumbprint': {'key': 'clientCertificatethumbprint', 'type': 'str'},
        'max_partition_resolution_retries': {'key': 'maxPartitionResolutionRetries', 'type': 'int'},
        'management_endpoints': {'key': 'managementEndpoints', 'type': '[str]'},
        'server_certificate_thumbprints': {'key': 'serverCertificateThumbprints', 'type': '[str]'},
        'server_x509_names': {'key': 'serverX509Names', 'type': '[X509CertificateName]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendServiceFabricClusterProperties, self).__init__(**kwargs)
        self.client_certificate_id = kwargs.get('client_certificate_id', None)
        self.client_certificatethumbprint = kwargs.get('client_certificatethumbprint', None)
        self.max_partition_resolution_retries = kwargs.get('max_partition_resolution_retries', None)
        self.management_endpoints = kwargs['management_endpoints']
        self.server_certificate_thumbprints = kwargs.get('server_certificate_thumbprints', None)
        self.server_x509_names = kwargs.get('server_x509_names', None)


class BackendTlsProperties(msrest.serialization.Model):
    """Properties controlling TLS Certificate Validation.

    :param validate_certificate_chain: Flag indicating whether SSL certificate chain validation
     should be done when using self-signed certificates for this backend host.
    :type validate_certificate_chain: bool
    :param validate_certificate_name: Flag indicating whether SSL certificate name validation
     should be done when using self-signed certificates for this backend host.
    :type validate_certificate_name: bool
    """

    _attribute_map = {
        'validate_certificate_chain': {'key': 'validateCertificateChain', 'type': 'bool'},
        'validate_certificate_name': {'key': 'validateCertificateName', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendTlsProperties, self).__init__(**kwargs)
        self.validate_certificate_chain = kwargs.get('validate_certificate_chain', True)
        self.validate_certificate_name = kwargs.get('validate_certificate_name', True)


class BackendUpdateParameterProperties(BackendBaseParameters):
    """Parameters supplied to the Update Backend operation.

    :param title: Backend Title.
    :type title: str
    :param description: Backend Description.
    :type description: str
    :param resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or Api Apps.
    :type resource_id: str
    :param properties: Backend Properties contract.
    :type properties: ~azure.mgmt.apimanagement.models.BackendProperties
    :param credentials: Backend Credentials Contract Properties.
    :type credentials: ~azure.mgmt.apimanagement.models.BackendCredentialsContract
    :param proxy: Backend Proxy Contract Properties.
    :type proxy: ~azure.mgmt.apimanagement.models.BackendProxyContract
    :param tls: Backend TLS Properties.
    :type tls: ~azure.mgmt.apimanagement.models.BackendTlsProperties
    :param url: Runtime Url of the Backend.
    :type url: str
    :param protocol: Backend communication protocol. Possible values include: "http", "soap".
    :type protocol: str or ~azure.mgmt.apimanagement.models.BackendProtocol
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
        'url': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'tls', 'type': 'BackendTlsProperties'},
        'url': {'key': 'url', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendUpdateParameterProperties, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)
        self.protocol = kwargs.get('protocol', None)


class BackendUpdateParameters(msrest.serialization.Model):
    """Backend update parameters.

    :param title: Backend Title.
    :type title: str
    :param description: Backend Description.
    :type description: str
    :param resource_id: Management Uri of the Resource in External System. This url can be the Arm
     Resource Id of Logic Apps, Function Apps or Api Apps.
    :type resource_id: str
    :param properties: Backend Properties contract.
    :type properties: ~azure.mgmt.apimanagement.models.BackendProperties
    :param credentials: Backend Credentials Contract Properties.
    :type credentials: ~azure.mgmt.apimanagement.models.BackendCredentialsContract
    :param proxy: Backend Proxy Contract Properties.
    :type proxy: ~azure.mgmt.apimanagement.models.BackendProxyContract
    :param tls: Backend TLS Properties.
    :type tls: ~azure.mgmt.apimanagement.models.BackendTlsProperties
    :param url: Runtime Url of the Backend.
    :type url: str
    :param protocol: Backend communication protocol. Possible values include: "http", "soap".
    :type protocol: str or ~azure.mgmt.apimanagement.models.BackendProtocol
    """

    _validation = {
        'title': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 2000, 'min_length': 1},
        'resource_id': {'max_length': 2000, 'min_length': 1},
        'url': {'max_length': 2000, 'min_length': 1},
    }

    _attribute_map = {
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': 'BackendProperties'},
        'credentials': {'key': 'properties.credentials', 'type': 'BackendCredentialsContract'},
        'proxy': {'key': 'properties.proxy', 'type': 'BackendProxyContract'},
        'tls': {'key': 'properties.tls', 'type': 'BackendTlsProperties'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackendUpdateParameters, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.properties = kwargs.get('properties', None)
        self.credentials = kwargs.get('credentials', None)
        self.proxy = kwargs.get('proxy', None)
        self.tls = kwargs.get('tls', None)
        self.url = kwargs.get('url', None)
        self.protocol = kwargs.get('protocol', None)


class BodyDiagnosticSettings(msrest.serialization.Model):
    """Body logging settings.

    :param bytes: Number of request body bytes to log.
    :type bytes: int
    """

    _validation = {
        'bytes': {'maximum': 8192},
    }

    _attribute_map = {
        'bytes': {'key': 'bytes', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BodyDiagnosticSettings, self).__init__(**kwargs)
        self.bytes = kwargs.get('bytes', None)


class CacheCollection(msrest.serialization.Model):
    """Paged Caches list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.CacheContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CacheContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class CacheContract(Resource):
    """Cache details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Cache description.
    :type description: str
    :param connection_string: Runtime connection string to cache.
    :type connection_string: str
    :param use_from_location: Location identifier to use cache from (should be either 'default' or
     valid Azure region identifier).
    :type use_from_location: str
    :param resource_id: Original uri of entity in external system cache points to.
    :type resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 2000, 'min_length': 0},
        'connection_string': {'max_length': 300, 'min_length': 0},
        'use_from_location': {'max_length': 256, 'min_length': 0},
        'resource_id': {'max_length': 2000, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'use_from_location': {'key': 'properties.useFromLocation', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.use_from_location = kwargs.get('use_from_location', None)
        self.resource_id = kwargs.get('resource_id', None)


class CacheUpdateParameters(msrest.serialization.Model):
    """Cache update details.

    :param description: Cache description.
    :type description: str
    :param connection_string: Runtime connection string to cache.
    :type connection_string: str
    :param use_from_location: Location identifier to use cache from (should be either 'default' or
     valid Azure region identifier).
    :type use_from_location: str
    :param resource_id: Original uri of entity in external system cache points to.
    :type resource_id: str
    """

    _validation = {
        'description': {'max_length': 2000, 'min_length': 0},
        'connection_string': {'max_length': 300, 'min_length': 0},
        'use_from_location': {'max_length': 256, 'min_length': 0},
        'resource_id': {'max_length': 2000, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'use_from_location': {'key': 'properties.useFromLocation', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CacheUpdateParameters, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.use_from_location = kwargs.get('use_from_location', None)
        self.resource_id = kwargs.get('resource_id', None)


class CertificateCollection(msrest.serialization.Model):
    """Paged Certificates list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.CertificateContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CertificateContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class CertificateConfiguration(msrest.serialization.Model):
    """Certificate configuration which consist of non-trusted intermediates and root certificates.

    All required parameters must be populated in order to send to Azure.

    :param encoded_certificate: Base64 Encoded certificate.
    :type encoded_certificate: str
    :param certificate_password: Certificate Password.
    :type certificate_password: str
    :param store_name: Required. The System.Security.Cryptography.x509certificates.StoreName
     certificate store location. Only Root and CertificateAuthority are valid locations. Possible
     values include: "CertificateAuthority", "Root".
    :type store_name: str or ~azure.mgmt.apimanagement.models.CertificateConfigurationStoreName
    :param certificate: Certificate information.
    :type certificate: ~azure.mgmt.apimanagement.models.CertificateInformation
    """

    _validation = {
        'store_name': {'required': True},
    }

    _attribute_map = {
        'encoded_certificate': {'key': 'encodedCertificate', 'type': 'str'},
        'certificate_password': {'key': 'certificatePassword', 'type': 'str'},
        'store_name': {'key': 'storeName', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'CertificateInformation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateConfiguration, self).__init__(**kwargs)
        self.encoded_certificate = kwargs.get('encoded_certificate', None)
        self.certificate_password = kwargs.get('certificate_password', None)
        self.store_name = kwargs['store_name']
        self.certificate = kwargs.get('certificate', None)


class CertificateContract(Resource):
    """Certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param subject: Subject attribute of the certificate.
    :type subject: str
    :param thumbprint: Thumbprint of the certificate.
    :type thumbprint: str
    :param expiration_date: Expiration date of the certificate. The date conforms to the following
     format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type expiration_date: ~datetime.datetime
    :param key_vault: KeyVault location details of the certificate.
    :type key_vault: ~azure.mgmt.apimanagement.models.KeyVaultContractProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subject': {'key': 'properties.subject', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateContract, self).__init__(**kwargs)
        self.subject = kwargs.get('subject', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.expiration_date = kwargs.get('expiration_date', None)
        self.key_vault = kwargs.get('key_vault', None)


class CertificateCreateOrUpdateParameters(msrest.serialization.Model):
    """Certificate create or update details.

    :param data: Base 64 encoded certificate using the application/x-pkcs12 representation.
    :type data: str
    :param password: Password for the Certificate.
    :type password: str
    :param key_vault: KeyVault location details of the certificate.
    :type key_vault: ~azure.mgmt.apimanagement.models.KeyVaultContractCreateProperties
    """

    _attribute_map = {
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateCreateOrUpdateParameters, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.password = kwargs.get('password', None)
        self.key_vault = kwargs.get('key_vault', None)


class CertificateInformation(msrest.serialization.Model):
    """SSL certificate information.

    All required parameters must be populated in order to send to Azure.

    :param expiry: Required. Expiration date of the certificate. The date conforms to the following
     format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type expiry: ~datetime.datetime
    :param thumbprint: Required. Thumbprint of the certificate.
    :type thumbprint: str
    :param subject: Required. Subject of the certificate.
    :type subject: str
    """

    _validation = {
        'expiry': {'required': True},
        'thumbprint': {'required': True},
        'subject': {'required': True},
    }

    _attribute_map = {
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateInformation, self).__init__(**kwargs)
        self.expiry = kwargs['expiry']
        self.thumbprint = kwargs['thumbprint']
        self.subject = kwargs['subject']


class ClientSecretContract(msrest.serialization.Model):
    """Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.

    :param client_secret: Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.
    :type client_secret: str
    """

    _attribute_map = {
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientSecretContract, self).__init__(**kwargs)
        self.client_secret = kwargs.get('client_secret', None)


class ConnectivityStatusContract(msrest.serialization.Model):
    """Details about connectivity to a resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The hostname of the resource which the service depends on. This can be
     the database, storage or any other azure resource on which the service depends upon.
    :type name: str
    :param status: Required. Resource Connectivity Status Type identifier. Possible values include:
     "initializing", "success", "failure".
    :type status: str or ~azure.mgmt.apimanagement.models.ConnectivityStatusType
    :param error: Error details of the connectivity to the resource.
    :type error: str
    :param last_updated: Required. The date when the resource connectivity status was last updated.
     This status should be updated every 15 minutes. If this status has not been updated, then it
     means that the service has lost network connectivity to the resource, from inside the Virtual
     Network.The date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the
     ISO 8601 standard.
    :type last_updated: ~datetime.datetime
    :param last_status_change: Required. The date when the resource connectivity status last
     Changed from success to failure or vice-versa. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type last_status_change: ~datetime.datetime
    :param resource_type: Required. Resource Type.
    :type resource_type: str
    :param is_optional: Required. Whether this is optional.
    :type is_optional: bool
    """

    _validation = {
        'name': {'required': True, 'min_length': 1},
        'status': {'required': True},
        'last_updated': {'required': True},
        'last_status_change': {'required': True},
        'resource_type': {'required': True},
        'is_optional': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'str'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'last_status_change': {'key': 'lastStatusChange', 'type': 'iso-8601'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'is_optional': {'key': 'isOptional', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectivityStatusContract, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.status = kwargs['status']
        self.error = kwargs.get('error', None)
        self.last_updated = kwargs['last_updated']
        self.last_status_change = kwargs['last_status_change']
        self.resource_type = kwargs['resource_type']
        self.is_optional = kwargs['is_optional']


class ContentItemCollection(msrest.serialization.Model):
    """Paged list of content items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of content items.
    :vartype value: list[~azure.mgmt.apimanagement.models.ContentItemContract]
    :ivar next_link: Next page link, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContentItemContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContentItemCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ContentItemContract(Resource):
    """Content type contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param properties: Properties of the content item.
    :type properties: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContentItemContract, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ContentTypeCollection(msrest.serialization.Model):
    """Paged list of content types.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of content types.
    :vartype value: list[~azure.mgmt.apimanagement.models.ContentTypeContract]
    :ivar next_link: Next page link, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContentTypeContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContentTypeCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ContentTypeContract(Resource):
    """Content type contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param id_properties_id: Content type identifier.
    :type id_properties_id: str
    :param name_properties_name: Content type name. Must be 1 to 250 characters long.
    :type name_properties_name: str
    :param description: Content type description.
    :type description: str
    :param schema: Content type schema.
    :type schema: any
    :param version: Content type version.
    :type version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'schema': {'key': 'properties.schema', 'type': 'object'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContentTypeContract, self).__init__(**kwargs)
        self.id_properties_id = kwargs.get('id_properties_id', None)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.description = kwargs.get('description', None)
        self.schema = kwargs.get('schema', None)
        self.version = kwargs.get('version', None)


class DataMasking(msrest.serialization.Model):
    """DataMasking.

    :param query_params: Masking settings for Url query parameters.
    :type query_params: list[~azure.mgmt.apimanagement.models.DataMaskingEntity]
    :param headers: Masking settings for headers.
    :type headers: list[~azure.mgmt.apimanagement.models.DataMaskingEntity]
    """

    _attribute_map = {
        'query_params': {'key': 'queryParams', 'type': '[DataMaskingEntity]'},
        'headers': {'key': 'headers', 'type': '[DataMaskingEntity]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataMasking, self).__init__(**kwargs)
        self.query_params = kwargs.get('query_params', None)
        self.headers = kwargs.get('headers', None)


class DataMaskingEntity(msrest.serialization.Model):
    """DataMaskingEntity.

    :param value: The name of an entity to mask (e.g. a name of a header or a query parameter).
    :type value: str
    :param mode: Data masking mode. Possible values include: "Mask", "Hide".
    :type mode: str or ~azure.mgmt.apimanagement.models.DataMaskingMode
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataMaskingEntity, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.mode = kwargs.get('mode', None)


class DeletedServiceContract(Resource):
    """Deleted Api Management Service information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :ivar location: Api Management Service Master Location.
    :vartype location: str
    :param service_id: Fully-qualified API Management Service Resource ID.
    :type service_id: str
    :param scheduled_purge_date: UTC Date and Time when the service will be automatically purged.
     The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601
     standard.
    :type scheduled_purge_date: ~datetime.datetime
    :param deletion_date: UTC Timestamp when the service was soft-deleted. The date conforms to the
     following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :type deletion_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'service_id': {'key': 'properties.serviceId', 'type': 'str'},
        'scheduled_purge_date': {'key': 'properties.scheduledPurgeDate', 'type': 'iso-8601'},
        'deletion_date': {'key': 'properties.deletionDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedServiceContract, self).__init__(**kwargs)
        self.location = None
        self.service_id = kwargs.get('service_id', None)
        self.scheduled_purge_date = kwargs.get('scheduled_purge_date', None)
        self.deletion_date = kwargs.get('deletion_date', None)


class DeletedServicesCollection(msrest.serialization.Model):
    """Paged deleted Api Management Services List Representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.DeletedServiceContract]
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeletedServiceContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedServicesCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DeployConfigurationParameters(msrest.serialization.Model):
    """Deploy Tenant Configuration Contract.

    :param branch: The name of the Git branch from which the configuration is to be deployed to the
     configuration database.
    :type branch: str
    :param force: The value enforcing deleting subscriptions to products that are deleted in this
     update.
    :type force: bool
    """

    _attribute_map = {
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'force': {'key': 'properties.force', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeployConfigurationParameters, self).__init__(**kwargs)
        self.branch = kwargs.get('branch', None)
        self.force = kwargs.get('force', None)


class DiagnosticCollection(msrest.serialization.Model):
    """Paged Diagnostic list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.DiagnosticContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiagnosticContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class DiagnosticContract(Resource):
    """Diagnostic details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param always_log: Specifies for what type of messages sampling settings should not apply.
     Possible values include: "allErrors".
    :type always_log: str or ~azure.mgmt.apimanagement.models.AlwaysLog
    :param logger_id: Resource Id of a target logger.
    :type logger_id: str
    :param sampling: Sampling settings for Diagnostic.
    :type sampling: ~azure.mgmt.apimanagement.models.SamplingSettings
    :param frontend: Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
    :type frontend: ~azure.mgmt.apimanagement.models.PipelineDiagnosticSettings
    :param backend: Diagnostic settings for incoming/outgoing HTTP messages to the Backend.
    :type backend: ~azure.mgmt.apimanagement.models.PipelineDiagnosticSettings
    :param log_client_ip: Log the ClientIP. Default is false.
    :type log_client_ip: bool
    :param http_correlation_protocol: Sets correlation protocol to use for Application Insights
     diagnostics. Possible values include: "None", "Legacy", "W3C".
    :type http_correlation_protocol: str or
     ~azure.mgmt.apimanagement.models.HttpCorrelationProtocol
    :param verbosity: The verbosity level applied to traces emitted by trace policies. Possible
     values include: "verbose", "information", "error".
    :type verbosity: str or ~azure.mgmt.apimanagement.models.Verbosity
    :param operation_name_format: The format of the Operation Name for Application Insights
     telemetries. Default is Name. Possible values include: "Name", "Url".
    :type operation_name_format: str or ~azure.mgmt.apimanagement.models.OperationNameFormat
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'always_log': {'key': 'properties.alwaysLog', 'type': 'str'},
        'logger_id': {'key': 'properties.loggerId', 'type': 'str'},
        'sampling': {'key': 'properties.sampling', 'type': 'SamplingSettings'},
        'frontend': {'key': 'properties.frontend', 'type': 'PipelineDiagnosticSettings'},
        'backend': {'key': 'properties.backend', 'type': 'PipelineDiagnosticSettings'},
        'log_client_ip': {'key': 'properties.logClientIp', 'type': 'bool'},
        'http_correlation_protocol': {'key': 'properties.httpCorrelationProtocol', 'type': 'str'},
        'verbosity': {'key': 'properties.verbosity', 'type': 'str'},
        'operation_name_format': {'key': 'properties.operationNameFormat', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticContract, self).__init__(**kwargs)
        self.always_log = kwargs.get('always_log', None)
        self.logger_id = kwargs.get('logger_id', None)
        self.sampling = kwargs.get('sampling', None)
        self.frontend = kwargs.get('frontend', None)
        self.backend = kwargs.get('backend', None)
        self.log_client_ip = kwargs.get('log_client_ip', None)
        self.http_correlation_protocol = kwargs.get('http_correlation_protocol', None)
        self.verbosity = kwargs.get('verbosity', None)
        self.operation_name_format = kwargs.get('operation_name_format', None)


class EmailTemplateCollection(msrest.serialization.Model):
    """Paged email template list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.EmailTemplateContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EmailTemplateContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailTemplateCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class EmailTemplateContract(Resource):
    """Email Template details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param subject: Subject of the Template.
    :type subject: str
    :param body: Email Template Body. This should be a valid XDocument.
    :type body: str
    :param title: Title of the Template.
    :type title: str
    :param description: Description of the Email Template.
    :type description: str
    :ivar is_default: Whether the template is the default template provided by Api Management or
     has been edited.
    :vartype is_default: bool
    :param parameters: Email Template Parameter values.
    :type parameters:
     list[~azure.mgmt.apimanagement.models.EmailTemplateParametersContractProperties]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'subject': {'max_length': 1000, 'min_length': 1},
        'body': {'min_length': 1},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subject': {'key': 'properties.subject', 'type': 'str'},
        'body': {'key': 'properties.body', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_default': {'key': 'properties.isDefault', 'type': 'bool'},
        'parameters': {'key': 'properties.parameters', 'type': '[EmailTemplateParametersContractProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailTemplateContract, self).__init__(**kwargs)
        self.subject = kwargs.get('subject', None)
        self.body = kwargs.get('body', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.is_default = None
        self.parameters = kwargs.get('parameters', None)


class EmailTemplateParametersContractProperties(msrest.serialization.Model):
    """Email Template Parameter contract.

    :param name: Template parameter name.
    :type name: str
    :param title: Template parameter title.
    :type title: str
    :param description: Template parameter description.
    :type description: str
    """

    _validation = {
        'name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'title': {'max_length': 4096, 'min_length': 1},
        'description': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailTemplateParametersContractProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)


class EmailTemplateUpdateParameters(msrest.serialization.Model):
    """Email Template update Parameters.

    :param subject: Subject of the Template.
    :type subject: str
    :param title: Title of the Template.
    :type title: str
    :param description: Description of the Email Template.
    :type description: str
    :param body: Email Template Body. This should be a valid XDocument.
    :type body: str
    :param parameters: Email Template Parameter values.
    :type parameters:
     list[~azure.mgmt.apimanagement.models.EmailTemplateParametersContractProperties]
    """

    _validation = {
        'subject': {'max_length': 1000, 'min_length': 1},
        'body': {'min_length': 1},
    }

    _attribute_map = {
        'subject': {'key': 'properties.subject', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'body': {'key': 'properties.body', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': '[EmailTemplateParametersContractProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailTemplateUpdateParameters, self).__init__(**kwargs)
        self.subject = kwargs.get('subject', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.body = kwargs.get('body', None)
        self.parameters = kwargs.get('parameters', None)


class ErrorFieldContract(msrest.serialization.Model):
    """Error Field contract.

    :param code: Property level error code.
    :type code: str
    :param message: Human-readable representation of property-level error.
    :type message: str
    :param target: Property name.
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorFieldContract, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)


class ErrorResponse(msrest.serialization.Model):
    """Error Response.

    :param code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :type code: str
    :param message: Human-readable representation of the error.
    :type message: str
    :param details: The list of invalid fields send in request, in case of validation error.
    :type details: list[~azure.mgmt.apimanagement.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'details': {'key': 'error.details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class ErrorResponseBody(msrest.serialization.Model):
    """Error Body contract.

    :param code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :type code: str
    :param message: Human-readable representation of the error.
    :type message: str
    :param details: The list of invalid fields send in request, in case of validation error.
    :type details: list[~azure.mgmt.apimanagement.models.ErrorFieldContract]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorFieldContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class GatewayCertificateAuthorityCollection(msrest.serialization.Model):
    """Paged Gateway certificate authority list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.GatewayCertificateAuthorityContract]
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayCertificateAuthorityContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayCertificateAuthorityCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GatewayCertificateAuthorityContract(Resource):
    """Gateway certificate authority details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param is_trusted: Determines whether certificate authority is trusted.
    :type is_trusted: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_trusted': {'key': 'properties.isTrusted', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayCertificateAuthorityContract, self).__init__(**kwargs)
        self.is_trusted = kwargs.get('is_trusted', None)


class GatewayCollection(msrest.serialization.Model):
    """Paged Gateway list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.GatewayContract]
    :param count: Total record count number across all pages.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class GatewayContract(Resource):
    """Gateway details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param location_data: Gateway location.
    :type location_data: ~azure.mgmt.apimanagement.models.ResourceLocationDataContract
    :param description: Gateway description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location_data': {'key': 'properties.locationData', 'type': 'ResourceLocationDataContract'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayContract, self).__init__(**kwargs)
        self.location_data = kwargs.get('location_data', None)
        self.description = kwargs.get('description', None)


class GatewayHostnameConfigurationCollection(msrest.serialization.Model):
    """Paged Gateway hostname configuration list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.GatewayHostnameConfigurationContract]
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GatewayHostnameConfigurationContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayHostnameConfigurationCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GatewayHostnameConfigurationContract(Resource):
    """Gateway hostname configuration details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param hostname: Hostname value. Supports valid domain name, partial or full wildcard.
    :type hostname: str
    :param certificate_id: Identifier of Certificate entity that will be used for TLS connection
     establishment.
    :type certificate_id: str
    :param negotiate_client_certificate: Determines whether gateway requests client certificate.
    :type negotiate_client_certificate: bool
    :param tls10_enabled: Specifies if TLS 1.0 is supported.
    :type tls10_enabled: bool
    :param tls11_enabled: Specifies if TLS 1.1 is supported.
    :type tls11_enabled: bool
    :param http2_enabled: Specifies if HTTP/2.0 is supported.
    :type http2_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'certificate_id': {'key': 'properties.certificateId', 'type': 'str'},
        'negotiate_client_certificate': {'key': 'properties.negotiateClientCertificate', 'type': 'bool'},
        'tls10_enabled': {'key': 'properties.tls10Enabled', 'type': 'bool'},
        'tls11_enabled': {'key': 'properties.tls11Enabled', 'type': 'bool'},
        'http2_enabled': {'key': 'properties.http2Enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayHostnameConfigurationContract, self).__init__(**kwargs)
        self.hostname = kwargs.get('hostname', None)
        self.certificate_id = kwargs.get('certificate_id', None)
        self.negotiate_client_certificate = kwargs.get('negotiate_client_certificate', None)
        self.tls10_enabled = kwargs.get('tls10_enabled', None)
        self.tls11_enabled = kwargs.get('tls11_enabled', None)
        self.http2_enabled = kwargs.get('http2_enabled', None)


class GatewayKeyRegenerationRequestContract(msrest.serialization.Model):
    """Gateway key regeneration request contract properties.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. The Key being regenerated. Possible values include: "primary",
     "secondary".
    :type key_type: str or ~azure.mgmt.apimanagement.models.KeyType
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayKeyRegenerationRequestContract, self).__init__(**kwargs)
        self.key_type = kwargs['key_type']


class GatewayKeysContract(msrest.serialization.Model):
    """Gateway authentication keys.

    :param primary: Primary gateway key.
    :type primary: str
    :param secondary: Secondary gateway key.
    :type secondary: str
    """

    _attribute_map = {
        'primary': {'key': 'primary', 'type': 'str'},
        'secondary': {'key': 'secondary', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayKeysContract, self).__init__(**kwargs)
        self.primary = kwargs.get('primary', None)
        self.secondary = kwargs.get('secondary', None)


class GatewayTokenContract(msrest.serialization.Model):
    """Gateway access token.

    :param value: Shared Access Authentication token value for the Gateway.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayTokenContract, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class GatewayTokenRequestContract(msrest.serialization.Model):
    """Gateway token request contract properties.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. The Key to be used to generate gateway token. Possible values
     include: "primary", "secondary".
    :type key_type: str or ~azure.mgmt.apimanagement.models.KeyType
    :param expiry: Required. The Expiry time of the Token. Maximum token expiry time is set to 30
     days. The date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the
     ISO 8601 standard.
    :type expiry: ~datetime.datetime
    """

    _validation = {
        'key_type': {'required': True},
        'expiry': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GatewayTokenRequestContract, self).__init__(**kwargs)
        self.key_type = kwargs['key_type']
        self.expiry = kwargs['expiry']


class GenerateSsoUrlResult(msrest.serialization.Model):
    """Generate SSO Url operations response details.

    :param value: Redirect Url containing the SSO URL value.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GenerateSsoUrlResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class GroupCollection(msrest.serialization.Model):
    """Paged Group list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.GroupContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GroupContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class GroupContract(Resource):
    """Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param display_name: Group name.
    :type display_name: str
    :param description: Group description. Can contain HTML formatting tags.
    :type description: str
    :ivar built_in: true if the group is one of the three system groups (Administrators,
     Developers, or Guests); otherwise false.
    :vartype built_in: bool
    :param type_properties_type: Group type. Possible values include: "custom", "system",
     "external".
    :type type_properties_type: str or ~azure.mgmt.apimanagement.models.GroupType
    :param external_id: For external groups, this property contains the id of the group from the
     external identity provider, e.g. for Azure Active Directory
     ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
    :type external_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 300, 'min_length': 1},
        'description': {'max_length': 1000, 'min_length': 0},
        'built_in': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'built_in': {'key': 'properties.builtIn', 'type': 'bool'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'external_id': {'key': 'properties.externalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupContract, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.built_in = None
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.external_id = kwargs.get('external_id', None)


class GroupContractProperties(msrest.serialization.Model):
    """Group contract Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param display_name: Required. Group name.
    :type display_name: str
    :param description: Group description. Can contain HTML formatting tags.
    :type description: str
    :ivar built_in: true if the group is one of the three system groups (Administrators,
     Developers, or Guests); otherwise false.
    :vartype built_in: bool
    :param type: Group type. Possible values include: "custom", "system", "external".
    :type type: str or ~azure.mgmt.apimanagement.models.GroupType
    :param external_id: For external groups, this property contains the id of the group from the
     external identity provider, e.g. for Azure Active Directory
     ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
    :type external_id: str
    """

    _validation = {
        'display_name': {'required': True, 'max_length': 300, 'min_length': 1},
        'description': {'max_length': 1000, 'min_length': 0},
        'built_in': {'readonly': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'built_in': {'key': 'builtIn', 'type': 'bool'},
        'type': {'key': 'type', 'type': 'str'},
        'external_id': {'key': 'externalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupContractProperties, self).__init__(**kwargs)
        self.display_name = kwargs['display_name']
        self.description = kwargs.get('description', None)
        self.built_in = None
        self.type = kwargs.get('type', None)
        self.external_id = kwargs.get('external_id', None)


class GroupCreateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create Group operation.

    :param display_name: Group name.
    :type display_name: str
    :param description: Group description.
    :type description: str
    :param type: Group type. Possible values include: "custom", "system", "external".
    :type type: str or ~azure.mgmt.apimanagement.models.GroupType
    :param external_id: Identifier of the external groups, this property contains the id of the
     group from the external identity provider, e.g. for Azure Active Directory
     ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
    :type external_id: str
    """

    _validation = {
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'external_id': {'key': 'properties.externalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupCreateParameters, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.type = kwargs.get('type', None)
        self.external_id = kwargs.get('external_id', None)


class GroupUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to the Update Group operation.

    :param display_name: Group name.
    :type display_name: str
    :param description: Group description.
    :type description: str
    :param type: Group type. Possible values include: "custom", "system", "external".
    :type type: str or ~azure.mgmt.apimanagement.models.GroupType
    :param external_id: Identifier of the external groups, this property contains the id of the
     group from the external identity provider, e.g. for Azure Active Directory
     ``aad://<tenant>.onmicrosoft.com/groups/<group object id>``\ ; otherwise the value is null.
    :type external_id: str
    """

    _validation = {
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'external_id': {'key': 'properties.externalId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupUpdateParameters, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.type = kwargs.get('type', None)
        self.external_id = kwargs.get('external_id', None)


class HostnameConfiguration(msrest.serialization.Model):
    """Custom hostname configuration.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Hostname type. Possible values include: "Proxy", "Portal", "Management",
     "Scm", "DeveloperPortal".
    :type type: str or ~azure.mgmt.apimanagement.models.HostnameType
    :param host_name: Required. Hostname to configure on the Api Management service.
    :type host_name: str
    :param key_vault_id: Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url
     containing version is provided, auto-update of ssl certificate will not work. This requires Api
     Management service to be configured with aka.ms/apimmsi. The secret should be of type
     *application/x-pkcs12*.
    :type key_vault_id: str
    :param identity_client_id: System or User Assigned Managed identity clientId as generated by
     Azure AD, which has GET access to the keyVault containing the SSL certificate.
    :type identity_client_id: str
    :param encoded_certificate: Base64 Encoded certificate.
    :type encoded_certificate: str
    :param certificate_password: Certificate Password.
    :type certificate_password: str
    :param default_ssl_binding: Specify true to setup the certificate associated with this Hostname
     as the Default SSL Certificate. If a client does not send the SNI header, then this will be the
     certificate that will be challenged. The property is useful if a service has multiple custom
     hostname enabled and it needs to decide on the default ssl certificate. The setting only
     applied to Proxy Hostname Type.
    :type default_ssl_binding: bool
    :param negotiate_client_certificate: Specify true to always negotiate client certificate on the
     hostname. Default Value is false.
    :type negotiate_client_certificate: bool
    :param certificate: Certificate information.
    :type certificate: ~azure.mgmt.apimanagement.models.CertificateInformation
    """

    _validation = {
        'type': {'required': True},
        'host_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
        'encoded_certificate': {'key': 'encodedCertificate', 'type': 'str'},
        'certificate_password': {'key': 'certificatePassword', 'type': 'str'},
        'default_ssl_binding': {'key': 'defaultSslBinding', 'type': 'bool'},
        'negotiate_client_certificate': {'key': 'negotiateClientCertificate', 'type': 'bool'},
        'certificate': {'key': 'certificate', 'type': 'CertificateInformation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostnameConfiguration, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.host_name = kwargs['host_name']
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.identity_client_id = kwargs.get('identity_client_id', None)
        self.encoded_certificate = kwargs.get('encoded_certificate', None)
        self.certificate_password = kwargs.get('certificate_password', None)
        self.default_ssl_binding = kwargs.get('default_ssl_binding', False)
        self.negotiate_client_certificate = kwargs.get('negotiate_client_certificate', False)
        self.certificate = kwargs.get('certificate', None)


class HttpMessageDiagnostic(msrest.serialization.Model):
    """Http message diagnostic settings.

    :param headers: Array of HTTP Headers to log.
    :type headers: list[str]
    :param body: Body logging settings.
    :type body: ~azure.mgmt.apimanagement.models.BodyDiagnosticSettings
    :param data_masking: Data masking settings.
    :type data_masking: ~azure.mgmt.apimanagement.models.DataMasking
    """

    _attribute_map = {
        'headers': {'key': 'headers', 'type': '[str]'},
        'body': {'key': 'body', 'type': 'BodyDiagnosticSettings'},
        'data_masking': {'key': 'dataMasking', 'type': 'DataMasking'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpMessageDiagnostic, self).__init__(**kwargs)
        self.headers = kwargs.get('headers', None)
        self.body = kwargs.get('body', None)
        self.data_masking = kwargs.get('data_masking', None)


class IdentityProviderBaseParameters(msrest.serialization.Model):
    """Identity Provider Base Parameter Properties.

    :param type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :type type: str or ~azure.mgmt.apimanagement.models.IdentityProviderType
    :param signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :type signin_tenant: str
    :param allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :type allowed_tenants: list[str]
    :param authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :type authority: str
    :param signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :type signup_policy_name: str
    :param signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :type signin_policy_name: str
    :param profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :type profile_editing_policy_name: str
    :param password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :type password_reset_policy_name: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'signin_tenant': {'key': 'signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'allowedTenants', 'type': '[str]'},
        'authority': {'key': 'authority', 'type': 'str'},
        'signup_policy_name': {'key': 'signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'passwordResetPolicyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProviderBaseParameters, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.signin_tenant = kwargs.get('signin_tenant', None)
        self.allowed_tenants = kwargs.get('allowed_tenants', None)
        self.authority = kwargs.get('authority', None)
        self.signup_policy_name = kwargs.get('signup_policy_name', None)
        self.signin_policy_name = kwargs.get('signin_policy_name', None)
        self.profile_editing_policy_name = kwargs.get('profile_editing_policy_name', None)
        self.password_reset_policy_name = kwargs.get('password_reset_policy_name', None)


class IdentityProviderContract(Resource):
    """Identity Provider details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param type_properties_type: Identity Provider Type identifier. Possible values include:
     "facebook", "google", "microsoft", "twitter", "aad", "aadB2C".
    :type type_properties_type: str or ~azure.mgmt.apimanagement.models.IdentityProviderType
    :param signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :type signin_tenant: str
    :param allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :type allowed_tenants: list[str]
    :param authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :type authority: str
    :param signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :type signup_policy_name: str
    :param signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :type signin_policy_name: str
    :param profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :type profile_editing_policy_name: str
    :param password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :type password_reset_policy_name: str
    :param client_id: Client Id of the Application in the external Identity Provider. It is App ID
     for Facebook login, Client ID for Google login, App ID for Microsoft.
    :type client_id: str
    :param client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :type client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'signin_tenant': {'key': 'properties.signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'properties.allowedTenants', 'type': '[str]'},
        'authority': {'key': 'properties.authority', 'type': 'str'},
        'signup_policy_name': {'key': 'properties.signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'properties.signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'properties.profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'properties.passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProviderContract, self).__init__(**kwargs)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.signin_tenant = kwargs.get('signin_tenant', None)
        self.allowed_tenants = kwargs.get('allowed_tenants', None)
        self.authority = kwargs.get('authority', None)
        self.signup_policy_name = kwargs.get('signup_policy_name', None)
        self.signin_policy_name = kwargs.get('signin_policy_name', None)
        self.profile_editing_policy_name = kwargs.get('profile_editing_policy_name', None)
        self.password_reset_policy_name = kwargs.get('password_reset_policy_name', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class IdentityProviderContractProperties(IdentityProviderBaseParameters):
    """The external Identity Providers like Facebook, Google, Microsoft, Twitter or Azure Active Directory which can be used to enable access to the API Management service developer portal for all users.

    All required parameters must be populated in order to send to Azure.

    :param type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :type type: str or ~azure.mgmt.apimanagement.models.IdentityProviderType
    :param signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :type signin_tenant: str
    :param allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :type allowed_tenants: list[str]
    :param authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :type authority: str
    :param signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :type signup_policy_name: str
    :param signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :type signin_policy_name: str
    :param profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :type profile_editing_policy_name: str
    :param password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :type password_reset_policy_name: str
    :param client_id: Required. Client Id of the Application in the external Identity Provider. It
     is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
    :type client_id: str
    :param client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :type client_secret: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'required': True, 'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'signin_tenant': {'key': 'signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'allowedTenants', 'type': '[str]'},
        'authority': {'key': 'authority', 'type': 'str'},
        'signup_policy_name': {'key': 'signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProviderContractProperties, self).__init__(**kwargs)
        self.client_id = kwargs['client_id']
        self.client_secret = kwargs.get('client_secret', None)


class IdentityProviderCreateContract(Resource):
    """Identity Provider details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param type_properties_type: Identity Provider Type identifier. Possible values include:
     "facebook", "google", "microsoft", "twitter", "aad", "aadB2C".
    :type type_properties_type: str or ~azure.mgmt.apimanagement.models.IdentityProviderType
    :param signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :type signin_tenant: str
    :param allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :type allowed_tenants: list[str]
    :param authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :type authority: str
    :param signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :type signup_policy_name: str
    :param signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :type signin_policy_name: str
    :param profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :type profile_editing_policy_name: str
    :param password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :type password_reset_policy_name: str
    :param client_id: Client Id of the Application in the external Identity Provider. It is App ID
     for Facebook login, Client ID for Google login, App ID for Microsoft.
    :type client_id: str
    :param client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft. This property will not be filled on 'GET' operations!
     Use '/listSecrets' POST request to get the value.
    :type client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'signin_tenant': {'key': 'properties.signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'properties.allowedTenants', 'type': '[str]'},
        'authority': {'key': 'properties.authority', 'type': 'str'},
        'signup_policy_name': {'key': 'properties.signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'properties.signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'properties.profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'properties.passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProviderCreateContract, self).__init__(**kwargs)
        self.type_properties_type = kwargs.get('type_properties_type', None)
        self.signin_tenant = kwargs.get('signin_tenant', None)
        self.allowed_tenants = kwargs.get('allowed_tenants', None)
        self.authority = kwargs.get('authority', None)
        self.signup_policy_name = kwargs.get('signup_policy_name', None)
        self.signin_policy_name = kwargs.get('signin_policy_name', None)
        self.profile_editing_policy_name = kwargs.get('profile_editing_policy_name', None)
        self.password_reset_policy_name = kwargs.get('password_reset_policy_name', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class IdentityProviderCreateContractProperties(IdentityProviderBaseParameters):
    """The external Identity Providers like Facebook, Google, Microsoft, Twitter or Azure Active Directory which can be used to enable access to the API Management service developer portal for all users.

    All required parameters must be populated in order to send to Azure.

    :param type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :type type: str or ~azure.mgmt.apimanagement.models.IdentityProviderType
    :param signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :type signin_tenant: str
    :param allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :type allowed_tenants: list[str]
    :param authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :type authority: str
    :param signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :type signup_policy_name: str
    :param signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :type signin_policy_name: str
    :param profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :type profile_editing_policy_name: str
    :param password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :type password_reset_policy_name: str
    :param client_id: Required. Client Id of the Application in the external Identity Provider. It
     is App ID for Facebook login, Client ID for Google login, App ID for Microsoft.
    :type client_id: str
    :param client_secret: Required. Client secret of the Application in external Identity Provider,
     used to authenticate login request. For example, it is App Secret for Facebook login, API Key
     for Google login, Public Key for Microsoft. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :type client_secret: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'required': True, 'min_length': 1},
        'client_secret': {'required': True, 'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'signin_tenant': {'key': 'signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'allowedTenants', 'type': '[str]'},
        'authority': {'key': 'authority', 'type': 'str'},
        'signup_policy_name': {'key': 'signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProviderCreateContractProperties, self).__init__(**kwargs)
        self.client_id = kwargs['client_id']
        self.client_secret = kwargs['client_secret']


class IdentityProviderList(msrest.serialization.Model):
    """List of all the Identity Providers configured on the service instance.

    :param value: Identity Provider configuration values.
    :type value: list[~azure.mgmt.apimanagement.models.IdentityProviderContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IdentityProviderContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProviderList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class IdentityProviderUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to update Identity Provider.

    :param type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :type type: str or ~azure.mgmt.apimanagement.models.IdentityProviderType
    :param signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :type signin_tenant: str
    :param allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :type allowed_tenants: list[str]
    :param authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :type authority: str
    :param signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :type signup_policy_name: str
    :param signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :type signin_policy_name: str
    :param profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :type profile_editing_policy_name: str
    :param password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :type password_reset_policy_name: str
    :param client_id: Client Id of the Application in the external Identity Provider. It is App ID
     for Facebook login, Client ID for Google login, App ID for Microsoft.
    :type client_id: str
    :param client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft.
    :type client_secret: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'properties.type', 'type': 'str'},
        'signin_tenant': {'key': 'properties.signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'properties.allowedTenants', 'type': '[str]'},
        'authority': {'key': 'properties.authority', 'type': 'str'},
        'signup_policy_name': {'key': 'properties.signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'properties.signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'properties.profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'properties.passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProviderUpdateParameters, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.signin_tenant = kwargs.get('signin_tenant', None)
        self.allowed_tenants = kwargs.get('allowed_tenants', None)
        self.authority = kwargs.get('authority', None)
        self.signup_policy_name = kwargs.get('signup_policy_name', None)
        self.signin_policy_name = kwargs.get('signin_policy_name', None)
        self.profile_editing_policy_name = kwargs.get('profile_editing_policy_name', None)
        self.password_reset_policy_name = kwargs.get('password_reset_policy_name', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class IdentityProviderUpdateProperties(IdentityProviderBaseParameters):
    """Parameters supplied to the Update Identity Provider operation.

    :param type: Identity Provider Type identifier. Possible values include: "facebook", "google",
     "microsoft", "twitter", "aad", "aadB2C".
    :type type: str or ~azure.mgmt.apimanagement.models.IdentityProviderType
    :param signin_tenant: The TenantId to use instead of Common when logging into Active Directory.
    :type signin_tenant: str
    :param allowed_tenants: List of Allowed Tenants when configuring Azure Active Directory login.
    :type allowed_tenants: list[str]
    :param authority: OpenID Connect discovery endpoint hostname for AAD or AAD B2C.
    :type authority: str
    :param signup_policy_name: Signup Policy Name. Only applies to AAD B2C Identity Provider.
    :type signup_policy_name: str
    :param signin_policy_name: Signin Policy Name. Only applies to AAD B2C Identity Provider.
    :type signin_policy_name: str
    :param profile_editing_policy_name: Profile Editing Policy Name. Only applies to AAD B2C
     Identity Provider.
    :type profile_editing_policy_name: str
    :param password_reset_policy_name: Password Reset Policy Name. Only applies to AAD B2C Identity
     Provider.
    :type password_reset_policy_name: str
    :param client_id: Client Id of the Application in the external Identity Provider. It is App ID
     for Facebook login, Client ID for Google login, App ID for Microsoft.
    :type client_id: str
    :param client_secret: Client secret of the Application in external Identity Provider, used to
     authenticate login request. For example, it is App Secret for Facebook login, API Key for
     Google login, Public Key for Microsoft.
    :type client_secret: str
    """

    _validation = {
        'allowed_tenants': {'max_items': 32, 'min_items': 0},
        'signup_policy_name': {'min_length': 1},
        'signin_policy_name': {'min_length': 1},
        'profile_editing_policy_name': {'min_length': 1},
        'password_reset_policy_name': {'min_length': 1},
        'client_id': {'min_length': 1},
        'client_secret': {'min_length': 1},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'signin_tenant': {'key': 'signinTenant', 'type': 'str'},
        'allowed_tenants': {'key': 'allowedTenants', 'type': '[str]'},
        'authority': {'key': 'authority', 'type': 'str'},
        'signup_policy_name': {'key': 'signupPolicyName', 'type': 'str'},
        'signin_policy_name': {'key': 'signinPolicyName', 'type': 'str'},
        'profile_editing_policy_name': {'key': 'profileEditingPolicyName', 'type': 'str'},
        'password_reset_policy_name': {'key': 'passwordResetPolicyName', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProviderUpdateProperties, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class IssueAttachmentCollection(msrest.serialization.Model):
    """Paged Issue Attachment list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Issue Attachment values.
    :vartype value: list[~azure.mgmt.apimanagement.models.IssueAttachmentContract]
    :param count: Total record count number across all pages.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IssueAttachmentContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueAttachmentCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class IssueAttachmentContract(Resource):
    """Issue Attachment Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param title: Filename by which the binary data will be saved.
    :type title: str
    :param content_format: Either 'link' if content is provided via an HTTP link or the MIME type
     of the Base64-encoded binary data provided in the 'content' property.
    :type content_format: str
    :param content: An HTTP link or Base64-encoded binary data.
    :type content: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'content_format': {'key': 'properties.contentFormat', 'type': 'str'},
        'content': {'key': 'properties.content', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueAttachmentContract, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.content_format = kwargs.get('content_format', None)
        self.content = kwargs.get('content', None)


class IssueCollection(msrest.serialization.Model):
    """Paged Issue list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Issue values.
    :vartype value: list[~azure.mgmt.apimanagement.models.IssueContract]
    :param count: Total record count number across all pages.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IssueContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class IssueCommentCollection(msrest.serialization.Model):
    """Paged Issue Comment list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Issue Comment values.
    :vartype value: list[~azure.mgmt.apimanagement.models.IssueCommentContract]
    :param count: Total record count number across all pages.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IssueCommentContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueCommentCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class IssueCommentContract(Resource):
    """Issue Comment Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param text: Comment text.
    :type text: str
    :param created_date: Date and time when the comment was created.
    :type created_date: ~datetime.datetime
    :param user_id: A resource identifier for the user who left the comment.
    :type user_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'text': {'key': 'properties.text', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueCommentContract, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.created_date = kwargs.get('created_date', None)
        self.user_id = kwargs.get('user_id', None)


class IssueContract(Resource):
    """Issue Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param created_date: Date and time when the issue was created.
    :type created_date: ~datetime.datetime
    :param state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :type state: str or ~azure.mgmt.apimanagement.models.State
    :param api_id: A resource identifier for the API the issue was created for.
    :type api_id: str
    :param title: The issue title.
    :type title: str
    :param description: Text describing the issue.
    :type description: str
    :param user_id: A resource identifier for the user created the issue.
    :type user_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'api_id': {'key': 'properties.apiId', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueContract, self).__init__(**kwargs)
        self.created_date = kwargs.get('created_date', None)
        self.state = kwargs.get('state', None)
        self.api_id = kwargs.get('api_id', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.user_id = kwargs.get('user_id', None)


class IssueContractBaseProperties(msrest.serialization.Model):
    """Issue contract Base Properties.

    :param created_date: Date and time when the issue was created.
    :type created_date: ~datetime.datetime
    :param state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :type state: str or ~azure.mgmt.apimanagement.models.State
    :param api_id: A resource identifier for the API the issue was created for.
    :type api_id: str
    """

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'api_id': {'key': 'apiId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueContractBaseProperties, self).__init__(**kwargs)
        self.created_date = kwargs.get('created_date', None)
        self.state = kwargs.get('state', None)
        self.api_id = kwargs.get('api_id', None)


class IssueContractProperties(IssueContractBaseProperties):
    """Issue contract Properties.

    All required parameters must be populated in order to send to Azure.

    :param created_date: Date and time when the issue was created.
    :type created_date: ~datetime.datetime
    :param state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :type state: str or ~azure.mgmt.apimanagement.models.State
    :param api_id: A resource identifier for the API the issue was created for.
    :type api_id: str
    :param title: Required. The issue title.
    :type title: str
    :param description: Required. Text describing the issue.
    :type description: str
    :param user_id: Required. A resource identifier for the user created the issue.
    :type user_id: str
    """

    _validation = {
        'title': {'required': True},
        'description': {'required': True},
        'user_id': {'required': True},
    }

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'api_id': {'key': 'apiId', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueContractProperties, self).__init__(**kwargs)
        self.title = kwargs['title']
        self.description = kwargs['description']
        self.user_id = kwargs['user_id']


class IssueUpdateContract(msrest.serialization.Model):
    """Issue update Parameters.

    :param created_date: Date and time when the issue was created.
    :type created_date: ~datetime.datetime
    :param state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :type state: str or ~azure.mgmt.apimanagement.models.State
    :param api_id: A resource identifier for the API the issue was created for.
    :type api_id: str
    :param title: The issue title.
    :type title: str
    :param description: Text describing the issue.
    :type description: str
    :param user_id: A resource identifier for the user created the issue.
    :type user_id: str
    """

    _attribute_map = {
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'api_id': {'key': 'properties.apiId', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueUpdateContract, self).__init__(**kwargs)
        self.created_date = kwargs.get('created_date', None)
        self.state = kwargs.get('state', None)
        self.api_id = kwargs.get('api_id', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.user_id = kwargs.get('user_id', None)


class IssueUpdateContractProperties(IssueContractBaseProperties):
    """Issue contract Update Properties.

    :param created_date: Date and time when the issue was created.
    :type created_date: ~datetime.datetime
    :param state: Status of the issue. Possible values include: "proposed", "open", "removed",
     "resolved", "closed".
    :type state: str or ~azure.mgmt.apimanagement.models.State
    :param api_id: A resource identifier for the API the issue was created for.
    :type api_id: str
    :param title: The issue title.
    :type title: str
    :param description: Text describing the issue.
    :type description: str
    :param user_id: A resource identifier for the user created the issue.
    :type user_id: str
    """

    _attribute_map = {
        'created_date': {'key': 'createdDate', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'api_id': {'key': 'apiId', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IssueUpdateContractProperties, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.user_id = kwargs.get('user_id', None)


class KeyVaultContractCreateProperties(msrest.serialization.Model):
    """Create keyVault contract details.

    :param secret_identifier: Key vault secret identifier for fetching secret. Providing a
     versioned secret will prevent auto-refresh. This requires Api Management service to be
     configured with aka.ms/apimmsi.
    :type secret_identifier: str
    :param identity_client_id: SystemAssignedIdentity or UserAssignedIdentity Client Id which will
     be used to access key vault secret.
    :type identity_client_id: str
    """

    _attribute_map = {
        'secret_identifier': {'key': 'secretIdentifier', 'type': 'str'},
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultContractCreateProperties, self).__init__(**kwargs)
        self.secret_identifier = kwargs.get('secret_identifier', None)
        self.identity_client_id = kwargs.get('identity_client_id', None)


class KeyVaultContractProperties(KeyVaultContractCreateProperties):
    """KeyVault contract details.

    :param secret_identifier: Key vault secret identifier for fetching secret. Providing a
     versioned secret will prevent auto-refresh. This requires Api Management service to be
     configured with aka.ms/apimmsi.
    :type secret_identifier: str
    :param identity_client_id: SystemAssignedIdentity or UserAssignedIdentity Client Id which will
     be used to access key vault secret.
    :type identity_client_id: str
    :param last_status: Last time sync and refresh status of secret from key vault.
    :type last_status: ~azure.mgmt.apimanagement.models.KeyVaultLastAccessStatusContractProperties
    """

    _attribute_map = {
        'secret_identifier': {'key': 'secretIdentifier', 'type': 'str'},
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
        'last_status': {'key': 'lastStatus', 'type': 'KeyVaultLastAccessStatusContractProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultContractProperties, self).__init__(**kwargs)
        self.last_status = kwargs.get('last_status', None)


class KeyVaultLastAccessStatusContractProperties(msrest.serialization.Model):
    """Issue contract Update Properties.

    :param code: Last status code for sync and refresh of secret from key vault.
    :type code: str
    :param message: Details of the error else empty.
    :type message: str
    :param time_stamp_utc: Last time secret was accessed. The date conforms to the following
     format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type time_stamp_utc: ~datetime.datetime
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time_stamp_utc': {'key': 'timeStampUtc', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultLastAccessStatusContractProperties, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.time_stamp_utc = kwargs.get('time_stamp_utc', None)


class LoggerCollection(msrest.serialization.Model):
    """Paged Logger list representation.

    :param value: Logger values.
    :type value: list[~azure.mgmt.apimanagement.models.LoggerContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoggerContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoggerCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class LoggerContract(Resource):
    """Logger details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param logger_type: Logger type. Possible values include: "azureEventHub",
     "applicationInsights", "azureMonitor".
    :type logger_type: str or ~azure.mgmt.apimanagement.models.LoggerType
    :param description: Logger description.
    :type description: str
    :param credentials: The name and SendRule connection string of the event hub for azureEventHub
     logger.
     Instrumentation key for applicationInsights logger.
    :type credentials: dict[str, str]
    :param is_buffered: Whether records are buffered in the logger before publishing. Default is
     assumed to be true.
    :type is_buffered: bool
    :param resource_id: Azure Resource Id of a log target (either Azure Event Hub resource or Azure
     Application Insights resource).
    :type resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'logger_type': {'key': 'properties.loggerType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': '{str}'},
        'is_buffered': {'key': 'properties.isBuffered', 'type': 'bool'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoggerContract, self).__init__(**kwargs)
        self.logger_type = kwargs.get('logger_type', None)
        self.description = kwargs.get('description', None)
        self.credentials = kwargs.get('credentials', None)
        self.is_buffered = kwargs.get('is_buffered', None)
        self.resource_id = kwargs.get('resource_id', None)


class LoggerUpdateContract(msrest.serialization.Model):
    """Logger update contract.

    :param logger_type: Logger type. Possible values include: "azureEventHub",
     "applicationInsights", "azureMonitor".
    :type logger_type: str or ~azure.mgmt.apimanagement.models.LoggerType
    :param description: Logger description.
    :type description: str
    :param credentials: Logger credentials.
    :type credentials: dict[str, str]
    :param is_buffered: Whether records are buffered in the logger before publishing. Default is
     assumed to be true.
    :type is_buffered: bool
    """

    _attribute_map = {
        'logger_type': {'key': 'properties.loggerType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'credentials': {'key': 'properties.credentials', 'type': '{str}'},
        'is_buffered': {'key': 'properties.isBuffered', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoggerUpdateContract, self).__init__(**kwargs)
        self.logger_type = kwargs.get('logger_type', None)
        self.description = kwargs.get('description', None)
        self.credentials = kwargs.get('credentials', None)
        self.is_buffered = kwargs.get('is_buffered', None)


class NamedValueCollection(msrest.serialization.Model):
    """Paged NamedValue list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.NamedValueContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NamedValueContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedValueCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class NamedValueContract(Resource):
    """NamedValue details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :type tags: list[str]
    :param secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :type secret: bool
    :param display_name: Unique name of NamedValue. It may contain only letters, digits, period,
     dash, and underscore characters.
    :type display_name: str
    :param value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace. This property will not be filled on 'GET' operations! Use
     '/listSecrets' POST request to get the value.
    :type value: str
    :param key_vault: KeyVault location details of the namedValue.
    :type key_vault: ~azure.mgmt.apimanagement.models.KeyVaultContractProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'properties.tags', 'type': '[str]'},
        'secret': {'key': 'properties.secret', 'type': 'bool'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedValueContract, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.secret = kwargs.get('secret', None)
        self.display_name = kwargs.get('display_name', None)
        self.value = kwargs.get('value', None)
        self.key_vault = kwargs.get('key_vault', None)


class NamedValueEntityBaseParameters(msrest.serialization.Model):
    """NamedValue Entity Base Parameters set.

    :param tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :type tags: list[str]
    :param secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :type secret: bool
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '[str]'},
        'secret': {'key': 'secret', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedValueEntityBaseParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.secret = kwargs.get('secret', None)


class NamedValueContractProperties(NamedValueEntityBaseParameters):
    """NamedValue Contract properties.

    All required parameters must be populated in order to send to Azure.

    :param tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :type tags: list[str]
    :param secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :type secret: bool
    :param display_name: Required. Unique name of NamedValue. It may contain only letters, digits,
     period, dash, and underscore characters.
    :type display_name: str
    :param value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace. This property will not be filled on 'GET' operations! Use
     '/listSecrets' POST request to get the value.
    :type value: str
    :param key_vault: KeyVault location details of the namedValue.
    :type key_vault: ~azure.mgmt.apimanagement.models.KeyVaultContractProperties
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'required': True, 'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '[str]'},
        'secret': {'key': 'secret', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultContractProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedValueContractProperties, self).__init__(**kwargs)
        self.display_name = kwargs['display_name']
        self.value = kwargs.get('value', None)
        self.key_vault = kwargs.get('key_vault', None)


class NamedValueCreateContract(Resource):
    """NamedValue details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :type tags: list[str]
    :param secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :type secret: bool
    :param display_name: Unique name of NamedValue. It may contain only letters, digits, period,
     dash, and underscore characters.
    :type display_name: str
    :param value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace. This property will not be filled on 'GET' operations! Use
     '/listSecrets' POST request to get the value.
    :type value: str
    :param key_vault: KeyVault location details of the namedValue.
    :type key_vault: ~azure.mgmt.apimanagement.models.KeyVaultContractCreateProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'properties.tags', 'type': '[str]'},
        'secret': {'key': 'properties.secret', 'type': 'bool'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedValueCreateContract, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.secret = kwargs.get('secret', None)
        self.display_name = kwargs.get('display_name', None)
        self.value = kwargs.get('value', None)
        self.key_vault = kwargs.get('key_vault', None)


class NamedValueCreateContractProperties(NamedValueEntityBaseParameters):
    """NamedValue Contract properties.

    All required parameters must be populated in order to send to Azure.

    :param tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :type tags: list[str]
    :param secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :type secret: bool
    :param display_name: Required. Unique name of NamedValue. It may contain only letters, digits,
     period, dash, and underscore characters.
    :type display_name: str
    :param value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace. This property will not be filled on 'GET' operations! Use
     '/listSecrets' POST request to get the value.
    :type value: str
    :param key_vault: KeyVault location details of the namedValue.
    :type key_vault: ~azure.mgmt.apimanagement.models.KeyVaultContractCreateProperties
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'required': True, 'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '[str]'},
        'secret': {'key': 'secret', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedValueCreateContractProperties, self).__init__(**kwargs)
        self.display_name = kwargs['display_name']
        self.value = kwargs.get('value', None)
        self.key_vault = kwargs.get('key_vault', None)


class NamedValueSecretContract(msrest.serialization.Model):
    """Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.

    :param value: This is secret value of the NamedValue entity.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedValueSecretContract, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class NamedValueUpdateParameterProperties(NamedValueEntityBaseParameters):
    """NamedValue Contract properties.

    :param tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :type tags: list[str]
    :param secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :type secret: bool
    :param display_name: Unique name of NamedValue. It may contain only letters, digits, period,
     dash, and underscore characters.
    :type display_name: str
    :param value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace.
    :type value: str
    :param key_vault: KeyVault location details of the namedValue.
    :type key_vault: ~azure.mgmt.apimanagement.models.KeyVaultContractCreateProperties
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 1},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '[str]'},
        'secret': {'key': 'secret', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'key_vault': {'key': 'keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedValueUpdateParameterProperties, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.value = kwargs.get('value', None)
        self.key_vault = kwargs.get('key_vault', None)


class NamedValueUpdateParameters(msrest.serialization.Model):
    """NamedValue update Parameters.

    :param tags: A set of tags. Optional tags that when provided can be used to filter the
     NamedValue list.
    :type tags: list[str]
    :param secret: Determines whether the value is a secret and should be encrypted or not. Default
     value is false.
    :type secret: bool
    :param display_name: Unique name of NamedValue. It may contain only letters, digits, period,
     dash, and underscore characters.
    :type display_name: str
    :param value: Value of the NamedValue. Can contain policy expressions. It may not be empty or
     consist only of whitespace.
    :type value: str
    :param key_vault: KeyVault location details of the namedValue.
    :type key_vault: ~azure.mgmt.apimanagement.models.KeyVaultContractCreateProperties
    """

    _validation = {
        'tags': {'max_items': 32, 'min_items': 0},
        'display_name': {'max_length': 256, 'min_length': 1, 'pattern': r'^[A-Za-z0-9-._]+$'},
        'value': {'max_length': 4096, 'min_length': 1},
    }

    _attribute_map = {
        'tags': {'key': 'properties.tags', 'type': '[str]'},
        'secret': {'key': 'properties.secret', 'type': 'bool'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'KeyVaultContractCreateProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NamedValueUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.secret = kwargs.get('secret', None)
        self.display_name = kwargs.get('display_name', None)
        self.value = kwargs.get('value', None)
        self.key_vault = kwargs.get('key_vault', None)


class NetworkStatusContract(msrest.serialization.Model):
    """Network Status details.

    All required parameters must be populated in order to send to Azure.

    :param dns_servers: Required. Gets the list of DNS servers IPV4 addresses.
    :type dns_servers: list[str]
    :param connectivity_status: Required. Gets the list of Connectivity Status to the Resources on
     which the service depends upon.
    :type connectivity_status: list[~azure.mgmt.apimanagement.models.ConnectivityStatusContract]
    """

    _validation = {
        'dns_servers': {'required': True},
        'connectivity_status': {'required': True},
    }

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
        'connectivity_status': {'key': 'connectivityStatus', 'type': '[ConnectivityStatusContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkStatusContract, self).__init__(**kwargs)
        self.dns_servers = kwargs['dns_servers']
        self.connectivity_status = kwargs['connectivity_status']


class NetworkStatusContractByLocation(msrest.serialization.Model):
    """Network Status in the Location.

    :param location: Location of service.
    :type location: str
    :param network_status: Network status in Location.
    :type network_status: ~azure.mgmt.apimanagement.models.NetworkStatusContract
    """

    _validation = {
        'location': {'min_length': 1},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'network_status': {'key': 'networkStatus', 'type': 'NetworkStatusContract'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkStatusContractByLocation, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.network_status = kwargs.get('network_status', None)


class NotificationCollection(msrest.serialization.Model):
    """Paged Notification list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.NotificationContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NotificationContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotificationCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class NotificationContract(Resource):
    """Notification details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param title: Title of the Notification.
    :type title: str
    :param description: Description of the Notification.
    :type description: str
    :param recipients: Recipient Parameter values.
    :type recipients: ~azure.mgmt.apimanagement.models.RecipientsContractProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'title': {'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'recipients': {'key': 'properties.recipients', 'type': 'RecipientsContractProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotificationContract, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.recipients = kwargs.get('recipients', None)


class OAuth2AuthenticationSettingsContract(msrest.serialization.Model):
    """API OAuth2 Authentication settings details.

    :param authorization_server_id: OAuth authorization server identifier.
    :type authorization_server_id: str
    :param scope: operations scope.
    :type scope: str
    """

    _attribute_map = {
        'authorization_server_id': {'key': 'authorizationServerId', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OAuth2AuthenticationSettingsContract, self).__init__(**kwargs)
        self.authorization_server_id = kwargs.get('authorization_server_id', None)
        self.scope = kwargs.get('scope', None)


class OpenIdAuthenticationSettingsContract(msrest.serialization.Model):
    """API OAuth2 Authentication settings details.

    :param openid_provider_id: OAuth authorization server identifier.
    :type openid_provider_id: str
    :param bearer_token_sending_methods: How to send token to the server.
    :type bearer_token_sending_methods: list[str or
     ~azure.mgmt.apimanagement.models.BearerTokenSendingMethods]
    """

    _attribute_map = {
        'openid_provider_id': {'key': 'openidProviderId', 'type': 'str'},
        'bearer_token_sending_methods': {'key': 'bearerTokenSendingMethods', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OpenIdAuthenticationSettingsContract, self).__init__(**kwargs)
        self.openid_provider_id = kwargs.get('openid_provider_id', None)
        self.bearer_token_sending_methods = kwargs.get('bearer_token_sending_methods', None)


class OpenIdConnectProviderCollection(msrest.serialization.Model):
    """Paged OpenIdProviders list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.OpenidConnectProviderContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OpenidConnectProviderContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OpenIdConnectProviderCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class OpenidConnectProviderContract(Resource):
    """OpenId Connect Provider details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param display_name: User-friendly OpenID Connect Provider name.
    :type display_name: str
    :param description: User-friendly description of OpenID Connect Provider.
    :type description: str
    :param metadata_endpoint: Metadata endpoint URI.
    :type metadata_endpoint: str
    :param client_id: Client ID of developer console which is the client application.
    :type client_id: str
    :param client_secret: Client Secret of developer console which is the client application.
    :type client_secret: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'metadata_endpoint': {'key': 'properties.metadataEndpoint', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OpenidConnectProviderContract, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.metadata_endpoint = kwargs.get('metadata_endpoint', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class OpenidConnectProviderUpdateContract(msrest.serialization.Model):
    """Parameters supplied to the Update OpenID Connect Provider operation.

    :param display_name: User-friendly OpenID Connect Provider name.
    :type display_name: str
    :param description: User-friendly description of OpenID Connect Provider.
    :type description: str
    :param metadata_endpoint: Metadata endpoint URI.
    :type metadata_endpoint: str
    :param client_id: Client ID of developer console which is the client application.
    :type client_id: str
    :param client_secret: Client Secret of developer console which is the client application.
    :type client_secret: str
    """

    _validation = {
        'display_name': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'metadata_endpoint': {'key': 'properties.metadataEndpoint', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OpenidConnectProviderUpdateContract, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.metadata_endpoint = kwargs.get('metadata_endpoint', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)


class Operation(msrest.serialization.Model):
    """REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that describes the operation.
    :type display: ~azure.mgmt.apimanagement.models.OperationDisplay
    :param origin: The operation origin.
    :type origin: str
    :param properties: The operation properties.
    :type properties: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationCollection(msrest.serialization.Model):
    """Paged Operation list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.OperationContract]
    :param count: Total record count number across all pages.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class OperationContract(Resource):
    """Api Operation details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param template_parameters: Collection of URL template parameters.
    :type template_parameters: list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param description: Description of the operation. May include HTML formatting tags.
    :type description: str
    :param request: An entity containing request details.
    :type request: ~azure.mgmt.apimanagement.models.RequestContract
    :param responses: Array of Operation responses.
    :type responses: list[~azure.mgmt.apimanagement.models.ResponseContract]
    :param policies: Operation Policies.
    :type policies: str
    :param display_name: Operation Name.
    :type display_name: str
    :param method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not
     limited by only them.
    :type method: str
    :param url_template: Relative URL template identifying the target resource for this operation.
     May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :type url_template: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'url_template': {'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'template_parameters': {'key': 'properties.templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'request': {'key': 'properties.request', 'type': 'RequestContract'},
        'responses': {'key': 'properties.responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'properties.policies', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'method': {'key': 'properties.method', 'type': 'str'},
        'url_template': {'key': 'properties.urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationContract, self).__init__(**kwargs)
        self.template_parameters = kwargs.get('template_parameters', None)
        self.description = kwargs.get('description', None)
        self.request = kwargs.get('request', None)
        self.responses = kwargs.get('responses', None)
        self.policies = kwargs.get('policies', None)
        self.display_name = kwargs.get('display_name', None)
        self.method = kwargs.get('method', None)
        self.url_template = kwargs.get('url_template', None)


class OperationEntityBaseContract(msrest.serialization.Model):
    """Api Operation Entity Base Contract details.

    :param template_parameters: Collection of URL template parameters.
    :type template_parameters: list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param description: Description of the operation. May include HTML formatting tags.
    :type description: str
    :param request: An entity containing request details.
    :type request: ~azure.mgmt.apimanagement.models.RequestContract
    :param responses: Array of Operation responses.
    :type responses: list[~azure.mgmt.apimanagement.models.ResponseContract]
    :param policies: Operation Policies.
    :type policies: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'template_parameters': {'key': 'templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'description', 'type': 'str'},
        'request': {'key': 'request', 'type': 'RequestContract'},
        'responses': {'key': 'responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'policies', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationEntityBaseContract, self).__init__(**kwargs)
        self.template_parameters = kwargs.get('template_parameters', None)
        self.description = kwargs.get('description', None)
        self.request = kwargs.get('request', None)
        self.responses = kwargs.get('responses', None)
        self.policies = kwargs.get('policies', None)


class OperationContractProperties(OperationEntityBaseContract):
    """Operation Contract Properties.

    All required parameters must be populated in order to send to Azure.

    :param template_parameters: Collection of URL template parameters.
    :type template_parameters: list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param description: Description of the operation. May include HTML formatting tags.
    :type description: str
    :param request: An entity containing request details.
    :type request: ~azure.mgmt.apimanagement.models.RequestContract
    :param responses: Array of Operation responses.
    :type responses: list[~azure.mgmt.apimanagement.models.ResponseContract]
    :param policies: Operation Policies.
    :type policies: str
    :param display_name: Required. Operation Name.
    :type display_name: str
    :param method: Required. A Valid HTTP Operation Method. Typical Http Methods like GET, PUT,
     POST but not limited by only them.
    :type method: str
    :param url_template: Required. Relative URL template identifying the target resource for this
     operation. May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :type url_template: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'required': True, 'max_length': 300, 'min_length': 1},
        'method': {'required': True},
        'url_template': {'required': True, 'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'template_parameters': {'key': 'templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'description', 'type': 'str'},
        'request': {'key': 'request', 'type': 'RequestContract'},
        'responses': {'key': 'responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'policies', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url_template': {'key': 'urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationContractProperties, self).__init__(**kwargs)
        self.display_name = kwargs['display_name']
        self.method = kwargs['method']
        self.url_template = kwargs['url_template']


class OperationDisplay(msrest.serialization.Model):
    """The object that describes the operation.

    :param provider: Friendly name of the resource provider.
    :type provider: str
    :param operation: Operation type: read, write, delete, listKeys/action, etc.
    :type operation: str
    :param resource: Resource type on which the operation is performed.
    :type resource: str
    :param description: Friendly name of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.operation = kwargs.get('operation', None)
        self.resource = kwargs.get('resource', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next set of results.

    :param value: List of operations supported by the resource provider.
    :type value: list[~azure.mgmt.apimanagement.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class OperationResultContract(Resource):
    """Long Running Git Operation Results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param id_properties_id: Operation result identifier.
    :type id_properties_id: str
    :param status: Status of an async operation. Possible values include: "Started", "InProgress",
     "Succeeded", "Failed".
    :type status: str or ~azure.mgmt.apimanagement.models.AsyncOperationStatus
    :param started: Start time of an async operation. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type started: ~datetime.datetime
    :param updated: Last update time of an async operation. The date conforms to the following
     format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type updated: ~datetime.datetime
    :param result_info: Optional result info.
    :type result_info: str
    :param error: Error Body Contract.
    :type error: ~azure.mgmt.apimanagement.models.ErrorResponseBody
    :ivar action_log: This property if only provided as part of the TenantConfiguration_Validate
     operation. It contains the log the entities which will be updated/created/deleted as part of
     the TenantConfiguration_Deploy operation.
    :vartype action_log: list[~azure.mgmt.apimanagement.models.OperationResultLogItemContract]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'action_log': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'started': {'key': 'properties.started', 'type': 'iso-8601'},
        'updated': {'key': 'properties.updated', 'type': 'iso-8601'},
        'result_info': {'key': 'properties.resultInfo', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'ErrorResponseBody'},
        'action_log': {'key': 'properties.actionLog', 'type': '[OperationResultLogItemContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResultContract, self).__init__(**kwargs)
        self.id_properties_id = kwargs.get('id_properties_id', None)
        self.status = kwargs.get('status', None)
        self.started = kwargs.get('started', None)
        self.updated = kwargs.get('updated', None)
        self.result_info = kwargs.get('result_info', None)
        self.error = kwargs.get('error', None)
        self.action_log = None


class OperationResultLogItemContract(msrest.serialization.Model):
    """Log of the entity being created, updated or deleted.

    :param object_type: The type of entity contract.
    :type object_type: str
    :param action: Action like create/update/delete.
    :type action: str
    :param object_key: Identifier of the entity being created/updated/deleted.
    :type object_key: str
    """

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'object_key': {'key': 'objectKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResultLogItemContract, self).__init__(**kwargs)
        self.object_type = kwargs.get('object_type', None)
        self.action = kwargs.get('action', None)
        self.object_key = kwargs.get('object_key', None)


class OperationTagResourceContractProperties(msrest.serialization.Model):
    """Operation Entity contract Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Identifier of the operation in form /operations/{operationId}.
    :type id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar api_name: Api Name.
    :vartype api_name: str
    :ivar api_revision: Api Revision.
    :vartype api_revision: str
    :ivar api_version: Api Version.
    :vartype api_version: str
    :ivar description: Operation Description.
    :vartype description: str
    :ivar method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not
     limited by only them.
    :vartype method: str
    :ivar url_template: Relative URL template identifying the target resource for this operation.
     May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :vartype url_template: str
    """

    _validation = {
        'name': {'readonly': True},
        'api_name': {'readonly': True},
        'api_revision': {'readonly': True},
        'api_version': {'readonly': True},
        'description': {'readonly': True},
        'method': {'readonly': True},
        'url_template': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'api_name': {'key': 'apiName', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url_template': {'key': 'urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationTagResourceContractProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.api_name = None
        self.api_revision = None
        self.api_version = None
        self.description = None
        self.method = None
        self.url_template = None


class OperationUpdateContract(msrest.serialization.Model):
    """Api Operation Update Contract details.

    :param template_parameters: Collection of URL template parameters.
    :type template_parameters: list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param description: Description of the operation. May include HTML formatting tags.
    :type description: str
    :param request: An entity containing request details.
    :type request: ~azure.mgmt.apimanagement.models.RequestContract
    :param responses: Array of Operation responses.
    :type responses: list[~azure.mgmt.apimanagement.models.ResponseContract]
    :param policies: Operation Policies.
    :type policies: str
    :param display_name: Operation Name.
    :type display_name: str
    :param method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not
     limited by only them.
    :type method: str
    :param url_template: Relative URL template identifying the target resource for this operation.
     May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :type url_template: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'url_template': {'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'template_parameters': {'key': 'properties.templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'request': {'key': 'properties.request', 'type': 'RequestContract'},
        'responses': {'key': 'properties.responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'properties.policies', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'method': {'key': 'properties.method', 'type': 'str'},
        'url_template': {'key': 'properties.urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationUpdateContract, self).__init__(**kwargs)
        self.template_parameters = kwargs.get('template_parameters', None)
        self.description = kwargs.get('description', None)
        self.request = kwargs.get('request', None)
        self.responses = kwargs.get('responses', None)
        self.policies = kwargs.get('policies', None)
        self.display_name = kwargs.get('display_name', None)
        self.method = kwargs.get('method', None)
        self.url_template = kwargs.get('url_template', None)


class OperationUpdateContractProperties(OperationEntityBaseContract):
    """Operation Update Contract Properties.

    :param template_parameters: Collection of URL template parameters.
    :type template_parameters: list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param description: Description of the operation. May include HTML formatting tags.
    :type description: str
    :param request: An entity containing request details.
    :type request: ~azure.mgmt.apimanagement.models.RequestContract
    :param responses: Array of Operation responses.
    :type responses: list[~azure.mgmt.apimanagement.models.ResponseContract]
    :param policies: Operation Policies.
    :type policies: str
    :param display_name: Operation Name.
    :type display_name: str
    :param method: A Valid HTTP Operation Method. Typical Http Methods like GET, PUT, POST but not
     limited by only them.
    :type method: str
    :param url_template: Relative URL template identifying the target resource for this operation.
     May include parameters. Example: /customers/{cid}/orders/{oid}/?date={date}.
    :type url_template: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
        'url_template': {'max_length': 1000, 'min_length': 1},
    }

    _attribute_map = {
        'template_parameters': {'key': 'templateParameters', 'type': '[ParameterContract]'},
        'description': {'key': 'description', 'type': 'str'},
        'request': {'key': 'request', 'type': 'RequestContract'},
        'responses': {'key': 'responses', 'type': '[ResponseContract]'},
        'policies': {'key': 'policies', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url_template': {'key': 'urlTemplate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationUpdateContractProperties, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.method = kwargs.get('method', None)
        self.url_template = kwargs.get('url_template', None)


class ParameterContract(msrest.serialization.Model):
    """Operation parameters details.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Parameter name.
    :type name: str
    :param description: Parameter description.
    :type description: str
    :param type: Required. Parameter type.
    :type type: str
    :param default_value: Default parameter value.
    :type default_value: str
    :param required: Specifies whether parameter is required or not.
    :type required: bool
    :param values: Parameter values.
    :type values: list[str]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParameterContract, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.type = kwargs['type']
        self.default_value = kwargs.get('default_value', None)
        self.required = kwargs.get('required', None)
        self.values = kwargs.get('values', None)


class PipelineDiagnosticSettings(msrest.serialization.Model):
    """Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.

    :param request: Diagnostic settings for request.
    :type request: ~azure.mgmt.apimanagement.models.HttpMessageDiagnostic
    :param response: Diagnostic settings for response.
    :type response: ~azure.mgmt.apimanagement.models.HttpMessageDiagnostic
    """

    _attribute_map = {
        'request': {'key': 'request', 'type': 'HttpMessageDiagnostic'},
        'response': {'key': 'response', 'type': 'HttpMessageDiagnostic'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PipelineDiagnosticSettings, self).__init__(**kwargs)
        self.request = kwargs.get('request', None)
        self.response = kwargs.get('response', None)


class PolicyCollection(msrest.serialization.Model):
    """The response of the list policy operation.

    :param value: Policy Contract value.
    :type value: list[~azure.mgmt.apimanagement.models.PolicyContract]
    :param count: Total record count number.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PolicyContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class PolicyContract(Resource):
    """Policy Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param value: Contents of the Policy as defined by the format.
    :type value: str
    :param format: Format of the policyContent. Possible values include: "xml", "xml-link",
     "rawxml", "rawxml-link". Default value: "xml".
    :type format: str or ~azure.mgmt.apimanagement.models.PolicyContentFormat
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyContract, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.format = kwargs.get('format', "xml")


class PolicyDescriptionCollection(msrest.serialization.Model):
    """Descriptions of APIM policies.

    :param value: Descriptions of APIM policies.
    :type value: list[~azure.mgmt.apimanagement.models.PolicyDescriptionContract]
    :param count: Total record count number.
    :type count: long
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PolicyDescriptionContract]'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyDescriptionCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)


class PolicyDescriptionContract(Resource):
    """Policy description details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :ivar description: Policy description.
    :vartype description: str
    :ivar scope: Binary OR value of the Snippet scope.
    :vartype scope: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'scope': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyDescriptionContract, self).__init__(**kwargs)
        self.description = None
        self.scope = None


class PortalDelegationSettings(Resource):
    """Delegation settings for a developer portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param url: A delegation Url.
    :type url: str
    :param validation_key: A base64-encoded validation key to validate, that a request is coming
     from Azure API Management.
    :type validation_key: str
    :param subscriptions: Subscriptions delegation settings.
    :type subscriptions: ~azure.mgmt.apimanagement.models.SubscriptionsDelegationSettingsProperties
    :param user_registration: User registration delegation settings.
    :type user_registration:
     ~azure.mgmt.apimanagement.models.RegistrationDelegationSettingsProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'validation_key': {'key': 'properties.validationKey', 'type': 'str'},
        'subscriptions': {'key': 'properties.subscriptions', 'type': 'SubscriptionsDelegationSettingsProperties'},
        'user_registration': {'key': 'properties.userRegistration', 'type': 'RegistrationDelegationSettingsProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PortalDelegationSettings, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)
        self.validation_key = kwargs.get('validation_key', None)
        self.subscriptions = kwargs.get('subscriptions', None)
        self.user_registration = kwargs.get('user_registration', None)


class PortalRevisionCollection(msrest.serialization.Model):
    """Paged list of portal revisions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of portal revisions.
    :vartype value: list[~azure.mgmt.apimanagement.models.PortalRevisionContract]
    :ivar next_link: Next page link, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PortalRevisionContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PortalRevisionCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PortalRevisionContract(Resource):
    """Portal revisions contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Portal revision description.
    :type description: str
    :ivar status_details: Portal revision publishing status details.
    :vartype status_details: str
    :ivar status: Portal revision publishing status. Possible values include: "pending",
     "publishing", "completed", "failed".
    :vartype status: str or ~azure.mgmt.apimanagement.models.PortalRevisionStatus
    :param is_current: Indicates if the Portal Revision is public.
    :type is_current: bool
    :ivar created_date_time: Portal revision creation date and time.
    :vartype created_date_time: ~datetime.datetime
    :ivar updated_date_time: Last updated date and time.
    :vartype updated_date_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 2000, 'min_length': 0},
        'status_details': {'readonly': True, 'max_length': 2000, 'min_length': 0},
        'status': {'readonly': True},
        'created_date_time': {'readonly': True},
        'updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'status_details': {'key': 'properties.statusDetails', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'is_current': {'key': 'properties.isCurrent', 'type': 'bool'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'updated_date_time': {'key': 'properties.updatedDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PortalRevisionContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.status_details = None
        self.status = None
        self.is_current = kwargs.get('is_current', None)
        self.created_date_time = None
        self.updated_date_time = None


class PortalSettingsCollection(msrest.serialization.Model):
    """Descriptions of APIM policies.

    :param value: Descriptions of APIM policies.
    :type value: list[~azure.mgmt.apimanagement.models.PortalSettingsContract]
    :param count: Total record count number.
    :type count: long
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PortalSettingsContract]'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PortalSettingsCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)


class PortalSettingsContract(Resource):
    """Portal Settings for the Developer Portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param url: A delegation Url.
    :type url: str
    :param validation_key: A base64-encoded validation key to validate, that a request is coming
     from Azure API Management.
    :type validation_key: str
    :param subscriptions: Subscriptions delegation settings.
    :type subscriptions: ~azure.mgmt.apimanagement.models.SubscriptionsDelegationSettingsProperties
    :param user_registration: User registration delegation settings.
    :type user_registration:
     ~azure.mgmt.apimanagement.models.RegistrationDelegationSettingsProperties
    :param enabled: Redirect Anonymous users to the Sign-In page.
    :type enabled: bool
    :param terms_of_service: Terms of service contract properties.
    :type terms_of_service: ~azure.mgmt.apimanagement.models.TermsOfServiceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'validation_key': {'key': 'properties.validationKey', 'type': 'str'},
        'subscriptions': {'key': 'properties.subscriptions', 'type': 'SubscriptionsDelegationSettingsProperties'},
        'user_registration': {'key': 'properties.userRegistration', 'type': 'RegistrationDelegationSettingsProperties'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'terms_of_service': {'key': 'properties.termsOfService', 'type': 'TermsOfServiceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PortalSettingsContract, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)
        self.validation_key = kwargs.get('validation_key', None)
        self.subscriptions = kwargs.get('subscriptions', None)
        self.user_registration = kwargs.get('user_registration', None)
        self.enabled = kwargs.get('enabled', None)
        self.terms_of_service = kwargs.get('terms_of_service', None)


class PortalSettingValidationKeyContract(msrest.serialization.Model):
    """Client or app secret used in IdentityProviders, Aad, OpenID or OAuth.

    :param validation_key: This is secret value of the validation key in portal settings.
    :type validation_key: str
    """

    _attribute_map = {
        'validation_key': {'key': 'validationKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PortalSettingValidationKeyContract, self).__init__(**kwargs)
        self.validation_key = kwargs.get('validation_key', None)


class PortalSigninSettings(Resource):
    """Sign-In settings for the Developer Portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param enabled: Redirect Anonymous users to the Sign-In page.
    :type enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PortalSigninSettings, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class PortalSignupSettings(Resource):
    """Sign-Up settings for a developer portal.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param enabled: Allow users to sign up on a developer portal.
    :type enabled: bool
    :param terms_of_service: Terms of service contract properties.
    :type terms_of_service: ~azure.mgmt.apimanagement.models.TermsOfServiceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'terms_of_service': {'key': 'properties.termsOfService', 'type': 'TermsOfServiceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PortalSignupSettings, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.terms_of_service = kwargs.get('terms_of_service', None)


class ProductCollection(msrest.serialization.Model):
    """Paged Products list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.ProductContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProductContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class ProductContract(Resource):
    """Product details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Product description. May include HTML formatting tags.
    :type description: str
    :param terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :type terms: str
    :param subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :type subscription_required: bool
    :param approval_required: whether subscription approval is required. If false, new
     subscriptions will be approved automatically enabling developers to call the product’s APIs
     immediately after subscribing. If true, administrators must manually approve the subscription
     before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
     property is present and has a value of false.
    :type approval_required: bool
    :param subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :type subscriptions_limit: int
    :param state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :type state: str or ~azure.mgmt.apimanagement.models.ProductState
    :param display_name: Product name.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'terms': {'key': 'properties.terms', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'properties.approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'properties.subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.terms = kwargs.get('terms', None)
        self.subscription_required = kwargs.get('subscription_required', None)
        self.approval_required = kwargs.get('approval_required', None)
        self.subscriptions_limit = kwargs.get('subscriptions_limit', None)
        self.state = kwargs.get('state', None)
        self.display_name = kwargs.get('display_name', None)


class ProductEntityBaseParameters(msrest.serialization.Model):
    """Product Entity Base Parameters.

    :param description: Product description. May include HTML formatting tags.
    :type description: str
    :param terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :type terms: str
    :param subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :type subscription_required: bool
    :param approval_required: whether subscription approval is required. If false, new
     subscriptions will be approved automatically enabling developers to call the product’s APIs
     immediately after subscribing. If true, administrators must manually approve the subscription
     before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
     property is present and has a value of false.
    :type approval_required: bool
    :param subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :type subscriptions_limit: int
    :param state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :type state: str or ~azure.mgmt.apimanagement.models.ProductState
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'terms': {'key': 'terms', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductEntityBaseParameters, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.terms = kwargs.get('terms', None)
        self.subscription_required = kwargs.get('subscription_required', None)
        self.approval_required = kwargs.get('approval_required', None)
        self.subscriptions_limit = kwargs.get('subscriptions_limit', None)
        self.state = kwargs.get('state', None)


class ProductContractProperties(ProductEntityBaseParameters):
    """Product profile.

    All required parameters must be populated in order to send to Azure.

    :param description: Product description. May include HTML formatting tags.
    :type description: str
    :param terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :type terms: str
    :param subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :type subscription_required: bool
    :param approval_required: whether subscription approval is required. If false, new
     subscriptions will be approved automatically enabling developers to call the product’s APIs
     immediately after subscribing. If true, administrators must manually approve the subscription
     before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
     property is present and has a value of false.
    :type approval_required: bool
    :param subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :type subscriptions_limit: int
    :param state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :type state: str or ~azure.mgmt.apimanagement.models.ProductState
    :param display_name: Required. Product name.
    :type display_name: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'required': True, 'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'terms': {'key': 'terms', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductContractProperties, self).__init__(**kwargs)
        self.display_name = kwargs['display_name']


class ProductTagResourceContractProperties(ProductEntityBaseParameters):
    """Product profile.

    All required parameters must be populated in order to send to Azure.

    :param description: Product description. May include HTML formatting tags.
    :type description: str
    :param terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :type terms: str
    :param subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :type subscription_required: bool
    :param approval_required: whether subscription approval is required. If false, new
     subscriptions will be approved automatically enabling developers to call the product’s APIs
     immediately after subscribing. If true, administrators must manually approve the subscription
     before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
     property is present and has a value of false.
    :type approval_required: bool
    :param subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :type subscriptions_limit: int
    :param state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :type state: str or ~azure.mgmt.apimanagement.models.ProductState
    :param id: Identifier of the product in the form of /products/{productId}.
    :type id: str
    :param name: Required. Product name.
    :type name: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'name': {'required': True, 'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'terms': {'key': 'terms', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductTagResourceContractProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs['name']


class ProductUpdateParameters(msrest.serialization.Model):
    """Product Update parameters.

    :param description: Product description. May include HTML formatting tags.
    :type description: str
    :param terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :type terms: str
    :param subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :type subscription_required: bool
    :param approval_required: whether subscription approval is required. If false, new
     subscriptions will be approved automatically enabling developers to call the product’s APIs
     immediately after subscribing. If true, administrators must manually approve the subscription
     before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
     property is present and has a value of false.
    :type approval_required: bool
    :param subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :type subscriptions_limit: int
    :param state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :type state: str or ~azure.mgmt.apimanagement.models.ProductState
    :param display_name: Product name.
    :type display_name: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'terms': {'key': 'properties.terms', 'type': 'str'},
        'subscription_required': {'key': 'properties.subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'properties.approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'properties.subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductUpdateParameters, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.terms = kwargs.get('terms', None)
        self.subscription_required = kwargs.get('subscription_required', None)
        self.approval_required = kwargs.get('approval_required', None)
        self.subscriptions_limit = kwargs.get('subscriptions_limit', None)
        self.state = kwargs.get('state', None)
        self.display_name = kwargs.get('display_name', None)


class ProductUpdateProperties(ProductEntityBaseParameters):
    """Parameters supplied to the Update Product operation.

    :param description: Product description. May include HTML formatting tags.
    :type description: str
    :param terms: Product terms of use. Developers trying to subscribe to the product will be
     presented and required to accept these terms before they can complete the subscription process.
    :type terms: str
    :param subscription_required: Whether a product subscription is required for accessing APIs
     included in this product. If true, the product is referred to as "protected" and a valid
     subscription key is required for a request to an API included in the product to succeed. If
     false, the product is referred to as "open" and requests to an API included in the product can
     be made without a subscription key. If property is omitted when creating a new product it's
     value is assumed to be true.
    :type subscription_required: bool
    :param approval_required: whether subscription approval is required. If false, new
     subscriptions will be approved automatically enabling developers to call the product’s APIs
     immediately after subscribing. If true, administrators must manually approve the subscription
     before the developer can any of the product’s APIs. Can be present only if subscriptionRequired
     property is present and has a value of false.
    :type approval_required: bool
    :param subscriptions_limit: Whether the number of subscriptions a user can have to this product
     at the same time. Set to null or omit to allow unlimited per user subscriptions. Can be present
     only if subscriptionRequired property is present and has a value of false.
    :type subscriptions_limit: int
    :param state: whether product is published or not. Published products are discoverable by users
     of developer portal. Non published products are visible only to administrators. Default state
     of Product is notPublished. Possible values include: "notPublished", "published".
    :type state: str or ~azure.mgmt.apimanagement.models.ProductState
    :param display_name: Product name.
    :type display_name: str
    """

    _validation = {
        'description': {'max_length': 1000, 'min_length': 0},
        'display_name': {'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'terms': {'key': 'terms', 'type': 'str'},
        'subscription_required': {'key': 'subscriptionRequired', 'type': 'bool'},
        'approval_required': {'key': 'approvalRequired', 'type': 'bool'},
        'subscriptions_limit': {'key': 'subscriptionsLimit', 'type': 'int'},
        'state': {'key': 'state', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProductUpdateProperties, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)


class QuotaCounterCollection(msrest.serialization.Model):
    """Paged Quota Counter list representation.

    :param value: Quota counter values.
    :type value: list[~azure.mgmt.apimanagement.models.QuotaCounterContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QuotaCounterContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaCounterCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class QuotaCounterContract(msrest.serialization.Model):
    """Quota counter details.

    All required parameters must be populated in order to send to Azure.

    :param counter_key: Required. The Key value of the Counter. Must not be empty.
    :type counter_key: str
    :param period_key: Required. Identifier of the Period for which the counter was collected. Must
     not be empty.
    :type period_key: str
    :param period_start_time: Required. The date of the start of Counter Period. The date conforms
     to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type period_start_time: ~datetime.datetime
    :param period_end_time: Required. The date of the end of Counter Period. The date conforms to
     the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type period_end_time: ~datetime.datetime
    :param value: Quota Value Properties.
    :type value: ~azure.mgmt.apimanagement.models.QuotaCounterValueContractProperties
    """

    _validation = {
        'counter_key': {'required': True, 'min_length': 1},
        'period_key': {'required': True, 'min_length': 1},
        'period_start_time': {'required': True},
        'period_end_time': {'required': True},
    }

    _attribute_map = {
        'counter_key': {'key': 'counterKey', 'type': 'str'},
        'period_key': {'key': 'periodKey', 'type': 'str'},
        'period_start_time': {'key': 'periodStartTime', 'type': 'iso-8601'},
        'period_end_time': {'key': 'periodEndTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'QuotaCounterValueContractProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaCounterContract, self).__init__(**kwargs)
        self.counter_key = kwargs['counter_key']
        self.period_key = kwargs['period_key']
        self.period_start_time = kwargs['period_start_time']
        self.period_end_time = kwargs['period_end_time']
        self.value = kwargs.get('value', None)


class QuotaCounterValueContract(msrest.serialization.Model):
    """Quota counter value details.

    :param calls_count: Number of times Counter was called.
    :type calls_count: int
    :param kb_transferred: Data Transferred in KiloBytes.
    :type kb_transferred: float
    """

    _attribute_map = {
        'calls_count': {'key': 'value.callsCount', 'type': 'int'},
        'kb_transferred': {'key': 'value.kbTransferred', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaCounterValueContract, self).__init__(**kwargs)
        self.calls_count = kwargs.get('calls_count', None)
        self.kb_transferred = kwargs.get('kb_transferred', None)


class QuotaCounterValueContractProperties(msrest.serialization.Model):
    """Quota counter value details.

    :param calls_count: Number of times Counter was called.
    :type calls_count: int
    :param kb_transferred: Data Transferred in KiloBytes.
    :type kb_transferred: float
    """

    _attribute_map = {
        'calls_count': {'key': 'callsCount', 'type': 'int'},
        'kb_transferred': {'key': 'kbTransferred', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaCounterValueContractProperties, self).__init__(**kwargs)
        self.calls_count = kwargs.get('calls_count', None)
        self.kb_transferred = kwargs.get('kb_transferred', None)


class QuotaCounterValueUpdateContract(msrest.serialization.Model):
    """Quota counter value details.

    :param calls_count: Number of times Counter was called.
    :type calls_count: int
    :param kb_transferred: Data Transferred in KiloBytes.
    :type kb_transferred: float
    """

    _attribute_map = {
        'calls_count': {'key': 'properties.callsCount', 'type': 'int'},
        'kb_transferred': {'key': 'properties.kbTransferred', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaCounterValueUpdateContract, self).__init__(**kwargs)
        self.calls_count = kwargs.get('calls_count', None)
        self.kb_transferred = kwargs.get('kb_transferred', None)


class RecipientEmailCollection(msrest.serialization.Model):
    """Paged Recipient User list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.RecipientEmailContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecipientEmailContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecipientEmailCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class RecipientEmailContract(Resource):
    """Recipient Email details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param email: User Email subscribed to notification.
    :type email: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email': {'key': 'properties.email', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecipientEmailContract, self).__init__(**kwargs)
        self.email = kwargs.get('email', None)


class RecipientsContractProperties(msrest.serialization.Model):
    """Notification Parameter contract.

    :param emails: List of Emails subscribed for the notification.
    :type emails: list[str]
    :param users: List of Users subscribed for the notification.
    :type users: list[str]
    """

    _attribute_map = {
        'emails': {'key': 'emails', 'type': '[str]'},
        'users': {'key': 'users', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecipientsContractProperties, self).__init__(**kwargs)
        self.emails = kwargs.get('emails', None)
        self.users = kwargs.get('users', None)


class RecipientUserCollection(msrest.serialization.Model):
    """Paged Recipient User list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.RecipientUserContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecipientUserContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecipientUserCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class RecipientUserContract(Resource):
    """Recipient User details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param user_id: API Management UserId subscribed to notification.
    :type user_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecipientUserContract, self).__init__(**kwargs)
        self.user_id = kwargs.get('user_id', None)


class RegionContract(msrest.serialization.Model):
    """Region profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Region name.
    :vartype name: str
    :param is_master_region: whether Region is the master region.
    :type is_master_region: bool
    :param is_deleted: whether Region is deleted.
    :type is_deleted: bool
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_master_region': {'key': 'isMasterRegion', 'type': 'bool'},
        'is_deleted': {'key': 'isDeleted', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegionContract, self).__init__(**kwargs)
        self.name = None
        self.is_master_region = kwargs.get('is_master_region', None)
        self.is_deleted = kwargs.get('is_deleted', None)


class RegionListResult(msrest.serialization.Model):
    """Lists Regions operation response details.

    :param value: Lists of Regions.
    :type value: list[~azure.mgmt.apimanagement.models.RegionContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RegionContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class RegistrationDelegationSettingsProperties(msrest.serialization.Model):
    """User registration delegation settings properties.

    :param enabled: Enable or disable delegation for user registration.
    :type enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistrationDelegationSettingsProperties, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class ReportCollection(msrest.serialization.Model):
    """Paged Report records list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.ReportRecordContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReportRecordContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReportCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class ReportRecordContract(msrest.serialization.Model):
    """Report data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Name depending on report endpoint specifies product, API, operation or developer
     name.
    :type name: str
    :param timestamp: Start of aggregation period. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type timestamp: ~datetime.datetime
    :param interval: Length of aggregation period.  Interval must be multiple of 15 minutes and may
     not be zero. The value should be in ISO 8601 format
     (http://en.wikipedia.org/wiki/ISO_8601#Durations).
    :type interval: str
    :param country: Country to which this record data is related.
    :type country: str
    :param region: Country region to which this record data is related.
    :type region: str
    :param zip: Zip code to which this record data is related.
    :type zip: str
    :ivar user_id: User identifier path. /users/{userId}.
    :vartype user_id: str
    :ivar product_id: Product identifier path. /products/{productId}.
    :vartype product_id: str
    :param api_id: API identifier path. /apis/{apiId}.
    :type api_id: str
    :param operation_id: Operation identifier path. /apis/{apiId}/operations/{operationId}.
    :type operation_id: str
    :param api_region: API region identifier.
    :type api_region: str
    :param subscription_id: Subscription identifier path. /subscriptions/{subscriptionId}.
    :type subscription_id: str
    :param call_count_success: Number of successful calls. This includes calls returning
     HttpStatusCode <= 301 and HttpStatusCode.NotModified and HttpStatusCode.TemporaryRedirect.
    :type call_count_success: int
    :param call_count_blocked: Number of calls blocked due to invalid credentials. This includes
     calls returning HttpStatusCode.Unauthorized and HttpStatusCode.Forbidden and
     HttpStatusCode.TooManyRequests.
    :type call_count_blocked: int
    :param call_count_failed: Number of calls failed due to proxy or backend errors. This includes
     calls returning HttpStatusCode.BadRequest(400) and any Code between
     HttpStatusCode.InternalServerError (500) and 600.
    :type call_count_failed: int
    :param call_count_other: Number of other calls.
    :type call_count_other: int
    :param call_count_total: Total number of calls.
    :type call_count_total: int
    :param bandwidth: Bandwidth consumed.
    :type bandwidth: long
    :param cache_hit_count: Number of times when content was served from cache policy.
    :type cache_hit_count: int
    :param cache_miss_count: Number of times content was fetched from backend.
    :type cache_miss_count: int
    :param api_time_avg: Average time it took to process request.
    :type api_time_avg: float
    :param api_time_min: Minimum time it took to process request.
    :type api_time_min: float
    :param api_time_max: Maximum time it took to process request.
    :type api_time_max: float
    :param service_time_avg: Average time it took to process request on backend.
    :type service_time_avg: float
    :param service_time_min: Minimum time it took to process request on backend.
    :type service_time_min: float
    :param service_time_max: Maximum time it took to process request on backend.
    :type service_time_max: float
    """

    _validation = {
        'user_id': {'readonly': True},
        'product_id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'interval': {'key': 'interval', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'zip': {'key': 'zip', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
        'product_id': {'key': 'productId', 'type': 'str'},
        'api_id': {'key': 'apiId', 'type': 'str'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'api_region': {'key': 'apiRegion', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'call_count_success': {'key': 'callCountSuccess', 'type': 'int'},
        'call_count_blocked': {'key': 'callCountBlocked', 'type': 'int'},
        'call_count_failed': {'key': 'callCountFailed', 'type': 'int'},
        'call_count_other': {'key': 'callCountOther', 'type': 'int'},
        'call_count_total': {'key': 'callCountTotal', 'type': 'int'},
        'bandwidth': {'key': 'bandwidth', 'type': 'long'},
        'cache_hit_count': {'key': 'cacheHitCount', 'type': 'int'},
        'cache_miss_count': {'key': 'cacheMissCount', 'type': 'int'},
        'api_time_avg': {'key': 'apiTimeAvg', 'type': 'float'},
        'api_time_min': {'key': 'apiTimeMin', 'type': 'float'},
        'api_time_max': {'key': 'apiTimeMax', 'type': 'float'},
        'service_time_avg': {'key': 'serviceTimeAvg', 'type': 'float'},
        'service_time_min': {'key': 'serviceTimeMin', 'type': 'float'},
        'service_time_max': {'key': 'serviceTimeMax', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReportRecordContract, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.interval = kwargs.get('interval', None)
        self.country = kwargs.get('country', None)
        self.region = kwargs.get('region', None)
        self.zip = kwargs.get('zip', None)
        self.user_id = None
        self.product_id = None
        self.api_id = kwargs.get('api_id', None)
        self.operation_id = kwargs.get('operation_id', None)
        self.api_region = kwargs.get('api_region', None)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.call_count_success = kwargs.get('call_count_success', None)
        self.call_count_blocked = kwargs.get('call_count_blocked', None)
        self.call_count_failed = kwargs.get('call_count_failed', None)
        self.call_count_other = kwargs.get('call_count_other', None)
        self.call_count_total = kwargs.get('call_count_total', None)
        self.bandwidth = kwargs.get('bandwidth', None)
        self.cache_hit_count = kwargs.get('cache_hit_count', None)
        self.cache_miss_count = kwargs.get('cache_miss_count', None)
        self.api_time_avg = kwargs.get('api_time_avg', None)
        self.api_time_min = kwargs.get('api_time_min', None)
        self.api_time_max = kwargs.get('api_time_max', None)
        self.service_time_avg = kwargs.get('service_time_avg', None)
        self.service_time_min = kwargs.get('service_time_min', None)
        self.service_time_max = kwargs.get('service_time_max', None)


class RepresentationContract(msrest.serialization.Model):
    """Operation request/response representation details.

    All required parameters must be populated in order to send to Azure.

    :param content_type: Required. Specifies a registered or custom content type for this
     representation, e.g. application/xml.
    :type content_type: str
    :param sample: An example of the representation.
    :type sample: str
    :param schema_id: Schema identifier. Applicable only if 'contentType' value is neither
     'application/x-www-form-urlencoded' nor 'multipart/form-data'.
    :type schema_id: str
    :param type_name: Type name defined by the schema. Applicable only if 'contentType' value is
     neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
    :type type_name: str
    :param form_parameters: Collection of form parameters. Required if 'contentType' value is
     either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
    :type form_parameters: list[~azure.mgmt.apimanagement.models.ParameterContract]
    """

    _validation = {
        'content_type': {'required': True},
    }

    _attribute_map = {
        'content_type': {'key': 'contentType', 'type': 'str'},
        'sample': {'key': 'sample', 'type': 'str'},
        'schema_id': {'key': 'schemaId', 'type': 'str'},
        'type_name': {'key': 'typeName', 'type': 'str'},
        'form_parameters': {'key': 'formParameters', 'type': '[ParameterContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RepresentationContract, self).__init__(**kwargs)
        self.content_type = kwargs['content_type']
        self.sample = kwargs.get('sample', None)
        self.schema_id = kwargs.get('schema_id', None)
        self.type_name = kwargs.get('type_name', None)
        self.form_parameters = kwargs.get('form_parameters', None)


class RequestContract(msrest.serialization.Model):
    """Operation request details.

    :param description: Operation request description.
    :type description: str
    :param query_parameters: Collection of operation request query parameters.
    :type query_parameters: list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param headers: Collection of operation request headers.
    :type headers: list[~azure.mgmt.apimanagement.models.ParameterContract]
    :param representations: Collection of operation request representations.
    :type representations: list[~azure.mgmt.apimanagement.models.RepresentationContract]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'query_parameters': {'key': 'queryParameters', 'type': '[ParameterContract]'},
        'headers': {'key': 'headers', 'type': '[ParameterContract]'},
        'representations': {'key': 'representations', 'type': '[RepresentationContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequestContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.query_parameters = kwargs.get('query_parameters', None)
        self.headers = kwargs.get('headers', None)
        self.representations = kwargs.get('representations', None)


class RequestReportCollection(msrest.serialization.Model):
    """Paged Report records list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.RequestReportRecordContract]
    :param count: Total record count number across all pages.
    :type count: long
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RequestReportRecordContract]'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequestReportCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)


class RequestReportRecordContract(msrest.serialization.Model):
    """Request Report data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param api_id: API identifier path. /apis/{apiId}.
    :type api_id: str
    :param operation_id: Operation identifier path. /apis/{apiId}/operations/{operationId}.
    :type operation_id: str
    :ivar product_id: Product identifier path. /products/{productId}.
    :vartype product_id: str
    :ivar user_id: User identifier path. /users/{userId}.
    :vartype user_id: str
    :param method: The HTTP method associated with this request..
    :type method: str
    :param url: The full URL associated with this request.
    :type url: str
    :param ip_address: The client IP address associated with this request.
    :type ip_address: str
    :param backend_response_code: The HTTP status code received by the gateway as a result of
     forwarding this request to the backend.
    :type backend_response_code: str
    :param response_code: The HTTP status code returned by the gateway.
    :type response_code: int
    :param response_size: The size of the response returned by the gateway.
    :type response_size: int
    :param timestamp: The date and time when this request was received by the gateway in ISO 8601
     format.
    :type timestamp: ~datetime.datetime
    :param cache: Specifies if response cache was involved in generating the response. If the value
     is none, the cache was not used. If the value is hit, cached response was returned. If the
     value is miss, the cache was used but lookup resulted in a miss and request was fulfilled by
     the backend.
    :type cache: str
    :param api_time: The total time it took to process this request.
    :type api_time: float
    :param service_time: he time it took to forward this request to the backend and get the
     response back.
    :type service_time: float
    :param api_region: Azure region where the gateway that processed this request is located.
    :type api_region: str
    :param subscription_id: Subscription identifier path. /subscriptions/{subscriptionId}.
    :type subscription_id: str
    :param request_id: Request Identifier.
    :type request_id: str
    :param request_size: The size of this request..
    :type request_size: int
    """

    _validation = {
        'product_id': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'api_id': {'key': 'apiId', 'type': 'str'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'product_id': {'key': 'productId', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'backend_response_code': {'key': 'backendResponseCode', 'type': 'str'},
        'response_code': {'key': 'responseCode', 'type': 'int'},
        'response_size': {'key': 'responseSize', 'type': 'int'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'cache': {'key': 'cache', 'type': 'str'},
        'api_time': {'key': 'apiTime', 'type': 'float'},
        'service_time': {'key': 'serviceTime', 'type': 'float'},
        'api_region': {'key': 'apiRegion', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'request_size': {'key': 'requestSize', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequestReportRecordContract, self).__init__(**kwargs)
        self.api_id = kwargs.get('api_id', None)
        self.operation_id = kwargs.get('operation_id', None)
        self.product_id = None
        self.user_id = None
        self.method = kwargs.get('method', None)
        self.url = kwargs.get('url', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.backend_response_code = kwargs.get('backend_response_code', None)
        self.response_code = kwargs.get('response_code', None)
        self.response_size = kwargs.get('response_size', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.cache = kwargs.get('cache', None)
        self.api_time = kwargs.get('api_time', None)
        self.service_time = kwargs.get('service_time', None)
        self.api_region = kwargs.get('api_region', None)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.request_id = kwargs.get('request_id', None)
        self.request_size = kwargs.get('request_size', None)


class ResourceLocationDataContract(msrest.serialization.Model):
    """Resource location data properties.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A canonical name for the geographic or physical location.
    :type name: str
    :param city: The city or locality where the resource is located.
    :type city: str
    :param district: The district, state, or province where the resource is located.
    :type district: str
    :param country_or_region: The country or region where the resource is located.
    :type country_or_region: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 256, 'min_length': 0},
        'city': {'max_length': 256, 'min_length': 0},
        'district': {'max_length': 256, 'min_length': 0},
        'country_or_region': {'max_length': 256, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'district': {'key': 'district', 'type': 'str'},
        'country_or_region': {'key': 'countryOrRegion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceLocationDataContract, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.city = kwargs.get('city', None)
        self.district = kwargs.get('district', None)
        self.country_or_region = kwargs.get('country_or_region', None)


class ResourceSku(msrest.serialization.Model):
    """Describes an available API Management SKU.

    :param name: Name of the Sku. Possible values include: "Developer", "Standard", "Premium",
     "Basic", "Consumption", "Isolated".
    :type name: str or ~azure.mgmt.apimanagement.models.SkuType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class ResourceSkuCapacity(msrest.serialization.Model):
    """Describes scaling information of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: int
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: int
    :ivar default: The default capacity.
    :vartype default: int
    :ivar scale_type: The scale type applicable to the sku. Possible values include: "automatic",
     "manual", "none".
    :vartype scale_type: str or ~azure.mgmt.apimanagement.models.ResourceSkuCapacityScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class ResourceSkuResult(msrest.serialization.Model):
    """Describes an available API Management service SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar sku: Specifies API Management SKU.
    :vartype sku: ~azure.mgmt.apimanagement.models.ResourceSku
    :ivar capacity: Specifies the number of API Management units.
    :vartype capacity: ~azure.mgmt.apimanagement.models.ResourceSkuCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'readonly': True},
        'capacity': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'capacity': {'key': 'capacity', 'type': 'ResourceSkuCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuResult, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class ResourceSkuResults(msrest.serialization.Model):
    """The API Management service SKUs operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of skus available for the service.
    :type value: list[~azure.mgmt.apimanagement.models.ResourceSkuResult]
    :param next_link: The uri to fetch the next page of API Management service Skus.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceSkuResult]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuResults, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class ResponseContract(msrest.serialization.Model):
    """Operation response details.

    All required parameters must be populated in order to send to Azure.

    :param status_code: Required. Operation response HTTP status code.
    :type status_code: int
    :param description: Operation response description.
    :type description: str
    :param representations: Collection of operation response representations.
    :type representations: list[~azure.mgmt.apimanagement.models.RepresentationContract]
    :param headers: Collection of operation response headers.
    :type headers: list[~azure.mgmt.apimanagement.models.ParameterContract]
    """

    _validation = {
        'status_code': {'required': True},
    }

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'description': {'key': 'description', 'type': 'str'},
        'representations': {'key': 'representations', 'type': '[RepresentationContract]'},
        'headers': {'key': 'headers', 'type': '[ParameterContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseContract, self).__init__(**kwargs)
        self.status_code = kwargs['status_code']
        self.description = kwargs.get('description', None)
        self.representations = kwargs.get('representations', None)
        self.headers = kwargs.get('headers', None)


class SamplingSettings(msrest.serialization.Model):
    """Sampling settings for Diagnostic.

    :param sampling_type: Sampling type. Possible values include: "fixed".
    :type sampling_type: str or ~azure.mgmt.apimanagement.models.SamplingType
    :param percentage: Rate of sampling for fixed-rate sampling.
    :type percentage: float
    """

    _validation = {
        'percentage': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'sampling_type': {'key': 'samplingType', 'type': 'str'},
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SamplingSettings, self).__init__(**kwargs)
        self.sampling_type = kwargs.get('sampling_type', None)
        self.percentage = kwargs.get('percentage', None)


class SaveConfigurationParameter(msrest.serialization.Model):
    """Save Tenant Configuration Contract details.

    :param branch: The name of the Git branch in which to commit the current configuration
     snapshot.
    :type branch: str
    :param force: The value if true, the current configuration database is committed to the Git
     repository, even if the Git repository has newer changes that would be overwritten.
    :type force: bool
    """

    _attribute_map = {
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'force': {'key': 'properties.force', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SaveConfigurationParameter, self).__init__(**kwargs)
        self.branch = kwargs.get('branch', None)
        self.force = kwargs.get('force', None)


class SchemaCollection(msrest.serialization.Model):
    """The response of the list schema operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Api Schema Contract value.
    :vartype value: list[~azure.mgmt.apimanagement.models.SchemaContract]
    :param count: Total record count number.
    :type count: long
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SchemaContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SchemaCollection, self).__init__(**kwargs)
        self.value = None
        self.count = kwargs.get('count', None)
        self.next_link = None


class SchemaContract(Resource):
    """Schema Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param content_type: Must be a valid a media type used in a Content-Type header as defined in
     the RFC 2616. Media type of the schema document (e.g. application/json, application/xml). </br>
     - ``Swagger`` Schema use ``application/vnd.ms-azure-apim.swagger.definitions+json`` </br> -
     ``WSDL`` Schema use ``application/vnd.ms-azure-apim.xsd+xml`` </br> - ``OpenApi`` Schema use
     ``application/vnd.oai.openapi.components+json`` </br> - ``WADL Schema`` use
     ``application/vnd.ms-azure-apim.wadl.grammars+xml``.
    :type content_type: str
    :param value: Json escaped string defining the document representing the Schema. Used for
     schemas other than Swagger/OpenAPI.
    :type value: str
    :param definitions: Types definitions. Used for Swagger/OpenAPI schemas only, null otherwise.
    :type definitions: any
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'content_type': {'key': 'properties.contentType', 'type': 'str'},
        'value': {'key': 'properties.document.value', 'type': 'str'},
        'definitions': {'key': 'properties.document.definitions', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SchemaContract, self).__init__(**kwargs)
        self.content_type = kwargs.get('content_type', None)
        self.value = kwargs.get('value', None)
        self.definitions = kwargs.get('definitions', None)


class SubscriptionCollection(msrest.serialization.Model):
    """Paged Subscriptions list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.SubscriptionContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubscriptionContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class SubscriptionContract(Resource):
    """Subscription details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param owner_id: The user resource identifier of the subscription owner. The value is a valid
     relative URL in the format of /users/{userId} where {userId} is a user identifier.
    :type owner_id: str
    :param scope: Scope like /products/{productId} or /apis or /apis/{apiId}.
    :type scope: str
    :param display_name: The name of the subscription, or null if the subscription has no name.
    :type display_name: str
    :param state: Subscription state. Possible states are * active – the subscription is active, *
     suspended – the subscription is blocked, and the subscriber cannot call any APIs of the
     product, * submitted – the subscription request has been made by the developer, but has not yet
     been approved or rejected, * rejected – the subscription request has been denied by an
     administrator, * cancelled – the subscription has been cancelled by the developer or
     administrator, * expired – the subscription reached its expiration date and was deactivated.
     Possible values include: "suspended", "active", "expired", "submitted", "rejected",
     "cancelled".
    :type state: str or ~azure.mgmt.apimanagement.models.SubscriptionState
    :ivar created_date: Subscription creation date. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :vartype created_date: ~datetime.datetime
    :param start_date: Subscription activation date. The setting is for audit purposes only and the
     subscription is not automatically activated. The subscription lifecycle can be managed by using
     the ``state`` property. The date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as
     specified by the ISO 8601 standard.
    :type start_date: ~datetime.datetime
    :param expiration_date: Subscription expiration date. The setting is for audit purposes only
     and the subscription is not automatically expired. The subscription lifecycle can be managed by
     using the ``state`` property. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type expiration_date: ~datetime.datetime
    :param end_date: Date when subscription was cancelled or expired. The setting is for audit
     purposes only and the subscription is not automatically cancelled. The subscription lifecycle
     can be managed by using the ``state`` property. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type end_date: ~datetime.datetime
    :param notification_date: Upcoming subscription expiration notification date. The date conforms
     to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type notification_date: ~datetime.datetime
    :param primary_key: Subscription primary key. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :type primary_key: str
    :param secondary_key: Subscription secondary key. This property will not be filled on 'GET'
     operations! Use '/listSecrets' POST request to get the value.
    :type secondary_key: str
    :param state_comment: Optional subscription comment added by an administrator when the state is
     changed to the 'rejected'.
    :type state_comment: str
    :param allow_tracing: Determines whether tracing is enabled.
    :type allow_tracing: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 100, 'min_length': 0},
        'created_date': {'readonly': True},
        'primary_key': {'max_length': 256, 'min_length': 1},
        'secondary_key': {'max_length': 256, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'owner_id': {'key': 'properties.ownerId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'start_date': {'key': 'properties.startDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'end_date': {'key': 'properties.endDate', 'type': 'iso-8601'},
        'notification_date': {'key': 'properties.notificationDate', 'type': 'iso-8601'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'state_comment': {'key': 'properties.stateComment', 'type': 'str'},
        'allow_tracing': {'key': 'properties.allowTracing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionContract, self).__init__(**kwargs)
        self.owner_id = kwargs.get('owner_id', None)
        self.scope = kwargs.get('scope', None)
        self.display_name = kwargs.get('display_name', None)
        self.state = kwargs.get('state', None)
        self.created_date = None
        self.start_date = kwargs.get('start_date', None)
        self.expiration_date = kwargs.get('expiration_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.notification_date = kwargs.get('notification_date', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.state_comment = kwargs.get('state_comment', None)
        self.allow_tracing = kwargs.get('allow_tracing', None)


class SubscriptionCreateParameters(msrest.serialization.Model):
    """Subscription create details.

    :param owner_id: User (user id path) for whom subscription is being created in form
     /users/{userId}.
    :type owner_id: str
    :param scope: Scope like /products/{productId} or /apis or /apis/{apiId}.
    :type scope: str
    :param display_name: Subscription name.
    :type display_name: str
    :param primary_key: Primary subscription key. If not specified during request key will be
     generated automatically.
    :type primary_key: str
    :param secondary_key: Secondary subscription key. If not specified during request key will be
     generated automatically.
    :type secondary_key: str
    :param state: Initial subscription state. If no value is specified, subscription is created
     with Submitted state. Possible states are * active – the subscription is active, * suspended –
     the subscription is blocked, and the subscriber cannot call any APIs of the product, *
     submitted – the subscription request has been made by the developer, but has not yet been
     approved or rejected, * rejected – the subscription request has been denied by an
     administrator, * cancelled – the subscription has been cancelled by the developer or
     administrator, * expired – the subscription reached its expiration date and was deactivated.
     Possible values include: "suspended", "active", "expired", "submitted", "rejected",
     "cancelled".
    :type state: str or ~azure.mgmt.apimanagement.models.SubscriptionState
    :param allow_tracing: Determines whether tracing can be enabled.
    :type allow_tracing: bool
    """

    _validation = {
        'display_name': {'max_length': 100, 'min_length': 1},
        'primary_key': {'max_length': 256, 'min_length': 1},
        'secondary_key': {'max_length': 256, 'min_length': 1},
    }

    _attribute_map = {
        'owner_id': {'key': 'properties.ownerId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'allow_tracing': {'key': 'properties.allowTracing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionCreateParameters, self).__init__(**kwargs)
        self.owner_id = kwargs.get('owner_id', None)
        self.scope = kwargs.get('scope', None)
        self.display_name = kwargs.get('display_name', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.state = kwargs.get('state', None)
        self.allow_tracing = kwargs.get('allow_tracing', None)


class SubscriptionKeyParameterNamesContract(msrest.serialization.Model):
    """Subscription key parameter names details.

    :param header: Subscription key header name.
    :type header: str
    :param query: Subscription key query string parameter name.
    :type query: str
    """

    _attribute_map = {
        'header': {'key': 'header', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionKeyParameterNamesContract, self).__init__(**kwargs)
        self.header = kwargs.get('header', None)
        self.query = kwargs.get('query', None)


class SubscriptionKeysContract(msrest.serialization.Model):
    """Subscription keys.

    :param primary_key: Subscription primary key.
    :type primary_key: str
    :param secondary_key: Subscription secondary key.
    :type secondary_key: str
    """

    _validation = {
        'primary_key': {'max_length': 256, 'min_length': 1},
        'secondary_key': {'max_length': 256, 'min_length': 1},
    }

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionKeysContract, self).__init__(**kwargs)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)


class SubscriptionsDelegationSettingsProperties(msrest.serialization.Model):
    """Subscriptions delegation settings properties.

    :param enabled: Enable or disable delegation for subscriptions.
    :type enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionsDelegationSettingsProperties, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class SubscriptionUpdateParameters(msrest.serialization.Model):
    """Subscription update details.

    :param owner_id: User identifier path: /users/{userId}.
    :type owner_id: str
    :param scope: Scope like /products/{productId} or /apis or /apis/{apiId}.
    :type scope: str
    :param expiration_date: Subscription expiration date. The setting is for audit purposes only
     and the subscription is not automatically expired. The subscription lifecycle can be managed by
     using the ``state`` property. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type expiration_date: ~datetime.datetime
    :param display_name: Subscription name.
    :type display_name: str
    :param primary_key: Primary subscription key.
    :type primary_key: str
    :param secondary_key: Secondary subscription key.
    :type secondary_key: str
    :param state: Subscription state. Possible states are * active – the subscription is active, *
     suspended – the subscription is blocked, and the subscriber cannot call any APIs of the
     product, * submitted – the subscription request has been made by the developer, but has not yet
     been approved or rejected, * rejected – the subscription request has been denied by an
     administrator, * cancelled – the subscription has been cancelled by the developer or
     administrator, * expired – the subscription reached its expiration date and was deactivated.
     Possible values include: "suspended", "active", "expired", "submitted", "rejected",
     "cancelled".
    :type state: str or ~azure.mgmt.apimanagement.models.SubscriptionState
    :param state_comment: Comments describing subscription state change by the administrator when
     the state is changed to the 'rejected'.
    :type state_comment: str
    :param allow_tracing: Determines whether tracing can be enabled.
    :type allow_tracing: bool
    """

    _validation = {
        'primary_key': {'max_length': 256, 'min_length': 1},
        'secondary_key': {'max_length': 256, 'min_length': 1},
    }

    _attribute_map = {
        'owner_id': {'key': 'properties.ownerId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'primary_key': {'key': 'properties.primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'properties.secondaryKey', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'state_comment': {'key': 'properties.stateComment', 'type': 'str'},
        'allow_tracing': {'key': 'properties.allowTracing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionUpdateParameters, self).__init__(**kwargs)
        self.owner_id = kwargs.get('owner_id', None)
        self.scope = kwargs.get('scope', None)
        self.expiration_date = kwargs.get('expiration_date', None)
        self.display_name = kwargs.get('display_name', None)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.state = kwargs.get('state', None)
        self.state_comment = kwargs.get('state_comment', None)
        self.allow_tracing = kwargs.get('allow_tracing', None)


class TagCollection(msrest.serialization.Model):
    """Paged Tag list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.TagContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TagContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class TagContract(Resource):
    """Tag Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param display_name: Tag name.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagContract, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)


class TagCreateUpdateParameters(msrest.serialization.Model):
    """Parameters supplied to Create/Update Tag operations.

    :param display_name: Tag name.
    :type display_name: str
    """

    _validation = {
        'display_name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagCreateUpdateParameters, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)


class TagDescriptionBaseProperties(msrest.serialization.Model):
    """Parameters supplied to the Create TagDescription operation.

    :param description: Description of the Tag.
    :type description: str
    :param external_docs_url: Absolute URL of external resources describing the tag.
    :type external_docs_url: str
    :param external_docs_description: Description of the external resources describing the tag.
    :type external_docs_description: str
    """

    _validation = {
        'external_docs_url': {'max_length': 2000, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'external_docs_url': {'key': 'externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'externalDocsDescription', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagDescriptionBaseProperties, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.external_docs_url = kwargs.get('external_docs_url', None)
        self.external_docs_description = kwargs.get('external_docs_description', None)


class TagDescriptionCollection(msrest.serialization.Model):
    """Paged TagDescription list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.TagDescriptionContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TagDescriptionContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagDescriptionCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class TagDescriptionContract(Resource):
    """Contract details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param description: Description of the Tag.
    :type description: str
    :param external_docs_url: Absolute URL of external resources describing the tag.
    :type external_docs_url: str
    :param external_docs_description: Description of the external resources describing the tag.
    :type external_docs_description: str
    :param tag_id: Identifier of the tag in the form of /tags/{tagId}.
    :type tag_id: str
    :param display_name: Tag name.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'external_docs_url': {'max_length': 2000, 'min_length': 0},
        'display_name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_docs_url': {'key': 'properties.externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'properties.externalDocsDescription', 'type': 'str'},
        'tag_id': {'key': 'properties.tagId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagDescriptionContract, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.external_docs_url = kwargs.get('external_docs_url', None)
        self.external_docs_description = kwargs.get('external_docs_description', None)
        self.tag_id = kwargs.get('tag_id', None)
        self.display_name = kwargs.get('display_name', None)


class TagDescriptionContractProperties(TagDescriptionBaseProperties):
    """TagDescription contract Properties.

    :param description: Description of the Tag.
    :type description: str
    :param external_docs_url: Absolute URL of external resources describing the tag.
    :type external_docs_url: str
    :param external_docs_description: Description of the external resources describing the tag.
    :type external_docs_description: str
    :param tag_id: Identifier of the tag in the form of /tags/{tagId}.
    :type tag_id: str
    :param display_name: Tag name.
    :type display_name: str
    """

    _validation = {
        'external_docs_url': {'max_length': 2000, 'min_length': 0},
        'display_name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'external_docs_url': {'key': 'externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'externalDocsDescription', 'type': 'str'},
        'tag_id': {'key': 'tagId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagDescriptionContractProperties, self).__init__(**kwargs)
        self.tag_id = kwargs.get('tag_id', None)
        self.display_name = kwargs.get('display_name', None)


class TagDescriptionCreateParameters(msrest.serialization.Model):
    """Parameters supplied to the Create TagDescription operation.

    :param description: Description of the Tag.
    :type description: str
    :param external_docs_url: Absolute URL of external resources describing the tag.
    :type external_docs_url: str
    :param external_docs_description: Description of the external resources describing the tag.
    :type external_docs_description: str
    """

    _validation = {
        'external_docs_url': {'max_length': 2000, 'min_length': 0},
    }

    _attribute_map = {
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_docs_url': {'key': 'properties.externalDocsUrl', 'type': 'str'},
        'external_docs_description': {'key': 'properties.externalDocsDescription', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagDescriptionCreateParameters, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.external_docs_url = kwargs.get('external_docs_url', None)
        self.external_docs_description = kwargs.get('external_docs_description', None)


class TagResourceCollection(msrest.serialization.Model):
    """Paged Tag list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.TagResourceContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TagResourceContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class TagResourceContract(msrest.serialization.Model):
    """TagResource contract properties.

    All required parameters must be populated in order to send to Azure.

    :param tag: Required. Tag associated with the resource.
    :type tag: ~azure.mgmt.apimanagement.models.TagResourceContractProperties
    :param api: Api associated with the tag.
    :type api: ~azure.mgmt.apimanagement.models.ApiTagResourceContractProperties
    :param operation: Operation associated with the tag.
    :type operation: ~azure.mgmt.apimanagement.models.OperationTagResourceContractProperties
    :param product: Product associated with the tag.
    :type product: ~azure.mgmt.apimanagement.models.ProductTagResourceContractProperties
    """

    _validation = {
        'tag': {'required': True},
    }

    _attribute_map = {
        'tag': {'key': 'tag', 'type': 'TagResourceContractProperties'},
        'api': {'key': 'api', 'type': 'ApiTagResourceContractProperties'},
        'operation': {'key': 'operation', 'type': 'OperationTagResourceContractProperties'},
        'product': {'key': 'product', 'type': 'ProductTagResourceContractProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagResourceContract, self).__init__(**kwargs)
        self.tag = kwargs['tag']
        self.api = kwargs.get('api', None)
        self.operation = kwargs.get('operation', None)
        self.product = kwargs.get('product', None)


class TagResourceContractProperties(msrest.serialization.Model):
    """Contract defining the Tag property in the Tag Resource Contract.

    :param id: Tag identifier.
    :type id: str
    :param name: Tag Name.
    :type name: str
    """

    _validation = {
        'name': {'max_length': 160, 'min_length': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagResourceContractProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)


class TenantConfigurationSyncStateContract(msrest.serialization.Model):
    """Result of Tenant Configuration Sync State.

    :param branch: The name of Git branch.
    :type branch: str
    :param commit_id: The latest commit Id.
    :type commit_id: str
    :param is_export: value indicating if last sync was save (true) or deploy (false) operation.
    :type is_export: bool
    :param is_synced: value indicating if last synchronization was later than the configuration
     change.
    :type is_synced: bool
    :param is_git_enabled: value indicating whether Git configuration access is enabled.
    :type is_git_enabled: bool
    :param sync_date: The date of the latest synchronization. The date conforms to the following
     format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type sync_date: ~datetime.datetime
    :param configuration_change_date: The date of the latest configuration change. The date
     conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601
     standard.
    :type configuration_change_date: ~datetime.datetime
    :param last_operation_id: Most recent tenant configuration operation identifier.
    :type last_operation_id: str
    """

    _attribute_map = {
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'commit_id': {'key': 'properties.commitId', 'type': 'str'},
        'is_export': {'key': 'properties.isExport', 'type': 'bool'},
        'is_synced': {'key': 'properties.isSynced', 'type': 'bool'},
        'is_git_enabled': {'key': 'properties.isGitEnabled', 'type': 'bool'},
        'sync_date': {'key': 'properties.syncDate', 'type': 'iso-8601'},
        'configuration_change_date': {'key': 'properties.configurationChangeDate', 'type': 'iso-8601'},
        'last_operation_id': {'key': 'properties.lastOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TenantConfigurationSyncStateContract, self).__init__(**kwargs)
        self.branch = kwargs.get('branch', None)
        self.commit_id = kwargs.get('commit_id', None)
        self.is_export = kwargs.get('is_export', None)
        self.is_synced = kwargs.get('is_synced', None)
        self.is_git_enabled = kwargs.get('is_git_enabled', None)
        self.sync_date = kwargs.get('sync_date', None)
        self.configuration_change_date = kwargs.get('configuration_change_date', None)
        self.last_operation_id = kwargs.get('last_operation_id', None)


class TenantSettingsCollection(msrest.serialization.Model):
    """Paged AccessInformation list representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Page values.
    :vartype value: list[~azure.mgmt.apimanagement.models.TenantSettingsContract]
    :ivar next_link: Next page link if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TenantSettingsContract]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TenantSettingsCollection, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class TenantSettingsContract(Resource):
    """Tenant Settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param settings: Tenant settings.
    :type settings: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'settings': {'key': 'properties.settings', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TenantSettingsContract, self).__init__(**kwargs)
        self.settings = kwargs.get('settings', None)


class TermsOfServiceProperties(msrest.serialization.Model):
    """Terms of service contract properties.

    :param text: A terms of service text.
    :type text: str
    :param enabled: Display terms of service during a sign-up process.
    :type enabled: bool
    :param consent_required: Ask user for consent to the terms of service.
    :type consent_required: bool
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'consent_required': {'key': 'consentRequired', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TermsOfServiceProperties, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.enabled = kwargs.get('enabled', None)
        self.consent_required = kwargs.get('consent_required', None)


class TokenBodyParameterContract(msrest.serialization.Model):
    """OAuth acquire token request body parameter (www-url-form-encoded).

    All required parameters must be populated in order to send to Azure.

    :param name: Required. body parameter name.
    :type name: str
    :param value: Required. body parameter value.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenBodyParameterContract, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.value = kwargs['value']


class UserCollection(msrest.serialization.Model):
    """Paged Users list representation.

    :param value: Page values.
    :type value: list[~azure.mgmt.apimanagement.models.UserContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UserContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class UserContract(Resource):
    """User details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :type state: str or ~azure.mgmt.apimanagement.models.UserState
    :param note: Optional note about a user set by the administrator.
    :type note: str
    :param identities: Collection of user identities.
    :type identities: list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    :param first_name: First name.
    :type first_name: str
    :param last_name: Last name.
    :type last_name: str
    :param email: Email address.
    :type email: str
    :param registration_date: Date of user registration. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type registration_date: ~datetime.datetime
    :ivar groups: Collection of groups user is part of.
    :vartype groups: list[~azure.mgmt.apimanagement.models.GroupContractProperties]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'groups': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'note': {'key': 'properties.note', 'type': 'str'},
        'identities': {'key': 'properties.identities', 'type': '[UserIdentityContract]'},
        'first_name': {'key': 'properties.firstName', 'type': 'str'},
        'last_name': {'key': 'properties.lastName', 'type': 'str'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'registration_date': {'key': 'properties.registrationDate', 'type': 'iso-8601'},
        'groups': {'key': 'properties.groups', 'type': '[GroupContractProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserContract, self).__init__(**kwargs)
        self.state = kwargs.get('state', "active")
        self.note = kwargs.get('note', None)
        self.identities = kwargs.get('identities', None)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)
        self.email = kwargs.get('email', None)
        self.registration_date = kwargs.get('registration_date', None)
        self.groups = None


class UserEntityBaseParameters(msrest.serialization.Model):
    """User Entity Base Parameters set.

    :param state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :type state: str or ~azure.mgmt.apimanagement.models.UserState
    :param note: Optional note about a user set by the administrator.
    :type note: str
    :param identities: Collection of user identities.
    :type identities: list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'note': {'key': 'note', 'type': 'str'},
        'identities': {'key': 'identities', 'type': '[UserIdentityContract]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserEntityBaseParameters, self).__init__(**kwargs)
        self.state = kwargs.get('state', "active")
        self.note = kwargs.get('note', None)
        self.identities = kwargs.get('identities', None)


class UserContractProperties(UserEntityBaseParameters):
    """User profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :type state: str or ~azure.mgmt.apimanagement.models.UserState
    :param note: Optional note about a user set by the administrator.
    :type note: str
    :param identities: Collection of user identities.
    :type identities: list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    :param first_name: First name.
    :type first_name: str
    :param last_name: Last name.
    :type last_name: str
    :param email: Email address.
    :type email: str
    :param registration_date: Date of user registration. The date conforms to the following format:
     ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601 standard.
    :type registration_date: ~datetime.datetime
    :ivar groups: Collection of groups user is part of.
    :vartype groups: list[~azure.mgmt.apimanagement.models.GroupContractProperties]
    """

    _validation = {
        'groups': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'note': {'key': 'note', 'type': 'str'},
        'identities': {'key': 'identities', 'type': '[UserIdentityContract]'},
        'first_name': {'key': 'firstName', 'type': 'str'},
        'last_name': {'key': 'lastName', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'registration_date': {'key': 'registrationDate', 'type': 'iso-8601'},
        'groups': {'key': 'groups', 'type': '[GroupContractProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserContractProperties, self).__init__(**kwargs)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)
        self.email = kwargs.get('email', None)
        self.registration_date = kwargs.get('registration_date', None)
        self.groups = None


class UserCreateParameterProperties(UserEntityBaseParameters):
    """Parameters supplied to the Create User operation.

    All required parameters must be populated in order to send to Azure.

    :param state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :type state: str or ~azure.mgmt.apimanagement.models.UserState
    :param note: Optional note about a user set by the administrator.
    :type note: str
    :param identities: Collection of user identities.
    :type identities: list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    :param email: Required. Email address. Must not be empty and must be unique within the service
     instance.
    :type email: str
    :param first_name: Required. First name.
    :type first_name: str
    :param last_name: Required. Last name.
    :type last_name: str
    :param password: User Password. If no value is provided, a default password is generated.
    :type password: str
    :param app_type: Determines the type of application which send the create user request. Default
     is legacy portal. Possible values include: "portal", "developerPortal".
    :type app_type: str or ~azure.mgmt.apimanagement.models.AppType
    :param confirmation: Determines the type of confirmation e-mail that will be sent to the newly
     created user. Possible values include: "signup", "invite".
    :type confirmation: str or ~azure.mgmt.apimanagement.models.Confirmation
    """

    _validation = {
        'email': {'required': True, 'max_length': 254, 'min_length': 1},
        'first_name': {'required': True, 'max_length': 100, 'min_length': 1},
        'last_name': {'required': True, 'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'note': {'key': 'note', 'type': 'str'},
        'identities': {'key': 'identities', 'type': '[UserIdentityContract]'},
        'email': {'key': 'email', 'type': 'str'},
        'first_name': {'key': 'firstName', 'type': 'str'},
        'last_name': {'key': 'lastName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'app_type': {'key': 'appType', 'type': 'str'},
        'confirmation': {'key': 'confirmation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserCreateParameterProperties, self).__init__(**kwargs)
        self.email = kwargs['email']
        self.first_name = kwargs['first_name']
        self.last_name = kwargs['last_name']
        self.password = kwargs.get('password', None)
        self.app_type = kwargs.get('app_type', None)
        self.confirmation = kwargs.get('confirmation', None)


class UserCreateParameters(msrest.serialization.Model):
    """User create details.

    :param state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :type state: str or ~azure.mgmt.apimanagement.models.UserState
    :param note: Optional note about a user set by the administrator.
    :type note: str
    :param identities: Collection of user identities.
    :type identities: list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    :param email: Email address. Must not be empty and must be unique within the service instance.
    :type email: str
    :param first_name: First name.
    :type first_name: str
    :param last_name: Last name.
    :type last_name: str
    :param password: User Password. If no value is provided, a default password is generated.
    :type password: str
    :param app_type: Determines the type of application which send the create user request. Default
     is legacy portal. Possible values include: "portal", "developerPortal".
    :type app_type: str or ~azure.mgmt.apimanagement.models.AppType
    :param confirmation: Determines the type of confirmation e-mail that will be sent to the newly
     created user. Possible values include: "signup", "invite".
    :type confirmation: str or ~azure.mgmt.apimanagement.models.Confirmation
    """

    _validation = {
        'email': {'max_length': 254, 'min_length': 1},
        'first_name': {'max_length': 100, 'min_length': 1},
        'last_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'state': {'key': 'properties.state', 'type': 'str'},
        'note': {'key': 'properties.note', 'type': 'str'},
        'identities': {'key': 'properties.identities', 'type': '[UserIdentityContract]'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'first_name': {'key': 'properties.firstName', 'type': 'str'},
        'last_name': {'key': 'properties.lastName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'app_type': {'key': 'properties.appType', 'type': 'str'},
        'confirmation': {'key': 'properties.confirmation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserCreateParameters, self).__init__(**kwargs)
        self.state = kwargs.get('state', "active")
        self.note = kwargs.get('note', None)
        self.identities = kwargs.get('identities', None)
        self.email = kwargs.get('email', None)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)
        self.password = kwargs.get('password', None)
        self.app_type = kwargs.get('app_type', None)
        self.confirmation = kwargs.get('confirmation', None)


class UserIdentityCollection(msrest.serialization.Model):
    """List of Users Identity list representation.

    :param value: User Identity values.
    :type value: list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    :param count: Total record count number across all pages.
    :type count: long
    :param next_link: Next page link if any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UserIdentityContract]'},
        'count': {'key': 'count', 'type': 'long'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserIdentityCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = kwargs.get('count', None)
        self.next_link = kwargs.get('next_link', None)


class UserIdentityContract(msrest.serialization.Model):
    """User identity details.

    :param provider: Identity provider name.
    :type provider: str
    :param id: Identifier value within provider.
    :type id: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserIdentityContract, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.id = kwargs.get('id', None)


class UserIdentityProperties(msrest.serialization.Model):
    """UserIdentityProperties.

    :param principal_id: The principal id of user assigned identity.
    :type principal_id: str
    :param client_id: The client id of user assigned identity.
    :type client_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = kwargs.get('principal_id', None)
        self.client_id = kwargs.get('client_id', None)


class UserTokenParameters(msrest.serialization.Model):
    """Get User Token parameters.

    :param key_type: The Key to be used to generate token for user. Possible values include:
     "primary", "secondary".
    :type key_type: str or ~azure.mgmt.apimanagement.models.KeyType
    :param expiry: The Expiry time of the Token. Maximum token expiry time is set to 30 days. The
     date conforms to the following format: ``yyyy-MM-ddTHH:mm:ssZ`` as specified by the ISO 8601
     standard.
    :type expiry: ~datetime.datetime
    """

    _attribute_map = {
        'key_type': {'key': 'properties.keyType', 'type': 'str'},
        'expiry': {'key': 'properties.expiry', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserTokenParameters, self).__init__(**kwargs)
        self.key_type = kwargs.get('key_type', None)
        self.expiry = kwargs.get('expiry', None)


class UserTokenResult(msrest.serialization.Model):
    """Get User Token response details.

    :param value: Shared Access Authorization token for the User.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserTokenResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class UserUpdateParameters(msrest.serialization.Model):
    """User update parameters.

    :param state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :type state: str or ~azure.mgmt.apimanagement.models.UserState
    :param note: Optional note about a user set by the administrator.
    :type note: str
    :param identities: Collection of user identities.
    :type identities: list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    :param email: Email address. Must not be empty and must be unique within the service instance.
    :type email: str
    :param password: User Password.
    :type password: str
    :param first_name: First name.
    :type first_name: str
    :param last_name: Last name.
    :type last_name: str
    """

    _validation = {
        'email': {'max_length': 254, 'min_length': 1},
        'first_name': {'max_length': 100, 'min_length': 1},
        'last_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'state': {'key': 'properties.state', 'type': 'str'},
        'note': {'key': 'properties.note', 'type': 'str'},
        'identities': {'key': 'properties.identities', 'type': '[UserIdentityContract]'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'first_name': {'key': 'properties.firstName', 'type': 'str'},
        'last_name': {'key': 'properties.lastName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserUpdateParameters, self).__init__(**kwargs)
        self.state = kwargs.get('state', "active")
        self.note = kwargs.get('note', None)
        self.identities = kwargs.get('identities', None)
        self.email = kwargs.get('email', None)
        self.password = kwargs.get('password', None)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)


class UserUpdateParametersProperties(UserEntityBaseParameters):
    """Parameters supplied to the Update User operation.

    :param state: Account state. Specifies whether the user is active or not. Blocked users are
     unable to sign into the developer portal or call any APIs of subscribed products. Default state
     is Active. Possible values include: "active", "blocked", "pending", "deleted". Default value:
     "active".
    :type state: str or ~azure.mgmt.apimanagement.models.UserState
    :param note: Optional note about a user set by the administrator.
    :type note: str
    :param identities: Collection of user identities.
    :type identities: list[~azure.mgmt.apimanagement.models.UserIdentityContract]
    :param email: Email address. Must not be empty and must be unique within the service instance.
    :type email: str
    :param password: User Password.
    :type password: str
    :param first_name: First name.
    :type first_name: str
    :param last_name: Last name.
    :type last_name: str
    """

    _validation = {
        'email': {'max_length': 254, 'min_length': 1},
        'first_name': {'max_length': 100, 'min_length': 1},
        'last_name': {'max_length': 100, 'min_length': 1},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'note': {'key': 'note', 'type': 'str'},
        'identities': {'key': 'identities', 'type': '[UserIdentityContract]'},
        'email': {'key': 'email', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'first_name': {'key': 'firstName', 'type': 'str'},
        'last_name': {'key': 'lastName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserUpdateParametersProperties, self).__init__(**kwargs)
        self.email = kwargs.get('email', None)
        self.password = kwargs.get('password', None)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)


class VirtualNetworkConfiguration(msrest.serialization.Model):
    """Configuration of a virtual network to which API Management service is deployed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vnetid: The virtual network ID. This is typically a GUID. Expect a null GUID by default.
    :vartype vnetid: str
    :ivar subnetname: The name of the subnet.
    :vartype subnetname: str
    :param subnet_resource_id: The full resource ID of a subnet in a virtual network to deploy the
     API Management service in.
    :type subnet_resource_id: str
    """

    _validation = {
        'vnetid': {'readonly': True},
        'subnetname': {'readonly': True},
        'subnet_resource_id': {'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
    }

    _attribute_map = {
        'vnetid': {'key': 'vnetid', 'type': 'str'},
        'subnetname': {'key': 'subnetname', 'type': 'str'},
        'subnet_resource_id': {'key': 'subnetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkConfiguration, self).__init__(**kwargs)
        self.vnetid = None
        self.subnetname = None
        self.subnet_resource_id = kwargs.get('subnet_resource_id', None)


class X509CertificateName(msrest.serialization.Model):
    """Properties of server X509Names.

    :param name: Common Name of the Certificate.
    :type name: str
    :param issuer_certificate_thumbprint: Thumbprint for the Issuer of the Certificate.
    :type issuer_certificate_thumbprint: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'issuer_certificate_thumbprint': {'key': 'issuerCertificateThumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(X509CertificateName, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.issuer_certificate_thumbprint = kwargs.get('issuer_certificate_thumbprint', None)
