(*
	Copyright (c) 2000
		Cambridge University Technical Services Limited

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*)


structure XmTypes = struct
local open MotifTypes XWindows in
exception XmNaccelerator                   of string ;
exception XmNacceleratorText               of XmString ;
exception XmNaccelerators                  of XtAccelerators ;
exception XmNadjustLast                    of bool ;
exception XmNadjustMargin                  of bool ;
exception XmNalignment                     of XmAlignment ;
exception XmNallowOverlap                  of bool ;
exception XmNallowResize                   of bool ;
exception XmNallowShellResize              of bool ;
exception XmNancestorSensitive             of bool ;
exception XmNapplyLabelString              of XmString ;
exception XmNargc                          of int ;
exception XmNargv                          of string list ;
exception XmNarmColor                      of int ;
exception XmNarmPixmap                     of Drawable ;
exception XmNarrowDirection                of XmArrowDirection ;
exception XmNautoShowCursorPosition        of bool ;
exception XmNautoUnmanage                  of bool ;
exception XmNautomaticSelection            of bool ;
exception XmNbackground                    of int ;
exception XmNbackgroundPixmap              of Drawable ;
exception XmNbaseHeight                    of int ;
exception XmNbaseWidth                     of int ;
exception XmNblinkRate                     of int ;
exception XmNborderColor                   of int ;
exception XmNborderPixmap                  of Drawable ;
exception XmNborderWidth                   of int ;
exception XmNbottomAttachment              of XmAttachment ;
exception XmNbottomOffset                  of int ;
exception XmNbottomPosition                of int ;
exception XmNbottomShadowColor             of int ;
exception XmNbottomShadowPixmap            of Drawable ;
exception XmNbottomWidget                  of Widget ;
exception XmNbuttonAcceleratorText         of XmString list ;
exception XmNbuttonAccelerators            of string list ;
exception XmNbuttonCount                   of int ;
exception XmNbuttonFontList                of (XFontStruct * string) list ;
exception XmNbuttonMnemonicCharSets        of XmString list ;
exception XmNbuttonMnemonics               of int list ;
exception XmNbuttonSet                     of int ;
exception XmNbuttonType                    of XmButtonType list ;
exception XmNbuttons                       of XmString list ;
exception XmNcancelButton                  of Widget ;
exception XmNcancelLabelString             of XmString ;
exception XmNcascadePixmap                 of Drawable ;
exception XmNchildren                      of Widget list ;
exception XmNclipWindow                    of Widget ;
exception XmNcolormap                      of Colormap ;
exception XmNcolumns                       of int ;
exception XmNcommand                       of XmString ;
exception XmNcommandWindow                 of Widget ;
exception XmNcommandWindowLocation         of XmCommandWindowLocation ;
exception XmNcursorPosition                of int ;
exception XmNcursorPositionVisible         of bool ;
exception XmNdecimalPoints                 of int ;
exception XmNdefaultButton                 of Widget ;
exception XmNdefaultButtonShadowThickness  of int ;
exception XmNdefaultButtonType             of XmDefaultButtonType ;
exception XmNdefaultFontList               of (XFontStruct * string) list ;
exception XmNdefaultPosition               of bool ;
exception XmNdeleteResponse                of XmDeleteResponse ;
exception XmNdepth                         of int ;
exception XmNdialogStyle                   of XmDialogStyle ;
exception XmNdialogTitle                   of XmString ;
exception XmNdialogType                    of XmDialogType ;
exception XmNdirListItemCount              of int ;
exception XmNdirListItems                  of XmString list ;
exception XmNdirListLabelString            of XmString ;
exception XmNdirMask                       of XmString ;
exception XmNdirSpec                       of XmString ;
exception XmNdirectory                     of XmString ;
exception XmNdirectoryValid                of bool ;
exception XmNdoubleClickInterval           of int ;
exception XmNeditMode                      of XmEditMode ;
exception XmNeditable                      of bool ;
exception XmNentryAlignment                of XmAlignment ;
exception XmNentryBorder                   of int ;
exception XmNfileListItemCount             of int ;
exception XmNfileListItems                 of XmString list ;
exception XmNfileListLabelString           of XmString ;
exception XmNfileTypeMask                  of XmFileTypeMask ;
exception XmNfillOnArm                     of bool ;
exception XmNfillOnSelect                  of bool ;
exception XmNfilterLabelString             of XmString ;
exception XmNfontList                      of (XFontStruct * string) list ;
exception XmNforeground                    of int ;
exception XmNfractionBase                  of int ;
exception XmNgeometry                      of string ;
exception XmNheight                        of int ;
exception XmNheightInc                     of int ;
exception XmNhelpLabelString               of XmString ;
exception XmNhighlightColor                of int ;
exception XmNhighlightOnEnter              of bool ;
exception XmNhighlightPixmap               of Drawable ;
exception XmNhighlightThickness            of int ;
exception XmNhistoryItemCount              of int ;
exception XmNhistoryItems                  of XmString list ;
exception XmNhistoryMaxItems               of int ;
exception XmNhistoryVisibleItemCount       of int ;
exception XmNhorizontalScrollBar           of Widget ;
exception XmNhorizontalSpacing             of int ;
exception XmNiconMask                      of Drawable ;
exception XmNiconName                      of string ;
exception XmNiconNameEncoding              of int ;
exception XmNiconPixmap                    of Drawable ;
exception XmNiconWindow                    of Drawable ;
exception XmNiconX                         of int ;
exception XmNiconY                         of int ;
exception XmNiconic                        of bool ;
exception XmNincrement                     of int ;
exception XmNindicatorOn                   of bool ;
exception XmNindicatorSize                 of int ;
exception XmNindicatorType                 of XmIndicatorType ;
exception XmNinitialDelay                  of int ;
exception XmNinitialResourcesPersistent    of bool ;
exception XmNinitialState                  of XWMStateHint ;
exception XmNinput                         of bool ;
exception XmNisAligned                     of bool ;
exception XmNisHomogeneous                 of bool ;
exception XmNitemCount                     of int ;
exception XmNitems                         of XmString list ;
exception XmNkeyboardFocusPolicy           of XmKeyboardFocusPolicy ;
exception XmNlabelFontList                 of (XFontStruct * string) list ;
exception XmNlabelInsensitivePixmap        of Drawable ;
exception XmNlabelPixmap                   of Drawable ;
exception XmNlabelString                   of XmString ;
exception XmNlabelType                     of XmLabelType ;
exception XmNleftAttachment                of XmAttachment ;
exception XmNleftOffset                    of int ;
exception XmNleftPosition                  of int ;
exception XmNleftWidget                    of Widget ;
exception XmNlistItemCount                 of int ;
exception XmNlistItems                     of XmString list ;
exception XmNlistLabelString               of XmString ;
exception XmNlistMarginHeight              of int ;
exception XmNlistMarginWidth               of int ;
exception XmNlistSizePolicy                of XmVisualPolicy ;
exception XmNlistSpacing                   of int ;
exception XmNlistUpdated                   of bool ;
exception XmNlistVisibleItemCount          of int ;
exception XmNmainWindowMarginHeight        of int ;
exception XmNmainWindowMarginWidth         of int ;
exception XmNmappedWhenManaged             of bool ;
exception XmNmappingDelay                  of int ;
exception XmNmargin                        of int ;
exception XmNmarginBottom                  of int ;
exception XmNmarginHeight                  of int ;
exception XmNmarginLeft                    of int ;
exception XmNmarginRight                   of int ;
exception XmNmarginTop                     of int ;
exception XmNmarginWidth                   of int ;
exception XmNmaxAspectX                    of int ;
exception XmNmaxAspectY                    of int ;
exception XmNmaxHeight                     of int ;
exception XmNmaxLength                     of int ;
exception XmNmaxWidth                      of int ;
exception XmNmaximum                       of int ;
exception XmNmenuAccelerator               of string ;
exception XmNmenuBar                       of Widget ;
exception XmNmenuCursor                    of Cursor ;
exception XmNmenuHelpWidget                of Widget ;
exception XmNmenuHistory                   of Widget ;
exception XmNmenuPost                      of string ;
exception XmNmessageAlignment              of XmAlignment ;
exception XmNmessageString                 of XmString ;
exception XmNmessageWindow                 of Widget ;
exception XmNminAspectX                    of int ;
exception XmNminAspectY                    of int ;
exception XmNminHeight                     of int ;
exception XmNminWidth                      of int ;
exception XmNminimizeButtons               of bool ;
exception XmNminimum                       of int ;
exception XmNmnemonic                      of int ;
exception XmNmnemonicCharSet               of string ;
exception XmNmultiClick                    of XmMultiClickType ;
exception XmNmustMatch                     of bool ;
exception XmNmwmDecorations                of int ;
exception XmNmwmFunctions                  of int ;
exception XmNmwmInputMode                  of int ;
exception XmNmwmMenu                       of string ;
exception XmNnavigationType                of XmNavigationType ;
exception XmNnoMatchString                 of XmString ;
exception XmNnoResize                      of bool ;
exception XmNnumChildren                   of int ;
exception XmNnumColumns                    of int ;
exception XmNokLabelString                 of XmString ;
exception XmNoptionLabel                   of XmString ;
exception XmNoptionMnemonic                of int ;
exception XmNorientation                   of XmOrientation ;
exception XmNoverrideRedirect              of bool ;
exception XmNpacking                       of XmPacking ;
exception XmNpageIncrement                 of int ;
exception XmNpaneMaximum                   of int ;
exception XmNpaneMinimum                   of int ;
exception XmNpattern                       of XmString ;
exception XmNpendingDelete                 of bool ;
exception XmNpopupEnabled                  of bool ;
exception XmNpostFromButton                of int ;
exception XmNprocessingDirection           of XmProcessingDirection ;
exception XmNpromptString                  of XmString ;
exception XmNpushButtonEnabled             of bool ;
exception XmNradioAlwaysOne                of bool ;
exception XmNradioBehavior                 of bool ;
exception XmNrecomputeSize                 of bool ;
exception XmNrefigureMode                  of bool ;
exception XmNrepeatDelay                   of int ;
exception XmNresizable                     of bool ;
exception XmNresizeHeight                  of bool ;
exception XmNresizePolicy                  of XmResizePolicy ;
exception XmNresizeWidth                   of bool ;
exception XmNrightAttachment               of XmAttachment ;
exception XmNrightOffset                   of int ;
exception XmNrightPosition                 of int ;
exception XmNrightWidget                   of Widget ;
exception XmNrowColumnType                 of XmRowColumnType ;
exception XmNrows                          of int ;
exception XmNrubberPositioning             of bool ;
exception XmNsashHeight                    of int ;
exception XmNsashIndent                    of int ;
exception XmNsashShadowThickness           of int ;
exception XmNsashWidth                     of int ;
exception XmNsaveUnder                     of bool ;
exception XmNscaleHeight                   of int ;
exception XmNscaleMultiple                 of int ;
exception XmNscaleWidth                    of int ;
exception XmNscrollBarDisplayPolicy        of XmScrollBarDisplayPolicy ;
exception XmNscrollBarPlacement            of XmScrollBarPlacement ;
exception XmNscrollHorizontal              of bool ;
exception XmNscrollLeftSide                of bool ;
exception XmNscrollTopSide                 of bool ;
exception XmNscrollVertical                of bool ;
exception XmNscrolledWindowMarginHeight    of int ;
exception XmNscrolledWindowMarginWidth     of int ;
exception XmNscrollingPolicy               of XmScrollingPolicy ;
exception XmNselectColor                   of int ;
exception XmNselectInsensitivePixmap       of Drawable ;
exception XmNselectPixmap                  of Drawable ;
exception XmNselectThreshold               of int ;
exception XmNselectedItemCount             of int ;
exception XmNselectedItems                 of XmString list ;
exception XmNselectionArray                of XmTextScanType list ;
exception XmNselectionArrayCount           of int ;
exception XmNselectionLabelString          of XmString ;
exception XmNselectionPolicy               of XmSelectionPolicy ;
exception XmNsensitive                     of bool ;
exception XmNseparatorOn                   of bool ;
exception XmNseparatorType                 of XmShadowType ;
exception XmNset                           of bool ;
exception XmNshadowThickness               of int ;
exception XmNshadowType                    of XmShadowType ;
exception XmNshellUnitType                 of XmUnitType ;
exception XmNshowArrows                    of bool ;
exception XmNshowAsDefault                 of int ;
exception XmNshowSeparator                 of bool ;
exception XmNshowValue                     of bool ;
exception XmNskipAdjust                    of bool ;
exception XmNsliderSize                    of int ;
exception XmNspacing                       of int ;
exception XmNstringDirection               of XmStringDirection ;
exception XmNsubMenuId                     of Widget ;
exception XmNsymbolPixmap                  of Drawable ;
exception XmNtextAccelerators              of XtAccelerators ;
exception XmNtextColumns                   of int ;
exception XmNtextFontList                  of (XFontStruct * string) list ;
exception XmNtextString                    of XmString ;
exception XmNtextTranslations              of XtTranslations ;
exception XmNtitle                         of string ;
exception XmNtitleEncoding                 of int ;
exception XmNtitleString                   of XmString ;
exception XmNtopAttachment                 of XmAttachment ;
exception XmNtopCharacter                  of int ;
exception XmNtopItemPosition               of int ;
exception XmNtopOffset                     of int ;
exception XmNtopPosition                   of int ;
exception XmNtopShadowColor                of int ;
exception XmNtopShadowPixmap               of Drawable ;
exception XmNtopWidget                     of Widget ;
exception XmNtransient                     of bool ;
exception XmNtransientFor                  of Widget ;
exception XmNtranslations                  of XtTranslations ;
exception XmNtraversalOn                   of bool ;
exception XmNtroughColor                   of int ;
exception XmNunitType                      of XmUnitType ;
exception XmNuseAsyncGeometry              of bool ;
exception XmNvalue                         of int ;
exception XmNverifyBell                    of bool ;
exception XmNverticalScrollBar             of Widget ;
exception XmNverticalSpacing               of int ;
exception XmNvisibleItemCount              of int ;
exception XmNvisibleWhenOff                of bool ;
exception XmNvisual                        of Visual ;
exception XmNvisualPolicy                  of XmVisualPolicy ;
exception XmNwaitForWm                     of bool ;
exception XmNwidth                         of int ;
exception XmNwidthInc                      of int ;
exception XmNwinGravity                    of int ;
exception XmNwindowGroup                   of Drawable ;
exception XmNwmTimeout                     of int ;
exception XmNwordWrap                      of bool ;
exception XmNworkWindow                    of Widget ;
exception XmNx                             of int ;
exception XmNy                             of int ;
val XmCAccelerator                   = "Accelerator" ;
val XmCAcceleratorText               = "AcceleratorText" ;
val XmCAccelerators                  = "Accelerators" ;
val XmCAdjustLast                    = "AdjustLast" ;
val XmCAdjustMargin                  = "AdjustMargin" ;
val XmCAlignment                     = "Alignment" ;
val XmCAllowOverlap                  = "AllowOverlap" ;
val XmCAllowShellResize              = "AllowShellResize" ;
val XmCApplyLabelString              = "ApplyLabelString" ;
val XmCArgc                          = "Argc" ;
val XmCArgv                          = "Argv" ;
val XmCArmColor                      = "ArmColor" ;
val XmCArmPixmap                     = "ArmPixmap" ;
val XmCArrowDirection                = "ArrowDirection" ;
val XmCAttachment                    = "Attachment" ;
val XmCAutoShowCursorPosition        = "AutoShowCursorPosition" ;
val XmCAutoUnmanage                  = "AutoUnmanage" ;
val XmCAutomaticSelection            = "AutomaticSelection" ;
val XmCBackground                    = "Background" ;
val XmCBackgroundPixmap              = "BackgroundPixmap" ;
val XmCBaseHeight                    = "BaseHeight" ;
val XmCBaseWidth                     = "BaseWidth" ;
val XmCBlinkRate                     = "BlinkRate" ;
val XmCBoolean                       = "Boolean" ;
val XmCBorderColor                   = "BorderColor" ;
val XmCBorderWidth                   = "BorderWidth" ;
val XmCBottomShadowColor             = "BottomShadowColor" ;
val XmCBottomShadowPixmap            = "BottomShadowPixmap" ;
val XmCButtonAcceleratorText         = "ButtonAcceleratorText" ;
val XmCButtonAccelerators            = "ButtonAccelerators" ;
val XmCButtonCount                   = "ButtonCount" ;
val XmCButtonFontList                = "ButtonFontList" ;
val XmCButtonMnemonicCharSets        = "ButtonMnemonicCharSets" ;
val XmCButtonMnemonics               = "ButtonMnemonics" ;
val XmCButtonSet                     = "ButtonSet" ;
val XmCButtonType                    = "ButtonType" ;
val XmCButtons                       = "Buttons" ;
val XmCCancelLabelString             = "CancelLabelString" ;
val XmCChildren                      = "Children" ;
val XmCClipWindow                    = "ClipWindow" ;
val XmCColormap                      = "Colormap" ;
val XmCColumns                       = "Columns" ;
val XmCCommandWindow                 = "CommandWindow" ;
val XmCCommandWindowLocation         = "CommandWindowLocation" ;
val XmCCursor                        = "Cursor" ;
val XmCCursorPosition                = "CursorPosition" ;
val XmCCursorPositionVisible         = "CursorPositionVisible" ;
val XmCDecimalPoints                 = "DecimalPoints" ;
val XmCDefaultButtonShadowThickness  = "DefaultButtonShadowThickness" ;
val XmCDefaultButtonType             = "DefaultButtonType" ;
val XmCDefaultFontList               = "DefaultFontList" ;
val XmCDefaultPosition               = "DefaultPosition" ;
val XmCDeleteResponse                = "DeleteResponse" ;
val XmCDepth                         = "Depth" ;
val XmCDialogStyle                   = "DialogStyle" ;
val XmCDialogTitle                   = "DialogTitle" ;
val XmCDialogType                    = "DialogType" ;
val XmCDirListItemCount              = "DirListItemCount" ;
val XmCDirListItems                  = "DirListItems" ;
val XmCDirListLabelString            = "DirListLabelString" ;
val XmCDirMask                       = "DirMask" ;
val XmCDirSpec                       = "DirSpec" ;
val XmCDirectory                     = "Directory" ;
val XmCDirectoryValid                = "DirectoryValid" ;
val XmCDoubleClickInterval           = "DoubleClickInterval" ;
val XmCEditMode                      = "EditMode" ;
val XmCEditable                      = "Editable" ;
val XmCEntryBorder                   = "EntryBorder" ;
val XmCFileListItemCount             = "FileListItemCount" ;
val XmCFileListItems                 = "FileListItems" ;
val XmCFileListLabelString           = "FileListLabelString" ;
val XmCFileTypeMask                  = "FileTypeMask" ;
val XmCFillOnArm                     = "FillOnArm" ;
val XmCFillOnSelect                  = "FillOnSelect" ;
val XmCFilterLabelString             = "FilterLabelString" ;
val XmCFontList                      = "FontList" ;
val XmCForeground                    = "Foreground" ;
val XmCFraction                      = "Fraction" ;
val XmCGeometry                      = "Geometry" ;
val XmCHeight                        = "Height" ;
val XmCHeightInc                     = "HeightInc" ;
val XmCHelpLabelString               = "HelpLabelString" ;
val XmCHighlightColor                = "HighlightColor" ;
val XmCHighlightOnEnter              = "HighlightOnEnter" ;
val XmCHighlightPixmap               = "HighlightPixmap" ;
val XmCHighlightThickness            = "HighlightThickness" ;
val XmCHorizontalScrollBar           = "HorizontalScrollBar" ;
val XmCIconMask                      = "IconMask" ;
val XmCIconName                      = "IconName" ;
val XmCIconNameEncoding              = "IconNameEncoding" ;
val XmCIconPixmap                    = "IconPixmap" ;
val XmCIconWindow                    = "IconWindow" ;
val XmCIconX                         = "IconX" ;
val XmCIconY                         = "IconY" ;
val XmCIconic                        = "Iconic" ;
val XmCIncrement                     = "Increment" ;
val XmCIndicatorOn                   = "IndicatorOn" ;
val XmCIndicatorSize                 = "IndicatorSize" ;
val XmCIndicatorType                 = "IndicatorType" ;
val XmCInitialDelay                  = "InitialDelay" ;
val XmCInitialResourcesPersistent    = "InitialResourcesPersistent" ;
val XmCInitialState                  = "InitialState" ;
val XmCInput                         = "Input" ;
val XmCIsAligned                     = "IsAligned" ;
val XmCIsHomogeneous                 = "IsHomogeneous" ;
val XmCItemCount                     = "ItemCount" ;
val XmCItems                         = "Items" ;
val XmCKeyboardFocusPolicy           = "KeyboardFocusPolicy" ;
val XmCLabelFontList                 = "LabelFontList" ;
val XmCLabelInsensitivePixmap        = "LabelInsensitivePixmap" ;
val XmCLabelPixmap                   = "LabelPixmap" ;
val XmCLabelString                   = "LabelString" ;
val XmCLabelType                     = "LabelType" ;
val XmCListLabelString               = "ListLabelString" ;
val XmCListMarginHeight              = "ListMarginHeight" ;
val XmCListMarginWidth               = "ListMarginWidth" ;
val XmCListSizePolicy                = "ListSizePolicy" ;
val XmCListSpacing                   = "ListSpacing" ;
val XmCListUpdated                   = "ListUpdated" ;
val XmCMainWindowMarginHeight        = "MainWindowMarginHeight" ;
val XmCMainWindowMarginWidth         = "MainWindowMarginWidth" ;
val XmCMappedWhenManaged             = "MappedWhenManaged" ;
val XmCMappingDelay                  = "MappingDelay" ;
val XmCMargin                        = "Margin" ;
val XmCMarginBottom                  = "MarginBottom" ;
val XmCMarginHeight                  = "MarginHeight" ;
val XmCMarginLeft                    = "MarginLeft" ;
val XmCMarginRight                   = "MarginRight" ;
val XmCMarginTop                     = "MarginTop" ;
val XmCMarginWidth                   = "MarginWidth" ;
val XmCMaxAspectX                    = "MaxAspectX" ;
val XmCMaxAspectY                    = "MaxAspectY" ;
val XmCMaxHeight                     = "MaxHeight" ;
val XmCMaxItems                      = "MaxItems" ;
val XmCMaxLength                     = "MaxLength" ;
val XmCMaxWidth                      = "MaxWidth" ;
val XmCMaximum                       = "Maximum" ;
val XmCMenuBar                       = "MenuBar" ;
val XmCMenuPost                      = "MenuPost" ;
val XmCMenuWidget                    = "MenuWidget" ;
val XmCMessageString                 = "MessageString" ;
val XmCMessageWindow                 = "MessageWindow" ;
val XmCMinAspectX                    = "MinAspectX" ;
val XmCMinAspectY                    = "MinAspectY" ;
val XmCMinHeight                     = "MinHeight" ;
val XmCMinWidth                      = "MinWidth" ;
val XmCMinimizeButtons               = "MinimizeButtons" ;
val XmCMinimum                       = "Minimum" ;
val XmCMnemonic                      = "Mnemonic" ;
val XmCMnemonicCharSet               = "MnemonicCharSet" ;
val XmCMultiClick                    = "MultiClick" ;
val XmCMustMatch                     = "MustMatch" ;
val XmCMwmDecorations                = "MwmDecorations" ;
val XmCMwmFunctions                  = "MwmFunctions" ;
val XmCMwmInputMode                  = "MwmInputMode" ;
val XmCMwmMenu                       = "MwmMenu" ;
val XmCNavigationType                = "NavigationType" ;
val XmCNoMatchString                 = "NoMatchString" ;
val XmCNoResize                      = "NoResize" ;
val XmCNumChildren                   = "NumChildren" ;
val XmCNumColumns                    = "NumColumns" ;
val XmCOffset                        = "Offset" ;
val XmCOkLabelString                 = "OkLabelString" ;
val XmCOptionLabel                   = "OptionLabel" ;
val XmCOptionMnemonic                = "OptionMnemonic" ;
val XmCOrientation                   = "Orientation" ;
val XmCOverrideRedirect              = "OverrideRedirect" ;
val XmCPacking                       = "Packing" ;
val XmCPageIncrement                 = "PageIncrement" ;
val XmCPaneMaximum                   = "PaneMaximum" ;
val XmCPaneMinimum                   = "PaneMinimum" ;
val XmCPattern                       = "Pattern" ;
val XmCPendingDelete                 = "PendingDelete" ;
val XmCPixmap                        = "Pixmap" ;
val XmCPopupEnabled                  = "PopupEnabled" ;
val XmCPosition                      = "Position" ;
val XmCPostFromButton                = "PostFromButton" ;
val XmCProcessingDirection           = "ProcessingDirection" ;
val XmCPromptString                  = "PromptString" ;
val XmCPushButtonEnabled             = "PushButtonEnabled" ;
val XmCRadioAlwaysOne                = "RadioAlwaysOne" ;
val XmCRadioBehavior                 = "RadioBehavior" ;
val XmCRecomputeSize                 = "RecomputeSize" ;
val XmCRepeatDelay                   = "RepeatDelay" ;
val XmCResizeHeight                  = "ResizeHeight" ;
val XmCResizePolicy                  = "ResizePolicy" ;
val XmCResizeWidth                   = "ResizeWidth" ;
val XmCRowColumnType                 = "RowColumnType" ;
val XmCRows                          = "Rows" ;
val XmCRubberPositioning             = "RubberPositioning" ;
val XmCSashHeight                    = "SashHeight" ;
val XmCSashIndent                    = "SashIndent" ;
val XmCSashWidth                     = "SashWidth" ;
val XmCSaveUnder                     = "SaveUnder" ;
val XmCScaleHeight                   = "ScaleHeight" ;
val XmCScaleMultiple                 = "ScaleMultiple" ;
val XmCScaleWidth                    = "ScaleWidth" ;
val XmCScroll                        = "Scroll" ;
val XmCScrollBarDisplayPolicy        = "ScrollBarDisplayPolicy" ;
val XmCScrollBarPlacement            = "ScrollBarPlacement" ;
val XmCScrollSide                    = "ScrollSide" ;
val XmCScrolledWindowMarginHeight    = "ScrolledWindowMarginHeight" ;
val XmCScrolledWindowMarginWidth     = "ScrolledWindowMarginWidth" ;
val XmCScrollingPolicy               = "ScrollingPolicy" ;
val XmCSelectColor                   = "SelectColor" ;
val XmCSelectInsensitivePixmap       = "SelectInsensitivePixmap" ;
val XmCSelectPixmap                  = "SelectPixmap" ;
val XmCSelectThreshold               = "SelectThreshold" ;
val XmCSelectedItemCount             = "SelectedItemCount" ;
val XmCSelectedItems                 = "SelectedItems" ;
val XmCSelectionArray                = "SelectionArray" ;
val XmCSelectionArrayCount           = "SelectionArrayCount" ;
val XmCSelectionLabelString          = "SelectionLabelString" ;
val XmCSelectionPolicy               = "SelectionPolicy" ;
val XmCSensitive                     = "Sensitive" ;
val XmCSeparatorOn                   = "SeparatorOn" ;
val XmCSeparatorType                 = "SeparatorType" ;
val XmCSet                           = "Set" ;
val XmCShadowThickness               = "ShadowThickness" ;
val XmCShadowType                    = "ShadowType" ;
val XmCShellUnitType                 = "ShellUnitType" ;
val XmCShowArrows                    = "ShowArrows" ;
val XmCShowAsDefault                 = "ShowAsDefault" ;
val XmCShowSeparator                 = "ShowSeparator" ;
val XmCShowValue                     = "ShowValue" ;
val XmCSliderSize                    = "SliderSize" ;
val XmCSpacing                       = "Spacing" ;
val XmCStringDirection               = "StringDirection" ;
val XmCTextFontList                  = "TextFontList" ;
val XmCTextPosition                  = "TextPosition" ;
val XmCTextString                    = "TextString" ;
val XmCTitle                         = "Title" ;
val XmCTitleEncoding                 = "TitleEncoding" ;
val XmCTitleString                   = "TitleString" ;
val XmCTopItemPosition               = "TopItemPosition" ;
val XmCTopShadowColor                = "TopShadowColor" ;
val XmCTopShadowPixmap               = "TopShadowPixmap" ;
val XmCTransient                     = "Transient" ;
val XmCTransientFor                  = "TransientFor" ;
val XmCTranslations                  = "Translations" ;
val XmCTraversalOn                   = "TraversalOn" ;
val XmCTroughColor                   = "TroughColor" ;
val XmCUnitType                      = "UnitType" ;
val XmCUseAsyncGeometry              = "UseAsyncGeometry" ;
val XmCValue                         = "Value" ;
val XmCVerifyBell                    = "VerifyBell" ;
val XmCVerticalScrollBar             = "VerticalScrollBar" ;
val XmCVisibleItemCount              = "VisibleItemCount" ;
val XmCVisibleWhenOff                = "VisibleWhenOff" ;
val XmCVisual                        = "Visual" ;
val XmCVisualPolicy                  = "VisualPolicy" ;
val XmCWaitForWm                     = "WaitForWm" ;
val XmCWidget                        = "Widget" ;
val XmCWidth                         = "Width" ;
val XmCWidthInc                      = "WidthInc" ;
val XmCWinGravity                    = "WinGravity" ;
val XmCWindowGroup                   = "WindowGroup" ;
val XmCWmTimeout                     = "WmTimeout" ;
val XmCWordWrap                      = "WordWrap" ;
val XmCWorkWindow                    = "WorkWindow" ;
val XmCX                             = "X" ;
val XmCY                             = "Y" ;
end (* local *) ;
end (* struct *) ;
