# Contributing to lcobucci/jwt

First off, thanks for taking the time to contribute!

## Reporting issues

We accept bug and feature requests via issues created [here](https://github.com/lcobucci/jwt/issues).

### Prior to submitting a bug report

- **Always search the issue or pull request list first** - The odds are good that if you've found a problem, someone else has found it, too;
- **Always try the [master](https://github.com/lcobucci/jwt) branch** - to see if the reported bug has not already been fixed.

## Pull Requests

We accept contributions via pull requests [here](https://github.com/lcobucci/jwt/pulls).

- Follow [PSR-2 coding standards](http://www.php-fig.org/psr/psr-2);
- Follow [PSR-4 autoloading standards](http://www.php-fig.org/psr/psr-4);
- Follow [semver](http://semver.org);
- Add tests (everything MUST be well tested);
- Improve documentation (don't forget to update README.md);
- Create topic branches (don't send a PR from your master);
- One pull request per feature;
- Send coherent history by rebasing your work before submitting;

### Running tests locally

We provide a GNU-Make configuration that allows you to run the CI checks locally with a single command: `make`.

### Branches

- **5.0.x**: used to the next major release (new features that breaks BC)
- **4.4.x**: used to develop migration path for the next version
- **4.3.x**: used to fix bugs
- **4.2.x**: unmaintained
- **4.1.x**: unmaintained
- **4.0.x**: unmaintained
- **3.4.x**: security issues only
- **3.3**: unmaintained
- **3.2**: unmaintained
- **3.1**: unmaintained
- **3.0**: unmaintained
- **2.1**: unmaintained

**Thank you and happy coding!**

@lcobucci
