/*****************************************************************
 * gmerlin-avdecoder - a general purpose multimedia decoding library
 *
 * Copyright (c) 2001 - 2024 Members of the Gmerlin project
 * http://github.com/bplaum
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * *****************************************************************/



#ifndef BGAV_MPA_HEADER_H_INCLUDED
#define BGAV_MPA_HEADER_H_INCLUDED

typedef enum
  {
    MPEG_VERSION_NONE = 0,
    MPEG_VERSION_1 = 1,
    MPEG_VERSION_2 = 2,
    MPEG_VERSION_2_5
  } bgav_mpa_version_t;

#define CHANNEL_STEREO   0
#define CHANNEL_JSTEREO  1
#define CHANNEL_DUAL     2
#define CHANNEL_MONO     3

#define BGAV_MPA_MAX_FRAME_BYTES 2881

typedef struct
  {
  bgav_mpa_version_t version;
  int layer;
  int bitrate;    /* -1: VBR */
  int samplerate;
  int frame_bytes;
  int channel_mode;
  int mode;
  int samples_per_frame;

  int has_crc;
  int side_info_size;
  
  } bgav_mpa_header_t;

int bgav_mpa_header_equal(bgav_mpa_header_t * h1, bgav_mpa_header_t * h2);
void bgav_mpa_header_dump(bgav_mpa_header_t * h);
int bgav_mpa_header_decode(bgav_mpa_header_t * h, uint8_t * ptr);

void bgav_mpa_header_get_format(const bgav_mpa_header_t * h,
                                gavl_audio_format_t * format);

#endif // BGAV_MPA_HEADER_H_INCLUDED

