//  Copyright (c) 2006 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Each row of test data contains in order:
//
// k, phi, E(k, phi)
//
   static const std::array<std::array<typename table_type<T>::type, 3>, 520> ellint_e2_data = {{
      {{ SC_(0.177219114266335964202880859375e-2), SC_(-0.804919183254241943359375e0), SC_(0.17721905416489978459933452744691987573693030723399e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(-0.74602639675140380859375e0), SC_(0.17721906263793616232304803862551613935165980878975e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(-0.72904598712921142578125e0), SC_(0.17721906496143189532808590572077500756745196250994e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(-0.62323606014251708984375e0), SC_(0.17721907823458326176536911566374461949290266081915e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(-0.5579319000244140625e0), SC_(0.17721908538996504890695781731051446713497872352528e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(-0.44300353527069091796875e0), SC_(0.1772190960611723703532438177387763930589137687723e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(-0.38366591930389404296875e0), SC_(0.17721910061149527140815880383922381002724195459473e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.9376299381256103515625e-1), SC_(0.17721911345080004258530792787497396150296565903888e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.944411754608154296875e-1), SC_(0.17721911343895994071624688564628016634872782068401e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.264718532562255859375e0), SC_(0.17721910776580442894609156234461709334349303324512e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.62944734096527099609375e0), SC_(0.17721907751280664212690267651483481595911639313105e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.67001712322235107421875e0), SC_(0.17721907262237245229946682518231598438599636326697e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.81158387660980224609375e0), SC_(0.1772190531655048767532217861236813247332269413991e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.826751708984375e0), SC_(0.17721905086031437581845682018005163376219526346493e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.91501367092132568359375e0), SC_(0.17721903659952045902730471028534006712649156285481e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.92977702617645263671875e0), SC_(0.17721903407305898397789671421686956699622188608929e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.93538987636566162109375e0), SC_(0.17721903310191937273874074422793996165770412692148e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.93773555755615234375e0), SC_(0.17721903269433608619814655577621926258964232521032e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.98576259613037109375e0), SC_(0.17721902412478400771222500977665176615786698940728e-2) }}, 
      {{ SC_(0.177219114266335964202880859375e-2), SC_(0.99292266368865966796875e0), SC_(0.17721902281054485597950865679003652002775579957175e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(-0.804919183254241943359375e0), SC_(0.22177274667911356404114891574256878749693907344194e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(-0.74602639675140380859375e0), SC_(0.22177276328387303450482024510234767179030032679487e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(-0.72904598712921142578125e0), SC_(0.2217727678372686367339028586754168902231177349864e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(-0.62323606014251708984375e0), SC_(0.22177279384889650054782811230773624538568740820856e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(-0.5579319000244140625e0), SC_(0.22177280787142304325383561406780984188050064485493e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(-0.44300353527069091796875e0), SC_(0.22177282878397316166435787421159323409852657193959e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(-0.38366591930389404296875e0), SC_(0.22177283770131950245199600240560529548081991406878e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.9376299381256103515625e-1), SC_(0.2217728628627254479372625258375135600386491716262e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.944411754608154296875e-1), SC_(0.2217728628395221979258299938047197957597496164853e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.264718532562255859375e0), SC_(0.22177285172174219060847672057602083161874684079641e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.62944734096527099609375e0), SC_(0.22177279243441823271547938764610382865435171389572e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.67001712322235107421875e0), SC_(0.22177278285054864598218183902335374842302009015249e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.81158387660980224609375e0), SC_(0.22177274472058160774429082218212375574848674857853e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.826751708984375e0), SC_(0.22177274020305878581113108501360596469572415665098e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.91501367092132568359375e0), SC_(0.22177271225592599152503205364411936997104330819552e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.92977702617645263671875e0), SC_(0.22177270730477403168508453406178297939782452362205e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.93538987636566162109375e0), SC_(0.22177270540161426246190034172682702788389529386352e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.93773555755615234375e0), SC_(0.22177270460286595928412185481890644744187621951273e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.98576259613037109375e0), SC_(0.22177268780896006483002343116598140190281467534408e-2) }}, 
      {{ SC_(0.22177286446094512939453125e-2), SC_(0.99292266368865966796875e0), SC_(0.22177268523342180309535844744234619982692618957978e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(-0.804919183254241943359375e0), SC_(0.74444554408367041960081599572734384580648039601292e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(-0.74602639675140380859375e0), SC_(0.74444617216162272729935658343672599710823129917136e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(-0.72904598712921142578125e0), SC_(0.7444463443944617202862815487638272084421484282213e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(-0.62323606014251708984375e0), SC_(0.74444732828674762841832446009298546988014342845109e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(-0.5579319000244140625e0), SC_(0.74444785868925647373677427756541386357216267403116e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(-0.44300353527069091796875e0), SC_(0.7444486497059729002932025822805836773020204604622e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(-0.38366591930389404296875e0), SC_(0.7444489870039692628767038225671358877887084418318e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.9376299381256103515625e-1), SC_(0.74444993873102289959003988480526261034186232298732e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.944411754608154296875e-1), SC_(0.74444993785336377021615551123021090095012183365455e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.264718532562255859375e0), SC_(0.74444951732496163285321657924324274340742574731183e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.62944734096527099609375e0), SC_(0.74444727478402810869648210185177744717615995463001e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.67001712322235107421875e0), SC_(0.74444691227345931676783343972213308719772501191675e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.81158387660980224609375e0), SC_(0.74444547000179682301220146799104273617595274550494e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.826751708984375e0), SC_(0.74444529912552191587668074107636437041675982253389e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.91501367092132568359375e0), SC_(0.74444424201776730075960207569226490521597156912434e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.92977702617645263671875e0), SC_(0.74444405473886664282906533654411935648151688362809e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.93538987636566162109375e0), SC_(0.74444398275122133283989327309245789244705679180104e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.93773555755615234375e0), SC_(0.74444395253830019766374648366268259171697141665571e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.98576259613037109375e0), SC_(0.74444331730273938555860696278431505938817087276882e-2) }}, 
      {{ SC_(0.7444499991834163665771484375e-2), SC_(0.99292266368865966796875e0), SC_(0.74444321988199504330861521619247593689621297824599e-2) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(-0.804919183254241943359375e0), SC_(0.14335686705725696407060645727945600655565741414147e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(-0.74602639675140380859375e0), SC_(0.14335731558581990142476732612631387140359085570156e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(-0.72904598712921142578125e0), SC_(0.14335743858193055553888894193489743522839559243509e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(-0.62323606014251708984375e0), SC_(0.14335814120326027832379597580040828122216388507481e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(-0.5579319000244140625e0), SC_(0.14335851997467008238725204894793026916257019753693e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(-0.44300353527069091796875e0), SC_(0.14335908485363563424533546850245012850090360873434e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(-0.38366591930389404296875e0), SC_(0.14335932572318417439388238927592963489979339519294e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.9376299381256103515625e-1), SC_(0.14336000536285207953459760778071938813620926376329e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.944411754608154296875e-1), SC_(0.14336000473610715309472432563583032814457494094135e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.264718532562255859375e0), SC_(0.14335970443226789444113931927418674846075665585412e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.62944734096527099609375e0), SC_(0.14335810299578782495392921047255424568664286939309e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.67001712322235107421875e0), SC_(0.14335784411863985146631166860519228538944451465492e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.81158387660980224609375e0), SC_(0.14335681415313482527267826975008547916557671973967e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.826751708984375e0), SC_(0.14335669212508490437041994345359491275578416731562e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.91501367092132568359375e0), SC_(0.1433559372086014461936976066148820437936563510921e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.92977702617645263671875e0), SC_(0.14335580346584476426767024206037631424851951301064e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.93538987636566162109375e0), SC_(0.14335575205677374246197434850917518154812470284912e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.93773555755615234375e0), SC_(0.14335573048058908550764743332104831817119331680375e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.98576259613037109375e0), SC_(0.14335527683396662777675860041375777953747610473763e-1) }}, 
      {{ SC_(0.1433600485324859619140625e-1), SC_(0.99292266368865966796875e0), SC_(0.14335520726182617060139852455489440586802090752734e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(-0.804919183254241943359375e0), SC_(0.17608580108574407596974329704841169956949700562955e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(-0.74602639675140380859375e0), SC_(0.17608663231619667706144284604540728747274691033403e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(-0.72904598712921142578125e0), SC_(0.17608686025692226081166910626170820785576222384032e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(-0.62323606014251708984375e0), SC_(0.17608816237609089248262489588718703344935310646926e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(-0.5579319000244140625e0), SC_(0.17608886432433642683152813125927533432394416093985e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(-0.44300353527069091796875e0), SC_(0.17608991116840504430604382009436726055680942592846e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(-0.38366591930389404296875e0), SC_(0.176090357551125362347926995427228626500868394589e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.9376299381256103515625e-1), SC_(0.17609161706489009824375122022213121549814666772137e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.944411754608154296875e-1), SC_(0.17609161590340381771438539655887170786578607686625e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.264718532562255859375e0), SC_(0.17609105937855647197851193299561879969853300958653e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.62944734096527099609375e0), SC_(0.17608809156899384005720536484472837230830065065362e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.67001712322235107421875e0), SC_(0.17608761181057073227708699591125844960940811676035e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.81158387660980224609375e0), SC_(0.17608570304162501463076154868058948699689399732159e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.826751708984375e0), SC_(0.17608547689404223463630864650669183425712473803568e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.91501367092132568359375e0), SC_(0.17608407784672239506239468119798486189473586582955e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.92977702617645263671875e0), SC_(0.17608382998754781901869199398720568129229579547611e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.93538987636566162109375e0), SC_(0.17608373471347270582239268505690054737704285676384e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.93773555755615234375e0), SC_(0.17608369472730925070207638812129721785547912618809e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.98576259613037109375e0), SC_(0.1760828540033432824714172980056450648102099021249e-1) }}, 
      {{ SC_(0.1760916970670223236083984375e-1), SC_(0.99292266368865966796875e0), SC_(0.1760827250680427232498457772793807499892371857118e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(-0.804919183254241943359375e0), SC_(0.61501977006950685147287768516293323208160579222561e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(-0.74602639675140380859375e0), SC_(0.61505522489025659599931604724877390313025548257308e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(-0.72904598712921142578125e0), SC_(0.61506494675121255552513729228591687728362292179595e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(-0.62323606014251708984375e0), SC_(0.6151204783438311669516418454684974438012040582801e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(-0.5579319000244140625e0), SC_(0.61515041095618531533933041042944610555423576496996e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(-0.44300353527069091796875e0), SC_(0.61519504621160125867433869303576963606044911782478e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(-0.38366591930389404296875e0), SC_(0.61521407741571578777767245737873183733981816461528e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.9376299381256103515625e-1), SC_(0.61526777062967981169049636151844834926854584285419e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.944411754608154296875e-1), SC_(0.61526772111895451062409353986808208860857193530741e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.264718532562255859375e0), SC_(0.61524399735335177275474273521472375918132832837151e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.62944734096527099609375e0), SC_(0.61511745884028483102790380253646823175238112494646e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.67001712322235107421875e0), SC_(0.6150969993380767120526675862688574839444187666016e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.81158387660980224609375e0), SC_(0.61501558792980989731745029704453425507936947479545e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.826751708984375e0), SC_(0.6150059412689594790766306366724969854744633162111e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.91501367092132568359375e0), SC_(0.6149462572658848296026943427784475993369283738193e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.92977702617645263671875e0), SC_(0.61493568248035940269881357391157292683808423254872e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.93538987636566162109375e0), SC_(0.61493161758041224579051594027510051678482376027455e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.93773555755615234375e0), SC_(0.61492991154427406040710017225498992861736055228753e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.98576259613037109375e0), SC_(0.61489403968675255445594757668519531570161557334001e-1) }}, 
      {{ SC_(0.6152711808681488037109375e-1), SC_(0.99292266368865966796875e0), SC_(0.61488853799260647384525257050300692876228193751127e-1) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(-0.804919183254241943359375e0), SC_(0.11940159351652991642087635107572968021280491356493e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(-0.74602639675140380859375e0), SC_(0.11942762071829396048733749883613051021682286386073e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(-0.72904598712921142578125e0), SC_(0.11943475617239474629497253451891457719819822132972e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(-0.62323606014251708984375e0), SC_(0.11947550329635179606625307953230445565622088756883e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(-0.5579319000244140625e0), SC_(0.11949745915811193389695075959086858402078090470861e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(-0.44300353527069091796875e0), SC_(0.11953018963741346322165319442975512391777037152449e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(-0.38366591930389404296875e0), SC_(0.11954414137898877094879944738421764544396529920502e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.9376299381256103515625e-1), SC_(0.1195834921804170562568474669624073454993125331367e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.944411754608154296875e-1), SC_(0.11958345590276751842953375574122677488392674763143e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.264718532562255859375e0), SC_(0.11956607128021548072844495801612937580324335914271e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.62944734096527099609375e0), SC_(0.11947328816450132752169835924569094033180591400024e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.67001712322235107421875e0), SC_(0.11945827747732508482238164500953342523090935816124e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.81158387660980224609375e0), SC_(0.11939852293295489024456283834841921944198117803215e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.826751708984375e0), SC_(0.11939143982430379243843352157975729271012597587493e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.91501367092132568359375e0), SC_(0.11934760413857031705335418990966249231391480564468e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.92977702617645263671875e0), SC_(0.11933983512028402595181333144487621852351068127479e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.93538987636566162109375e0), SC_(0.11933684856578003526165946465617461351295689535782e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.93773555755615234375e0), SC_(0.11933559508099898217297810142098532520972110488427e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.98576259613037109375e0), SC_(0.11930923471047814074619306305775614928960324848883e0) }}, 
      {{ SC_(0.11958599090576171875e0), SC_(0.99292266368865966796875e0), SC_(0.11930519111527445236541508266188797205166808801345e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(-0.804919183254241943359375e0), SC_(0.15224623392135128578680619330449866771577238682122e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(-0.74602639675140380859375e0), SC_(0.15230033713946658950752983865173904269516800645461e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(-0.72904598712921142578125e0), SC_(0.15231516739375119917477976688943665577491066091918e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(-0.62323606014251708984375e0), SC_(0.15239983651503112649682258666440110081268937272464e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(-0.5579319000244140625e0), SC_(0.15244544538794094274525902173112038959961311329937e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(-0.44300353527069091796875e0), SC_(0.15251341875995068536469244827700455268806565305523e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(-0.38366591930389404296875e0), SC_(0.15254238679985931337567146181937132920154008973836e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.9376299381256103515625e-1), SC_(0.15262407046188851014921270597605552174731396772469e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.944411754608154296875e-1), SC_(0.15262399517134502490562721875740259768389539174152e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.264718532562255859375e0), SC_(0.1525879122137402352429747540288980455807227867214e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.62944734096527099609375e0), SC_(0.15239523449826308917160579764876251393662675458499e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.67001712322235107421875e0), SC_(0.15236404670155401714376875284315912431270385428872e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.81158387660980224609375e0), SC_(0.15223985015727243233689620438691615621218869025621e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.826751708984375e0), SC_(0.15222512361224625374547578609193034943889148186694e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.91501367092132568359375e0), SC_(0.15213396230380987320882128027780180899136897816778e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.92977702617645263671875e0), SC_(0.15211780174885177274370910735736555265731529501898e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.93538987636566162109375e0), SC_(0.15211158901157390502706763335244443821063889167839e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.93773555755615234375e0), SC_(0.1521089814147135141659163193040473742647528237765e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.98576259613037109375e0), SC_(0.1520541372380949020893748127479892420810366551134e0) }}, 
      {{ SC_(0.15262925624847412109375e0), SC_(0.99292266368865966796875e0), SC_(0.15204572308928941922694535278617983266242187978535e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(-0.804919183254241943359375e0), SC_(0.40087773847838692250599377386281200239812605761021e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(-0.74602639675140380859375e0), SC_(0.40190874907104190742266687116670835102616276359536e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(-0.72904598712921142578125e0), SC_(0.40219063116119237535715115066249936376943652529699e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(-0.62323606014251708984375e0), SC_(0.40379404878672778473045770121975900252569033833797e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(-0.5579319000244140625e0), SC_(0.40465366026345755178874727069996147915274182052549e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(-0.44300353527069091796875e0), SC_(0.40592956032851837395876207703781835375115306753739e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(-0.38366591930389404296875e0), SC_(0.40647143410211291015028648027745384098009512778998e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.9376299381256103515625e-1), SC_(0.4079934794784219868282542935099093235211913904893e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.944411754608154296875e-1), SC_(0.40799208054080733383412043058040143407336373603265e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.264718532562255859375e0), SC_(0.40732079857882022043521866955517522729905017636387e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.62944734096527099609375e0), SC_(0.40370715415748270886050626898809348109166668227234e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.67001712322235107421875e0), SC_(0.40311749948369311324045498984372099418497701077126e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.81158387660980224609375e0), SC_(0.40075580972366876584605938363354779695825695272009e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.826751708984375e0), SC_(0.40047431017887375506803582421963983831920170735876e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.91501367092132568359375e0), SC_(0.39872467472817423843989762742028917255315191362367e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.92977702617645263671875e0), SC_(0.39841322079218516274219285200467132068435667762241e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.93538987636566162109375e0), SC_(0.39829338138625534095200356535516738903620889921783e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.93773555755615234375e0), SC_(0.39824306529599668565264152008444297067068527070376e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.98576259613037109375e0), SC_(0.39718240033425029422849871471704838858196403329514e0) }}, 
      {{ SC_(0.408089816570281982421875e0), SC_(0.99292266368865966796875e0), SC_(0.39701926661844557487217508134389279947772521093395e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(-0.804919183254241943359375e0), SC_(0.62522331487538074022825917796040968566573507875511e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(-0.74602639675140380859375e0), SC_(0.62944010005835347310947633106956030526960463441699e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(-0.72904598712921142578125e0), SC_(0.63058722441882207761841292783688165863615300163541e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(-0.62323606014251708984375e0), SC_(0.63706737330730808488005558734124053363169510869579e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(-0.5579319000244140625e0), SC_(0.64051121382140412221790264833005000507966070497052e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(-0.44300353527069091796875e0), SC_(0.64558595649337792095337773652653080354106518147584e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(-0.38366591930389404296875e0), SC_(0.64772836188639894302717596798865659637396954090751e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.9376299381256103515625e-1), SC_(0.6537069635023878618426694835256753522498828373194e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.944411754608154296875e-1), SC_(0.65370149423060049998526648357170182473256401270091e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.264718532562255859375e0), SC_(0.65107165036797609262224724632821416721537921994855e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.62944734096527099609375e0), SC_(0.63671810080087286219564326366975721131333859794536e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.67001712322235107421875e0), SC_(0.63434228874068145533071278393418018799392202624323e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.81158387660980224609375e0), SC_(0.62472239384386569111230671026640406599725147303377e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.826751708984375e0), SC_(0.62356405672673580029848515255238795623363670777346e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.91501367092132568359375e0), SC_(0.61630452496331986253041113084404331468209750721079e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.92977702617645263671875e0), SC_(0.61500097864475673111192722304305196291959713174315e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.93538987636566162109375e0), SC_(0.61449846585373303142455074938236361432978040499459e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.93773555755615234375e0), SC_(0.61428732215378190261322829618275502535126448964389e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.98576259613037109375e0), SC_(0.60981426733254549075843922364215605764678485220391e0) }}, 
      {{ SC_(0.6540834903717041015625e0), SC_(0.99292266368865966796875e0), SC_(0.60912245913255241754185533186562613329924721350394e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(-0.804919183254241943359375e0), SC_(0.97358076980581963214979957740641809690010032871498e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(-0.74602639675140380859375e0), SC_(0.99284261635986343530890870423642451505197092051096e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(-0.72904598712921142578125e0), SC_(0.99799717657418253873311393911450835120059461203911e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(-0.62323606014251708984375e0), SC_(0.10265146669393067798961767846142130025383852815092e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(-0.5579319000244140625e0), SC_(0.10412993131049983738821846778802937877887398184407e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(-0.44300353527069091796875e0), SC_(0.10626791213895727458974730171210587495749582852499e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(-0.38366591930389404296875e0), SC_(0.10715726991631194844715086904661806838247934897991e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.9376299381256103515625e-1), SC_(0.10960180450371527751749388123599541977039935839209e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.944411754608154296875e-1), SC_(0.10959959178963911636246396357479089365230913458689e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.264718532562255859375e0), SC_(0.1085307588270983137395984320679292591117855769782e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.62944734096527099609375e0), SC_(0.10250017111642034995968530653796236533683328385994e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.67001712322235107421875e0), SC_(0.10146402575381134424781556460512128266275614033932e1) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.81158387660980224609375e0), SC_(0.97125740974534056452551832813587223267950701145455e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.826751708984375e0), SC_(0.96585401343971995157426022835338799331733172449179e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.91501367092132568359375e0), SC_(0.93087613454943087704421229934262160482880771114428e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.92977702617645263671875e0), SC_(0.92435947741383209880306251092716774892053707866899e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.93538987636566162109375e0), SC_(0.92182511164582055119665026711580263575974688395746e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.93773555755615234375e0), SC_(0.92075640715667306226202947709957133854495533453504e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.98576259613037109375e0), SC_(0.89752615752053353845738311032151978950979954505705e0) }}, 
      {{ SC_(0.1097540378570556640625e1), SC_(0.99292266368865966796875e0), SC_(0.89382068911421126061217108491550697038968667547063e0) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(-0.746025502681732177734375e0), SC_(0.20606948435553395590824575106717672337532725557054e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(-0.729045093059539794921875e0), SC_(0.20858197299728117364713717259787406867294493268913e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(-0.557931125164031982421875e0), SC_(0.22894234426001721773416713893403381076946469595761e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(-0.38366520404815673828125e0), SC_(0.24257333087184108449743582987567124940455016242611e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.26471889019012451171875e0), SC_(0.24863297461620451392065876231613437352714077748701e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.629447519779205322265625e0), SC_(0.22141741803463461293944784056846771544822087170898e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.670017302036285400390625e0), SC_(0.21655199139056638540725221233525474068485862941694e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.811583995819091796875e0), SC_(0.19527311832302614803373557823539383964559728957586e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.826751768589019775390625e0), SC_(0.19248895773095513740300312496230532259922126635573e1) }}, 
      {{ SC_(0.2539736270904541015625e1), SC_(0.937735617160797119140625e0), SC_(0.16717943098455195529310991682026902826908198208045e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(-0.746025502681732177734375e0), SC_(0.22184580794979653971201742020111621976224445127624e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(-0.729045093059539794921875e0), SC_(0.22441452387610873267122698779043437245731497203019e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(-0.557931125164031982421875e0), SC_(0.24526061122275048579533316315210129083300132363638e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(-0.38366520404815673828125e0), SC_(0.25924400069523964196047849930161341834936783435732e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.26471889019012451171875e0), SC_(0.26546664812765387292489382317562053772809047876253e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.629447519779205322265625e0), SC_(0.2375501871506669700925943115561488937861633211455e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.670017302036285400390625e0), SC_(0.23256847813233190187753887336237443134156207212024e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.811583995819091796875e0), SC_(0.21081802123998041997969678911354025634560737710665e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.826751768589019775390625e0), SC_(0.20797699889679274128699246900504616733139759172985e1) }}, 
      {{ SC_(0.27095401287078857421875e1), SC_(0.937735617160797119140625e0), SC_(0.18221151183801884028067383734533766684821378125347e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(-0.804919183254241943359375e0), SC_(0.24966589961325599268221995946805641031689252487049e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(-0.74602639675140380859375e0), SC_(0.25960501394971412975900561652162250216491366170856e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(-0.72904598712921142578125e0), SC_(0.26220711502622234559264465533236396384241845212442e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(-0.62323606014251708984375e0), SC_(0.27625466426905881315055585967058535457063901073405e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(-0.5579319000244140625e0), SC_(0.28334469762829322200644742292437271592339037175022e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(-0.44300353527069091796875e0), SC_(0.29341160586103434126405449706997785098201059382841e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(-0.38366591930389404296875e0), SC_(0.29754295823615905718580189633551539775555543180419e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.9376299381256103515625e-1), SC_(0.30875250779662108495021400635872294087615435039158e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.944411754608154296875e-1), SC_(0.30874244998889923463791010006402273081656749816566e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.264718532562255859375e0), SC_(0.30386598032520992270715096668318673176158242824106e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.62944734096527099609375e0), SC_(0.27552242219968067063681238173120084004766454909705e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.67001712322235107421875e0), SC_(0.27047094380143394760995618020031882608831817214288e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.81158387660980224609375e0), SC_(0.24844080382738187460131716973309269340302648290835e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.826751708984375e0), SC_(0.24556640918901794130358411103680426047070343802371e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.91501367092132568359375e0), SC_(0.22581214856834495063480250802851614997776341399303e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.92977702617645263671875e0), SC_(0.22181274072350009795300888143074598471657186923109e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.93538987636566162109375e0), SC_(0.22021690304825114090225800638603978580592312397702e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.93773555755615234375e0), SC_(0.21953629436834643253771177954924738788998620384537e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.98576259613037109375e0), SC_(0.20289662407902669010943414872019445993549312038813e1) }}, 
      {{ SC_(0.30944411754608154296875e1), SC_(0.99292266368865966796875e0), SC_(0.19956012661512807858781973557149956496146241937617e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(-0.746025502681732177734375e0), SC_(0.37671885599157883291888879306071148970461163854417e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(-0.729045093059539794921875e0), SC_(0.38010428438032877561255280902574224339063138286022e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(-0.557931125164031982421875e0), SC_(0.4077288838442777482264521651646610468827663767543e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(-0.38366520404815673828125e0), SC_(0.4263837274235952634866093836362018199067995934673e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.26471889019012451171875e0), SC_(0.43471180936852849800199789250097491615323458505614e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.629447519779205322265625e0), SC_(0.39748260204362937713742640050702888121054133123283e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.670017302036285400390625e0), SC_(0.39087959518515946851012024222639255565129674465982e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.811583995819091796875e0), SC_(0.36224145017411978773815035029374687756122913807008e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.826751768589019775390625e0), SC_(0.35852835494424491289403755839868444023176297138091e1) }}, 
      {{ SC_(0.4420680999755859375e1), SC_(0.937735617160797119140625e0), SC_(0.32529050407115750526409300420610566795238770575452e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(-0.804919183254241943359375e0), SC_(0.40649742361758996182193721586198335678185195390056e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(-0.74602639675140380859375e0), SC_(0.42407205988487990230865760675097389160329171550655e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(-0.72904598712921142578125e0), SC_(0.42866194892330269259984093995907378568943010060222e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(-0.62323606014251708984375e0), SC_(0.45337225216642051682826738540837414057648592420988e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(-0.5579319000244140625e0), SC_(0.46580558191746459736878562728120645312485562256259e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(-0.44300353527069091796875e0), SC_(0.48342172200235668600302927269017412608599509088581e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(-0.38366591930389404296875e0), SC_(0.49063970236465748655529503955284751661922730351636e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.9376299381256103515625e-1), SC_(0.51019413492836552269988939281130221555088517524603e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.944411754608154296875e-1), SC_(0.51017660804202934944174033208734166760825311108377e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.264718532562255859375e0), SC_(0.50167501245734356768540125877502595711140481630397e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.62944734096527099609375e0), SC_(0.4520868054009284772995718224197102131757224348837e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.67001712322235107421875e0), SC_(0.44321152860655340802540045094573522968889573572411e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.81158387660980224609375e0), SC_(0.4043260224796061724399941700230178777652776440263e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.826751708984375e0), SC_(0.39922646259037948716093537743483596221786621196096e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.91501367092132568359375e0), SC_(0.36395484865797341150628669429352827727536291480368e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.92977702617645263671875e0), SC_(0.35675343153556408122538650005829418186488674701339e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.93538987636566162109375e0), SC_(0.35387270357964784236089639327883312464090232559874e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.93773555755615234375e0), SC_(0.35264275585053300717215077204783880710205031599261e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.98576259613037109375e0), SC_(0.32224223011463683291996839992817620518228498305602e1) }}, 
      {{ SC_(0.51139926910400390625e1), SC_(0.99292266368865966796875e0), SC_(0.31603381419503048253972861877193204490835414529538e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(-0.746025502681732177734375e0), SC_(0.51667012502980379461898875289291999981214269242786e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(-0.729045093059539794921875e0), SC_(0.52187368513321014104715814414709305645529259241246e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(-0.557931125164031982421875e0), SC_(0.56414319598861465893219034775202286253687816834462e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(-0.38366520404815673828125e0), SC_(0.59253552764849920201787681645997918639468877327057e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.26471889019012451171875e0), SC_(0.60517951198996061900872892967569621065549235628133e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.629447519779205322265625e0), SC_(0.54850058315491967388582768092489680485748613764955e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.670017302036285400390625e0), SC_(0.53839894879806611456636949153790476778381423510555e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.811583995819091796875e0), SC_(0.49434395273121454160560701796666025612557499346665e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.826751768589019775390625e0), SC_(0.48859581068465552634367513856474258488740249891201e1) }}, 
      {{ SC_(0.616334056854248046875e1), SC_(0.937735617160797119140625e0), SC_(0.43654050578874159400773930861758695751496514187013e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(-0.804919183254241943359375e0), SC_(0.77136146906088677425264272482883176369286481419599e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(-0.74602639675140380859375e0), SC_(0.80118013860105363210218143929900357319985605144755e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(-0.72904598712921142578125e0), SC_(0.80898680556235258193316064147736202843180417156732e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(-0.62323606014251708984375e0), SC_(0.8511315308683729273758679464197894065484024124487e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(-0.5579319000244140625e0), SC_(0.87240275075120340182990906663883774796713254440042e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(-0.44300353527069091796875e0), SC_(0.90260514522865427669612028384755250538027384103773e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(-0.38366591930389404296875e0), SC_(0.91499991427692940745883168029740655894361701789444e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.9376299381256103515625e-1), SC_(0.94863057144862190225682867443713708524807003150009e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.944411754608154296875e-1), SC_(0.94860039617347090460051866847732454807723897228135e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.264718532562255859375e0), SC_(0.93397009976641663899466433140384802110682769979558e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.62944734096527099609375e0), SC_(0.84893469169604569670711335846314472062066099711682e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.67001712322235107421875e0), SC_(0.83377949107106217825548050584221381545333611376562e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.81158387660980224609375e0), SC_(0.76768602522661609494793804271972367745790429985765e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.826751708984375e0), SC_(0.75906248037474697255279272971596822908517107621838e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.91501367092132568359375e0), SC_(0.69979746531203014449954466015965693163485850087946e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.92977702617645263671875e0), SC_(0.68779884608548303292899961043004036990044181837584e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.93538987636566162109375e0), SC_(0.68301118095634658082855905750210855770914175711587e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.93773555755615234375e0), SC_(0.68096929107873634247927365160052985738547786973975e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.98576259613037109375e0), SC_(0.63104893790109956868661123771970614094301307005046e1) }}, 
      {{ SC_(0.95070552825927734375e1), SC_(0.99292266368865966796875e0), SC_(0.6210392396338984857582476239045604900996293467409e1) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(-0.746025502681732177734375e0), SC_(0.10653538970236647615480809194456539078299223044901e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(-0.729045093059539794921875e0), SC_(0.10757626738803613551565262041921891845552920393775e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(-0.557931125164031982421875e0), SC_(0.1160316253958585467164577335025405203848761058251e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(-0.38366520404815673828125e0), SC_(0.12171117565603642524502696012778576125730417642359e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.26471889019012451171875e0), SC_(0.12424048173526351202025724421124918552082251415423e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.629447519779205322265625e0), SC_(0.11290254160795181871925641179301890117412347414617e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.670017302036285400390625e0), SC_(0.11088186621805165818165302782365444898327250556274e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.811583995819091796875e0), SC_(0.1020694796764127067619946436108138573035166051701e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.826751768589019775390625e0), SC_(0.10091968682401590180018899342329066590460564132281e2) }}, 
      {{ SC_(0.1264718532562255859375e2), SC_(0.937735617160797119140625e0), SC_(0.90507329377618259595498984086557298983272927625963e1) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(-0.746025502681732177734375e0), SC_(0.13784521468002260032830612582772624143561302320573e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(-0.729045093059539794921875e0), SC_(0.13915458791365675023265680192667340580620135300383e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(-0.557931125164031982421875e0), SC_(0.14979561147101185478546235281066599605118632279816e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(-0.38366520404815673828125e0), SC_(0.15694752545469067028774200091139254989461735354799e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.26471889019012451171875e0), SC_(0.16013353139381842613324769456926764052295579088234e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.629447519779205322265625e0), SC_(0.14585675620452694842566737536525641950850829741502e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.670017302036285400390625e0), SC_(0.14331371650756724156722446880010765968912841082353e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.811583995819091796875e0), SC_(0.13222885048234084764513779251503819172897378461364e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.826751768589019775390625e0), SC_(0.13078328257639057534548908564659500463659583141858e2) }}, 
      {{ SC_(0.162944736480712890625e2), SC_(0.937735617160797119140625e0), SC_(0.11770137850789958016758667532132414633028714217042e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(-0.746025502681732177734375e0), SC_(0.14128322944727813270320008156208189411607964356057e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(-0.729045093059539794921875e0), SC_(0.14262303387968871533731534702557260886716116918925e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(-0.557931125164031982421875e0), SC_(0.15352002249094351296781815596508348723508379422342e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(-0.38366520404815673828125e0), SC_(0.16085098656320784280811799665131950596018820059305e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.26471889019012451171875e0), SC_(0.16411819978040450666580803067616777058580953611619e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.629447519779205322265625e0), SC_(0.14948478355307172142569426978676013882554076892178e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.670017302036285400390625e0), SC_(0.14688048855947871334824645163386108910506173269061e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.811583995819091796875e0), SC_(0.13553959558824892053958981203587009794537636045778e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.826751768589019775390625e0), SC_(0.13406222268398232679728917528579007902775776934482e2) }}, 
      {{ SC_(0.167001705169677734375e2), SC_(0.937735617160797119140625e0), SC_(0.12071626784174372426100624134053082284140599127615e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(-0.746025502681732177734375e0), SC_(0.15159739173172581363783198952635101542721961699771e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(-0.729045093059539794921875e0), SC_(0.15314257415471888419514665290744734332948047372087e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(-0.557931125164031982421875e0), SC_(0.16568661977229522614616080453985283825248521667222e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(-0.38366520404815673828125e0), SC_(0.17410546992376683792758792483313517569542111428637e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.26471889019012451171875e0), SC_(0.17785304179414303257139485762582850264887992141587e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.629447519779205322265625e0), SC_(0.16104599980275333702969936821150635738838459547235e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.670017302036285400390625e0), SC_(0.15804826051230434644438176943141596905308787147794e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.811583995819091796875e0), SC_(0.14496504201425767930308456115143773987217221079921e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.826751768589019775390625e0), SC_(0.14325672492868025087046123806824342703136113105287e2) }}, 
      {{ SC_(0.181158390045166015625e2), SC_(0.937735617160797119140625e0), SC_(0.12776994408705170294497229724623086805282427381906e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(-0.746025502681732177734375e0), SC_(0.15294680181863217643351199614623519336837101935148e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(-0.729045093059539794921875e0), SC_(0.15449996816318134429379707744699879178221731695988e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(-0.557931125164031982421875e0), SC_(0.16711225137527882111994431225484349414920827404575e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(-0.38366520404815673828125e0), SC_(0.17557986140719412110073486816905803540813830571612e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.26471889019012451171875e0), SC_(0.17934979435249067274995396347671578186369882165268e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.629447519779205322265625e0), SC_(0.16244572001238844765170304697384194165407574561166e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.670017302036285400390625e0), SC_(0.15943164568755228239946894179666815707263079411025e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.811583995819091796875e0), SC_(0.14628139102102744259739666593315074730653759163808e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.826751768589019775390625e0), SC_(0.14456489920621798386112303504456619040483195805351e2) }}, 
      {{ SC_(0.1826751708984375e2), SC_(0.937735617160797119140625e0), SC_(0.12901176802885551607449079455698545619295133053525e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(-0.746025502681732177734375e0), SC_(0.16373768104669207594805580038875573404930513441141e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(-0.729045093059539794921875e0), SC_(0.16530503377588252332123798771909333002264706286237e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(-0.557931125164031982421875e0), SC_(0.17804058754070622422766997709671427593350718649892e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(-0.38366520404815673828125e0), SC_(0.18659842238649258536607864613522185923147834958364e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.26471889019012451171875e0), SC_(0.19041030605847353537553971598984547853104130787962e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.629447519779205322265625e0), SC_(0.17332682733638471968076741364997786992867783129002e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.670017302036285400390625e0), SC_(0.17028324148549023912783662691488402026075436758155e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.811583995819091796875e0), SC_(0.15701406907247747111941107887807025988255322067759e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.826751768589019775390625e0), SC_(0.15528332343584439448389189168804413412072962805104e2) }}, 
      {{ SC_(0.193773555755615234375e2), SC_(0.937735617160797119140625e0), SC_(0.13961657625936999843598239494906227678346385879793e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(-0.804919183254241943359375e0), SC_(0.19973712815825299667336984155088357850125615023123e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(-0.74602639675140380859375e0), SC_(0.20768004459970888039199267530797007460378708348059e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(-0.72904598712921142578125e0), SC_(0.20975943494043643277033667107384491638216384996087e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(-0.62323606014251708984375e0), SC_(0.22098443919543021942239317650015874567854619599202e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(-0.5579319000244140625e0), SC_(0.22664947340796186155366996806574897452369784765661e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(-0.44300353527069091796875e0), SC_(0.23469261598109129306359004629782265062848360423816e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(-0.38366591930389404296875e0), SC_(0.23799328593005125768727498081978362209712153932061e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.9376299381256103515625e-1), SC_(0.24694852720359920299551294559883862642318482599145e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.944411754608154296875e-1), SC_(0.24694049235688264750968213166432298305126846672919e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.264718532562255859375e0), SC_(0.24304478584680961005931801432386351667362783289287e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.62944734096527099609375e0), SC_(0.22039935221994627954183192969119948491358660108522e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.67001712322235107421875e0), SC_(0.21636296414446293970175857383590143009540439330899e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.81158387660980224609375e0), SC_(0.19875804168183088026665735450886894189681201632558e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.826751708984375e0), SC_(0.19646081172044826743084650552577425186190287709336e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.91501367092132568359375e0), SC_(0.18067160258877176951344927132690170586626964142213e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.92977702617645263671875e0), SC_(0.17747460257589178862266160366202249788012092338898e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.93538987636566162109375e0), SC_(0.1761989043638227807923381411637723086292075460006e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.93773555755615234375e0), SC_(0.17565482547753583589691333584786894138119947266515e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.98576259613037109375e0), SC_(0.16235168852347324251833412843526594759633037668815e2) }}, 
      {{ SC_(0.24750102996826171875e2), SC_(0.99292266368865966796875e0), SC_(0.15968381270631338011523879835516013766575733453686e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(-0.804919183254241943359375e0), SC_(0.51735076982937951254171869082026686330395931657756e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(-0.74602639675140380859375e0), SC_(0.53735253525316134052564359957264589213799006829359e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(-0.72904598712921142578125e0), SC_(0.54259002788506760633617386042907016100264309943144e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(-0.62323606014251708984375e0), SC_(0.57087088411384188443059036724130943024517238989915e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(-0.5579319000244140625e0), SC_(0.58514821144592672620816994129808760700883696698888e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(-0.44300353527069091796875e0), SC_(0.60542369689374696573684154327407535366063815034119e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(-0.38366591930389404296875e0), SC_(0.61374566177446927418580325097452063248689623107673e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.9376299381256103515625e-1), SC_(0.63632855404412900606970850559558711372112158070995e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.944411754608154296875e-1), SC_(0.63630828959803323604085377439494768567131998295705e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.264718532562255859375e0), SC_(0.62648357705824211187974249016595230244678166587558e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.62944734096527099609375e0), SC_(0.56939648192191960771973930506667154426504267417061e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.67001712322235107421875e0), SC_(0.55922578474864948169973560210668458622933042213651e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.81158387660980224609375e0), SC_(0.51488577520720272133497076956397448336502677313913e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.826751708984375e0), SC_(0.50910264549849546254066916309118645291651994625069e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.91501367092132568359375e0), SC_(0.46937509984942940045851986231767768021174403986936e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.92977702617645263671875e0), SC_(0.46133618758338888010268807150354721574616537539013e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.93538987636566162109375e0), SC_(0.45812898641153494108307738842855998347397656315438e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.93773555755615234375e0), SC_(0.45676123380369536364985025253679313558219859857273e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.98576259613037109375e0), SC_(0.42334171739294930109632841225610524120215098033768e2) }}, 
      {{ SC_(0.637722015380859375e2), SC_(0.99292266368865966796875e0), SC_(0.41664672795248799701393038401300753761810137139415e2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(-0.804919183254241943359375e0), SC_(0.10137468822760781607784774270981389840101266483832e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(-0.74602639675140380859375e0), SC_(0.10534954334948361003000417646652824404574675668826e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(-0.72904598712921142578125e0), SC_(0.10639016759084929339444178511460542264340872987764e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(-0.62323606014251708984375e0), SC_(0.11200795729026387473537304781098683277197588766149e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(-0.5579319000244140625e0), SC_(0.11484331104327320120318357756153273925013856305548e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(-0.44300353527069091796875e0), SC_(0.11886909510926264047059962380263040095638955867975e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(-0.38366591930389404296875e0), SC_(0.12052122010812007576222077355913806951856516620111e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.9376299381256103515625e-1), SC_(0.12500387135949011803045698967769359044120246547929e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.944411754608154296875e-1), SC_(0.12499984931060490591196138981515034443752207624849e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.264718532562255859375e0), SC_(0.12304977687189097618316695768097733194153360043434e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.62944734096527099609375e0), SC_(0.11171512713122776131362764054699403290641206227743e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.67001712322235107421875e0), SC_(0.10969498814359799656230657020295638012242837420475e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.81158387660980224609375e0), SC_(0.10088474339952115871348342782761419290971427670271e3) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.826751708984375e0), SC_(0.99735201367471668012729563209452870009080433897514e2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.91501367092132568359375e0), SC_(0.9183483821328090539030255660612587397255470446336e2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.92977702617645263671875e0), SC_(0.90235313741876110793793852044195888545454411231332e2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.93538987636566162109375e0), SC_(0.89597070499289576537977775936679148370391280099975e2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.93773555755615234375e0), SC_(0.89324865581406130469577188264349272423780191543836e2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.98576259613037109375e0), SC_(0.82669810066174027119944981658463812969668940194645e2) }}, 
      {{ SC_(0.1252804412841796875e3), SC_(0.99292266368865966796875e0), SC_(0.81335336040403656795313736128885158841116166974535e2) }}, 
      {{ SC_(0.25554705810546875e3), SC_(-0.804919183254241943359375e0), SC_(0.20700764550973680328414434800314432777055331427509e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(-0.74602639675140380859375e0), SC_(0.21507675778547769857538831564203470809107041641983e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(-0.72904598712921142578125e0), SC_(0.21718939686269735659654564097856865186822722458893e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(-0.62323606014251708984375e0), SC_(0.22859526280607275338353573784442332068563806082921e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(-0.5579319000244140625e0), SC_(0.23435239148172642455597581779392343214733312300889e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(-0.44300353527069091796875e0), SC_(0.24252714708405922784431827584940960429251369448148e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(-0.38366591930389404296875e0), SC_(0.24588210249372783105511815543504926950563073881809e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.9376299381256103515625e-1), SC_(0.25498538673690232815276745549123439517935261161815e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.944411754608154296875e-1), SC_(0.25497721858372113341055046559555104133881772296172e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.264718532562255859375e0), SC_(0.25101697810342330109978559528463285788854960697461e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.62944734096527099609375e0), SC_(0.22800069422528238571057630900516236406892483089531e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.67001712322235107421875e0), SC_(0.22389905343162223015078630824991304867795682926707e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.81158387660980224609375e0), SC_(0.20601309721659152994566457489652136325089156338786e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.826751708984375e0), SC_(0.20367967493557321005729149965570117740057541402533e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.91501367092132568359375e0), SC_(0.18764538276020807800382713164047910157306345187704e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.92977702617645263671875e0), SC_(0.1843996681133032922634723517455258521499005783416e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.93538987636566162109375e0), SC_(0.1831046323187958486393495047159210748715027471244e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.93773555755615234375e0), SC_(0.1825523244747659902152705106996228088807575562519e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.98576259613037109375e0), SC_(0.16905218202575964307858592053003848753493846326679e3) }}, 
      {{ SC_(0.25554705810546875e3), SC_(0.99292266368865966796875e0), SC_(0.166346118226110245517811474013176433963082627576e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(-0.804919183254241943359375e0), SC_(0.4073596809171988389742398150263813958066525852733e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(-0.74602639675140380859375e0), SC_(0.42326320799414536197030693961463823357039321817358e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(-0.72904598712921142578125e0), SC_(0.42742682818966336795606721796292568150309618969066e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(-0.62323606014251708984375e0), SC_(0.44990438001330262518694919031753384020576625696966e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(-0.5579319000244140625e0), SC_(0.46124922502921161009662440273528750616727045937458e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(-0.44300353527069091796875e0), SC_(0.47735745567472002811275473463900479664220214084528e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(-0.38366591930389404296875e0), SC_(0.48396812043024017707709837542494532143253698991882e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.9376299381256103515625e-1), SC_(0.50190480963296507338418291149366181766024849187853e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.944411754608154296875e-1), SC_(0.50188871584285852712073221168824514015029692480846e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.264718532562255859375e0), SC_(0.49408574205216958037913559664441409041763723627144e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.62944734096527099609375e0), SC_(0.448732712753173223917291380485323902266910100027e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.67001712322235107421875e0), SC_(0.44064980515604668179870304048719969769816683101636e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.81158387660980224609375e0), SC_(0.40539941613509322668871139516155737996637247323477e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.826751708984375e0), SC_(0.40080012733999218534312909286248833728961899399719e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.91501367092132568359375e0), SC_(0.36919171399237342314526184351256549304483460904576e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.92977702617645263671875e0), SC_(0.36279237787744593399714035595038205138016721213798e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.93538987636566162109375e0), SC_(0.36023892853829175638985926444127462444440080265681e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.93773555755615234375e0), SC_(0.35914990886887487679557974420087323548020127919695e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.98576259613037109375e0), SC_(0.33252547245143178927979205996695688705563461577588e3) }}, 
      {{ SC_(0.503011474609375e3), SC_(0.99292266368865966796875e0), SC_(0.32718692844071197014439649471431843150228446330379e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(-0.804919183254241943359375e0), SC_(0.81566217335361231611771646986187800572268739295575e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(-0.74602639675140380859375e0), SC_(0.84755287064438863615038784712657137407744566356707e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(-0.72904598712921142578125e0), SC_(0.85590189104276483616202632098287025738931943507153e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(-0.62323606014251708984375e0), SC_(0.9009738212363659705854642096463530651141689117269e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(-0.5579319000244140625e0), SC_(0.92372203670774325404806275709264270484304517663929e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(-0.44300353527069091796875e0), SC_(0.95602114692228459835045237318476147078694497472822e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(-0.38366591930389404296875e0), SC_(0.96927625305559748266490795989045893214495805831554e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.9376299381256103515625e-1), SC_(0.10052408954500277585485462407617932594289289210602e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.944411754608154296875e-1), SC_(0.10052086262210379665209822645440559289291237665647e4) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.264718532562255859375e0), SC_(0.98956304231616558867754941531972183396056332288818e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.62944734096527099609375e0), SC_(0.89862442644009820675218558218153173632055069943683e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.67001712322235107421875e0), SC_(0.88241671832232838738799982334634993277048716392487e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.81158387660980224609375e0), SC_(0.81173128112196665137058131884505478065505214589458e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.826751708984375e0), SC_(0.80250834127587356001580304856418261116625810606362e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.91501367092132568359375e0), SC_(0.73912196799060491702381369566485537415592290789722e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.92977702617645263671875e0), SC_(0.7262884386240235721342337367344044620971138470138e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.93538987636566162109375e0), SC_(0.72116757185358740018078031894015653763422120624137e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.93773555755615234375e0), SC_(0.71898356440546660369364312811873716877046903540745e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.98576259613037109375e0), SC_(0.66558630336818747011593267003329852836650815741705e3) }}, 
      {{ SC_(0.10074598388671875e4), SC_(0.99292266368865966796875e0), SC_(0.6548786829121203110560807170365229948244134922981e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(-0.804919183254241943359375e0), SC_(0.95992720290264897479760554571647114770157610887996e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(-0.74602639675140380859375e0), SC_(0.99741366529362017349163653479322848619622124868772e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(-0.72904598712921142578125e0), SC_(0.10072278878934483167286843735137660835902486784055e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(-0.62323606014251708984375e0), SC_(0.10602110806127832608392589101187996342688647189112e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(-0.5579319000244140625e0), SC_(0.10869529954610434278852140581154818972542686423743e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(-0.44300353527069091796875e0), SC_(0.11249233882184205470868187837372292890877647671181e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(-0.38366591930389404296875e0), SC_(0.11405061649275106998721240053724233425466223964298e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.9376299381256103515625e-1), SC_(0.11827870772689532014486419251476519345293661688085e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.944411754608154296875e-1), SC_(0.11827491403552705968358829702474865775810482378628e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.264718532562255859375e0), SC_(0.11643556929058415420471543503560945498245581125436e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.62944734096527099609375e0), SC_(0.10574492529652112224851625390587579547328457881061e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.67001712322235107421875e0), SC_(0.1038396462932344155293121667046538419874167990145e4) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.81158387660980224609375e0), SC_(0.9553066699471665679840089770219957164232252629554e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.826751708984375e0), SC_(0.94446573985220084327197598058015000573173775032994e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.91501367092132568359375e0), SC_(0.86996356635663675306873109547180307652983494815843e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.92977702617645263671875e0), SC_(0.85488052815230820219522803855058047921692647892349e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.93538987636566162109375e0), SC_(0.84886217610355647741057825617131638665389927335333e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.93773555755615234375e0), SC_(0.84629542044995161715099588574641450818752524118888e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.98576259613037109375e0), SC_(0.78354531056875687291420826162420650224843893529921e3) }}, 
      {{ SC_(0.1185395751953125e4), SC_(0.99292266368865966796875e0), SC_(0.77096378731739644110407751882818742444499646261653e3) }}
   }};

