# Copyright (c) 2012 Linaro Ltd.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

import glob
import os
import subprocess
import unittest

import utils


@unittest.skipUnless(utils.file_on_path('pychecker', os.environ['PATH']),
                     "pychecker not found")
class TestPychecker(unittest.TestCase):
    # pychecker can get confused if modules aren't passed in the right
    # order.
    order = ['config.py', 'tsort.py', 'utils.py', 'aptutils.py', 'tree.py',
             'xdeb.py', 'tests/__init__.py', 'tests/test_pep8.py',
             'tests/test_pychecker.py', 'tests/test_pyflakes.py',
             'tests/test_tree.py', 'tests/test_xdeb.py', ]

    def test_pychecker(self):
        # ignore return code
        proc = subprocess.Popen(
            ['pychecker', '-q', '-Q'] + self.order,
            stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        (stdout, stderr) = proc.communicate()
        self.assertEqual(b'', stdout)
        self.assertEqual(b'', stderr)

    def test_pychecker_no_missing(self):
        all_files = glob.glob('*.py') + glob.glob('tests/*.py')
        self.assertEqual(sorted(all_files), sorted(self.order))
