
/***************************************************************************
 *                    __            __ _ ___________                       *
 *                    \ \          / /| |____   ____|                      *
 *                     \ \        / / | |    | |                           *
 *                      \ \  /\  / /  | |    | |                           *
 *                       \ \/  \/ /   | |    | |                           *
 *                        \  /\  /    | |    | |                           *
 *                         \/  \/     |_|    |_|                           *
 *                                                                         *
 *                           Wiimms ISO Tools                              *
 *                         http://wit.wiimm.de/                            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *   This file is part of the WIT project.                                 *
 *   Visit http://wit.wiimm.de/ for project details and sources.           *
 *                                                                         *
 *   Copyright (c) 2009-2015 by Dirk Clemens <wiimm@wiimm.de>              *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   See file gpl-2.0.txt or http://www.gnu.org/licenses/gpl-2.0.txt       *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *   >>>  This file is automatically generated by './src/gen-ui.c'.  <<<   *
 *   >>>                   Do not edit this file!                    <<<   *
 *                                                                         *
 ***************************************************************************/


#ifndef WIT_UI_WDF_H
#define WIT_UI_WDF_H
#include "lib-std.h"
#include "ui.h"

//
///////////////////////////////////////////////////////////////////////////////
///////////////                enum enumOptions                 ///////////////
///////////////////////////////////////////////////////////////////////////////

typedef enum enumOptions
{
	OPT_NONE,

	//----- command specific options -----

	OPT_CHUNK,
	OPT_LONG,
	OPT_MINUS1,
	OPT_LIMIT,
	OPT_FILE_LIMIT,
	OPT_BLOCK_SIZE,
	OPT_WDF,
	OPT_WDF1,
	OPT_WDF2,
	OPT_WIA,
	OPT_CISO,
	OPT_WBI,
	OPT_SUFFIX,
	OPT_DEST,
	OPT_DEST2,
	OPT_STDOUT,
	OPT_KEEP,
	OPT_OVERWRITE,
	OPT_PRESERVE,
	OPT_AUTO_SPLIT,
	OPT_NO_SPLIT,
	OPT_SPLIT,
	OPT_SPLIT_SIZE,
	OPT_PREALLOC,
	OPT_CHUNK_MODE,
	OPT_CHUNK_SIZE,
	OPT_MAX_CHUNKS,
	OPT_COMPRESSION,
	OPT_MEM,

	OPT__N_SPECIFIC, // == 30 

	//----- global options -----

	OPT_VERSION,
	OPT_HELP,
	OPT_XHELP,
	OPT_WIDTH,
	OPT_QUIET,
	OPT_VERBOSE,
	OPT_LOGGING,
	OPT_IO,
	OPT_DIRECT,
	OPT_ALIGN_WDF,
	OPT_TEST,
	OPT_OLD,
	OPT_NEW,

	OPT__N_TOTAL // == 43

} enumOptions;

//
///////////////////////////////////////////////////////////////////////////////
///////////////               enum enumOptionsBit               ///////////////
///////////////////////////////////////////////////////////////////////////////

//	*****  only for verification  *****

//typedef enum enumOptionsBit
//{
//	//----- command specific options -----
//
//	OB_CHUNK		= 1llu << OPT_CHUNK,
//	OB_LONG			= 1llu << OPT_LONG,
//	OB_MINUS1		= 1llu << OPT_MINUS1,
//	OB_LIMIT		= 1llu << OPT_LIMIT,
//	OB_FILE_LIMIT		= 1llu << OPT_FILE_LIMIT,
//	OB_BLOCK_SIZE		= 1llu << OPT_BLOCK_SIZE,
//	OB_WDF			= 1llu << OPT_WDF,
//	OB_WDF1			= 1llu << OPT_WDF1,
//	OB_WDF2			= 1llu << OPT_WDF2,
//	OB_WIA			= 1llu << OPT_WIA,
//	OB_CISO			= 1llu << OPT_CISO,
//	OB_WBI			= 1llu << OPT_WBI,
//	OB_SUFFIX		= 1llu << OPT_SUFFIX,
//	OB_DEST			= 1llu << OPT_DEST,
//	OB_DEST2		= 1llu << OPT_DEST2,
//	OB_STDOUT		= 1llu << OPT_STDOUT,
//	OB_KEEP			= 1llu << OPT_KEEP,
//	OB_OVERWRITE		= 1llu << OPT_OVERWRITE,
//	OB_PRESERVE		= 1llu << OPT_PRESERVE,
//	OB_AUTO_SPLIT		= 1llu << OPT_AUTO_SPLIT,
//	OB_NO_SPLIT		= 1llu << OPT_NO_SPLIT,
//	OB_SPLIT		= 1llu << OPT_SPLIT,
//	OB_SPLIT_SIZE		= 1llu << OPT_SPLIT_SIZE,
//	OB_PREALLOC		= 1llu << OPT_PREALLOC,
//	OB_CHUNK_MODE		= 1llu << OPT_CHUNK_MODE,
//	OB_CHUNK_SIZE		= 1llu << OPT_CHUNK_SIZE,
//	OB_MAX_CHUNKS		= 1llu << OPT_MAX_CHUNKS,
//	OB_COMPRESSION		= 1llu << OPT_COMPRESSION,
//	OB_MEM			= 1llu << OPT_MEM,
//
//	//----- group & command options -----
//
//	OB_GRP_BASE		= 0,
//
//	OB_GRP_DEST		= OB_DEST
//				| OB_DEST2
//				| OB_OVERWRITE,
//
//	OB_GRP_DEST_PLUS	= OB_GRP_DEST
//				| OB_AUTO_SPLIT
//				| OB_NO_SPLIT
//				| OB_SPLIT
//				| OB_SPLIT_SIZE
//				| OB_PREALLOC
//				| OB_CHUNK_MODE
//				| OB_CHUNK_SIZE
//				| OB_MAX_CHUNKS
//				| OB_COMPRESSION
//				| OB_MEM,
//
//	OB_GRP_FILETYPE		= OB_WDF
//				| OB_WDF1
//				| OB_WDF2
//				| OB_WIA
//				| OB_CISO
//				| OB_WBI
//				| OB_SUFFIX,
//
//	OB_CMD_VERSION		= OB_LONG,
//
//	OB_CMD_HELP		= ~(u64)0,
//
//	OB_CMD_UNPACK		= OB_GRP_DEST_PLUS
//				| OB_STDOUT
//				| OB_KEEP
//				| OB_PRESERVE,
//
//	OB_CMD_PACK		= OB_CMD_UNPACK
//				| OB_GRP_FILETYPE,
//
//	OB_CMD_CAT		= OB_GRP_DEST,
//
//	OB_CMD_CMP		= OB_FILE_LIMIT
//				| OB_LIMIT
//				| OB_LONG
//				| OB_BLOCK_SIZE,
//
//	OB_CMD_DUMP		= OB_GRP_DEST
//				| OB_CHUNK
//				| OB_LONG
//				| OB_MINUS1,
//
//} enumOptionsBit;

//
///////////////////////////////////////////////////////////////////////////////
///////////////                enum enumCommands                ///////////////
///////////////////////////////////////////////////////////////////////////////

typedef enum enumCommands
{
	CMD__NONE,

	CMD_VERSION,
	CMD_HELP,

	CMD_PACK,
	CMD_UNPACK,
	CMD_CAT,
	CMD_CMP,
	CMD_DUMP,

	CMD__N // == 8

} enumCommands;

//
///////////////////////////////////////////////////////////////////////////////
///////////////                   enumGetOpt                    ///////////////
///////////////////////////////////////////////////////////////////////////////

typedef enum enumGetOpt
{
	GO_MINUS1		= '1',

	GO__ERR			= '?',

	GO_CISO			= 'C',
	GO_DEST2		= 'D',
	GO_LOGGING		= 'L',
	GO_VERSION		= 'V',
	GO_WDF			= 'W',
	GO_SPLIT_SIZE		= 'Z',

	GO_STDOUT		= 'c',
	GO_DEST			= 'd',
	GO_HELP			= 'h',
	GO_KEEP			= 'k',
	GO_LONG			= 'l',
	GO_OVERWRITE		= 'o',
	GO_PRESERVE		= 'p',
	GO_QUIET		= 'q',
	GO_SUFFIX		= 's',
	GO_TEST			= 't',
	GO_VERBOSE		= 'v',
	GO_SPLIT		= 'z',

	GO_XHELP		= 0x80,
	GO_WIDTH,
	GO_IO,
	GO_DIRECT,
	GO_CHUNK,
	GO_LIMIT,
	GO_FILE_LIMIT,
	GO_BLOCK_SIZE,
	GO_WDF1,
	GO_WDF2,
	GO_ALIGN_WDF,
	GO_WIA,
	GO_WBI,
	GO_AUTO_SPLIT,
	GO_NO_SPLIT,
	GO_PREALLOC,
	GO_CHUNK_MODE,
	GO_CHUNK_SIZE,
	GO_MAX_CHUNKS,
	GO_COMPRESSION,
	GO_MEM,
	GO_OLD,
	GO_NEW,

} enumGetOpt;

//
///////////////////////////////////////////////////////////////////////////////
///////////////                  external vars                  ///////////////
///////////////////////////////////////////////////////////////////////////////

extern const InfoOption_t OptionInfo[OPT__N_TOTAL+1];
extern const CommandTab_t CommandTab[];
extern const char OptionShort[];
extern const struct option OptionLong[];
extern u8 OptionUsed[OPT__N_TOTAL+1];
extern const u8 OptionIndex[OPT_INDEX_SIZE];
extern const InfoCommand_t CommandInfo[CMD__N+1];
extern const InfoUI_t InfoUI;

//
///////////////////////////////////////////////////////////////////////////////
///////////////                       END                       ///////////////
///////////////////////////////////////////////////////////////////////////////

#endif // WIT_UI_WDF_H

