## TFSA-2022-043: `CHECK`-failures during Grappler's `IsSimplifiableReshape`

### CVE Number
CVE-2022-23581

### Impact
The Grappler optimizer in TensorFlow can be used to cause a denial of service by altering a `SavedModel` such that [`IsSimplifiableReshape`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/grappler/optimizers/constant_folding.cc#L1687-L1742) would trigger `CHECK` failures.

### Patches
We have patched the issue in GitHub commits [ebc1a2ffe5a7573d905e99bd0ee3568ee07c12c1](https://github.com/tensorflow/tensorflow/commit/ebc1a2ffe5a7573d905e99bd0ee3568ee07c12c1), [1fb27733f943295d874417630edd3b38b34ce082](https://github.com/tensorflow/tensorflow/commit/1fb27733f943295d874417630edd3b38b34ce082), and [240655511cd3e701155f944a972db71b6c0b1bb6](https://github.com/tensorflow/tensorflow/commit/240655511cd3e701155f944a972db71b6c0b1bb6).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
