## TFSA-2021-111: Null pointer dereference in `CompressElement`

### CVE Number
CVE-2021-37637

### Impact
It is possible to trigger a null pointer dereference in TensorFlow by passing an
invalid input to `tf.raw_ops.CompressElement`:

```python
import tensorflow as tf

tf.raw_ops.CompressElement(components=[[]])
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/47a06f40411a69c99f381495f490536972152ac0/tensorflow/core/data/compression_utils.cc#L34)
was accessing the size of a buffer obtained from the return of a separate
function call before validating that said buffer is valid.

### Patches
We have patched the issue in GitHub commit
[5dc7f6981fdaf74c8c5be41f393df705841fb7c5](https://github.com/tensorflow/tensorflow/commit/5dc7f6981fdaf74c8c5be41f393df705841fb7c5).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360. Concurrently, it was resolved in `master` branch as it was also discovered
internally and fixed before the report was handled.
