/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebCallbacks_h
#define WebCallbacks_h

namespace blink {

// A WebCallbacks<S, T> represents a callback object. Typically it is created
// in Blink and passed to Chromium, and onSuccess or onError will be called
// from Chromium.
// When transferring ownership, use |std::unique_ptr<X>| as a type
// parameter. Otherwise, |const X&| or |X| for a type parameter. It is
// generally not preferred to use |X*| because the object ownership is not well
// specified.

template <typename S, typename T>
class WebCallbacks {
 public:
  virtual ~WebCallbacks() {}
  virtual void onSuccess(S) {}
  virtual void onError(T) {}
};

template <typename T>
class WebCallbacks<void, T> {
 public:
  virtual ~WebCallbacks() {}
  virtual void onSuccess() {}
  virtual void onError(T) {}
};

template <typename S>
class WebCallbacks<S, void> {
 public:
  virtual ~WebCallbacks() {}
  virtual void onSuccess(S) {}
  virtual void onError() {}
};

template <>
class WebCallbacks<void, void> {
 public:
  virtual ~WebCallbacks() {}
  virtual void onSuccess() {}
  virtual void onError() {}
};

}  // namespace blink

#endif
