// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "core/css/BinaryDataFontFaceSource.h"

#include "platform/SharedBuffer.h"
#include "platform/fonts/FontCustomPlatformData.h"
#include "platform/fonts/FontDescription.h"
#include "platform/fonts/SimpleFontData.h"

namespace blink {

BinaryDataFontFaceSource::BinaryDataFontFaceSource(SharedBuffer* data,
                                                   String& otsParseMessage)
    : m_customPlatformData(
          FontCustomPlatformData::create(data, otsParseMessage)) {}

BinaryDataFontFaceSource::~BinaryDataFontFaceSource() {}

bool BinaryDataFontFaceSource::isValid() const {
  return m_customPlatformData.get();
}

PassRefPtr<SimpleFontData> BinaryDataFontFaceSource::createFontData(
    const FontDescription& fontDescription) {
  return SimpleFontData::create(
      m_customPlatformData->fontPlatformData(
          fontDescription.effectiveFontSize(),
          fontDescription.isSyntheticBold(),
          fontDescription.isSyntheticItalic(), fontDescription.orientation()),
      CustomFontData::create());
}

}  // namespace blink
