/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecificationVisitorFactory;
import proguard.KeepClassSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassVisitor;

public class LibraryKeepChecker
implements ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private String keepName;

    public LibraryKeepChecker(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.notePrinter = warningPrinter;
    }

    public void checkClassSpecifications(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)list.get(i);
                this.keepName = keepClassSpecification.className;
                if (this.keepName == null) continue;
                ClassCounter classCounter = new ClassCounter();
                this.programClassPool.accept(ClassSpecificationVisitorFactory.createClassPoolVisitor(keepClassSpecification, (ClassVisitor)classCounter, null));
                if (classCounter.getCount() != 0) continue;
                this.libraryClassPool.accept(ClassSpecificationVisitorFactory.createClassPoolVisitor(keepClassSpecification, (ClassVisitor)this, null));
            }
        }
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        String string = libraryClass.getName();
        this.notePrinter.print(string, "Note: the configuration explicitly specifies '" + ClassUtil.externalClassName(this.keepName) + "' to keep library class '" + ClassUtil.externalClassName(string) + "'");
    }
}

