include(images/images.pro)

HTMLDIR=$$PWD/html

QHP_FILE = $$HTMLDIR/qsource-highlight.qhp
QCH_FILE = $$PWD/qsource-highlight.qch
QHC_FILE = $$PWD/qsource-highlight.qhc
QHCP_FILE = $$PWD/qsource-highlight.qhcp
MAN_FILE = $$PWD/qsource-highlight.1

mans.files = $$MAN_FILE
mans.path = /share/man/man1/

html_docs.files = \
    $$QHP_FILE \
    $$HTMLDIR/*.html $$HTMLDIR/*.dcf $$HTMLDIR/*.css $$HTMLDIR/*.index

qch_docs.files = $$QCH_FILE

qhc_docs.files = $$QHC_FILE

unix:!macx {
    qhc_docs.path = /share/doc/qsource-highlight
    qch_docs.path = /share/doc/qsource-highlight
    html_docs.path = /share/doc/qsource-highlight/html
}

macx {
    DOC_DIR = $${OUT_PWD}/bin/qsource-highlight.app/Contents/Resources/doc
    cp_docs.commands = mkdir -p $${DOC_DIR} ; $${QMAKE_COPY} $${QCH_FILE} $${DOC_DIR} ; $${QMAKE_COPY} $${QHC_FILE} $${DOC_DIR}
    cp_docs.depends += qhc_docs
    docs.depends = html_docs cp_docs
    QMAKE_EXTRA_TARGETS += html_docs qhc_docs qch_docs cp_docs docs
}
!macx {
    docs.depends = html_docs qch_docs qhc_docs
    QMAKE_EXTRA_TARGETS += html_docs qhc_docs qch_docs cp_docs docs
}

INSTALLS += qhc_docs qch_docs html_docs mans

OTHER_FILES = qsource-highlight.qdoc \
              qsource-highlight.qdocconf \
              qsource-highlight.source.qhcp \
              qsource-highlight.1
