#!/usr/bin/env python
"""Tests the Entity data structure and hierarchy. This is tricky to keep 
independent from the PDBParser. Tests entity.py.
"""
from copy import deepcopy, copy
import cPickle
from cogent.util.unit_test import TestCase, main
from cogent.core.entity import Atom
from cogent.core.sequence import ProteinSequence
from cogent.parse.pdb import PDBParser


__author__ = "Marcin Cieslik"
__copyright__ = "Copyright 2007-2012, The Cogent Project"
__credits__ = ["Marcin Cieslik"]
__license__ = "GPL"
__version__ = "1.5.3"
__maintainer__ = "Marcin Cieslik"
__email__ = "mpc4p@virginia.edu"
__status__ = "Development"


class DummyFile(object):
    def __init__(self, some_string):
        self.some_string = some_string
        slist = self.some_string.split('\n')
        self.some_string_list = [i + '\n' for i in slist]
    def readlines(self):
        return self.some_string_list
    def close(self):
        pass

test_file = """
ATOM      1  N   ASP A  10     143.224  41.252  20.262  1.00 33.32           N
ATOM      2  CA  ASP A  10     143.865  39.983  20.718  1.00 33.75           C
ATOM      3  C   ASP A  10     143.660  38.778  19.790  1.00 32.25           C
ATOM      4  O   ASP A  10     144.253  37.736  20.022  1.00 37.02           O
ATOM      5  CB  ASP A  10     143.405  39.643  22.148  1.00 35.94           C
ATOM      1  N   ASP A  10A    143.224  41.252  20.262  1.00 33.32           N
ATOM      2  CA  ASP A  10A    143.865  39.983  20.718  1.00 33.75           C
ATOM      3  C   ASP A  10A    143.660  38.778  19.790  1.00 32.25           C
ATOM      4  O   ASP A  10A    144.253  37.736  20.022  1.00 37.02           O
ATOM      5  CB  ASP A  10A    143.405  39.643  22.148  1.00 35.94           C
ATOM      6  N   LYS A  11     142.780  38.905  18.793  1.00 32.19           N
ATOM      7  CA  LYS A  11     142.495  37.859  17.785  1.00 26.76           C
ATOM      8  C   LYS A  11     143.600  37.697  16.725  1.00 22.39           C
ATOM      9  O   LYS A  11     144.151  38.698  16.231  1.00 18.85           O
ATOM     10  CB  LYS A  11     141.249  38.245  16.966  1.00 28.02           C
ATOM     11  CG  LYS A  11     139.941  38.456  17.713  1.00 32.27           C
ATOM     12  CD  LYS A  11     138.765  38.699  16.745  1.00 34.99           C
ATOM     13  CE  LYS A  11     137.481  38.943  17.534  1.00 40.00           C
ATOM     14  NZ  LYS A  11     136.210  38.723  16.752  1.00 43.13           N
ATOM     15  N   PRO A  12     143.913  36.445  16.338  1.00 19.62           N
ATOM     16  CA  PRO A  12     144.939  36.256  15.304  1.00 15.56           C
ATOM     17  C   PRO A  12     144.367  36.883  14.027  1.00 14.16           C
ATOM     18  O   PRO A  12     143.174  36.739  13.743  1.00 13.12           O
ATOM     19  CB  PRO A  12     144.999  34.740  15.151  1.00 16.36           C
ATOM     20  CG  PRO A  12     144.721  34.276  16.535  1.00 18.42           C
ATOM     21  CD  PRO A  12     143.561  35.158  16.956  1.00 18.73           C
ATOM     22  N   VAL A  13     145.192  37.598  13.283  1.00 12.41           N
ATOM     23  CA  VAL A  13     144.717  38.227  12.076  1.00 13.30           C
ATOM     24  C   VAL A  13     145.859  38.454  11.090  1.00 14.05           C
ATOM     25  O   VAL A  13     147.026  38.654  11.472  1.00 12.10           O
ATOM     26  CB  VAL A  13     144.026  39.573  12.439  1.00 17.06           C
ATOM     27  CG1 VAL A  13     145.024  40.511  13.176  1.00 19.48           C
ATOM     28  CG2 VAL A  13     143.470  40.256  11.238  1.00 13.49           C
ATOM     29  N   ALA A  14     145.510  38.434   9.800  1.00 13.51           N
ATOM     30  CA  ALA A  14     146.461  38.682   8.731  1.00 10.53           C
ATOM     31  C   ALA A  14     145.780  39.225   7.506  1.00  8.76           C
ATOM     32  O   ALA A  14     144.642  38.862   7.208  1.00  7.01           O
ATOM     33  CB  ALA A  14     147.243  37.395   8.355  1.00 12.75           C
ATOM     34  N   HIS A  15     146.389  40.256   6.945  1.00 11.87           N
ATOM     35  CA  HIS A  15     145.956  40.816   5.673  1.00 10.59           C
ATOM     36  C   HIS A  15     147.262  41.122   4.955  1.00 12.24           C
ATOM     37  O   HIS A  15     147.978  42.069   5.283  1.00 10.64           O
ATOM     38  CB  HIS A  15     145.049  42.045   5.772  1.00 10.41           C
ATOM     39  CG  HIS A  15     144.611  42.572   4.429  1.00  8.60           C
ATOM     40  ND1 HIS A  15     143.476  42.127   3.787  1.00  8.51           N
ATOM     41  CD2 HIS A  15     145.152  43.508   3.612  1.00  8.05           C
ATOM     42  CE1 HIS A  15     143.332  42.764   2.640  1.00  9.72           C
ATOM     43  NE2 HIS A  15     144.340  43.608   2.508  1.00  9.91           N
ATOM     44  N   VAL A  16     147.608  40.240   4.037  1.00 11.98           N
ATOM     45  CA  VAL A  16     148.826  40.371   3.274  1.00 12.24           C
ATOM     46  C   VAL A  16     148.525  40.670   1.799  1.00 12.12           C
ATOM     47  O   VAL A  16     147.447  40.332   1.280  1.00  7.76           O
ATOM     48  CB  VAL A  16     149.758  39.126   3.505  1.00 10.30           C
ATOM     49  CG1 VAL A  16     150.012  38.973   5.008  1.00 12.61           C
ATOM     50  CG2 VAL A  16     149.132  37.810   2.973  1.00 11.85           C
ATOM     51  N   VAL A  17     149.459  41.366   1.160  1.00 12.95           N
ATOM     52  CA  VAL A  17     149.331  41.748  -0.237  1.00 13.09           C
ATOM     53  C   VAL A  17     150.446  41.190  -1.128  1.00 11.45           C
ATOM     54  O   VAL A  17     151.493  40.738  -0.654  1.00 13.18           O
ATOM     55  CB  VAL A  17     149.341  43.306  -0.382  1.00 13.98           C
ATOM     56  CG1 VAL A  17     148.215  43.928   0.446  1.00 14.42           C
ATOM     57  CG2 VAL A  17     150.683  43.863   0.050  1.00 15.72           C
ATOM     58  N   ALA A  18     150.185  41.181  -2.426  1.00 14.79           N
ATOM     59  CA  ALA A  18     151.175  40.742  -3.388  1.00 15.88           C
ATOM     60  C   ALA A  18     152.362  41.709  -3.283  1.00 15.79           C
ATOM     61  O   ALA A  18     152.204  42.931  -3.133  1.00 17.49           O
ATOM     62  CB  ALA A  18     150.574  40.779  -4.812  1.00 12.09           C
ATOM     63  N   ASN A  19     153.552  41.153  -3.385  1.00 17.64           N
ATOM     64  CA  ASN A  19     154.773  41.948  -3.338  1.00 20.04           C
ATOM     65  C   ASN A  19     155.024  42.328  -4.821  1.00 20.85           C
ATOM     66  O   ASN A  19     155.319  41.474  -5.636  1.00 21.96           O
ATOM     67  CB  ASN A  19     155.898  41.077  -2.738  1.00 20.94           C
ATOM     68  CG  ASN A  19     157.279  41.714  -2.844  1.00 25.71           C
ATOM     69  OD1 ASN A  19     157.469  42.766  -3.478  1.00 23.72           O
ATOM     70  ND2 ASN A  19     158.255  41.065  -2.235  1.00 26.30           N
ATOM     71  N   PRO A  20     154.883  43.610  -5.183  1.00 22.12           N
ATOM     72  CA  PRO A  20     155.100  44.040  -6.574  1.00 28.28           C
ATOM     73  C   PRO A  20     156.542  43.933  -7.135  1.00 31.58           C
ATOM     74  O   PRO A  20     156.775  44.203  -8.322  1.00 33.79           O
ATOM     75  CB  PRO A  20     154.555  45.474  -6.567  1.00 28.83           C
ATOM     76  CG  PRO A  20     154.906  45.946  -5.200  1.00 28.31           C
ATOM     77  CD  PRO A  20     154.548  44.759  -4.324  1.00 23.42           C
ATOM     78  N   GLN A  21     157.495  43.551  -6.281  1.00 33.56           N
ATOM     79  CA  GLN A  21     158.887  43.374  -6.686  1.00 35.60           C
ATOM     80  C   GLN A  21     159.118  41.910  -7.067  1.00 34.82           C
ATOM     81  O   GLN A  21     160.213  41.556  -7.509  1.00 37.51           O
ATOM     82  CB  GLN A  21     159.874  43.764  -5.564  1.00 39.05           C
ATOM     83  CG  GLN A  21     159.747  45.192  -5.013  1.00 44.97           C
ATOM     84  CD  GLN A  21     160.081  46.289  -6.035  1.00 50.39           C
ATOM     85  OE1 GLN A  21     159.534  46.329  -7.148  1.00 53.45           O
ATOM     86  NE2 GLN A  21     160.967  47.201  -5.645  1.00 50.90           N
ATOM     87  N   ALA A  22     158.136  41.050  -6.807  1.00 31.14           N
ATOM     88  CA  ALA A  22     158.255  39.647  -7.170  1.00 28.99           C
ATOM     89  C   ALA A  22     157.710  39.539  -8.585  1.00 31.71           C
ATOM     90  O   ALA A  22     156.514  39.725  -8.826  1.00 34.93           O
ATOM     91  CB  ALA A  22     157.475  38.772  -6.233  1.00 26.11           C
ATOM     92  N   GLU A  23     158.618  39.349  -9.538  1.00 32.39           N
ATOM     93  CA  GLU A  23     158.256  39.235 -10.956  1.00 27.89           C
ATOM     94  C   GLU A  23     157.829  37.834 -11.272  1.00 24.65           C
ATOM     95  O   GLU A  23     158.553  36.914 -10.958  1.00 23.15           O
ATOM     96  CB  GLU A  23     159.425  39.592 -11.820  1.00 26.66           C
ATOM     97  N   GLY A  24     156.636  37.670 -11.841  1.00 26.46           N
ATOM     98  CA  GLY A  24     156.138  36.345 -12.200  1.00 25.24           C
ATOM     99  C   GLY A  24     155.941  35.332 -11.077  1.00 26.12           C
ATOM    100  O   GLY A  24     156.214  34.138 -11.235  1.00 23.73           O
ATOM    101  N   GLN A  25     155.499  35.812  -9.922  1.00 24.28           N
ATOM    102  CA  GLN A  25     155.222  34.939  -8.812  1.00 22.78           C
ATOM    103  C   GLN A  25     154.237  35.683  -7.928  1.00 21.14           C
ATOM    104  O   GLN A  25     154.180  36.915  -7.953  1.00 23.46           O
ATOM    105  CB  GLN A  25     156.496  34.657  -8.046  1.00 23.59           C
ATOM    106  N   LEU A  26     153.410  34.948  -7.195  1.00 20.41           N
ATOM    107  CA  LEU A  26     152.500  35.586  -6.248  1.00 17.69           C
ATOM    108  C   LEU A  26     153.184  35.466  -4.888  1.00 17.34           C
ATOM    109  O   LEU A  26     153.082  34.432  -4.220  1.00 19.82           O
ATOM    110  CB  LEU A  26     151.170  34.867  -6.224  1.00 16.13           C
ATOM    111  CG  LEU A  26     150.126  35.362  -5.230  1.00 15.88           C
ATOM    112  CD1 LEU A  26     150.134  36.851  -5.096  1.00 15.60           C
ATOM    113  CD2 LEU A  26     148.790  34.823  -5.621  1.00 15.18           C
ATOM    114  N   GLN A  27     153.940  36.490  -4.514  1.00 20.61           N
ATOM    115  CA  GLN A  27     154.654  36.517  -3.229  1.00 19.35           C
ATOM    116  C   GLN A  27     153.908  37.402  -2.240  1.00 16.18           C
ATOM    117  O   GLN A  27     153.790  38.615  -2.464  1.00 16.65           O
ATOM    118  CB  GLN A  27     156.029  37.095  -3.466  1.00 23.85           C
ATOM    119  CG  GLN A  27     157.104  36.564  -2.576  1.00 34.07           C
ATOM    120  CD  GLN A  27     158.455  37.180  -2.955  1.00 41.80           C
ATOM    121  OE1 GLN A  27     158.911  38.167  -2.331  1.00 43.70           O
ATOM    122  NE2 GLN A  27     159.060  36.665  -4.047  1.00 44.39           N
ATOM    123  N   TRP A  28     153.391  36.813  -1.169  1.00 14.32           N
ATOM    124  CA  TRP A  28     152.628  37.579  -0.167  1.00 13.78           C
ATOM    125  C   TRP A  28     153.525  38.388   0.767  1.00 11.87           C
ATOM    126  O   TRP A  28     154.602  37.927   1.159  1.00 15.31           O
ATOM    127  CB  TRP A  28     151.710  36.649   0.656  1.00 14.44           C
ATOM    128  CG  TRP A  28     150.707  35.960  -0.160  1.00 14.13           C
ATOM    129  CD1 TRP A  28     150.592  34.615  -0.356  1.00 12.17           C
ATOM    130  CD2 TRP A  28     149.658  36.579  -0.907  1.00 14.18           C
ATOM    131  NE1 TRP A  28     149.515  34.357  -1.175  1.00 14.75           N
ATOM    132  CE2 TRP A  28     148.920  35.544  -1.533  1.00 11.76           C
ATOM    133  CE3 TRP A  28     149.263  37.910  -1.111  1.00 14.41           C
ATOM    134  CZ2 TRP A  28     147.804  35.791  -2.357  1.00 11.06           C
ATOM    135  CZ3 TRP A  28     148.151  38.166  -1.929  1.00 14.92           C
ATOM    136  CH2 TRP A  28     147.435  37.101  -2.542  1.00 12.82           C
ATOM    137  N   SER A  29     153.060  39.567   1.170  1.00 12.87           N
ATOM    138  CA  SER A  29     153.850  40.429   2.060  1.00 12.86           C
ATOM    139  C   SER A  29     153.003  41.246   2.997  1.00 14.62           C
ATOM    140  O   SER A  29     151.941  41.729   2.611  1.00 14.58           O
ATOM    141  CB  SER A  29     154.662  41.400   1.240  1.00 14.50           C
ATOM    142  OG  SER A  29     155.469  42.187   2.091  1.00 19.88           O
ATOM    143  N   ASN A  30     153.477  41.396   4.238  1.00 16.28           N
ATOM    144  CA  ASN A  30     152.767  42.192   5.250  1.00 18.59           C
ATOM    145  C   ASN A  30     153.471  43.532   5.442  1.00 19.03           C
ATOM    146  O   ASN A  30     153.075  44.316   6.302  1.00 19.54           O
ATOM    147  CB  ASN A  30     152.792  41.475   6.599  1.00 14.38           C
ATOM    148  CG  ASN A  30     154.177  41.267   7.079  1.00 16.24           C
ATOM    149  OD1 ASN A  30     154.952  40.533   6.461  1.00 20.35           O
ATOM    150  ND2 ASN A  30     154.555  41.985   8.114  1.00 18.77           N
ATOM    151  N   ARG A  31     154.498  43.786   4.628  1.00 21.43           N
ATOM    152  CA  ARG A  31     155.308  44.991   4.755  1.00 25.65           C
ATOM    153  C   ARG A  31     154.732  46.101   3.932  1.00 26.84           C
ATOM    154  O   ARG A  31     155.339  46.565   2.973  1.00 26.52           O
ATOM    155  CB  ARG A  31     156.752  44.731   4.340  1.00 25.24           C
ATOM    156  CG  ARG A  31     157.279  43.390   4.733  1.00 29.66           C
ATOM    157  CD  ARG A  31     158.281  43.486   5.820  1.00 34.97           C
ATOM    158  NE  ARG A  31     157.612  43.458   7.097  1.00 37.26           N
ATOM    159  CZ  ARG A  31     158.207  43.193   8.248  1.00 35.45           C
ATOM    160  NH1 ARG A  31     159.501  42.932   8.318  1.00 34.87           N
ATOM    161  NH2 ARG A  31     157.480  43.164   9.336  1.00 40.35           N
ATOM    162  N   ARG A  32     153.553  46.533   4.345  1.00 26.97           N
ATOM    163  CA  ARG A  32     152.838  47.585   3.682  1.00 24.26           C
ATOM    164  C   ARG A  32     151.980  48.292   4.746  1.00 23.68           C
ATOM    165  O   ARG A  32     151.603  47.701   5.759  1.00 19.33           O
ATOM    166  CB  ARG A  32     151.953  46.924   2.610  1.00 27.52           C
ATOM    167  CG  ARG A  32     151.174  47.874   1.742  1.00 34.83           C
ATOM    168  CD  ARG A  32     150.779  47.201   0.458  1.00 40.41           C
ATOM    169  NE  ARG A  32     151.418  47.850  -0.681  1.00 49.54           N
ATOM    170  CZ  ARG A  32     152.454  47.358  -1.355  1.00 55.11           C
ATOM    171  NH1 ARG A  32     152.992  46.185  -1.022  1.00 58.48           N
ATOM    172  NH2 ARG A  32     152.977  48.069  -2.347  1.00 57.80           N
ATOM    173  N   ALA A  33     151.742  49.584   4.584  1.00 20.12           N
ATOM    174  CA  ALA A  33     150.844  50.231   5.510  1.00 21.21           C
ATOM    175  C   ALA A  33     149.520  49.577   5.018  1.00 22.20           C
ATOM    176  O   ALA A  33     149.435  49.140   3.854  1.00 24.03           O
ATOM    177  CB  ALA A  33     150.853  51.755   5.284  1.00 19.68           C
ATOM    178  N   ASN A  34     148.521  49.485   5.894  1.00 19.97           N
ATOM    179  CA  ASN A  34     147.229  48.860   5.591  1.00 16.85           C
ATOM    180  C   ASN A  34     147.285  47.321   5.352  1.00 14.45           C
ATOM    181  O   ASN A  34     146.436  46.755   4.670  1.00 15.47           O
ATOM    182  CB  ASN A  34     146.515  49.608   4.445  1.00 19.98           C
ATOM    183  CG  ASN A  34     146.272  51.098   4.763  1.00 22.23           C
ATOM    184  OD1 ASN A  34     145.660  51.419   5.773  1.00 24.36           O
ATOM    185  ND2 ASN A  34     146.724  51.997   3.888  1.00 20.16           N
ATOM    186  N   ALA A  35     148.330  46.668   5.854  1.00 13.25           N
ATOM    187  CA  ALA A  35     148.461  45.212   5.782  1.00 11.96           C
ATOM    188  C   ALA A  35     148.664  44.812   7.252  1.00 12.70           C
ATOM    189  O   ALA A  35     149.051  45.662   8.057  1.00 13.40           O
ATOM    190  CB  ALA A  35     149.646  44.796   4.942  1.00 11.98           C
ATOM    191  N   LEU A  36     148.331  43.572   7.608  1.00 13.11           N
ATOM    192  CA  LEU A  36     148.432  43.072   8.990  1.00 16.33           C
ATOM    193  C   LEU A  36     149.007  41.657   9.089  1.00 14.41           C
ATOM    194  O   LEU A  36     148.816  40.842   8.203  1.00 11.82           O
ATOM    195  CB  LEU A  36     147.027  42.994   9.613  1.00 21.14           C
ATOM    196  CG  LEU A  36     146.051  44.159   9.469  1.00 22.22           C
ATOM    197  CD1 LEU A  36     144.638  43.720   9.638  1.00 23.27           C
ATOM    198  CD2 LEU A  36     146.431  45.218  10.518  1.00 26.78           C
ATOM    199  N   LEU A  37     149.682  41.364  10.196  1.00 14.13           N
ATOM    200  CA  LEU A  37     150.216  40.024  10.472  1.00 15.60           C
ATOM    201  C   LEU A  37     150.462  40.021  11.993  1.00 18.45           C
ATOM    202  O   LEU A  37     151.615  40.157  12.445  1.00 19.89           O
ATOM    203  CB  LEU A  37     151.517  39.794   9.702  1.00 15.71           C
ATOM    204  CG  LEU A  37     151.954  38.317   9.650  1.00 16.03           C
ATOM    205  CD1 LEU A  37     150.932  37.490   8.815  1.00 17.74           C
ATOM    206  CD2 LEU A  37     153.339  38.183   9.008  1.00 18.39           C
ATOM    207  N   ALA A  38     149.367  39.871  12.760  1.00 20.95           N
ATOM    208  CA  ALA A  38     149.377  39.954  14.232  1.00 19.69           C
ATOM    209  C   ALA A  38     148.858  38.784  15.021  1.00 22.65           C
ATOM    210  O   ALA A  38     148.229  37.889  14.493  1.00 25.21           O
ATOM    211  CB  ALA A  38     148.591  41.206  14.669  1.00 18.54           C
ATOM    212  N   ASN A  39     149.155  38.802  16.314  1.00 22.40           N
ATOM    213  CA  ASN A  39     148.675  37.788  17.238  1.00 18.76           C
ATOM    214  C   ASN A  39     148.899  36.310  16.918  1.00 18.30           C
ATOM    215  O   ASN A  39     147.995  35.491  17.128  1.00 19.70           O
ATOM    216  CB  ASN A  39     147.183  38.019  17.568  1.00 17.42           C
ATOM    217  CG  ASN A  39     146.926  39.368  18.160  1.00 19.10           C
ATOM    218  OD1 ASN A  39     147.650  39.818  19.021  1.00 21.87           O
ATOM    219  ND2 ASN A  39     145.891  40.026  17.707  1.00 23.83           N
ATOM    220  N   GLY A  40     150.073  35.966  16.391  1.00 17.34           N
ATOM    221  CA  GLY A  40     150.389  34.563  16.152  1.00 17.19           C
ATOM    222  C   GLY A  40     150.386  34.016  14.747  1.00 18.10           C
ATOM    223  O   GLY A  40     150.978  32.957  14.470  1.00 16.88           O
ATOM    224  N   VAL A  41     149.655  34.678  13.862  1.00 18.73           N
ATOM    225  CA  VAL A  41     149.625  34.217  12.485  1.00 20.10           C
ATOM    226  C   VAL A  41     151.021  34.446  11.898  1.00 20.46           C
ATOM    227  O   VAL A  41     151.597  35.525  12.064  1.00 25.52           O
ATOM    228  CB  VAL A  41     148.589  34.965  11.667  1.00 14.08           C
ATOM    229  CG1 VAL A  41     148.546  34.394  10.275  1.00 18.10           C
ATOM    230  CG2 VAL A  41     147.261  34.845  12.314  1.00 11.27           C
ATOM    231  N   GLU A  42     151.569  33.418  11.252  1.00 21.47           N
ATOM    232  CA  GLU A  42     152.903  33.483  10.663  1.00 21.65           C
ATOM    233  C   GLU A  42     152.840  33.360   9.172  1.00 20.06           C
ATOM    234  O   GLU A  42     152.000  32.644   8.659  1.00 22.92           O
ATOM    235  CB  GLU A  42     153.764  32.312  11.138  1.00 27.01           C
ATOM    236  CG  GLU A  42     154.236  32.372  12.566  1.00 36.48           C
ATOM    237  CD  GLU A  42     155.124  31.170  12.935  1.00 42.54           C
ATOM    238  OE1 GLU A  42     155.050  30.094  12.257  1.00 42.73           O
ATOM    239  OE2 GLU A  42     155.897  31.312  13.918  1.00 46.54           O
ATOM    240  N   LEU A  43     153.755  34.032   8.492  1.00 19.87           N
ATOM    241  CA  LEU A  43     153.879  33.946   7.048  1.00 19.12           C
ATOM    242  C   LEU A  43     155.203  33.138   6.918  1.00 20.37           C
ATOM    243  O   LEU A  43     156.279  33.616   7.269  1.00 22.76           O
ATOM    244  CB  LEU A  43     153.947  35.346   6.397  1.00 16.01           C
ATOM    245  CG  LEU A  43     153.795  35.429   4.876  1.00 19.75           C
ATOM    246  CD1 LEU A  43     152.538  34.734   4.436  1.00 20.57           C
ATOM    247  CD2 LEU A  43     153.747  36.882   4.422  1.00 20.33           C
ATOM    248  N   ARG A  44     155.065  31.866   6.559  1.00 21.56           N
ATOM    249  CA  ARG A  44     156.147  30.911   6.389  1.00 24.64           C
ATOM    250  C   ARG A  44     155.988  30.273   5.011  1.00 24.69           C
ATOM    251  O   ARG A  44     154.906  29.807   4.664  1.00 22.92           O
ATOM    252  CB  ARG A  44     156.003  29.820   7.449  1.00 29.62           C
ATOM    253  CG  ARG A  44     156.899  30.045   8.623  1.00 38.09           C
ATOM    254  CD  ARG A  44     156.849  28.938   9.690  1.00 43.38           C
ATOM    255  NE  ARG A  44     157.905  29.133  10.700  1.00 49.92           N
ATOM    256  CZ  ARG A  44     158.219  30.300  11.279  1.00 53.06           C
ATOM    257  NH1 ARG A  44     157.565  31.422  10.965  1.00 52.63           N
ATOM    258  NH2 ARG A  44     159.186  30.349  12.199  1.00 53.67           N
ATOM    259  N   ASP A  45     157.063  30.196   4.241  1.00 25.43           N
ATOM    260  CA  ASP A  45     157.005  29.598   2.889  1.00 26.80           C
ATOM    261  C   ASP A  45     155.834  30.148   2.060  1.00 24.86           C
ATOM    262  O   ASP A  45     155.170  29.376   1.370  1.00 24.60           O
ATOM    263  CB  ASP A  45     156.816  28.048   2.860  1.00 29.11           C
ATOM    264  CG  ASP A  45     157.497  27.297   3.990  1.00 37.23           C
ATOM    265  OD1 ASP A  45     158.709  27.511   4.235  1.00 39.94           O
ATOM    266  OD2 ASP A  45     156.799  26.430   4.585  1.00 39.20           O
ATOM    267  N   ASN A  46     155.548  31.438   2.144  1.00 23.46           N
ATOM    268  CA  ASN A  46     154.447  32.027   1.383  1.00 20.18           C
ATOM    269  C   ASN A  46     153.062  31.519   1.816  1.00 19.44           C
ATOM    270  O   ASN A  46     152.076  31.760   1.116  1.00 18.47           O
ATOM    271  CB  ASN A  46     154.654  31.807  -0.139  1.00 20.87           C
ATOM    272  CG  ASN A  46     154.067  32.948  -0.999  1.00 18.87           C
ATOM    273  OD1 ASN A  46     154.167  34.116  -0.655  1.00 17.15           O
ATOM    274  ND2 ASN A  46     153.461  32.591  -2.121  1.00 17.43           N
ATOM    275  N   GLN A  47     152.997  30.892   2.993  1.00 17.36           N
ATOM    276  CA  GLN A  47     151.751  30.341   3.546  1.00 18.22           C
ATOM    277  C   GLN A  47     151.418  30.963   4.886  1.00 15.93           C
ATOM    278  O   GLN A  47     152.304  31.472   5.541  1.00 14.38           O
ATOM    279  CB  GLN A  47     151.865  28.838   3.739  1.00 15.71           C
ATOM    280  CG  GLN A  47     152.136  28.051   2.462  1.00 22.03           C
ATOM    281  CD  GLN A  47     152.347  26.558   2.722  1.00 25.55           C
ATOM    282  OE1 GLN A  47     151.439  25.763   2.537  1.00 32.21           O
ATOM    283  NE2 GLN A  47     153.537  26.184   3.181  1.00 31.59           N
ATOM    284  N   LEU A  48     150.132  30.986   5.256  1.00 17.41           N
ATOM    285  CA  LEU A  48     149.675  31.543   6.536  1.00 16.58           C
ATOM    286  C   LEU A  48     149.446  30.373   7.473  1.00 16.02           C
ATOM    287  O   LEU A  48     148.699  29.451   7.163  1.00 16.21           O
ATOM    288  CB  LEU A  48     148.391  32.380   6.395  1.00 12.90           C
ATOM    289  CG  LEU A  48     148.439  33.713   5.627  1.00 14.27           C
ATOM    290  CD1 LEU A  48     147.083  34.410   5.668  1.00 15.87           C
ATOM    291  CD2 LEU A  48     149.469  34.620   6.205  1.00 13.62           C
ATOM    292  N   VAL A  49     150.164  30.398   8.591  1.00 16.03           N
ATOM    293  CA  VAL A  49     150.129  29.354   9.608  1.00 15.49           C
ATOM    294  C   VAL A  49     149.208  29.776  10.758  1.00 15.64           C
ATOM    295  O   VAL A  49     149.358  30.870  11.290  1.00 15.29           O
ATOM    296  CB  VAL A  49     151.574  29.100  10.119  1.00 16.30           C
ATOM    297  CG1 VAL A  49     151.635  27.848  10.990  1.00 16.98           C
ATOM    298  CG2 VAL A  49     152.522  28.952   8.958  1.00 18.92           C
ATOM    299  N   VAL A  50     148.174  28.987  11.048  1.00 18.05           N
ATOM    300  CA  VAL A  50     147.234  29.307  12.139  1.00 18.82           C
ATOM    301  C   VAL A  50     147.789  28.999  13.550  1.00 16.51           C
ATOM    302  O   VAL A  50     148.261  27.902  13.837  1.00 15.43           O
ATOM    303  CB  VAL A  50     145.837  28.635  11.908  1.00 20.27           C
ATOM    304  CG1 VAL A  50     145.899  27.163  12.056  1.00 19.66           C
ATOM    305  CG2 VAL A  50     144.862  29.144  12.865  1.00 24.11           C
ATOM    306  N   PRO A  51     147.758  29.992  14.433  1.00 18.89           N
ATOM    307  CA  PRO A  51     148.241  29.943  15.827  1.00 20.91           C
ATOM    308  C   PRO A  51     147.393  29.238  16.885  1.00 21.62           C
ATOM    309  O   PRO A  51     147.878  28.984  17.995  1.00 21.70           O
ATOM    310  CB  PRO A  51     148.402  31.425  16.179  1.00 20.57           C
ATOM    311  CG  PRO A  51     147.274  32.080  15.392  1.00 19.04           C
ATOM    312  CD  PRO A  51     147.365  31.364  14.048  1.00 21.27           C
ATOM    313  N   ILE A  52     146.132  28.957  16.555  1.00 21.33           N
ATOM    314  CA  ILE A  52     145.185  28.336  17.477  1.00 23.54           C
ATOM    315  C   ILE A  52     144.044  27.704  16.697  1.00 23.32           C
ATOM    316  O   ILE A  52     143.750  28.092  15.573  1.00 23.21           O
ATOM    317  CB  ILE A  52     144.527  29.393  18.416  1.00 26.69           C
ATOM    318  CG1 ILE A  52     143.930  30.530  17.569  1.00 27.85           C
ATOM    319  CG2 ILE A  52     145.529  29.926  19.459  1.00 25.90           C
ATOM    320  CD1 ILE A  52     143.074  31.516  18.337  1.00 29.67           C
ATOM    321  N   GLU A  53     143.397  26.728  17.297  1.00 24.87           N
ATOM    322  CA  GLU A  53     142.282  26.084  16.635  1.00 27.88           C
ATOM    323  C   GLU A  53     141.106  27.031  16.790  1.00 26.53           C
ATOM    324  O   GLU A  53     141.071  27.792  17.759  1.00 29.04           O
ATOM    325  CB  GLU A  53     142.017  24.754  17.313  1.00 30.38           C
ATOM    326  CG  GLU A  53     140.839  24.010  16.796  1.00 37.75           C
ATOM    327  CD  GLU A  53     140.201  23.232  17.897  1.00 42.92           C
ATOM    328  OE1 GLU A  53     140.744  22.148  18.226  1.00 41.02           O
ATOM    329  OE2 GLU A  53     139.197  23.750  18.456  1.00 48.72           O
ATOM    330  N   GLY A  54     140.203  27.068  15.811  1.00 24.62           N
ATOM    331  CA  GLY A  54     139.053  27.964  15.898  1.00 20.71           C
ATOM    332  C   GLY A  54     138.336  28.176  14.575  1.00 15.54           C
ATOM    333  O   GLY A  54     138.655  27.517  13.610  1.00 17.51           O
ATOM    334  N   LEU A  55     137.346  29.052  14.544  1.00 17.03           N
ATOM    335  CA  LEU A  55     136.627  29.356  13.308  1.00 15.60           C
ATOM    336  C   LEU A  55     137.334  30.575  12.742  1.00 16.96           C
ATOM    337  O   LEU A  55     137.585  31.521  13.487  1.00 16.95           O
ATOM    338  CB  LEU A  55     135.182  29.747  13.603  1.00 17.07           C
ATOM    339  CG  LEU A  55     134.221  28.621  13.998  1.00 20.60           C
ATOM    340  CD1 LEU A  55     132.880  29.188  14.500  1.00 23.33           C
ATOM    341  CD2 LEU A  55     134.003  27.708  12.818  1.00 19.59           C
ATOM    342  N   PHE A  56     137.696  30.539  11.448  1.00 16.39           N
ATOM    343  CA  PHE A  56     138.358  31.661  10.788  1.00 14.03           C
ATOM    344  C   PHE A  56     137.631  32.117   9.523  1.00 12.38           C
ATOM    345  O   PHE A  56     137.116  31.275   8.786  1.00 11.33           O
ATOM    346  CB  PHE A  56     139.772  31.282  10.335  1.00 12.51           C
ATOM    347  CG  PHE A  56     140.787  31.224  11.448  1.00 17.83           C
ATOM    348  CD1 PHE A  56     140.890  30.089  12.262  1.00 20.70           C
ATOM    349  CD2 PHE A  56     141.634  32.311  11.689  1.00 16.16           C
ATOM    350  CE1 PHE A  56     141.811  30.045  13.298  1.00 16.83           C
ATOM    351  CE2 PHE A  56     142.556  32.280  12.717  1.00 15.39           C
ATOM    352  CZ  PHE A  56     142.641  31.150  13.519  1.00 18.90           C
ATOM    353  N   LEU A  57     137.469  33.428   9.346  1.00 11.29           N
ATOM    354  CA  LEU A  57     136.955  33.938   8.076  1.00 10.66           C
ATOM    355  C   LEU A  57     138.249  34.015   7.214  1.00 10.32           C
ATOM    356  O   LEU A  57     139.232  34.611   7.642  1.00 13.78           O
ATOM    357  CB  LEU A  57     136.367  35.321   8.241  1.00 12.96           C
ATOM    358  CG  LEU A  57     136.038  35.976   6.877  1.00 18.10           C
ATOM    359  CD1 LEU A  57     134.941  35.164   6.105  1.00 16.74           C
ATOM    360  CD2 LEU A  57     135.552  37.418   7.076  1.00 16.36           C
ATOM    361  N   ILE A  58     138.251  33.422   6.024  1.00  9.30           N
ATOM    362  CA  ILE A  58     139.436  33.410   5.164  1.00 10.57           C
ATOM    363  C   ILE A  58     139.019  34.019   3.831  1.00 12.12           C
ATOM    364  O   ILE A  58     137.945  33.701   3.345  1.00 13.73           O
ATOM    365  CB  ILE A  58     139.885  31.969   4.927  1.00 14.53           C
ATOM    366  CG1 ILE A  58     140.017  31.227   6.252  1.00 13.43           C
ATOM    367  CG2 ILE A  58     141.213  31.968   4.213  1.00 19.55           C
ATOM    368  CD1 ILE A  58     140.209  29.739   6.090  1.00 20.93           C
ATOM    369  N   TYR A  59     139.846  34.863   3.223  1.00 10.68           N
ATOM    370  CA  TYR A  59     139.450  35.494   1.959  1.00  9.28           C
ATOM    371  C   TYR A  59     140.647  35.894   1.058  1.00  9.65           C
ATOM    372  O   TYR A  59     141.806  35.932   1.491  1.00  9.24           O
ATOM    373  CB  TYR A  59     138.549  36.721   2.245  1.00 11.30           C
ATOM    374  CG  TYR A  59     139.284  37.830   2.996  1.00  6.97           C
ATOM    375  CD1 TYR A  59     140.044  38.792   2.306  1.00  6.96           C
ATOM    376  CD2 TYR A  59     139.300  37.868   4.400  1.00 10.69           C
ATOM    377  CE1 TYR A  59     140.796  39.752   3.009  1.00  8.24           C
ATOM    378  CE2 TYR A  59     140.042  38.812   5.087  1.00  8.56           C
ATOM    379  CZ  TYR A  59     140.786  39.739   4.384  1.00  7.21           C
ATOM    380  OH  TYR A  59     141.562  40.615   5.080  1.00 11.01           O
ATOM    381  N   SER A  60     140.385  36.181  -0.205  1.00  9.01           N
ATOM    382  CA  SER A  60     141.476  36.559  -1.088  1.00 10.88           C
ATOM    383  C   SER A  60     140.928  37.103  -2.398  1.00  7.56           C
ATOM    384  O   SER A  60     139.832  36.737  -2.819  1.00  9.72           O
ATOM    385  CB  SER A  60     142.405  35.348  -1.368  1.00  6.90           C
ATOM    386  OG  SER A  60     143.481  35.664  -2.268  1.00 12.31           O
ATOM    387  N   GLN A  61     141.642  38.045  -2.982  1.00  8.65           N
ATOM    388  CA  GLN A  61     141.260  38.568  -4.277  1.00  9.33           C
ATOM    389  C   GLN A  61     142.531  38.566  -5.126  1.00  9.29           C
ATOM    390  O   GLN A  61     143.640  38.736  -4.607  1.00  7.39           O
ATOM    391  CB  GLN A  61     140.734  39.987  -4.159  1.00  6.88           C
ATOM    392  CG  GLN A  61     140.477  40.672  -5.497  1.00 12.16           C
ATOM    393  CD  GLN A  61     140.021  42.131  -5.377  1.00  8.16           C
ATOM    394  OE1 GLN A  61     139.004  42.444  -4.757  1.00 12.48           O
ATOM    395  NE2 GLN A  61     140.772  43.025  -6.013  1.00 10.82           N
ATOM    396  N   VAL A  62     142.358  38.265  -6.410  1.00 10.07           N
ATOM    397  CA  VAL A  62     143.423  38.307  -7.372  1.00  8.77           C
ATOM    398  C   VAL A  62     142.868  39.093  -8.531  1.00  9.55           C
ATOM    399  O   VAL A  62     141.665  39.068  -8.752  1.00 10.13           O
ATOM    400  CB  VAL A  62     143.817  36.916  -7.873  1.00 10.60           C
ATOM    401  CG1 VAL A  62     144.564  36.172  -6.749  1.00 12.98           C
ATOM    402  CG2 VAL A  62     142.594  36.155  -8.343  1.00 15.30           C
ATOM    403  N   LEU A  63     143.732  39.809  -9.240  1.00 11.16           N
ATOM    404  CA  LEU A  63     143.328  40.547 -10.417  1.00 12.38           C
ATOM    405  C   LEU A  63     144.270  40.186 -11.591  1.00 12.36           C
ATOM    406  O   LEU A  63     145.498  40.353 -11.512  1.00  9.63           O
ATOM    407  CB  LEU A  63     143.353  42.040 -10.136  1.00 12.38           C
ATOM    408  CG  LEU A  63     142.498  42.905 -11.052  1.00 14.68           C
ATOM    409  CD1 LEU A  63     142.600  44.337 -10.522  1.00 18.87           C
ATOM    410  CD2 LEU A  63     143.012  42.873 -12.413  1.00 20.69           C
ATOM    411  N   PHE A  64     143.690  39.708 -12.696  1.00 13.07           N
ATOM    412  CA  PHE A  64     144.466  39.327 -13.879  1.00 10.92           C
ATOM    413  C   PHE A  64     144.319  40.378 -14.960  1.00 10.72           C
ATOM    414  O   PHE A  64     143.305  41.056 -15.073  1.00 10.15           O
ATOM    415  CB  PHE A  64     143.999  37.974 -14.424  1.00 13.06           C
ATOM    416  CG  PHE A  64     144.112  36.825 -13.425  1.00 15.95           C
ATOM    417  CD1 PHE A  64     145.342  36.218 -13.145  1.00 14.39           C
ATOM    418  CD2 PHE A  64     142.968  36.293 -12.836  1.00 11.76           C
ATOM    419  CE1 PHE A  64     145.412  35.098 -12.310  1.00 14.59           C
ATOM    420  CE2 PHE A  64     143.035  35.178 -12.005  1.00 12.78           C
ATOM    421  CZ  PHE A  64     144.255  34.583 -11.745  1.00 12.65           C
ATOM    422  N   LYS A  65     145.318  40.507 -15.789  1.00 12.13           N
ATOM    423  CA  LYS A  65     145.203  41.493 -16.823  1.00 14.96           C
ATOM    424  C   LYS A  65     145.825  40.938 -18.064  1.00 19.75           C
ATOM    425  O   LYS A  65     146.846  40.245 -17.968  1.00 17.88           O
ATOM    426  CB  LYS A  65     145.962  42.744 -16.428  1.00 17.82           C
ATOM    427  CG  LYS A  65     145.903  43.851 -17.457  1.00 21.84           C
ATOM    428  CD  LYS A  65     147.214  44.578 -17.555  1.00 23.46           C
ATOM    429  CE  LYS A  65     147.050  45.714 -18.538  1.00 27.61           C
ATOM    430  NZ  LYS A  65     147.858  46.916 -18.193  1.00 31.18           N
ATOM    431  N   GLY A  66     145.229  41.247 -19.222  1.00 20.48           N
ATOM    432  CA  GLY A  66     145.776  40.802 -20.501  1.00 27.18           C
ATOM    433  C   GLY A  66     145.701  41.841 -21.610  1.00 31.95           C
ATOM    434  O   GLY A  66     145.100  42.896 -21.424  1.00 30.27           O
ATOM    435  N   GLN A  67     146.315  41.714 -22.694  1.00 37.91           N
ATOM    436  CA  GLN A  67     146.253  42.712 -23.787  1.00 40.98           C
ATOM    437  C   GLN A  67     145.757  42.065 -25.063  1.00 40.98           C
ATOM    438  O   GLN A  67     146.529  41.739 -25.939  1.00 40.65           O
ATOM    439  CB  GLN A  67     147.586  43.485 -23.985  1.00 45.12           C
ATOM    440  CG  GLN A  67     148.828  42.591 -24.198  1.00 53.61           C
ATOM    441  CD  GLN A  67     150.169  43.256 -23.796  1.00 58.12           C
ATOM    442  OE1 GLN A  67     150.979  43.691 -24.649  1.00 60.58           O
ATOM    443  NE2 GLN A  67     150.417  43.309 -22.480  1.00 60.80           N
ATOM    444  N   GLY A  68     144.441  41.918 -25.112  1.00 41.86           N
ATOM    445  CA  GLY A  68     143.758  41.331 -26.218  1.00 44.13           C
ATOM    446  C   GLY A  68     143.674  39.853 -25.996  1.00 47.55           C
ATOM    447  O   GLY A  68     144.083  39.357 -24.963  1.00 44.84           O
ATOM    448  N   CYS A  69     143.174  39.143 -26.997  1.00 53.62           N
ATOM    449  CA  CYS A  69     143.033  37.684 -26.938  1.00 62.25           C
ATOM    450  C   CYS A  69     143.862  36.894 -27.991  1.00 67.78           C
ATOM    451  O   CYS A  69     143.275  36.120 -28.764  1.00 68.75           O
ATOM    452  CB  CYS A  69     141.565  37.272 -27.096  1.00 60.88           C
ATOM    453  SG  CYS A  69     140.448  37.934 -25.905  1.00 64.44           S
ATOM    454  N   PRO A  70     145.224  37.026 -27.989  1.00 73.36           N
ATOM    455  CA  PRO A  70     146.159  36.353 -28.915  1.00 78.19           C
ATOM    456  C   PRO A  70     145.780  34.988 -29.567  1.00 82.11           C
ATOM    457  O   PRO A  70     145.954  34.782 -30.788  1.00 83.22           O
ATOM    458  CB  PRO A  70     147.443  36.283 -28.072  1.00 76.96           C
ATOM    459  CG  PRO A  70     147.461  37.643 -27.445  1.00 74.67           C
ATOM    460  CD  PRO A  70     145.995  37.843 -27.018  1.00 74.33           C
ATOM    461  N   SER A  71     145.424  34.395 -30.550  1.00 86.04           N
ATOM    462  CA  SER A  71     145.404  33.039 -31.113  1.00 89.11           C
ATOM    463  C   SER A  71     144.767  31.771 -30.458  1.00 88.40           C
ATOM    464  O   SER A  71     144.315  30.849 -31.179  1.00 89.46           O
ATOM    465  CB  SER A  71     146.854  32.696 -31.540  1.00 91.69           C
ATOM    466  OG  SER A  71     147.092  31.285 -31.632  1.00 96.00           O
ATOM    467  N   THR A  72     144.762  31.677 -29.131  1.00 86.12           N
ATOM    468  CA  THR A  72     144.239  30.469 -28.486  1.00 82.35           C
ATOM    469  C   THR A  72     143.702  30.815 -27.093  1.00 76.27           C
ATOM    470  O   THR A  72     143.692  32.009 -26.718  1.00 77.40           O
ATOM    471  CB  THR A  72     145.338  29.403 -28.396  1.00 84.78           C
ATOM    472  OG1 THR A  72     144.906  28.310 -27.566  1.00 87.54           O
ATOM    473  CG2 THR A  72     146.624  30.048 -27.838  1.00 86.05           C
ATOM    474  N   HIS A  73     142.990  28.379 -25.746  1.00 68.68           N
ATOM    475  CA  HIS A  73     142.679  29.508 -24.901  1.00 59.58           C
ATOM    476  C   HIS A  73     143.088  29.268 -23.438  1.00 53.71           C
ATOM    477  O   HIS A  73     143.383  28.135 -22.998  1.00 51.71           O
ATOM    478  CB  HIS A  73     141.202  29.919 -25.032  1.00 61.72           C
ATOM    479  CG  HIS A  73     140.932  30.976 -26.088  1.00 64.15           C
ATOM    480  ND1 HIS A  73     141.903  31.839 -26.569  1.00 64.93           N
ATOM    481  CD2 HIS A  73     139.773  31.339 -26.707  1.00 64.65           C
ATOM    482  CE1 HIS A  73     141.352  32.687 -27.425  1.00 64.78           C
ATOM    483  NE2 HIS A  73     140.063  32.405 -27.527  1.00 64.61           N
ATOM    484  N   VAL A  74     143.056  30.287 -22.721  1.00 46.33           N
ATOM    485  CA  VAL A  74     143.599  30.460 -21.376  1.00 36.22           C
ATOM    486  C   VAL A  74     142.495  30.468 -20.322  1.00 31.87           C
ATOM    487  O   VAL A  74     141.454  31.107 -20.485  1.00 25.32           O
ATOM    488  CB  VAL A  74     144.373  31.810 -21.216  1.00 36.31           C
ATOM    489  CG1 VAL A  74     145.156  31.835 -19.914  1.00 37.31           C
ATOM    490  CG2 VAL A  74     145.325  32.050 -22.388  1.00 36.17           C
ATOM    491  N   LEU A  75     142.726  29.697 -19.266  1.00 28.74           N
ATOM    492  CA  LEU A  75     141.836  29.617 -18.117  1.00 27.40           C
ATOM    493  C   LEU A  75     142.633  30.164 -16.946  1.00 25.13           C
ATOM    494  O   LEU A  75     143.834  29.903 -16.804  1.00 24.29           O
ATOM    495  CB  LEU A  75     141.399  28.184 -17.844  1.00 30.26           C
ATOM    496  CG  LEU A  75     140.192  27.799 -18.683  1.00 31.53           C
ATOM    497  CD1 LEU A  75     139.784  26.367 -18.386  1.00 34.94           C
ATOM    498  CD2 LEU A  75     139.091  28.764 -18.387  1.00 32.19           C
ATOM    499  N   LEU A  76     141.973  30.933 -16.108  1.00 20.85           N
ATOM    500  CA  LEU A  76     142.648  31.541 -14.975  1.00 18.54           C
ATOM    501  C   LEU A  76     142.027  30.944 -13.724  1.00 15.05           C
ATOM    502  O   LEU A  76     140.807  30.899 -13.605  1.00 14.77           O
ATOM    503  CB  LEU A  76     142.473  33.067 -15.039  1.00 18.52           C
ATOM    504  CG  LEU A  76     143.265  33.949 -16.046  1.00 25.31           C
ATOM    505  CD1 LEU A  76     144.103  33.185 -17.028  1.00 25.29           C
ATOM    506  CD2 LEU A  76     142.343  34.937 -16.723  1.00 27.38           C
ATOM    507  N   THR A  77     142.846  30.415 -12.832  1.00 13.04           N
ATOM    508  CA  THR A  77     142.317  29.797 -11.615  1.00 14.45           C
ATOM    509  C   THR A  77     142.874  30.479 -10.366  1.00 13.18           C
ATOM    510  O   THR A  77     143.940  31.116 -10.418  1.00 11.55           O
ATOM    511  CB  THR A  77     142.647  28.273 -11.564  1.00 14.37           C
ATOM    512  OG1 THR A  77     144.057  28.074 -11.327  1.00 11.98           O
ATOM    513  CG2 THR A  77     142.205  27.596 -12.882  1.00 15.82           C
ATOM    514  N   HIS A  78     142.120  30.391  -9.277  1.00 10.47           N
ATOM    515  CA  HIS A  78     142.504  30.958  -7.977  1.00  8.86           C
ATOM    516  C   HIS A  78     141.938  29.994  -6.972  1.00  9.82           C
ATOM    517  O   HIS A  78     140.743  29.680  -7.043  1.00 10.74           O
ATOM    518  CB  HIS A  78     141.825  32.315  -7.792  1.00 11.94           C
ATOM    519  CG  HIS A  78     142.116  32.991  -6.485  1.00 15.09           C
ATOM    520  ND1 HIS A  78     141.206  33.815  -5.855  1.00 19.91           N
ATOM    521  CD2 HIS A  78     143.247  33.047  -5.742  1.00 16.68           C
ATOM    522  CE1 HIS A  78     141.769  34.361  -4.791  1.00 14.79           C
ATOM    523  NE2 HIS A  78     143.005  33.913  -4.701  1.00 16.53           N
ATOM    524  N   THR A  79     142.757  29.513  -6.040  1.00 10.36           N
ATOM    525  CA  THR A  79     142.228  28.583  -5.050  1.00 10.26           C
ATOM    526  C   THR A  79     142.897  28.810  -3.719  1.00 12.48           C
ATOM    527  O   THR A  79     143.973  29.418  -3.655  1.00 14.17           O
ATOM    528  CB  THR A  79     142.249  27.049  -5.536  1.00 16.73           C
ATOM    529  OG1 THR A  79     143.291  26.303  -4.931  1.00 25.39           O
ATOM    530  CG2 THR A  79     142.414  26.907  -7.010  1.00 13.30           C
ATOM    531  N   ILE A  80     142.160  28.548  -2.655  1.00 12.25           N
ATOM    532  CA  ILE A  80     142.738  28.679  -1.310  1.00 12.39           C
ATOM    533  C   ILE A  80     142.715  27.255  -0.786  1.00  9.85           C
ATOM    534  O   ILE A  80     141.685  26.636  -0.857  1.00  9.71           O
ATOM    535  CB  ILE A  80     141.898  29.619  -0.388  1.00  8.84           C
ATOM    536  CG1 ILE A  80     142.010  31.064  -0.877  1.00 12.23           C
ATOM    537  CG2 ILE A  80     142.428  29.581   1.083  1.00 11.01           C
ATOM    538  CD1 ILE A  80     141.009  32.035  -0.201  1.00 10.77           C
ATOM    539  N   SER A  81     143.879  26.673  -0.500  1.00 11.87           N
ATOM    540  CA  SER A  81     143.942  25.339   0.075  1.00 11.73           C
ATOM    541  C   SER A  81     144.341  25.356   1.547  1.00 15.56           C
ATOM    542  O   SER A  81     144.961  26.305   2.039  1.00 17.30           O
ATOM    543  CB  SER A  81     144.999  24.542  -0.617  1.00 15.75           C
ATOM    544  OG  SER A  81     144.969  24.870  -1.966  1.00 28.39           O
ATOM    545  N   ARG A  82     144.064  24.241   2.207  1.00 16.85           N
ATOM    546  CA  ARG A  82     144.392  24.027   3.602  1.00 17.03           C
ATOM    547  C   ARG A  82     145.340  22.828   3.601  1.00 20.76           C
ATOM    548  O   ARG A  82     145.089  21.860   2.864  1.00 17.91           O
ATOM    549  CB  ARG A  82     143.120  23.631   4.326  1.00 16.82           C
ATOM    550  CG  ARG A  82     143.307  23.378   5.803  1.00 20.13           C
ATOM    551  CD  ARG A  82     142.050  22.836   6.404  1.00 20.04           C
ATOM    552  NE  ARG A  82     142.376  22.207   7.671  1.00 27.98           N
ATOM    553  CZ  ARG A  82     141.563  21.419   8.361  1.00 30.32           C
ATOM    554  NH1 ARG A  82     140.344  21.140   7.917  1.00 28.33           N
ATOM    555  NH2 ARG A  82     141.979  20.919   9.514  1.00 30.81           N
ATOM    556  N   ILE A  83     146.457  22.912   4.332  1.00 25.59           N
ATOM    557  CA  ILE A  83     147.383  21.766   4.421  1.00 30.86           C
ATOM    558  C   ILE A  83     147.474  21.225   5.848  1.00 36.26           C
ATOM    559  O   ILE A  83     147.381  21.984   6.814  1.00 33.38           O
ATOM    560  CB  ILE A  83     148.828  22.018   3.803  1.00 30.20           C
ATOM    561  CG1 ILE A  83     149.908  21.913   4.884  1.00 30.27           C
ATOM    562  CG2 ILE A  83     148.877  23.322   2.987  1.00 30.31           C
ATOM    563  CD1 ILE A  83     151.328  22.075   4.403  1.00 34.89           C
ATOM    564  N   ALA A  84     146.356  20.588   6.607  1.00 44.19           N
ATOM    565  CA  ALA A  84     146.115  20.233   8.004  1.00 52.59           C
ATOM    566  C   ALA A  84     147.272  19.603   8.765  1.00 58.50           C
ATOM    567  O   ALA A  84     148.209  19.043   8.170  1.00 58.67           O
ATOM    568  CB  ALA A  84     144.902  19.348   8.111  1.00 49.84           C
ATOM    569  N   VAL A  85     147.233  19.792  10.088  1.00 65.35           N
ATOM    570  CA  VAL A  85     148.220  19.211  10.990  1.00 70.50           C
ATOM    571  C   VAL A  85     149.622  19.861  11.127  1.00 74.31           C
ATOM    572  O   VAL A  85     149.837  20.772  11.956  1.00 74.83           O
ATOM    573  CB  VAL A  85     148.349  17.661  10.677  1.00 69.90           C
ATOM    574  CG1 VAL A  85     149.630  17.059  11.272  1.00 69.59           C
ATOM    575  CG2 VAL A  85     147.086  16.900  11.170  1.00 68.52           C
ATOM    576  N   SER A  86     150.582  19.332  10.373  1.00 78.14           N
ATOM    577  CA  SER A  86     151.997  19.737  10.424  1.00 82.42           C
ATOM    578  C   SER A  86     152.586  18.760   9.436  1.00 83.87           C
ATOM    579  O   SER A  86     153.049  17.682   9.847  1.00 84.70           O
ATOM    580  CB  SER A  86     152.609  19.421  11.797  1.00 83.63           C
ATOM    581  OG  SER A  86     152.535  20.550  12.643  1.00 84.92           O
ATOM    582  N   TYR A  87     152.417  19.082   8.150  1.00 84.60           N
ATOM    583  CA  TYR A  87     152.865  18.257   7.030  1.00 83.31           C
ATOM    584  C   TYR A  87     151.891  17.094   6.724  1.00 82.14           C
ATOM    585  O   TYR A  87     152.282  15.927   6.704  1.00 82.75           O
ATOM    586  CB  TYR A  87     154.304  17.748   7.264  1.00 83.13           C
ATOM    587  N   GLN A  88     150.603  17.407   6.582  1.00 80.64           N
ATOM    588  CA  GLN A  88     149.613  16.386   6.220  1.00 79.15           C
ATOM    589  C   GLN A  88     149.231  16.706   4.773  1.00 78.25           C
ATOM    590  O   GLN A  88     150.010  17.371   4.075  1.00 78.91           O
ATOM    591  CB  GLN A  88     148.395  16.419   7.130  1.00 77.67           C
ATOM    592  N   THR A  89     148.038  16.295   4.331  1.00 76.42           N
ATOM    593  CA  THR A  89     147.611  16.535   2.939  1.00 73.67           C
ATOM    594  C   THR A  89     147.156  17.962   2.651  1.00 70.63           C
ATOM    595  O   THR A  89     146.904  18.747   3.573  1.00 69.90           O
ATOM    596  CB  THR A  89     146.420  15.632   2.539  1.00 75.37           C
ATOM    597  OG1 THR A  89     146.210  15.698   1.109  1.00 76.17           O
ATOM    598  CG2 THR A  89     145.135  16.109   3.282  1.00 76.34           C
ATOM    599  N   LYS A  90     147.009  18.256   1.360  1.00 66.36           N
ATOM    600  CA  LYS A  90     146.530  19.545   0.894  1.00 61.48           C
ATOM    601  C   LYS A  90     145.094  19.310   0.380  1.00 58.73           C
ATOM    602  O   LYS A  90     144.824  18.253  -0.216  1.00 59.46           O
ATOM    603  CB  LYS A  90     147.424  20.065  -0.225  1.00 59.63           C
ATOM    604  CG  LYS A  90     147.179  21.505  -0.488  1.00 60.67           C
ATOM    605  CD  LYS A  90     148.261  22.086  -1.311  1.00 61.36           C
ATOM    606  CE  LYS A  90     148.201  23.594  -1.276  1.00 62.29           C
ATOM    607  NZ  LYS A  90     149.379  24.147  -1.982  1.00 61.77           N
ATOM    608  N   VAL A  91     144.170  20.233   0.666  1.00 52.42           N
ATOM    609  CA  VAL A  91     142.774  20.118   0.217  1.00 46.24           C
ATOM    610  C   VAL A  91     142.198  21.511  -0.106  1.00 40.66           C
ATOM    611  O   VAL A  91     142.445  22.470   0.632  1.00 39.95           O
ATOM    612  CB  VAL A  91     141.902  19.446   1.280  1.00 46.28           C
ATOM    613  CG1 VAL A  91     141.986  20.190   2.606  1.00 46.22           C
ATOM    614  CG2 VAL A  91     140.484  19.410   0.800  1.00 47.03           C
ATOM    615  N   ASN A  92     141.524  21.766  -1.080  1.00 32.03           N
ATOM    616  CA  ASN A  92     140.933  23.048  -1.501  1.00 25.84           C
ATOM    617  C   ASN A  92     139.702  23.402  -0.676  1.00 20.98           C
ATOM    618  O   ASN A  92     138.856  22.567  -0.402  1.00 21.80           O
ATOM    619  CB  ASN A  92     140.554  23.048  -2.981  1.00 26.50           C
ATOM    620  CG  ASN A  92     141.756  22.983  -3.912  1.00 29.41           C
ATOM    621  OD1 ASN A  92     142.912  22.913  -3.482  1.00 31.51           O
ATOM    622  ND2 ASN A  92     141.477  22.998  -5.210  1.00 30.18           N
ATOM    623  N   LEU A  93     139.692  24.622  -0.178  1.00 16.21           N
ATOM    624  CA  LEU A  93     138.612  25.103   0.623  1.00 12.23           C
ATOM    625  C   LEU A  93     137.719  25.967  -0.234  1.00 10.77           C
ATOM    626  O   LEU A  93     136.507  25.860  -0.146  1.00 11.33           O
ATOM    627  CB  LEU A  93     139.173  25.939   1.775  1.00 13.27           C
ATOM    628  CG  LEU A  93     139.961  25.224   2.885  1.00 11.22           C
ATOM    629  CD1 LEU A  93     140.563  26.206   3.818  1.00 15.16           C
ATOM    630  CD2 LEU A  93     139.122  24.208   3.622  1.00  9.71           C
ATOM    631  N   LEU A  94     138.321  26.757  -1.122  1.00 12.44           N
ATOM    632  CA  LEU A  94     137.610  27.724  -1.980  1.00 10.12           C
ATOM    633  C   LEU A  94     138.335  27.727  -3.317  1.00 12.04           C
ATOM    634  O   LEU A  94     139.569  27.640  -3.353  1.00 11.28           O
ATOM    635  CB  LEU A  94     137.681  29.117  -1.329  1.00 11.80           C
ATOM    636  CG  LEU A  94     137.166  29.301   0.113  1.00  9.62           C
ATOM    637  CD1 LEU A  94     137.760  30.589   0.739  1.00 13.27           C
ATOM    638  CD2 LEU A  94     135.639  29.394   0.082  1.00 11.46           C
ATOM    639  N   SER A  95     137.586  27.871  -4.403  1.00 12.23           N
ATOM    640  CA  SER A  95     138.173  27.804  -5.740  1.00 13.05           C
ATOM    641  C   SER A  95     137.259  28.478  -6.783  1.00 11.64           C
ATOM    642  O   SER A  95     136.018  28.402  -6.701  1.00 11.49           O
ATOM    643  CB  SER A  95     138.356  26.317  -6.082  1.00 13.46           C
ATOM    644  OG  SER A  95     139.257  26.170  -7.153  1.00 22.53           O
ATOM    645  N   ALA A  96     137.876  29.134  -7.760  1.00  9.33           N
ATOM    646  CA  ALA A  96     137.139  29.785  -8.858  1.00  9.37           C
ATOM    647  C   ALA A  96     137.952  29.692 -10.136  1.00 10.16           C
ATOM    648  O   ALA A  96     139.165  29.533 -10.085  1.00  9.13           O
ATOM    649  CB  ALA A  96     136.803  31.212  -8.555  1.00  7.20           C
ATOM    650  N   ILE A  97     137.271  29.702 -11.275  1.00 11.82           N
ATOM    651  CA  ILE A  97     137.910  29.636 -12.591  1.00 14.10           C
ATOM    652  C   ILE A  97     137.260  30.696 -13.411  1.00 13.14           C
ATOM    653  O   ILE A  97     136.063  30.944 -13.264  1.00 14.36           O
ATOM    654  CB  ILE A  97     137.611  28.329 -13.356  1.00 15.42           C
ATOM    655  CG1 ILE A  97     137.996  27.138 -12.508  1.00 16.89           C
ATOM    656  CG2 ILE A  97     138.413  28.279 -14.661  1.00 15.09           C
ATOM    657  CD1 ILE A  97     137.346  25.874 -12.964  1.00 23.07           C
ATOM    658  N   LYS A  98     138.010  31.228 -14.357  1.00 13.95           N
ATOM    659  CA  LYS A  98     137.496  32.261 -15.216  1.00 18.27           C
ATOM    660  C   LYS A  98     138.182  32.125 -16.574  1.00 18.16           C
ATOM    661  O   LYS A  98     139.328  31.672 -16.637  1.00 20.04           O
ATOM    662  CB  LYS A  98     137.865  33.575 -14.571  1.00 21.03           C
ATOM    663  CG  LYS A  98     137.177  34.727 -15.120  1.00 24.61           C
ATOM    664  CD  LYS A  98     137.445  35.824 -14.211  1.00 28.64           C
ATOM    665  CE  LYS A  98     136.258  36.097 -13.386  1.00 30.54           C
ATOM    666  NZ  LYS A  98     136.787  37.129 -12.545  1.00 34.04           N
ATOM    667  N   SER A  99     137.470  32.402 -17.654  1.00 19.28           N
ATOM    668  CA  SER A  99     138.102  32.351 -18.974  1.00 20.54           C
ATOM    669  C   SER A  99     137.992  33.746 -19.551  1.00 24.24           C
ATOM    670  O   SER A  99     136.903  34.315 -19.638  1.00 24.84           O
ATOM    671  CB  SER A  99     137.508  31.274 -19.909  1.00 23.81           C
ATOM    672  OG  SER A  99     136.089  31.254 -19.939  1.00 29.79           O
ATOM    673  N   PRO A 100     139.146  34.376 -19.793  1.00 26.60           N
ATOM    674  CA  PRO A 100     139.153  35.724 -20.348  1.00 27.42           C
ATOM    675  C   PRO A 100     138.741  35.833 -21.810  1.00 30.40           C
ATOM    676  O   PRO A 100     137.987  36.715 -22.152  1.00 32.15           O
ATOM    677  CB  PRO A 100     140.589  36.178 -20.109  1.00 27.70           C
ATOM    678  CG  PRO A 100     141.382  34.875 -20.065  1.00 27.75           C
ATOM    679  CD  PRO A 100     140.484  33.969 -19.322  1.00 26.12           C
ATOM    680  N   CYS A 101     139.200  34.945 -22.678  1.00 34.08           N
ATOM    681  CA  CYS A 101     138.827  35.074 -24.082  1.00 40.79           C
ATOM    682  C   CYS A 101     137.980  33.968 -24.697  1.00 46.10           C
ATOM    683  O   CYS A 101     138.386  32.802 -24.774  1.00 48.78           O
ATOM    684  CB  CYS A 101     140.066  35.249 -24.930  1.00 39.94           C
ATOM    685  SG  CYS A 101     141.039  36.676 -24.519  1.00 44.90           S
ATOM    686  N   GLN A 102     136.814  34.342 -25.199  1.00 52.41           N
ATOM    687  CA  GLN A 102     135.984  33.343 -25.826  1.00 57.68           C
ATOM    688  C   GLN A 102     136.564  33.224 -27.247  1.00 59.52           C
ATOM    689  O   GLN A 102     136.710  32.116 -27.769  1.00 60.62           O
ATOM    690  CB  GLN A 102     134.503  33.763 -25.796  1.00 59.89           C
ATOM    691  CG  GLN A 102     133.525  32.641 -25.367  1.00 61.98           C
ATOM    692  CD  GLN A 102     133.596  32.274 -23.881  1.00 64.75           C
ATOM    693  OE1 GLN A 102     134.541  31.621 -23.407  1.00 65.12           O
ATOM    694  NE2 GLN A 102     132.565  32.664 -23.145  1.00 65.07           N
ATOM    695  N   ARG A 103     137.022  34.356 -27.796  1.00 60.57           N
ATOM    696  CA  ARG A 103     137.613  34.409 -29.140  1.00 61.59           C
ATOM    697  C   ARG A 103     138.560  35.609 -29.387  1.00 63.50           C
ATOM    698  O   ARG A 103     138.672  36.508 -28.548  1.00 63.76           O
ATOM    699  CB  ARG A 103     136.504  34.388 -30.200  1.00 59.24           C
ATOM    700  N   GLU A 104     139.262  35.539 -30.527  1.00 66.69           N
ATOM    701  CA  GLU A 104     140.233  36.502 -31.106  1.00 70.55           C
ATOM    702  C   GLU A 104     141.344  35.674 -31.722  1.00 74.59           C
ATOM    703  O   GLU A 104     141.116  34.526 -32.110  1.00 74.13           O
ATOM    704  CB  GLU A 104     140.844  37.523 -30.129  1.00 70.37           C
ATOM    705  CG  GLU A 104     142.194  38.109 -30.655  1.00 70.82           C
ATOM    706  CD  GLU A 104     142.312  39.640 -30.624  1.00 70.34           C
ATOM    707  OE1 GLU A 104     141.556  40.336 -31.332  1.00 70.07           O
ATOM    708  OE2 GLU A 104     143.212  40.156 -29.930  1.00 70.09           O
ATOM    709  N   THR A 105     140.954  35.709 -33.677  1.00 81.65           N
ATOM    710  CA  THR A 105     141.464  34.824 -34.784  1.00 87.35           C
ATOM    711  C   THR A 105     142.067  35.652 -36.007  1.00 90.13           C
ATOM    712  O   THR A 105     142.365  36.897 -35.846  1.00 90.21           O
ATOM    713  CB  THR A 105     140.210  33.881 -35.242  1.00 88.59           C
ATOM    714  OG1 THR A 105     138.945  34.518 -34.900  1.00 91.31           O
ATOM    715  CG2 THR A 105     140.258  32.431 -34.596  1.00 88.63           C
ATOM    716  N   PRO A 106     142.138  35.039 -37.260  1.00 92.17           N
ATOM    717  CA  PRO A 106     142.707  35.754 -38.453  1.00 93.63           C
ATOM    718  C   PRO A 106     142.790  37.327 -38.651  1.00 94.86           C
ATOM    719  O   PRO A 106     141.880  37.952 -39.325  1.00 95.77           O
ATOM    720  CB  PRO A 106     141.911  35.133 -39.627  1.00 93.20           C
ATOM    721  CG  PRO A 106     141.846  33.701 -39.239  1.00 92.26           C
ATOM    722  CD  PRO A 106     141.618  33.710 -37.688  1.00 91.68           C
ATOM    723  N   GLU A 107     143.884  37.954 -38.169  1.00 95.05           N
ATOM    724  CA  GLU A 107     144.098  39.400 -38.363  1.00 95.21           C
ATOM    725  C   GLU A 107     142.929  40.384 -38.107  1.00 95.40           C
ATOM    726  O   GLU A 107     141.917  40.078 -37.440  1.00 95.78           O
ATOM    727  CB  GLU A 107     144.685  39.655 -39.759  1.00 94.25           C
ATOM    728  N   GLY A 108     143.050  41.558 -38.708  1.00 95.84           N
ATOM    729  CA  GLY A 108     142.069  42.606 -38.482  1.00 96.19           C
ATOM    730  C   GLY A 108     142.831  43.580 -37.558  1.00 96.70           C
ATOM    731  O   GLY A 108     144.083  43.792 -37.695  1.00 96.78           O
ATOM    732  N   ALA A 109     142.104  44.147 -36.585  1.00 95.66           N
ATOM    733  CA  ALA A 109     142.717  45.087 -35.625  1.00 93.55           C
ATOM    734  C   ALA A 109     142.830  44.271 -34.326  1.00 90.80           C
ATOM    735  O   ALA A 109     142.545  43.036 -34.375  1.00 91.97           O
ATOM    736  CB  ALA A 109     141.813  46.324 -35.454  1.00 94.49           C
ATOM    737  N   GLU A 110     143.211  44.872 -33.178  1.00 86.58           N
ATOM    738  CA  GLU A 110     143.303  43.963 -32.004  1.00 82.70           C
ATOM    739  C   GLU A 110     143.579  44.490 -30.581  1.00 78.42           C
ATOM    740  O   GLU A 110     143.296  45.670 -30.268  1.00 78.66           O
ATOM    741  CB  GLU A 110     144.364  42.852 -32.341  1.00 83.97           C
ATOM    742  N   ALA A 111     144.270  43.452 -29.371  1.00 72.29           N
ATOM    743  CA  ALA A 111     145.294  44.198 -28.632  1.00 66.49           C
ATOM    744  C   ALA A 111     144.734  45.116 -27.531  1.00 61.84           C
ATOM    745  O   ALA A 111     145.439  45.997 -27.011  1.00 62.47           O
ATOM    746  CB  ALA A 111     146.177  45.003 -29.601  1.00 66.89           C
ATOM    747  N   LYS A 112     143.448  44.955 -27.233  1.00 55.77           N
ATOM    748  CA  LYS A 112     142.796  45.729 -26.176  1.00 49.52           C
ATOM    749  C   LYS A 112     143.017  45.015 -24.827  1.00 44.66           C
ATOM    750  O   LYS A 112     142.829  43.798 -24.721  1.00 41.76           O
ATOM    751  CB  LYS A 112     141.287  45.926 -26.466  1.00 49.12           C
ATOM    752  CG  LYS A 112     140.665  44.917 -27.424  1.00 48.61           C
ATOM    753  CD  LYS A 112     140.797  43.504 -26.875  1.00 48.10           C
ATOM    754  CE  LYS A 112     140.826  42.448 -27.968  1.00 46.57           C
ATOM    755  NZ  LYS A 112     140.954  41.129 -27.321  1.00 45.20           N
ATOM    756  N   PRO A 113     143.527  45.740 -23.817  1.00 40.92           N
ATOM    757  CA  PRO A 113     143.751  45.103 -22.513  1.00 38.66           C
ATOM    758  C   PRO A 113     142.431  44.747 -21.836  1.00 34.21           C
ATOM    759  O   PRO A 113     141.413  45.438 -21.990  1.00 33.86           O
ATOM    760  CB  PRO A 113     144.523  46.171 -21.722  1.00 39.82           C
ATOM    761  CG  PRO A 113     144.008  47.451 -22.300  1.00 39.92           C
ATOM    762  CD  PRO A 113     143.990  47.137 -23.802  1.00 40.85           C
ATOM    763  N   TRP A 114     142.460  43.682 -21.055  1.00 27.41           N
ATOM    764  CA  TRP A 114     141.263  43.265 -20.375  1.00 21.71           C
ATOM    765  C   TRP A 114     141.659  43.034 -18.939  1.00 19.51           C
ATOM    766  O   TRP A 114     142.835  42.812 -18.674  1.00 17.22           O
ATOM    767  CB  TRP A 114     140.667  41.999 -21.030  1.00 18.83           C
ATOM    768  CG  TRP A 114     141.609  40.863 -21.269  1.00 17.27           C
ATOM    769  CD1 TRP A 114     142.200  40.501 -22.466  1.00 18.02           C
ATOM    770  CD2 TRP A 114     142.067  39.918 -20.289  1.00 18.20           C
ATOM    771  NE1 TRP A 114     142.996  39.395 -22.278  1.00 16.57           N
ATOM    772  CE2 TRP A 114     142.932  39.016 -20.957  1.00 17.54           C
ATOM    773  CE3 TRP A 114     141.834  39.745 -18.908  1.00 13.25           C
ATOM    774  CZ2 TRP A 114     143.572  37.961 -20.285  1.00 19.73           C
ATOM    775  CZ3 TRP A 114     142.470  38.697 -18.238  1.00 10.85           C
ATOM    776  CH2 TRP A 114     143.330  37.821 -18.929  1.00 15.22           C
ATOM    777  N   TYR A 115     140.707  43.181 -18.010  1.00 17.91           N
ATOM    778  CA  TYR A 115     140.948  42.939 -16.596  1.00 13.28           C
ATOM    779  C   TYR A 115     139.891  42.001 -16.076  1.00 12.72           C
ATOM    780  O   TYR A 115     138.726  42.072 -16.480  1.00 14.81           O
ATOM    781  CB  TYR A 115     140.843  44.191 -15.811  1.00 11.84           C
ATOM    782  CG  TYR A 115     141.950  45.092 -16.053  1.00 14.28           C
ATOM    783  CD1 TYR A 115     141.934  45.951 -17.151  1.00 16.77           C
ATOM    784  CD2 TYR A 115     143.009  45.131 -15.163  1.00 13.80           C
ATOM    785  CE1 TYR A 115     142.963  46.846 -17.357  1.00 21.10           C
ATOM    786  CE2 TYR A 115     144.038  46.005 -15.341  1.00 18.22           C
ATOM    787  CZ  TYR A 115     144.023  46.875 -16.436  1.00 21.70           C
ATOM    788  OH  TYR A 115     145.046  47.795 -16.581  1.00 25.62           O
ATOM    789  N   GLU A 116     140.303  41.156 -15.132  1.00 13.08           N
ATOM    790  CA  GLU A 116     139.438  40.167 -14.538  1.00 12.20           C
ATOM    791  C   GLU A 116     139.799  39.901 -13.072  1.00 12.50           C
ATOM    792  O   GLU A 116     140.875  39.349 -12.773  1.00  9.75           O
ATOM    793  CB  GLU A 116     139.552  38.836 -15.291  1.00 18.67           C
ATOM    794  CG  GLU A 116     139.029  38.844 -16.696  1.00 18.84           C
ATOM    795  CD  GLU A 116     137.532  38.956 -16.781  1.00 22.77           C
ATOM    796  OE1 GLU A 116     136.854  39.311 -15.797  1.00 19.57           O
ATOM    797  OE2 GLU A 116     137.009  38.696 -17.881  1.00 28.82           O
ATOM    798  N   PRO A 117     138.910  40.327 -12.143  1.00 12.52           N
ATOM    799  CA  PRO A 117     139.120  40.117 -10.697  1.00 13.93           C
ATOM    800  C   PRO A 117     138.445  38.779 -10.240  1.00 13.59           C
ATOM    801  O   PRO A 117     137.480  38.324 -10.845  1.00 12.95           O
ATOM    802  CB  PRO A 117     138.454  41.352 -10.053  1.00 12.17           C
ATOM    803  CG  PRO A 117     137.279  41.641 -11.010  1.00 10.30           C
ATOM    804  CD  PRO A 117     137.718  41.176 -12.408  1.00 10.60           C
ATOM    805  N   ILE A 118     139.002  38.098  -9.241  1.00 13.57           N
ATOM    806  CA  ILE A 118     138.329  36.902  -8.711  1.00 11.65           C
ATOM    807  C   ILE A 118     138.365  37.112  -7.207  1.00 11.47           C
ATOM    808  O   ILE A 118     139.392  37.556  -6.727  1.00 12.50           O
ATOM    809  CB  ILE A 118     139.034  35.558  -9.058  1.00 13.40           C
ATOM    810  CG1 ILE A 118     139.049  35.329 -10.576  1.00 13.37           C
ATOM    811  CG2 ILE A 118     138.240  34.397  -8.420  1.00 10.68           C
ATOM    812  CD1 ILE A 118     139.757  33.996 -11.002  1.00 16.92           C
ATOM    813  N   TYR A 119     137.239  36.915  -6.513  1.00 11.48           N
ATOM    814  CA  TYR A 119     137.134  37.025  -5.049  1.00 10.08           C
ATOM    815  C   TYR A 119     136.712  35.635  -4.449  1.00 10.55           C
ATOM    816  O   TYR A 119     135.822  34.952  -4.972  1.00 12.30           O
ATOM    817  CB  TYR A 119     136.095  38.093  -4.645  1.00 10.67           C
ATOM    818  CG  TYR A 119     136.150  38.438  -3.177  1.00 10.16           C
ATOM    819  CD1 TYR A 119     137.016  39.436  -2.704  1.00 10.32           C
ATOM    820  CD2 TYR A 119     135.386  37.741  -2.249  1.00 10.91           C
ATOM    821  CE1 TYR A 119     137.129  39.733  -1.317  1.00 13.12           C
ATOM    822  CE2 TYR A 119     135.489  38.024  -0.864  1.00 11.39           C
ATOM    823  CZ  TYR A 119     136.362  39.017  -0.398  1.00 12.66           C
ATOM    824  OH  TYR A 119     136.488  39.251   0.965  1.00  9.71           O
ATOM    825  N   LEU A 120     137.341  35.242  -3.343  1.00  8.03           N
ATOM    826  CA  LEU A 120     137.031  33.992  -2.648  1.00 10.64           C
ATOM    827  C   LEU A 120     136.903  34.362  -1.162  1.00 10.02           C
ATOM    828  O   LEU A 120     137.649  35.218  -0.679  1.00 10.90           O
ATOM    829  CB  LEU A 120     138.198  33.041  -2.805  1.00 13.66           C
ATOM    830  CG  LEU A 120     138.351  31.970  -3.879  1.00 16.92           C
ATOM    831  CD1 LEU A 120     137.585  32.237  -5.130  1.00 19.17           C
ATOM    832  CD2 LEU A 120     139.795  31.760  -4.108  1.00 14.58           C
ATOM    833  N   GLY A 121     135.950  33.777  -0.440  1.00 11.07           N
ATOM    834  CA  GLY A 121     135.812  34.083   0.990  1.00  9.55           C
ATOM    835  C   GLY A 121     134.894  33.099   1.683  1.00  7.39           C
ATOM    836  O   GLY A 121     133.918  32.701   1.080  1.00 11.47           O
ATOM    837  N   GLY A 122     135.266  32.596   2.868  1.00  8.95           N
ATOM    838  CA  GLY A 122     134.416  31.650   3.578  1.00 10.35           C
ATOM    839  C   GLY A 122     134.859  31.421   5.013  1.00 11.54           C
ATOM    840  O   GLY A 122     135.983  31.778   5.356  1.00 12.43           O
ATOM    841  N   VAL A 123     134.005  30.793   5.822  1.00  7.76           N
ATOM    842  CA  VAL A 123     134.295  30.527   7.248  1.00 10.38           C
ATOM    843  C   VAL A 123     134.631  29.069   7.456  1.00 11.59           C
ATOM    844  O   VAL A 123     133.854  28.202   7.051  1.00 13.11           O
ATOM    845  CB  VAL A 123     133.101  30.924   8.138  1.00 10.65           C
ATOM    846  CG1 VAL A 123     133.312  30.485   9.603  1.00 11.84           C
ATOM    847  CG2 VAL A 123     132.925  32.412   8.072  1.00 11.48           C
ATOM    848  N   PHE A 124     135.782  28.803   8.086  1.00 11.38           N
ATOM    849  CA  PHE A 124     136.265  27.432   8.285  1.00 12.17           C
ATOM    850  C   PHE A 124     136.835  27.118   9.658  1.00 13.82           C
ATOM    851  O   PHE A 124     137.458  27.970  10.287  1.00 13.27           O
ATOM    852  CB  PHE A 124     137.338  27.096   7.216  1.00 14.08           C
ATOM    853  CG  PHE A 124     136.847  27.241   5.767  1.00 11.98           C
ATOM    854  CD1 PHE A 124     136.884  28.479   5.111  1.00 14.47           C
ATOM    855  CD2 PHE A 124     136.356  26.133   5.065  1.00 13.95           C
ATOM    856  CE1 PHE A 124     136.440  28.610   3.788  1.00 14.57           C
ATOM    857  CE2 PHE A 124     135.909  26.249   3.738  1.00 12.52           C
ATOM    858  CZ  PHE A 124     135.950  27.486   3.105  1.00  9.95           C
ATOM    859  N   GLN A 125     136.625  25.876  10.100  1.00 13.56           N
ATOM    860  CA  GLN A 125     137.141  25.379  11.388  1.00 12.70           C
ATOM    861  C   GLN A 125     138.526  24.827  11.114  1.00 13.91           C
ATOM    862  O   GLN A 125     138.692  23.898  10.324  1.00 12.60           O
ATOM    863  CB  GLN A 125     136.256  24.286  11.969  1.00 15.58           C
ATOM    864  CG  GLN A 125     136.746  23.711  13.299  1.00 22.63           C
ATOM    865  CD  GLN A 125     136.333  24.529  14.512  1.00 28.47           C
ATOM    866  OE1 GLN A 125     135.219  24.384  15.024  1.00 35.75           O
ATOM    867  NE2 GLN A 125     137.233  25.374  14.998  1.00 32.26           N
ATOM    868  N   LEU A 126     139.512  25.483  11.721  1.00 15.10           N
ATOM    869  CA  LEU A 126     140.922  25.165  11.565  1.00 18.02           C
ATOM    870  C   LEU A 126     141.492  24.763  12.909  1.00 18.46           C
ATOM    871  O   LEU A 126     140.898  25.068  13.933  1.00 16.37           O
ATOM    872  CB  LEU A 126     141.686  26.392  11.015  1.00 17.52           C
ATOM    873  CG  LEU A 126     141.195  26.964   9.685  1.00 16.72           C
ATOM    874  CD1 LEU A 126     142.183  28.035   9.229  1.00 16.79           C
ATOM    875  CD2 LEU A 126     141.123  25.853   8.667  1.00 13.83           C
ATOM    876  N   GLU A 127     142.628  24.070  12.871  1.00 21.14           N
ATOM    877  CA  GLU A 127     143.348  23.591  14.042  1.00 24.34           C
ATOM    878  C   GLU A 127     144.648  24.364  14.073  1.00 24.58           C
ATOM    879  O   GLU A 127     145.098  24.819  13.040  1.00 25.10           O
ATOM    880  CB  GLU A 127     143.715  22.127  13.878  1.00 26.09           C
ATOM    881  CG  GLU A 127     142.592  21.161  13.702  1.00 34.51           C
ATOM    882  CD  GLU A 127     143.093  19.770  13.194  1.00 40.22           C
ATOM    883  OE1 GLU A 127     144.315  19.600  12.902  1.00 43.77           O
ATOM    884  OE2 GLU A 127     142.253  18.847  13.051  1.00 40.57           O
ATOM    885  N   LYS A 128     145.273  24.491  15.240  1.00 24.50           N
ATOM    886  CA  LYS A 128     146.557  25.180  15.327  1.00 25.01           C
ATOM    887  C   LYS A 128     147.618  24.473  14.446  1.00 23.06           C
ATOM    888  O   LYS A 128     147.774  23.244  14.483  1.00 22.50           O
ATOM    889  CB  LYS A 128     147.077  25.189  16.778  1.00 27.04           C
ATOM    890  CG  LYS A 128     148.592  25.483  16.859  1.00 27.48           C
ATOM    891  CD  LYS A 128     149.237  24.865  18.062  1.00 34.45           C
ATOM    892  CE  LYS A 128     149.595  25.928  19.106  1.00 36.05           C
ATOM    893  NZ  LYS A 128     149.942  25.334  20.441  1.00 37.00           N
ATOM    894  N   GLY A 129     148.407  25.260  13.725  1.00 20.68           N
ATOM    895  CA  GLY A 129     149.452  24.684  12.889  1.00 22.11           C
ATOM    896  C   GLY A 129     149.089  24.481  11.431  1.00 21.56           C
ATOM    897  O   GLY A 129     149.985  24.284  10.588  1.00 19.83           O
ATOM    898  N   ASP A 130     147.783  24.493  11.139  1.00 21.38           N
ATOM    899  CA  ASP A 130     147.297  24.355   9.774  1.00 18.41           C
ATOM    900  C   ASP A 130     147.944  25.445   8.947  1.00 16.89           C
ATOM    901  O   ASP A 130     148.225  26.529   9.444  1.00 15.45           O
ATOM    902  CB  ASP A 130     145.774  24.512   9.707  1.00 18.00           C
ATOM    903  CG  ASP A 130     145.043  23.226  10.001  1.00 16.97           C
ATOM    904  OD1 ASP A 130     145.660  22.179  10.288  1.00 21.79           O
ATOM    905  OD2 ASP A 130     143.820  23.247   9.930  1.00 18.73           O
ATOM    906  N   ARG A 131     148.178  25.153   7.681  1.00 16.54           N
ATOM    907  CA  ARG A 131     148.779  26.110   6.774  1.00 20.89           C
ATOM    908  C   ARG A 131     147.813  26.400   5.651  1.00 19.92           C
ATOM    909  O   ARG A 131     147.163  25.486   5.120  1.00 20.50           O
ATOM    910  CB  ARG A 131     150.039  25.544   6.162  1.00 24.49           C
ATOM    911  CG  ARG A 131     151.200  25.583   7.080  1.00 34.08           C
ATOM    912  CD  ARG A 131     152.229  24.599   6.657  1.00 40.41           C
ATOM    913  NE  ARG A 131     153.393  24.781   7.504  1.00 50.20           N
ATOM    914  CZ  ARG A 131     154.364  25.653   7.255  1.00 53.51           C
ATOM    915  NH1 ARG A 131     154.346  26.363   6.130  1.00 56.09           N
ATOM    916  NH2 ARG A 131     155.381  25.766   8.104  1.00 55.90           N
ATOM    917  N   LEU A 132     147.733  27.669   5.278  1.00 18.92           N
ATOM    918  CA  LEU A 132     146.855  28.106   4.198  1.00 16.11           C
ATOM    919  C   LEU A 132     147.639  28.689   3.019  1.00 17.03           C
ATOM    920  O   LEU A 132     148.501  29.584   3.169  1.00 15.95           O
ATOM    921  CB  LEU A 132     145.843  29.143   4.714  1.00 13.19           C
ATOM    922  CG  LEU A 132     144.911  28.663   5.775  1.00  9.98           C
ATOM    923  CD1 LEU A 132     144.331  29.836   6.403  1.00 13.44           C
ATOM    924  CD2 LEU A 132     143.867  27.766   5.189  1.00 15.06           C
ATOM    925  N   SER A 133     147.252  28.252   1.832  1.00 15.91           N
ATOM    926  CA  SER A 133     147.864  28.741   0.616  1.00 18.56           C
ATOM    927  C   SER A 133     146.816  29.408  -0.323  1.00 14.84           C
ATOM    928  O   SER A 133     145.706  28.909  -0.439  1.00 16.32           O
ATOM    929  CB  SER A 133     148.477  27.543  -0.094  1.00 18.21           C
ATOM    930  OG  SER A 133     149.563  27.955  -0.882  1.00 27.00           O
ATOM    931  N   ALA A 134     147.125  30.572  -0.880  1.00 12.26           N
ATOM    932  CA  ALA A 134     146.255  31.234  -1.857  1.00 12.13           C
ATOM    933  C   ALA A 134     147.136  31.182  -3.098  1.00 15.17           C
ATOM    934  O   ALA A 134     148.187  31.864  -3.169  1.00 14.98           O
ATOM    935  CB  ALA A 134     146.005  32.627  -1.483  1.00 14.25           C
ATOM    936  N   GLU A 135     146.659  30.447  -4.101  1.00 14.49           N
ATOM    937  CA  GLU A 135     147.413  30.191  -5.310  1.00 14.62           C
ATOM    938  C   GLU A 135     146.696  30.396  -6.614  1.00 10.52           C
ATOM    939  O   GLU A 135     145.484  30.224  -6.687  1.00 10.35           O
ATOM    940  CB  GLU A 135     147.829  28.737  -5.285  1.00 16.30           C
ATOM    941  CG  GLU A 135     148.645  28.342  -4.086  1.00 19.37           C
ATOM    942  CD  GLU A 135     148.810  26.841  -3.993  1.00 22.13           C
ATOM    943  OE1 GLU A 135     148.160  26.102  -4.753  1.00 32.17           O
ATOM    944  OE2 GLU A 135     149.578  26.366  -3.149  1.00 28.78           O
ATOM    945  N   ILE A 136     147.447  30.838  -7.622  1.00 12.41           N
ATOM    946  CA  ILE A 136     146.933  31.017  -8.993  1.00 11.83           C
ATOM    947  C   ILE A 136     147.713  30.153 -10.016  1.00 13.72           C
ATOM    948  O   ILE A 136     148.868  29.819  -9.793  1.00 12.90           O
ATOM    949  CB  ILE A 136     146.970  32.492  -9.429  1.00 14.35           C
ATOM    950  CG1 ILE A 136     148.409  33.023  -9.368  1.00 15.26           C
ATOM    951  CG2 ILE A 136     146.006  33.303  -8.565  1.00 12.94           C
ATOM    952  CD1 ILE A 136     148.644  34.160 -10.201  1.00 19.85           C
ATOM    953  N   ASN A 137     147.124  29.819 -11.157  1.00 10.76           N
ATOM    954  CA  ASN A 137     147.871  29.031 -12.136  1.00 12.31           C
ATOM    955  C   ASN A 137     148.844  29.859 -12.976  1.00 10.82           C
ATOM    956  O   ASN A 137     149.952  29.409 -13.230  1.00 14.19           O
ATOM    957  CB  ASN A 137     146.943  28.202 -13.050  1.00 13.50           C
ATOM    958  CG  ASN A 137     145.982  29.061 -13.909  1.00 17.42           C
ATOM    959  OD1 ASN A 137     145.659  30.213 -13.564  1.00 17.90           O
ATOM    960  ND2 ASN A 137     145.503  28.474 -15.024  1.00 17.14           N
ATOM    961  N   ARG A 138     148.476  31.083 -13.345  1.00  9.75           N
ATOM    962  CA  ARG A 138     149.366  31.896 -14.167  1.00 11.53           C
ATOM    963  C   ARG A 138     149.776  33.240 -13.532  1.00 13.51           C
ATOM    964  O   ARG A 138     149.137  34.287 -13.757  1.00 13.12           O
ATOM    965  CB  ARG A 138     148.723  32.117 -15.530  1.00 11.98           C
ATOM    966  CG  ARG A 138     148.431  30.839 -16.363  1.00 15.10           C
ATOM    967  CD  ARG A 138     149.717  30.214 -16.977  1.00 16.37           C
ATOM    968  NE  ARG A 138     150.477  31.138 -17.856  1.00 20.70           N
ATOM    969  CZ  ARG A 138     150.373  31.246 -19.198  1.00 17.21           C
ATOM    970  NH1 ARG A 138     149.520  30.488 -19.884  1.00 14.90           N
ATOM    971  NH2 ARG A 138     151.158  32.109 -19.859  1.00 15.65           N
ATOM    972  N   PRO A 139     150.864  33.233 -12.726  1.00 15.85           N
ATOM    973  CA  PRO A 139     151.341  34.450 -12.070  1.00 16.17           C
ATOM    974  C   PRO A 139     151.777  35.498 -13.046  1.00 16.86           C
ATOM    975  O   PRO A 139     151.943  36.658 -12.673  1.00 18.12           O
ATOM    976  CB  PRO A 139     152.491  33.957 -11.202  1.00 14.86           C
ATOM    977  CG  PRO A 139     152.915  32.693 -11.886  1.00 21.02           C
ATOM    978  CD  PRO A 139     151.607  32.066 -12.223  1.00 14.27           C
ATOM    979  N   ASP A 140     151.978  35.082 -14.293  1.00 15.58           N
ATOM    980  CA  ASP A 140     152.395  36.004 -15.351  1.00 16.68           C
ATOM    981  C   ASP A 140     151.242  36.844 -15.906  1.00 13.10           C
ATOM    982  O   ASP A 140     151.471  37.748 -16.692  1.00 14.78           O
ATOM    983  CB  ASP A 140     153.173  35.270 -16.485  1.00 16.07           C
ATOM    984  CG  ASP A 140     152.413  34.080 -17.080  1.00 17.87           C
ATOM    985  OD1 ASP A 140     151.609  33.411 -16.391  1.00 15.77           O
ATOM    986  OD2 ASP A 140     152.630  33.820 -18.277  1.00 23.51           O
ATOM    987  N   TYR A 141     150.021  36.571 -15.456  1.00 10.86           N
ATOM    988  CA  TYR A 141     148.853  37.335 -15.883  1.00 13.66           C
ATOM    989  C   TYR A 141     148.377  38.237 -14.732  1.00 14.58           C
ATOM    990  O   TYR A 141     147.396  38.951 -14.879  1.00 15.33           O
ATOM    991  CB  TYR A 141     147.679  36.412 -16.288  1.00 14.82           C
ATOM    992  CG  TYR A 141     147.694  35.953 -17.701  1.00 12.10           C
ATOM    993  CD1 TYR A 141     148.440  34.863 -18.064  1.00 16.76           C
ATOM    994  CD2 TYR A 141     146.970  36.611 -18.671  1.00 14.69           C
ATOM    995  CE1 TYR A 141     148.473  34.413 -19.363  1.00 20.95           C
ATOM    996  CE2 TYR A 141     146.984  36.177 -19.987  1.00 20.43           C
ATOM    997  CZ  TYR A 141     147.752  35.061 -20.327  1.00 23.10           C
ATOM    998  OH  TYR A 141     147.816  34.568 -21.613  1.00 22.16           O
ATOM    999  N   LEU A 142     149.062  38.222 -13.594  1.00 16.72           N
ATOM   1000  CA  LEU A 142     148.624  39.051 -12.488  1.00 19.03           C
ATOM   1001  C   LEU A 142     148.908  40.523 -12.686  1.00 23.10           C
ATOM   1002  O   LEU A 142     149.821  40.924 -13.432  1.00 22.49           O
ATOM   1003  CB  LEU A 142     149.267  38.614 -11.171  1.00 15.87           C
ATOM   1004  CG  LEU A 142     148.660  37.477 -10.355  1.00 17.46           C
ATOM   1005  CD1 LEU A 142     149.556  37.281  -9.137  1.00 19.75           C
ATOM   1006  CD2 LEU A 142     147.210  37.784  -9.909  1.00 16.31           C
ATOM   1007  N   ASP A 143     148.046  41.321 -12.060  1.00 22.61           N
ATOM   1008  CA  ASP A 143     148.189  42.752 -12.054  1.00 23.51           C
ATOM   1009  C   ASP A 143     148.118  43.270 -10.600  1.00 22.94           C
ATOM   1010  O   ASP A 143     147.077  43.184  -9.954  1.00 22.01           O
ATOM   1011  CB  ASP A 143     147.110  43.391 -12.915  1.00 23.96           C
ATOM   1012  CG  ASP A 143     147.323  44.879 -13.111  1.00 27.00           C
ATOM   1013  OD1 ASP A 143     148.461  45.353 -13.008  1.00 28.49           O
ATOM   1014  OD2 ASP A 143     146.347  45.593 -13.381  1.00 30.38           O
ATOM   1015  N   PHE A 144     149.249  43.682 -10.039  1.00 25.83           N
ATOM   1016  CA  PHE A 144     149.265  44.264  -8.687  1.00 30.40           C
ATOM   1017  C   PHE A 144     149.961  45.599  -8.840  1.00 33.28           C
ATOM   1018  O   PHE A 144     150.579  46.118  -7.902  1.00 35.56           O
ATOM   1019  CB  PHE A 144     149.962  43.394  -7.612  1.00 31.48           C
ATOM   1020  CG  PHE A 144     151.122  42.564  -8.113  1.00 29.63           C
ATOM   1021  CD1 PHE A 144     152.310  43.152  -8.522  1.00 28.05           C
ATOM   1022  CD2 PHE A 144     151.010  41.180  -8.188  1.00 30.50           C
ATOM   1023  CE1 PHE A 144     153.356  42.374  -8.997  1.00 32.18           C
ATOM   1024  CE2 PHE A 144     152.057  40.399  -8.663  1.00 32.03           C
ATOM   1025  CZ  PHE A 144     153.227  40.997  -9.066  1.00 32.31           C
ATOM   1026  N   ALA A 145     149.826  46.134 -10.055  1.00 32.57           N
ATOM   1027  CA  ALA A 145     150.380  47.410 -10.467  1.00 32.42           C
ATOM   1028  C   ALA A 145     150.062  48.455  -9.439  1.00 35.45           C
ATOM   1029  O   ALA A 145     150.689  49.519  -9.394  1.00 35.79           O
ATOM   1030  CB  ALA A 145     149.771  47.832 -11.769  1.00 32.80           C
ATOM   1031  N   GLU A 146     149.046  48.180  -8.636  1.00 35.09           N
ATOM   1032  CA  GLU A 146     148.665  49.124  -7.613  1.00 33.95           C
ATOM   1033  C   GLU A 146     147.642  48.588  -6.646  1.00 30.04           C
ATOM   1034  O   GLU A 146     147.219  47.438  -6.734  1.00 28.78           O
ATOM   1035  CB  GLU A 146     148.084  50.373  -8.295  1.00 34.26           C
ATOM   1036  N   SER A 147     147.439  49.377  -5.606  1.00 28.85           N
ATOM   1037  CA  SER A 147     146.342  49.177  -4.682  1.00 29.39           C
ATOM   1038  C   SER A 147     146.059  47.929  -3.889  1.00 27.62           C
ATOM   1039  O   SER A 147     146.935  47.206  -3.432  1.00 33.54           O
ATOM   1040  CB  SER A 147     145.092  49.522  -5.476  1.00 29.12           C
ATOM   1041  OG  SER A 147     144.054  50.040  -4.675  1.00 37.21           O
ATOM   1042  N   GLY A 148     144.772  47.786  -3.637  1.00 26.24           N
ATOM   1043  CA  GLY A 148     144.258  46.676  -2.911  1.00 20.01           C
ATOM   1044  C   GLY A 148     143.746  45.780  -3.976  1.00 12.10           C
ATOM   1045  O   GLY A 148     142.638  45.320  -3.849  1.00 11.21           O
ATOM   1046  N   GLN A 149     144.549  45.532  -5.014  1.00 13.54           N
ATOM   1047  CA  GLN A 149     144.171  44.633  -6.124  1.00 11.77           C
ATOM   1048  C   GLN A 149     144.359  43.109  -5.883  1.00 11.26           C
ATOM   1049  O   GLN A 149     143.589  42.308  -6.410  1.00 11.23           O
ATOM   1050  CB  GLN A 149     144.934  45.021  -7.393  1.00 13.29           C
ATOM   1051  CG  GLN A 149     144.566  46.376  -7.972  1.00 18.69           C
ATOM   1052  CD  GLN A 149     145.250  46.657  -9.316  1.00 17.78           C
ATOM   1053  OE1 GLN A 149     144.912  47.622 -10.016  1.00 21.20           O
ATOM   1054  NE2 GLN A 149     146.191  45.798  -9.692  1.00 19.36           N
ATOM   1055  N   VAL A 150     145.392  42.720  -5.121  1.00 12.06           N
ATOM   1056  CA  VAL A 150     145.710  41.314  -4.824  1.00 10.98           C
ATOM   1057  C   VAL A 150     145.957  41.267  -3.326  1.00 11.31           C
ATOM   1058  O   VAL A 150     146.863  41.947  -2.854  1.00 10.87           O
ATOM   1059  CB  VAL A 150     147.024  40.862  -5.575  1.00  8.44           C
ATOM   1060  CG1 VAL A 150     147.249  39.380  -5.414  1.00  7.85           C
ATOM   1061  CG2 VAL A 150     146.910  41.187  -7.092  1.00 10.42           C
ATOM   1062  N   TYR A 151     145.188  40.443  -2.608  1.00 10.87           N
ATOM   1063  CA  TYR A 151     145.286  40.296  -1.156  1.00  7.76           C
ATOM   1064  C   TYR A 151     144.745  38.957  -0.686  1.00  6.81           C
ATOM   1065  O   TYR A 151     143.959  38.301  -1.369  1.00  9.17           O
ATOM   1066  CB  TYR A 151     144.553  41.428  -0.417  1.00  8.04           C
ATOM   1067  CG  TYR A 151     143.124  41.671  -0.878  1.00 10.04           C
ATOM   1068  CD1 TYR A 151     142.086  40.891  -0.405  1.00  7.86           C
ATOM   1069  CD2 TYR A 151     142.808  42.701  -1.796  1.00 12.17           C
ATOM   1070  CE1 TYR A 151     140.796  41.123  -0.812  1.00  9.92           C
ATOM   1071  CE2 TYR A 151     141.491  42.938  -2.221  1.00  9.29           C
ATOM   1072  CZ  TYR A 151     140.494  42.144  -1.718  1.00  8.74           C
ATOM   1073  OH  TYR A 151     139.173  42.363  -2.079  1.00 10.19           O
ATOM   1074  N   PHE A 152     145.192  38.571   0.498  1.00  8.63           N
ATOM   1075  CA  PHE A 152     144.838  37.309   1.148  1.00  7.60           C
ATOM   1076  C   PHE A 152     144.780  37.626   2.659  1.00  7.28           C
ATOM   1077  O   PHE A 152     145.731  38.199   3.218  1.00  6.24           O
ATOM   1078  CB  PHE A 152     145.958  36.313   0.775  1.00  7.78           C
ATOM   1079  CG  PHE A 152     145.894  34.920   1.417  1.00 12.16           C
ATOM   1080  CD1 PHE A 152     144.683  34.285   1.800  1.00 12.65           C
ATOM   1081  CD2 PHE A 152     147.102  34.200   1.557  1.00 11.05           C
ATOM   1082  CE1 PHE A 152     144.685  32.931   2.319  1.00 11.97           C
ATOM   1083  CE2 PHE A 152     147.114  32.870   2.062  1.00 11.38           C
ATOM   1084  CZ  PHE A 152     145.905  32.232   2.444  1.00  9.60           C
ATOM   1085  N   GLY A 153     143.667  37.324   3.310  1.00  9.92           N
ATOM   1086  CA  GLY A 153     143.585  37.569   4.747  1.00 11.12           C
ATOM   1087  C   GLY A 153     142.841  36.501   5.519  1.00 10.83           C
ATOM   1088  O   GLY A 153     142.167  35.655   4.950  1.00 12.36           O
ATOM   1089  N   ILE A 154     142.986  36.523   6.838  1.00 13.35           N
ATOM   1090  CA  ILE A 154     142.265  35.600   7.725  1.00 13.98           C
ATOM   1091  C   ILE A 154     142.077  36.328   9.036  1.00 12.09           C
ATOM   1092  O   ILE A 154     142.904  37.162   9.396  1.00 14.29           O
ATOM   1093  CB  ILE A 154     142.987  34.219   8.090  1.00 16.58           C
ATOM   1094  CG1 ILE A 154     144.222  34.423   8.963  1.00 14.91           C
ATOM   1095  CG2 ILE A 154     143.340  33.376   6.845  1.00 20.27           C
ATOM   1096  CD1 ILE A 154     144.680  33.112   9.614  1.00 21.92           C
ATOM   1097  N   ILE A 155     140.993  36.032   9.728  1.00 12.24           N
ATOM   1098  CA  ILE A 155     140.701  36.628  11.031  1.00 11.73           C
ATOM   1099  C   ILE A 155     139.934  35.578  11.866  1.00 11.73           C
ATOM   1100  O   ILE A 155     138.996  34.912  11.359  1.00  9.05           O
ATOM   1101  CB  ILE A 155     139.934  37.999  10.911  1.00 11.44           C
ATOM   1102  CG1 ILE A 155     139.553  38.515  12.300  1.00 14.11           C
ATOM   1103  CG2 ILE A 155     138.708  37.888  10.030  1.00 14.33           C
ATOM   1104  CD1 ILE A 155     140.080  39.930  12.603  1.00 18.47           C
ATOM   1105  N   ALA A 156     140.400  35.341  13.094  1.00 12.07           N
ATOM   1106  CA  ALA A 156     139.724  34.378  13.960  1.00 14.71           C
ATOM   1107  C   ALA A 156     138.398  34.995  14.392  1.00 17.52           C
ATOM   1108  O   ALA A 156     138.340  36.180  14.727  1.00 17.55           O
ATOM   1109  CB  ALA A 156     140.570  34.035  15.142  1.00 13.77           C
ATOM   1110  N   LEU A 157     137.334  34.202  14.295  1.00 21.24           N
ATOM   1111  CA  LEU A 157     135.967  34.622  14.639  1.00 27.30           C
ATOM   1112  C   LEU A 157     135.522  34.202  16.044  1.00 29.11           C
ATOM   1113  CB  LEU A 157     134.955  34.050  13.633  1.00 30.48           C
ATOM   1114  CG  LEU A 157     135.004  34.466  12.159  1.00 32.78           C
ATOM   1115  CD1 LEU A 157     133.788  33.891  11.444  1.00 31.95           C
ATOM   1116  CD2 LEU A 157     134.976  35.991  12.040  1.00 35.27           C
ATOM   1117  OXT LEU A 157     134.446  34.662  16.457  1.00 31.94           O
TER    1118      LEU A 157
HETATM 1119  O   HOH   201     137.069  41.771  -6.850  1.00 17.83           O
HETATM 1120  O   HOH   202     134.516  36.472  -8.339  1.00 19.46           O
HETATM 1121  O   HOH   204     145.132  25.531 -11.730  1.00 32.55           O
HETATM 1122  O   HOH   205     144.666  28.030  -8.681  1.00 16.62           O
HETATM 1123  O   HOH   206     145.999  26.779  -3.125  1.00 21.29           O
HETATM 1124  O   HOH   207     149.919  31.401  -0.735  1.00 15.23           O
HETATM 1125  O   HOH   208     155.666  26.973  -0.378  1.00 46.78           O
HETATM 1126  O   HOH   209     151.921  28.765  -1.919  1.00 28.44           O
HETATM 1127  O   HOH   210     150.433  31.196  -6.749  1.00 16.68           O
HETATM 1128  O   HOH   211     147.899  47.948   9.515  1.00 17.19           O
HETATM 1129  O   HOH   212     145.211  47.227   8.546  1.00 15.96           O
HETATM 1130  O   HOH   213     144.706  45.193   6.669  1.00  9.40           O
HETATM 1131  O   HOH   214     144.507  50.081   7.882  1.00 18.16           O
HETATM 1132  O   HOH   215     146.202  51.682  10.249  1.00 25.94           O
HETATM 1133  O   HOH   216     147.659  45.005  -5.373  1.00 22.32           O
HETATM 1134  O   HOH   217     145.917  44.434  -2.185  1.00 27.40           O
HETATM 1135  O   HOH   218     144.751  45.522   0.359  1.00 14.64           O
HETATM 1136  O   HOH   219     146.331  47.118   1.782  1.00 28.76           O
HETATM 1137  O   HOH   220     154.188  31.414 -15.920  1.00 32.81           O
HETATM 1138  O   HOH   221     155.223  31.090  -9.958  1.00 25.08           O
HETATM 1139  O   HOH   222     160.131  36.058  -8.682  1.00 33.75           O
HETATM 1140  O   HOH   223     156.028  35.122   1.212  1.00 23.18           O
HETATM 1141  O   HOH   224     156.810  33.593   3.329  1.00 17.90           O
HETATM 1142  O   HOH   225     131.548  26.688  18.681  1.00 51.58           O
HETATM 1143  O   HOH   226     139.719  21.261  14.235  1.00 33.22           O
HETATM 1144  O   HOH   227     138.199  31.513  16.287  1.00 28.45           O
HETATM 1145  O   HOH   228     151.999  42.522 -19.516  1.00 39.47           O
HETATM 1146  O   HOH   229     155.593  35.680   9.917  1.00 21.41           O
HETATM 1147  O   HOH   230     154.129  39.073  12.894  1.00 29.64           O
HETATM 1148  O   HOH   231     154.582  36.121  12.756  1.00 32.19           O
HETATM 1149  O   HOH   232     154.114  38.814 -17.897  1.00 26.17           O
HETATM 1150  O   HOH   233     153.958  38.932  -6.122  1.00 17.76           O
HETATM 1151  O   HOH   234     151.457  46.828  -5.607  1.00 35.17           O
HETATM 1152  O   HOH   235     151.071  50.634   9.434  1.00 30.11           O
HETATM 1153  O   HOH   236     152.883  23.313  10.011  1.00 34.98           O
HETATM 1154  O   HOH   237     139.672  31.590 -22.014  1.00 39.91           O
HETATM 1155  O   HOH   238     148.208  50.498   8.586  1.00 35.43           O
HETATM 1156  O   HOH   239     136.993  21.320   1.081  1.00 63.99           O
HETATM 1157  O   HOH   240     135.861  38.266 -31.914  1.00 34.44           O
HETATM 1158  O   HOH   241     144.105  22.014  17.148  1.00 33.48           O
HETATM 1159  O   HOH   242     158.385  48.495   5.435  1.00 23.41           O
HETATM 1160  O   HOH   243     158.241  40.897   2.047  1.00 40.82           O
HETATM 1161  O   HOH   244     167.036  38.524   8.384  1.00 87.86           O
HETATM 1162  O   HOH   245     145.907  38.427 -23.488  1.00 51.70           O
HETATM 1163  O   HOH   246     151.903  43.747 -12.234  1.00 27.51           O
HETATM 1164  O   HOH   247     152.055  53.152  -7.506  1.00 45.10           O
HETATM 1165  O   HOH   248     165.628  39.438   6.445  1.00 31.65           O
HETATM 1166  O   HOH   249     158.710  34.770  -6.387  1.00 30.31           O
HETATM 1167  O   HOH   250     162.568  40.773  -7.961  1.00 75.22           O
HETATM 1168  O   HOH   251     163.288  45.013  -7.285  1.00 48.22           O
HETATM 1169  O   HOH   252     153.343  30.821 -32.435  1.00 31.89           O
HETATM 1170  O   HOH   253     151.032  34.651 -28.310  1.00 50.45           O
HETATM 1171  O   HOH   254     153.664  38.706 -24.238  1.00 65.31           O
HETATM 1172  O   HOH   255     153.665  38.774 -13.000  1.00 35.47           O
HETATM 1173  O   HOH   256     159.158  44.270 -11.773  1.00 66.65           O
HETATM 1174  O   HOH   257     149.572  22.243   8.230  1.00 25.62           O
HETATM 1175  O   HOH   258     151.608  53.171   8.943  1.00 41.70           O
HETATM 1176  O   HOH   259     146.325  28.874 -25.979  1.00 43.62           O
HETATM 1177  O   HOH   260     141.897  33.449 -22.872  1.00 60.15           O
HETATM 1178  O   HOH   261     142.901  33.610 -33.680  1.00 32.13           O
HETATM 1179  O   HOH   262     142.993  26.074 -27.292  1.00 56.58           O
HETATM 1180  O   HOH   263     149.097  13.806  -1.263  1.00 37.20           O
HETATM 1181  O   HOH   264     143.952  19.577   4.867  1.00 34.68           O
HETATM 1182  O   HOH   265     146.180  25.248  -6.294  1.00 44.91           O
HETATM 1183  O   HOH   266     148.111  50.620  -3.136  1.00 55.61           O
HETATM 1184  O   HOH   267     144.093  13.465  10.360  1.00 64.38           O
HETATM 1185  O   HOH   268     141.577  14.676  13.168  1.00 54.76           O
HETATM 1186  O   HOH   269     137.019  17.606  19.854  1.00 33.36           O
HETATM 1187  O   HOH   270     149.639  55.203   4.611  1.00 49.01           O
HETATM 1188  O   HOH   271     156.238  32.191  -4.204  1.00 64.53           O
CONECT  453  685
CONECT  685  453
MASTER      357    0    0    1   10    0    0    6 1187    1    2   12
END
"""

dummy_file = DummyFile(test_file)


class EntityTests(TestCase):
    """Tests SMCRA.
    """

    def setUp(self):
        self.structure = PDBParser(dummy_file)
        self.working_model = self.structure.values()[0]
        self.working_chain = self.working_model.sortedvalues()[0] # waters have only one atom
        self.working_residue = self.working_chain.values()[0]
        self.working_residue2 = self.working_chain.values()[1]
        self.working_atom = self.working_residue.values()[0]

    def test_setId(self):
        """Test setting an id."""
        # structure
        self.structure.name = '4TSV'
        self.structure.id = ('4TSV',)
        self.structure.setId(('4TSV',))
        self.assertFalse(self.structure.modified)
        self.structure.setId(('4TSX',))
        self.assertTrue(self.structure.modified)
        self.assertEqual('4TSX', self.structure.name)
        self.structure.modified = False
        self.structure.setId()
        self.assertFalse(self.structure.modified)
        # residue 
        self.working_residue.modified = False
        (self.working_residue.name, self.working_residue.res_id, self.working_residue.res_ic) = ('XYZ', 666, 'W')
        self.working_residue.id = (('XYZ', 666, 'W'),)
        self.working_residue.setId()
        self.assertFalse(self.working_residue.modified)
        self.working_residue.setId((('XYZ', 666, 'W'),))
        self.assertFalse(self.working_residue.modified)
        self.working_residue.setId((('ABC', 999, 'M'),))
        self.assertTrue(self.working_residue.modified)
        self.assertEqual((self.working_residue.name, self.working_residue.res_id, self.working_residue.res_ic), ('ABC', 999, 'M'))
        self.assertEqual(self.working_residue.getId(), (('ABC', 999, 'M'),))
        # atom
        self.working_atom.modified = False
        (self.working_atom.at_id, self.working_atom.alt_loc) = ('X', 'W')
        self.working_atom.id = (('X', 'W'),)
        self.working_atom.setId()
        self.assertFalse(self.working_atom.modified)
        self.working_atom.setId((('X', 'W'),))
        self.assertFalse(self.working_atom.modified)
        self.working_atom.setId((('W', 'X'),))
        self.assertTrue(self.working_atom.modified)
        self.assertEqual((self.working_atom.at_id, self.working_atom.alt_loc), ('W', 'X'))
        self.assertEqual(self.working_atom.getId(), (('W', 'X'),))

    def test_masking(self):
        """Test entity masking."""
        self.assertFalse(self.structure.masked)
        self.assertFalse(self.working_model.masked)
        self.assertFalse(self.working_chain.masked)
        self.assertFalse(self.working_residue.masked)
        self.assertFalse(self.working_atom.masked)
        self.structure.setMasked()
        self.assertTrue(self.structure.masked)
        self.assertTrue(self.working_model.masked)
        self.assertTrue(self.working_chain.masked)
        self.assertTrue(self.working_residue.masked)
        self.assertTrue(self.working_residue2.masked)
        # Entity
        self.assertTrue(self.working_atom.masked)
        self.working_atom.setUnmasked()
        self.assertFalse(self.working_atom.masked)
        self.working_atom.setMasked()
        self.assertTrue(self.working_atom.masked)
        # all should be masked     
        # MultiyEntity
        self.structure.setUnmasked()
        self.structure.setUnmodified(True, True)
        self.assertFalse(self.structure.masked)
        self.assertFalse(self.working_model.masked)
        self.assertFalse(self.working_chain.masked)
        self.assertFalse(self.working_residue.masked)
        self.assertFalse(self.working_atom.masked)
        self.assertFalse(self.structure.masked)
        self.assertFalse(self.structure.modified)
        self.assertFalse(self.working_model.modified)
        self.assertFalse(self.working_chain.modified)
        self.assertFalse(self.working_residue.modified)
        self.assertFalse(self.working_atom.modified)
        self.working_residue.setMasked()
        self.assertTrue(self.working_residue.masked)
        self.assertTrue(self.working_atom.masked)
        self.assertTrue(self.structure.modified)
        self.assertTrue(self.working_model.modified)
        self.assertTrue(self.working_chain.modified)
        self.assertTrue(self.working_residue.modified)
        self.assertTrue(self.working_atom.modified)

    def test_parent(self):
        """Test parent manipulation"""
        self.assertFalse(self.structure.parent)
        self.assertTrue(self.working_model.parent)
        self.assertTrue(self.working_chain.parent)
        self.assertTrue(self.working_residue.parent)
        self.assertTrue(self.working_atom.parent)
        # atom
        self.working_atom.setUnmodified()
        self.working_residue.setUnmodified()
        self.working_residue2.setUnmodified()
        self.working_atom.setParent(self.working_residue2) # the other residue
        self.assertTrue(self.working_atom.modified)
        self.assertTrue(self.working_residue.modified)
        self.assertTrue(self.working_residue2.modified)

        self.working_atom.setUnmodified()
        self.working_atom.setParent(self.working_residue2) # the other residue
        self.assertFalse(self.working_atom.modified)

        self.working_atom.setParent(self.working_residue) # the first residue
        self.assertTrue(self.working_atom.modified)

        self.working_atom.setUnmodified(True, False)
        self.assertFalse(self.working_atom.modified)
        self.assertFalse(self.working_residue.modified)
        self.assertTrue(self.working_residue2.modified)

        #get parrent
        self.assertEqual(self.working_atom.getParent(), self.working_residue)
        self.assertEqual(self.working_atom.getParent('R'), self.working_residue)
        self.assertEqual(self.working_atom.getParent('C'), self.working_chain)
        self.assertEqual(self.working_atom.getParent('M'), self.working_model)
        self.assertEqual(self.working_atom.getParent('S'), self.structure)
        self.assertNotEqual(self.working_atom.getParent(), self.working_residue2)
        self.assertEqual(self.working_atom.getParent('C'), self.working_residue.getParent())
        self.assertEqual(self.working_atom.getParent('C'), self.working_residue2.getParent()) # should be the same chain

    def test_child(self):
        """Test child manipulation"""
        self.structure.setUnmodified()
        self.assertNotSameObj(self.working_residue2.get(self.working_atom.getId()), self.working_atom)
        self.assertSameObj(self.working_residue.get(self.working_atom.getId()), self.working_atom)
        self.working_residue2.addChild(self.working_atom)
        self.assertSameObj(self.working_residue2.get(self.working_atom.getId()), self.working_atom)
        self.assertFalse(self.working_residue.get(self.working_atom.getId()))
        self.assertTrue(self.structure.modified)
        self.assertTrue(self.working_model.modified)
        self.assertTrue(self.working_chain.modified)
        self.assertTrue(self.working_residue.modified)
        self.assertTrue(self.working_residue2.modified)
        self.assertTrue(self.working_atom.modified)
        self.structure.setUnmodified()
        self.assertSameObj(self.working_chain.get(self.working_residue.getId()), self.working_residue)
        self.working_chain.delChild(self.working_residue.getId())
        self.assertFalse(self.working_chain.get(self.working_residue.getId()))
        self.working_chain.addChild(self.working_residue)
        self.assertSameObj(self.working_chain.get(self.working_residue.getId()), self.working_residue)

    def test_getChildren(self):
        """Tests if can retrieve children."""
        id1 = self.working_residue.getId()
        id2 = self.working_residue2.getId()
        (child1, child2) = self.working_chain.getChildren([id1, id2])
        self.assertSameObj(self.working_residue, child1)
        self.assertSameObj(self.working_residue2, child2)
        self.working_residue.setMasked()
        self.assertEqual(len(self.working_chain.getChildren([id1, id2])), 1)
        self.assertEqual(len(self.working_chain.getChildren([id1, id2], unmask=True)), 2)
        self.working_residue.setUnmasked()
        self.assertEqual(len(self.working_chain.getChildren([id1, id2])), 2)

    def test_modif(self):
        """Tests modifications."""
        self.assertFalse(self.structure.modified)
        self.assertTrue(self.working_model.modified)
        self.assertTrue(self.working_chain.modified)
        self.assertTrue(self.working_residue.modified)
        self.assertTrue(self.working_atom.modified)
        self.working_model.setUnmodified()
        self.working_chain.setUnmodified()
        self.working_residue.setUnmodified()
        self.working_atom.setUnmodified()
        self.assertFalse(self.working_model.modified)
        self.assertFalse(self.working_chain.modified)
        self.assertFalse(self.working_residue.modified)
        self.assertFalse(self.working_atom.modified)
        self.structure.setModified(False, True)
        self.assertTrue(self.working_model.modified)
        self.assertTrue(self.working_chain.modified)
        self.assertTrue(self.working_residue.modified)
        self.assertTrue(self.working_atom.modified)
        self.working_atom.setUnmodified(True, False)
        self.assertFalse(self.working_model.modified)
        self.assertFalse(self.working_chain.modified)
        self.assertFalse(self.working_residue.modified)
        self.assertFalse(self.working_atom.modified)
        self.working_chain.setModified(True, True)
        self.assertTrue(self.structure.modified)
        self.assertTrue(self.working_model.modified)
        self.assertTrue(self.working_chain.modified)
        self.assertTrue(self.working_residue.modified)
        self.assertTrue(self.working_atom.modified)

    def test__link(self):
        """Tests linking for cPickle."""
        self.structure._unlink()
        self.assertFalse(self.structure.getChildren()[0].values()[0].\
                                              values()[0].values()[0].parent)
        self.structure._link()
        self.assertTrue(self.structure.getChildren()[0].values()[0].\
                                             values()[0].values()[0].parent)

    def test_iter(self):
        """Tests iterations."""
        self.assertTrue(self.working_chain.values())
        self.working_chain.setMasked()
        self.assertFalse(self.working_chain.values())
        self.assertTrue(self.working_chain.values(unmask=True))
        i = False
        for residue in self.working_chain:
            i = True
        self.assertFalse(i)
        self.working_chain.setUnmasked()
        for residue in self.working_chain:
            i = True
        self.assertTrue(i)
        
    def test_propagateData(self):
        from string import join
        result = self.working_chain.propagateData(join, 'A', 'element')
        assert self.working_chain.element is result
        assert isinstance(result, str)
        self.working_atom.xtra['what'] = 'this'
        result = self.working_chain.propagateData(join, 'A', 'what', xtra=True)
        assert result.strip() == 'this'
        

    def test_table_set_del_get(self):
        """test table creation
        """
        table = copy(self.working_chain.table)
        self.working_chain.setTable()
        assert self.working_chain.table != table
        self.working_chain.delTable()
        assert self.working_chain.table == table
        self.working_chain.setTable()
        assert self.working_chain.table['R'] is self.working_chain.getTable('R') != {}

#    def test_deepcopy(self):
#        """Tests deepcopy if nothing is lost."""
#        deep_structure = deepcopy(self.structure)
#        self.assertTrue(deep_structure == self.structure)
#        assert deep_structure is not self.structure

    def test_copy(self):
        wa_copied = copy(self.working_atom)
        wa_deepcopied = deepcopy(self.working_atom)
        self.assertTrue(self.working_atom.parent is self.working_residue)
        self.assertTrue(self.working_atom == wa_copied)
        self.assertFalse(self.working_atom is wa_copied)
        self.assertTrue(wa_copied.parent is None)
        self.assertTrue(self.working_atom == wa_deepcopied)
        self.assertFalse(self.working_atom is wa_deepcopied)
        self.assertTrue(wa_deepcopied.parent is None)

        wr_copied = copy(self.working_residue)
        wr_deepcopied = deepcopy(self.working_residue)
        self.assertTrue(self.working_residue == wr_deepcopied)
        self.assertFalse(self.working_residue is wr_copied)
        self.assertFalse(self.working_residue is wr_deepcopied)
        self.assertTrue(self.working_residue[(('N', ' '),)] ==
                                   wr_copied[(('N', ' '),)])
        self.assertTrue(self.working_residue[(('N', ' '),)] ==
                               wr_deepcopied[(('N', ' '),)])
        self.assertFalse(self.working_residue[(('N', ' '),)] is
                                   wr_copied[(('N', ' '),)])
        self.assertFalse(self.working_residue[(('N', ' '),)] is
                               wr_deepcopied[(('N', ' '),)])
        self.assertFalse(wr_copied[(('N', ' '),)] is
                         wr_deepcopied[(('N', ' '),)])
        #parentship
        self.assertTrue(self.working_residue.parent)
        self.assertTrue(wr_copied.parent is None)
        self.assertTrue(wr_deepcopied.parent is None)
        self.assertTrue(self.working_residue[(('N', ' '),)].parent)
        self.assertTrue(self.working_residue[(('N', ' '),)].parent is self.working_residue)
        self.assertTrue(wr_copied[(('N', ' '),)].parent is wr_copied)
        self.assertTrue(wr_deepcopied[(('N', ' '),)].parent is wr_deepcopied)


    def test_pickle(self):
        wa_copied = cPickle.loads(cPickle.dumps(self.working_atom))
        self.assertTrue(self.working_atom.parent is self.working_residue)
        self.assertTrue(self.working_atom == wa_copied)
        self.assertFalse(self.working_atom is wa_copied)
        self.assertTrue(wa_copied.parent is None)
        wr_copied = cPickle.loads(cPickle.dumps(self.working_residue))
        self.assertFalse(self.working_residue is wr_copied)
        self.assertTrue(self.working_residue[(('N', ' '),)] ==
                                   wr_copied[(('N', ' '),)])
        self.assertFalse(self.working_residue[(('N', ' '),)] is
                                   wr_copied[(('N', ' '),)])
        self.assertTrue(self.working_residue.parent)
        self.assertTrue(wr_copied.parent is None)
        self.assertTrue(self.working_residue[(('N', ' '),)].parent)
        self.assertTrue(self.working_residue[(('N', ' '),)].parent is self.working_residue)
        self.assertTrue(wr_copied[(('N', ' '),)].parent is wr_copied)

    def test_removeHydrogens(self):
        self.working_atom.setElement(' H')
        withh = len(self.working_residue.keys())
        self.working_residue.removeHydrogens()
        assert len(self.working_residue.keys()) == withh - 1

    def test_updateIds(self):
        """Test if ids get updated."""
        self.working_residue.name = 'XXX'
        try:
            self.working_chain[self.working_residue.getId()]
            raise AssertionError
        except KeyError:
            pass
        self.working_chain.updateIds()
        self.assertTrue(self.working_chain[self.working_residue.getId()])

    def test_table(self):
        """ Tests the creation of the SMCRA table."""
        for category in self.structure.table.values():
            self.assertTrue(category)
        for category in self.structure.values()[0].table.values():
            self.assertFalse(category)
        self.structure.values()[0].setTable()
        for category in self.structure.values()[0].table.values():
            self.assertTrue(category)
        self.structure.values()[0].setName(1)
        self.assertEqual(self.structure.table['M'].keys(), [(None, 0)]) # old id
        self.structure.setTable()
        self.assertEqual(self.structure.table['M'].keys(), [(None, 1)]) # new id

    def test_del_parent(self):
        """tests parent removal"""
        assert self.working_atom.getId() in self.working_residue
        self.working_atom.delParent()
        assert not self.working_atom.getId() in self.working_residue
        assert self.working_atom.parent is None
        
    def test_dispatch(self):
        """Tests method dispatching."""
        self.working_chain.dispatch('setMasked')
        self.assertTrue(self.working_residue.masked)
        self.assertTrue(self.working_chain.modified)
        self.assertFalse(self.working_chain.masked)
        self.assertFalse(self.working_chain.values())
        self.assertFalse(self.working_chain.values(unmask=False))
        self.assertTrue(self.working_chain.values(unmask=True))
        self.working_chain.dispatch('setUnmasked')
        self.assertTrue(self.working_residue.masked)  # dispatch should obey masking
        self.assertFalse(self.working_chain.values()) # -//-
        self.working_chain.setUnmasked(force=True)
        self.assertFalse(self.working_residue.masked)
        self.assertTrue(self.working_chain.values())

    def test_getMasked(self):
        """tests if masking works."""
        assert self.working_chain.getMasked() is False
        assert self.working_atom.getMasked() is False
        self.working_chain.setMasked()
        assert self.working_atom.getMasked() is True
        assert self.working_chain.getMasked() is True
        
        
    def test_selectChildren(self):
        from operator import eq
        assert self.working_chain.selectChildren('ALA', eq, 'name') == \
        self.working_chain.selectChildren('ALA', 'eq', 'name')
        assert self.working_chain.selectChildren('ALA', 'eq', 'name')

    def test_stripChildren(self):
        """Tests if removing children works."""
        i = 0
        res_num = len(self.working_chain)
        for residue in self.working_chain:
            if residue.name == 'ALA': i += 1
        self.working_chain.stripChildren('ALA', 'eq', 'name')
        self.assertEqual(len(self.working_chain) + i, res_num)
        self.assertEqual(len(self.working_chain.values()) + i, res_num)

    def test_maskChildren(self):
        i = 0
        res_num = len(self.working_chain)
        for residue in self.working_chain:
            if residue.name == 'ALA': i += 1
        self.working_chain.maskChildren('ALA', 'eq', 'name')
        self.assertEqual(len(self.working_chain), res_num)
        self.assertEqual(len(self.working_chain.values()) + i, res_num)

    def test_coords(self):
        self.assertTrue(sum(self.structure.coords))
        from copy import copy
        first_coords = copy(self.structure.coords)
        self.assertTrue(sum(self.working_model.coords))
        self.assertTrue(sum(self.working_atom.coords))
        self.assertTrue(sum(self.working_residue.coords))
        self.assertTrue(sum(self.working_chain.coords))
        from numpy import array
        result_array = array([0., 0., 0.])
        i = 0
        for atom in self.working_residue.getChildren():
            i += 1
            result_array += atom.coords
        self.assertFloatEqual(self.working_residue.coords, result_array / i)
        # recursive set/update
        self.working_atom.coords = array([0., 0., 0.])
        self.structure.setCoordsRecursively()
        self.assertNotEqual(self.structure.coords, first_coords)

    def test_coords2(self):
        from numpy import array, mean
        for residue in self.working_chain:
            residue.setCoords()
            atom_coords = []
            for atom in residue:
                atom_coords.append(atom.coords)
            residue_coords = mean(array(atom_coords), axis=0)
            self.assertFloatEqual(residue.coords, residue_coords)
        for residue in self.working_chain:
            residue.setCoords(' CA ', 'eq', 'name')
            for atom in residue:
                if atom.name == ' CA ': break
            atom_coords = atom.coords
            assert atom_coords is atom.getCoords()
            self.assertFloatEqual(residue.coords, atom_coords)
        

    def test_moveRecursively(self):
        from numpy import array
        first_coords = self.working_residue.coords
        self.structure.moveRecursively(self.structure.coords)
        self.assertFloatEqual(self.structure.coords, array([0., 0., 0.]))
        self.assertNotEqual(self.working_residue.coords, first_coords)

    def test_sorted(self):
        pass
        #print self.working_chain.sortedvalues()        

    def tearDown(self):
        self.structure = None
        
    def test_getSeq(self):
        testSeq = self.working_chain.getSeq()
        assert isinstance(testSeq, ProteinSequence)
        assert testSeq == "DKPVAHVVANPQAEGQLQWSNRRANALLANGVELRDNQLVVPIEGL" \
        "FLIYSQVLFKGQGCPSTHVLLTHTISRIAVSYQTKVNLLSAIKSPCQRETPEGAEAKPWYEPI" \
        "YLGGVFQLEKGDRLSAEINRPDYLDFAESGQVYFGIIAL"



#run if called from command-line
if __name__ == "__main__":
    main()
