# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementReachabilityAnalysisIntentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reachability_analysis_intents_list(self, resource_group):
        response = self.client.reachability_analysis_intents.list(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            workspace_name="str",
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reachability_analysis_intents_get(self, resource_group):
        response = self.client.reachability_analysis_intents.get(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            workspace_name="str",
            reachability_analysis_intent_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reachability_analysis_intents_create(self, resource_group):
        response = self.client.reachability_analysis_intents.create(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            workspace_name="str",
            reachability_analysis_intent_name="str",
            body={
                "properties": {
                    "destinationResourceId": "str",
                    "ipTraffic": {
                        "destinationIps": ["str"],
                        "destinationPorts": ["str"],
                        "protocols": ["str"],
                        "sourceIps": ["str"],
                        "sourcePorts": ["str"],
                    },
                    "sourceResourceId": "str",
                    "description": "str",
                    "provisioningState": "str",
                },
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_reachability_analysis_intents_delete(self, resource_group):
        response = self.client.reachability_analysis_intents.delete(
            resource_group_name=resource_group.name,
            network_manager_name="str",
            workspace_name="str",
            reachability_analysis_intent_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...
