######################################
package  DebugCustom;
######################################

##############################################################
=head1 NAME   
  DebugCustom  - A module for debugging
=head1 VERSION 
  $Id: DebugCustom.pm,v 1.4 2001/03/20 14:57:48 zdimic Exp $ 
=head1 SYNOPSIS     
  my $obj = new DebugCustom(DEBUG => "1"); - to turn it on
  my $obj = new DebugCustom(DEBUG => "0"); - to turn it off 
=head1 DESCRIPTION
  this module is used for debug printing
=cut 
###############################################################

$DebugCustom::AB_DEBUG=0;

sub new
{
   my $this     = shift;
   my %args     = @_;
   my $self     = {};  
   bless $self; 

    #print "args=@_\n";
    #print "args{DEBUG}= $args{DEBUG}"; 

   if ( defined $args{DEBUG}) {
       if ($args{DEBUG} == 1) {
          print "Module $0 is running in DEBUG mode\n";
       }
       $DebugCustom::AB_DEBUG=$args{DEBUG};
       #print "DebugCustom::AB_DEBUG=$DebugCustom::AB_DEBUG\n";    
   }

   return $self;
}

####################################################
# <p> debug print
# @param $string - any debug string
####################################################
sub debug_print {
   my $self = shift;
   if ($DebugCustom::AB_DEBUG) {
      my $string = $_[0];
      print "$string\n";
   }
} 

####################################################
# <p> debug print (multi-line)
# @param $string - any debug string
# @param @params - parameters to print
####################################################
sub debug_print_m  {
   my $self = shift; 
   if ($DebugCustom::AB_DEBUG) {
     my  $string = $_[0];
     my $i;
      print "$string \n";
      for($i=1; $i<@_; $i++) {
           print "  $i:    $_[$i] \n";
       }
    }
}    

####################################################
# <p>DEBUG  PRINT Array
# @param - $string - header string
# @param @array - array to print
####################################################
sub debug_print_array {
   my $self = shift;
   if ($DebugCustom::AB_DEBUG) { 
      my  $string = $_[0];
      print "$string \n";
      my $i;
      for($i=1; $i<@_; $i++) {
         print "  $i:    $_[$i] \n";
      }
   }
}      

####################################################
# <p> PRINT Array
# @param - $string - header string
# @param @array - array to print
####################################################
sub print_array {
   my $self = shift;
   my  $string = $_[0];
   print "$string \n";
   my $i;
   my $j=0;
   for($i=1; $i<@_; $i++) { 
         print "  $j:    $_[$i] \n";
   }
}

#######################################################
# <p> PRINT Hash 
# @param - $string - header string
# @param - $hash_ref - reference to hash array to print
#######################################################
sub debug_print_hash {
   if ($DebugCustom::AB_DEBUG) { 
   	my $self = shift;
   	my  ($string, $hash_ref) = @_; 
   	print "$string \n";
   	
   	my $j=0;
   	foreach $key (sort keys %{$hash_ref}) {
       	   $j++;
       	   print "  $j:  key=$key   value=$hash_ref->{$key} \n";
   	}
   }
}       
 
1;  
