## Usage

```js
var homedir = require('{%= name %}');
console.log(homedir());
//=> /Users/doowb
```

## Reasoning

This library is a polyfill for the [node.js os.homedir](https://nodejs.org/api/os.html#os_os_homedir) method found in modern versions of node.js.

This implementation tries to follow the implementation found in `libuv` by finding the current user using the `process.geteuid()` method and the `/etc/passwd` file. This should usually work in a linux environment, but will also fallback to looking at user specific environment variables to build the user's home directory if neccessary.

Since `/etc/passwd` is not available on windows platforms, this implementation will use environment variables to find the home directory.

In modern versions of node.js, [os.homedir](https://nodejs.org/api/os.html#os_os_homedir) is used.
