/* isocodes.c generated by valac 0.48.18, the Vala compiler
 * generated from isocodes.vala, do not modify */

/* Copyright © 2012-2013 Tobias Quathamer
 *
 * This file is part of libisocodes.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <locale.h>
#include <glib/gstdio.h>
#include <gee.h>
#include <libxml/xpath.h>

#define LIBISOCODES_TYPE_ISO_CODES (libisocodes_iso_codes_get_type ())
#define LIBISOCODES_ISO_CODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes))
#define LIBISOCODES_ISO_CODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_CodesClass))
#define LIBISOCODES_IS_ISO_CODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBISOCODES_TYPE_ISO_CODES))
#define LIBISOCODES_IS_ISO_CODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBISOCODES_TYPE_ISO_CODES))
#define LIBISOCODES_ISO_CODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_CodesClass))

typedef struct _libisocodesISO_Codes libisocodesISO_Codes;
typedef struct _libisocodesISO_CodesClass libisocodesISO_CodesClass;
typedef struct _libisocodesISO_CodesPrivate libisocodesISO_CodesPrivate;
enum  {
	LIBISOCODES_ISO_CODES_0_PROPERTY,
	LIBISOCODES_ISO_CODES_STANDARD_PROPERTY,
	LIBISOCODES_ISO_CODES_NUM_PROPERTIES
};
static GParamSpec* libisocodes_iso_codes_properties[LIBISOCODES_ISO_CODES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _libisocodesISO_Codes {
	GObject parent_instance;
	libisocodesISO_CodesPrivate * priv;
};

struct _libisocodesISO_CodesClass {
	GObjectClass parent_class;
	gchar** (*_get_xpaths) (libisocodesISO_Codes* self, const gchar* code, gint* result_length1);
	gchar** (*_get_fields) (libisocodesISO_Codes* self, gint* result_length1);
};

struct _libisocodesISO_CodesPrivate {
	gchar* _iso_codes_xml_version;
	gchar* _filepath;
	gchar* _standard;
	gchar* _locale;
	xmlDoc* _xml;
	xmlParserCtxt* _ctx;
};

typedef enum  {
	LIBISOCODES_ISO_CODES_ERROR_CANNOT_OPEN_FILE,
	LIBISOCODES_ISO_CODES_ERROR_CANNOT_CREATE_LIBXML_STRUCTURE,
	LIBISOCODES_ISO_CODES_ERROR_CANNOT_PARSE_FILE,
	LIBISOCODES_ISO_CODES_ERROR_FILE_DOES_NOT_CONTAIN_ISO_DATA,
	LIBISOCODES_ISO_CODES_ERROR_CODE_NOT_DEFINED
} libisocodesISOCodesError;
#define LIBISOCODES_ISO_CODES_ERROR libisocodes_iso_codes_error_quark ()

static gint libisocodesISO_Codes_private_offset;
static gpointer libisocodes_iso_codes_parent_class = NULL;

GType libisocodes_iso_codes_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (libisocodesISO_Codes, g_object_unref)
gchar** _libisocodes_iso_codes_get_xpaths (libisocodesISO_Codes* self,
                                           const gchar* code,
                                           gint* result_length1);
gchar** _libisocodes_iso_codes_get_fields (libisocodesISO_Codes* self,
                                           gint* result_length1);
GQuark libisocodes_iso_codes_error_quark (void);
gchar* libisocodes_iso_codes_get_iso_codes_xml_version (libisocodesISO_Codes* self,
                                                        GError** error);
void _libisocodes_iso_codes_open_file (libisocodesISO_Codes* self,
                                       const gchar* name,
                                       GError** error);
gchar* libisocodes_iso_codes_get_filepath (libisocodesISO_Codes* self);
void libisocodes_iso_codes_set_filepath (libisocodesISO_Codes* self,
                                         const gchar* path);
gchar* libisocodes_iso_codes_get_locale (libisocodesISO_Codes* self);
void libisocodes_iso_codes_set_locale (libisocodesISO_Codes* self,
                                       const gchar* locale);
void _libisocodes_iso_codes_setup_i18n (libisocodesISO_Codes* self);
const gchar* libisocodes_iso_codes_get_standard (libisocodesISO_Codes* self);
GeeArrayList* _libisocodes_iso_codes_find_all (libisocodesISO_Codes* self,
                                               GError** error);
void _libisocodes_iso_codes_translate (libisocodesISO_Codes* self,
                                       GeeHashMap* item,
                                       const gchar* locale);
GeeHashMap* _libisocodes_iso_codes_find_code (libisocodesISO_Codes* self,
                                              const gchar* code,
                                              GError** error);
gboolean _libisocodes_iso_codes_is_number (libisocodesISO_Codes* self,
                                           const gchar* text);
static gchar** libisocodes_iso_codes_real__get_xpaths (libisocodesISO_Codes* self,
                                                const gchar* code,
                                                gint* result_length1);
static gchar** libisocodes_iso_codes_real__get_fields (libisocodesISO_Codes* self,
                                                gint* result_length1);
libisocodesISO_Codes* libisocodes_iso_codes_construct (GType object_type);
void libisocodes_iso_codes_set_standard (libisocodesISO_Codes* self,
                                         const gchar* value);
static void libisocodes_iso_codes_finalize (GObject * obj);
static GType libisocodes_iso_codes_get_type_once (void);
static void _vala_libisocodes_iso_codes_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_libisocodes_iso_codes_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
libisocodes_iso_codes_get_instance_private (libisocodesISO_Codes* self)
{
	return G_STRUCT_MEMBER_P (self, libisocodesISO_Codes_private_offset);
}

/**
         * Get method for major version of the iso-codes XML files.
         * 
         * There is no set method because it does not make sense and
         * is therefore not necessary.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
gchar*
libisocodes_iso_codes_get_iso_codes_xml_version (libisocodesISO_Codes* self,
                                                 GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_iso_codes_xml_version;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		_libisocodes_iso_codes_open_file (self, "", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp1_ = self->priv->_iso_codes_xml_version;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
         * Get method for filepath of the XML file.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
gchar*
libisocodes_iso_codes_get_filepath (libisocodesISO_Codes* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filepath;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
         * Set method for filepath of the XML file.
         * 
         * If the new path is an empty string or NULL, the previous
         * value is not changed.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
void
libisocodes_iso_codes_set_filepath (libisocodesISO_Codes* self,
                                    const gchar* path)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlParserCtxt* _tmp4_;
	g_return_if_fail (self != NULL);
	if (path == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (path, "") == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_strdup (path);
	_g_free0 (self->priv->_filepath);
	self->priv->_filepath = _tmp1_;
	_tmp2_ = self->priv->_xml;
	if (_tmp2_ != NULL) {
		xmlDoc* _tmp3_;
		_tmp3_ = self->priv->_xml;
		xmlFreeDoc (_tmp3_);
		self->priv->_xml = NULL;
	}
	_tmp4_ = self->priv->_ctx;
	if (_tmp4_ != NULL) {
		xmlParserCtxt* _tmp5_;
		_tmp5_ = self->priv->_ctx;
		xmlFreeParserCtxt (_tmp5_);
		self->priv->_ctx = NULL;
	}
}

/**
         * Get method for output locale.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
gchar*
libisocodes_iso_codes_get_locale (libisocodesISO_Codes* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locale;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
         * Set method for output locale.
         * 
         * If the new locale is an empty string or NULL, no locale
         * is used for the returned values.
         * 
         * Currently, these methods need to be implemented instead
         * of using the built-in get/set methods.
         */
void
libisocodes_iso_codes_set_locale (libisocodesISO_Codes* self,
                                  const gchar* locale)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (locale);
	_g_free0 (self->priv->_locale);
	self->priv->_locale = _tmp0_;
}

/**
         * Set up the i18n framework.
         * 
         * This method needs to be called by every subclass.
         */
void
_libisocodes_iso_codes_setup_i18n (libisocodesISO_Codes* self)
{
	g_return_if_fail (self != NULL);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	setlocale (LC_ALL, "");
}

/**
         * Open and parse the file.
         * 
         * This method checks that the file exists and tries to parse
         * it.
         * 
         * @param string Filename to open, defaults to filepath.
         */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
_libisocodes_iso_codes_open_file (libisocodesISO_Codes* self,
                                  const gchar* name,
                                  GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	xmlParserCtxt* _tmp9_;
	xmlParserCtxt* _tmp10_;
	xmlParserCtxt* _tmp12_;
	xmlParserCtxt* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	xmlDoc* _tmp16_;
	xmlDoc* _tmp17_;
	gchar* root_name = NULL;
	xmlDoc* _tmp24_;
	xmlNode* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* expected_name = NULL;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp46_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (g_strcmp0 (name, "") != 0) {
		libisocodes_iso_codes_set_filepath (self, name);
	}
	_tmp0_ = libisocodes_iso_codes_get_filepath (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_IS_REGULAR) == FALSE;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp3_ = libisocodes_iso_codes_get_filepath (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_replace (_ ("The file \"%(filename)s\" could not be opened."), "%(filename)s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new_literal (LIBISOCODES_ISO_CODES_ERROR, LIBISOCODES_ISO_CODES_ERROR_CANNOT_OPEN_FILE, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = xmlNewParserCtxt ();
	self->priv->_ctx = _tmp9_;
	_tmp10_ = self->priv->_ctx;
	if (_tmp10_ == NULL) {
		GError* _tmp11_;
		_tmp11_ = g_error_new_literal (LIBISOCODES_ISO_CODES_ERROR, LIBISOCODES_ISO_CODES_ERROR_CANNOT_CREATE_LIBXML_STRUCTURE, _ ("An internal libxml structure could not be created."));
		_inner_error0_ = _tmp11_;
		if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = self->priv->_ctx;
	xmlCtxtUseOptions (_tmp12_, (gint) (XML_PARSE_NOERROR + XML_PARSE_NOWARNING));
	_tmp13_ = self->priv->_ctx;
	_tmp14_ = libisocodes_iso_codes_get_filepath (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = xmlCtxtReadFile (_tmp13_, _tmp15_, NULL, 0);
	self->priv->_xml = _tmp16_;
	_g_free0 (_tmp15_);
	_tmp17_ = self->priv->_xml;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
		_tmp18_ = libisocodes_iso_codes_get_filepath (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = string_replace (_ ("The file \"%(filename)s\" could not be parsed correctly."), "%(filename)s", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_error_new_literal (LIBISOCODES_ISO_CODES_ERROR, LIBISOCODES_ISO_CODES_ERROR_CANNOT_PARSE_FILE, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_inner_error0_ = _tmp23_;
		if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp24_ = self->priv->_xml;
	_tmp25_ = xmlDocGetRootElement (_tmp24_);
	_tmp26_ = _tmp25_->name;
	_tmp27_ = g_strdup (_tmp26_);
	root_name = _tmp27_;
	_tmp28_ = self->priv->_standard;
	_tmp29_ = string_replace (_tmp28_, "-", "_");
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat ("iso_", _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strconcat (_tmp32_, "_entries", NULL);
	_tmp34_ = _tmp33_;
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	expected_name = _tmp34_;
	_tmp35_ = root_name;
	_tmp36_ = expected_name;
	if (g_strcmp0 (_tmp35_, _tmp36_) != 0) {
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		GError* _tmp44_;
		GError* _tmp45_;
		_tmp37_ = libisocodes_iso_codes_get_filepath (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = string_replace (_ ("The file \"%(filename)s\" does not contain valid ISO %(standard)s data" \
"."), "%(filename)s", _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = self->priv->_standard;
		_tmp42_ = string_replace (_tmp40_, "%(standard)s", _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_error_new_literal (LIBISOCODES_ISO_CODES_ERROR, LIBISOCODES_ISO_CODES_ERROR_FILE_DOES_NOT_CONTAIN_ISO_DATA, _tmp43_);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp43_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		_inner_error0_ = _tmp45_;
		if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (expected_name);
			_g_free0 (root_name);
			return;
		} else {
			_g_free0 (expected_name);
			_g_free0 (root_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp46_ = g_strdup ("3");
	_g_free0 (self->priv->_iso_codes_xml_version);
	self->priv->_iso_codes_xml_version = _tmp46_;
	_g_free0 (expected_name);
	_g_free0 (root_name);
}

/**
         * Return an array of all items in the ISO standard.
         * 
         * @return array All ISO 3166 items.
         */
GeeArrayList*
_libisocodes_iso_codes_find_all (libisocodesISO_Codes* self,
                                 GError** error)
{
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	gchar* xpath = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	xmlDoc* _tmp8_;
	xmlXPathContext* context = NULL;
	xmlDoc* _tmp9_;
	xmlXPathContext* _tmp10_;
	xmlXPathContext* _tmp11_;
	xmlXPathObject* obj = NULL;
	xmlXPathContext* _tmp12_;
	const gchar* _tmp13_;
	xmlXPathObject* _tmp14_;
	xmlNodeSet* nodeset = NULL;
	xmlXPathObject* _tmp15_;
	xmlNodeSet* _tmp16_;
	gchar** fields = NULL;
	gint _tmp17_ = 0;
	gchar** _tmp18_;
	gint fields_length1;
	gint _fields_size_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->_standard;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("//iso_", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "_entry", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	xpath = _tmp7_;
	_tmp8_ = self->priv->_xml;
	if (_tmp8_ == NULL) {
		_libisocodes_iso_codes_open_file (self, "", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (xpath);
				_g_object_unref0 (_result_);
				return NULL;
			} else {
				_g_free0 (xpath);
				_g_object_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp9_ = self->priv->_xml;
	_tmp10_ = xmlXPathNewContext (_tmp9_);
	context = _tmp10_;
	_tmp11_ = context;
	_vala_assert (_tmp11_ != NULL, "context != null");
	_tmp12_ = context;
	_tmp13_ = xpath;
	_tmp14_ = xmlXPathEval ((xmlChar*) _tmp13_, _tmp12_);
	obj = _tmp14_;
	_tmp15_ = obj;
	_tmp16_ = _tmp15_->nodesetval;
	nodeset = _tmp16_;
	_tmp18_ = _libisocodes_iso_codes_get_fields (self, &_tmp17_);
	fields = _tmp18_;
	fields_length1 = _tmp17_;
	_fields_size_ = fields_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				xmlNodeSet* _tmp21_;
				xmlNode* node = NULL;
				xmlNodeSet* _tmp22_;
				xmlNode* _tmp23_;
				GeeHashMap* item = NULL;
				GeeHashMap* _tmp24_;
				gchar** _tmp25_;
				gint _tmp25__length1;
				const gchar* _tmp40_;
				gboolean _tmp52_ = FALSE;
				const gchar* _tmp53_;
				GeeArrayList* _tmp57_;
				GeeHashMap* _tmp58_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = nodeset;
				if (!(i < xmlXPathNodeSetGetLength (_tmp21_))) {
					break;
				}
				_tmp22_ = nodeset;
				_tmp23_ = xmlXPathNodeSetItem (_tmp22_, i);
				node = _tmp23_;
				_tmp24_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				item = _tmp24_;
				_tmp25_ = fields;
				_tmp25__length1 = fields_length1;
				{
					gchar** field_collection = NULL;
					gint field_collection_length1 = 0;
					gint _field_collection_size_ = 0;
					gint field_it = 0;
					field_collection = _tmp25_;
					field_collection_length1 = _tmp25__length1;
					for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
						gchar* _tmp26_;
						gchar* field = NULL;
						_tmp26_ = g_strdup (field_collection[field_it]);
						field = _tmp26_;
						{
							GeeHashMap* _tmp27_;
							const gchar* _tmp28_;
							xmlNode* _tmp29_;
							const gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp32_;
							GeeHashMap* _tmp33_;
							const gchar* _tmp34_;
							gpointer _tmp35_;
							gchar* _tmp36_;
							gboolean _tmp37_;
							_tmp27_ = item;
							_tmp28_ = field;
							_tmp29_ = node;
							_tmp30_ = field;
							_tmp31_ = (gchar*) xmlGetProp (_tmp29_, (xmlChar*) _tmp30_);
							_tmp32_ = _tmp31_;
							gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, _tmp32_);
							_g_free0 (_tmp32_);
							_tmp33_ = item;
							_tmp34_ = field;
							_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, _tmp34_);
							_tmp36_ = (gchar*) _tmp35_;
							_tmp37_ = _tmp36_ == NULL;
							_g_free0 (_tmp36_);
							if (_tmp37_) {
								GeeHashMap* _tmp38_;
								const gchar* _tmp39_;
								_tmp38_ = item;
								_tmp39_ = field;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp38_, _tmp39_, "");
							}
							_g_free0 (field);
						}
					}
				}
				_tmp40_ = self->priv->_standard;
				if (g_strcmp0 (_tmp40_, "3166-2") == 0) {
					GeeHashMap* _tmp41_;
					xmlNode* _tmp42_;
					xmlNode* _tmp43_;
					xmlNode* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					GeeHashMap* _tmp47_;
					xmlNode* _tmp48_;
					xmlNode* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					_tmp41_ = item;
					_tmp42_ = node;
					_tmp43_ = _tmp42_->parent;
					_tmp44_ = _tmp43_->parent;
					_tmp45_ = (gchar*) xmlGetProp (_tmp44_, (xmlChar*) "code");
					_tmp46_ = _tmp45_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp41_, "country", _tmp46_);
					_g_free0 (_tmp46_);
					_tmp47_ = item;
					_tmp48_ = node;
					_tmp49_ = _tmp48_->parent;
					_tmp50_ = (gchar*) xmlGetProp (_tmp49_, (xmlChar*) "type");
					_tmp51_ = _tmp50_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp47_, "type", _tmp51_);
					_g_free0 (_tmp51_);
				}
				_tmp53_ = self->priv->_locale;
				if (_tmp53_ != NULL) {
					const gchar* _tmp54_;
					_tmp54_ = self->priv->_locale;
					_tmp52_ = g_strcmp0 (_tmp54_, "") != 0;
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					GeeHashMap* _tmp55_;
					const gchar* _tmp56_;
					_tmp55_ = item;
					_tmp56_ = self->priv->_locale;
					_libisocodes_iso_codes_translate (self, _tmp55_, _tmp56_);
				}
				_tmp57_ = _result_;
				_tmp58_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp58_);
				_g_object_unref0 (item);
			}
		}
	}
	result = _result_;
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_xmlXPathFreeContext0 (context);
	_g_free0 (xpath);
	return result;
}

/**
         * Find the given code or codes with the given XPath.
         * 
         * @param string Code to search for.
         */
GeeHashMap*
_libisocodes_iso_codes_find_code (libisocodesISO_Codes* self,
                                  const gchar* code,
                                  GError** error)
{
	gboolean did_not_find_code = FALSE;
	GeeHashMap* _result_ = NULL;
	GeeHashMap* _tmp0_;
	xmlDoc* _tmp1_;
	xmlXPathContext* context = NULL;
	xmlDoc* _tmp2_;
	xmlXPathContext* _tmp3_;
	xmlXPathContext* _tmp4_;
	gchar** xpaths = NULL;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint xpaths_length1;
	gint _xpaths_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp53_ = FALSE;
	const gchar* _tmp54_;
	GError* _inner_error0_ = NULL;
	GeeHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (code != NULL, NULL);
	did_not_find_code = TRUE;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->_xml;
	if (_tmp1_ == NULL) {
		_libisocodes_iso_codes_open_file (self, "", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_result_);
				return NULL;
			} else {
				_g_object_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp2_ = self->priv->_xml;
	_tmp3_ = xmlXPathNewContext (_tmp2_);
	context = _tmp3_;
	_tmp4_ = context;
	_vala_assert (_tmp4_ != NULL, "context != null");
	_tmp6_ = _libisocodes_iso_codes_get_xpaths (self, code, &_tmp5_);
	xpaths = _tmp6_;
	xpaths_length1 = _tmp5_;
	_xpaths_size_ = xpaths_length1;
	_tmp7_ = xpaths;
	_tmp7__length1 = xpaths_length1;
	{
		gchar** xpath_collection = NULL;
		gint xpath_collection_length1 = 0;
		gint _xpath_collection_size_ = 0;
		gint xpath_it = 0;
		xpath_collection = _tmp7_;
		xpath_collection_length1 = _tmp7__length1;
		for (xpath_it = 0; xpath_it < xpath_collection_length1; xpath_it = xpath_it + 1) {
			gchar* _tmp8_;
			gchar* xpath = NULL;
			_tmp8_ = g_strdup (xpath_collection[xpath_it]);
			xpath = _tmp8_;
			{
				xmlXPathObject* obj = NULL;
				xmlXPathContext* _tmp9_;
				const gchar* _tmp10_;
				xmlXPathObject* _tmp11_;
				xmlNodeSet* nodeset = NULL;
				xmlXPathObject* _tmp12_;
				xmlNodeSet* _tmp13_;
				xmlNodeSet* _tmp14_;
				_tmp9_ = context;
				_tmp10_ = xpath;
				_tmp11_ = xmlXPathEval ((xmlChar*) _tmp10_, _tmp9_);
				obj = _tmp11_;
				_tmp12_ = obj;
				_tmp13_ = _tmp12_->nodesetval;
				nodeset = _tmp13_;
				_tmp14_ = nodeset;
				if (xmlXPathNodeSetGetLength (_tmp14_) == 1) {
					gchar** fields = NULL;
					gint _tmp15_ = 0;
					gchar** _tmp16_;
					gint fields_length1;
					gint _fields_size_;
					xmlNode* node = NULL;
					xmlNodeSet* _tmp17_;
					xmlNode* _tmp18_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp34_;
					_tmp16_ = _libisocodes_iso_codes_get_fields (self, &_tmp15_);
					fields = _tmp16_;
					fields_length1 = _tmp15_;
					_fields_size_ = fields_length1;
					_tmp17_ = nodeset;
					_tmp18_ = xmlXPathNodeSetItem (_tmp17_, 0);
					node = _tmp18_;
					_tmp19_ = fields;
					_tmp19__length1 = fields_length1;
					{
						gchar** field_collection = NULL;
						gint field_collection_length1 = 0;
						gint _field_collection_size_ = 0;
						gint field_it = 0;
						field_collection = _tmp19_;
						field_collection_length1 = _tmp19__length1;
						for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
							gchar* _tmp20_;
							gchar* field = NULL;
							_tmp20_ = g_strdup (field_collection[field_it]);
							field = _tmp20_;
							{
								GeeHashMap* _tmp21_;
								const gchar* _tmp22_;
								xmlNode* _tmp23_;
								const gchar* _tmp24_;
								gchar* _tmp25_;
								gchar* _tmp26_;
								GeeHashMap* _tmp27_;
								const gchar* _tmp28_;
								gpointer _tmp29_;
								gchar* _tmp30_;
								gboolean _tmp31_;
								_tmp21_ = _result_;
								_tmp22_ = field;
								_tmp23_ = node;
								_tmp24_ = field;
								_tmp25_ = (gchar*) xmlGetProp (_tmp23_, (xmlChar*) _tmp24_);
								_tmp26_ = _tmp25_;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp22_, _tmp26_);
								_g_free0 (_tmp26_);
								_tmp27_ = _result_;
								_tmp28_ = field;
								_tmp29_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp27_, _tmp28_);
								_tmp30_ = (gchar*) _tmp29_;
								_tmp31_ = _tmp30_ == NULL;
								_g_free0 (_tmp30_);
								if (_tmp31_) {
									GeeHashMap* _tmp32_;
									const gchar* _tmp33_;
									_tmp32_ = _result_;
									_tmp33_ = field;
									gee_abstract_map_set ((GeeAbstractMap*) _tmp32_, _tmp33_, "");
								}
								_g_free0 (field);
							}
						}
					}
					_tmp34_ = self->priv->_standard;
					if (g_strcmp0 (_tmp34_, "3166-2") == 0) {
						GeeHashMap* _tmp35_;
						xmlNode* _tmp36_;
						xmlNode* _tmp37_;
						xmlNode* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						GeeHashMap* _tmp41_;
						xmlNode* _tmp42_;
						xmlNode* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						_tmp35_ = _result_;
						_tmp36_ = node;
						_tmp37_ = _tmp36_->parent;
						_tmp38_ = _tmp37_->parent;
						_tmp39_ = (gchar*) xmlGetProp (_tmp38_, (xmlChar*) "code");
						_tmp40_ = _tmp39_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp35_, "country", _tmp40_);
						_g_free0 (_tmp40_);
						_tmp41_ = _result_;
						_tmp42_ = node;
						_tmp43_ = _tmp42_->parent;
						_tmp44_ = (gchar*) xmlGetProp (_tmp43_, (xmlChar*) "type");
						_tmp45_ = _tmp44_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp41_, "type", _tmp45_);
						_g_free0 (_tmp45_);
					}
					did_not_find_code = FALSE;
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xpath);
					break;
				}
				_g_free0 (xpath);
			}
		}
	}
	if (did_not_find_code) {
		gchar* _tmp46_;
		gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		GError* _tmp51_;
		GError* _tmp52_;
		_tmp46_ = string_replace (_ ("The code \"%(code)s\" is not defined in ISO %(standard)s."), "%(code)s", code);
		_tmp47_ = _tmp46_;
		_tmp48_ = self->priv->_standard;
		_tmp49_ = string_replace (_tmp47_, "%(standard)s", _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_error_new_literal (LIBISOCODES_ISO_CODES_ERROR, LIBISOCODES_ISO_CODES_ERROR_CODE_NOT_DEFINED, _tmp50_);
		_tmp52_ = _tmp51_;
		_g_free0 (_tmp50_);
		_g_free0 (_tmp47_);
		_inner_error0_ = _tmp52_;
		if (_inner_error0_->domain == LIBISOCODES_ISO_CODES_ERROR) {
			g_propagate_error (error, _inner_error0_);
			xpaths = (_vala_array_free (xpaths, xpaths_length1, (GDestroyNotify) g_free), NULL);
			_xmlXPathFreeContext0 (context);
			_g_object_unref0 (_result_);
			return NULL;
		} else {
			xpaths = (_vala_array_free (xpaths, xpaths_length1, (GDestroyNotify) g_free), NULL);
			_xmlXPathFreeContext0 (context);
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp54_ = self->priv->_locale;
	if (_tmp54_ != NULL) {
		const gchar* _tmp55_;
		_tmp55_ = self->priv->_locale;
		_tmp53_ = g_strcmp0 (_tmp55_, "") != 0;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		GeeHashMap* _tmp56_;
		const gchar* _tmp57_;
		_tmp56_ = _result_;
		_tmp57_ = self->priv->_locale;
		_libisocodes_iso_codes_translate (self, _tmp56_, _tmp57_);
	}
	result = _result_;
	xpaths = (_vala_array_free (xpaths, xpaths_length1, (GDestroyNotify) g_free), NULL);
	_xmlXPathFreeContext0 (context);
	return result;
}

/**
         * Translate an item to the wanted locale.
         * 
         * @param HashMap<string, string> Entry to be translated
         * @param string Locale to use for translation
         */
void
_libisocodes_iso_codes_translate (libisocodesISO_Codes* self,
                                  GeeHashMap* item,
                                  const gchar* locale)
{
	gchar** fields_to_translate = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint fields_to_translate_length1;
	gint _fields_to_translate_size_;
	gchar* loc_backup = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* env = NULL;
	const gchar* _tmp7_;
	gchar* env_backup = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* domain = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp27_;
	const gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (locale != NULL);
	_tmp0_ = g_strdup ("name");
	_tmp1_ = g_strdup ("official_name");
	_tmp2_ = g_strdup ("common_name");
	_tmp3_ = g_strdup ("currency_name");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	fields_to_translate = _tmp4_;
	fields_to_translate_length1 = 4;
	_fields_to_translate_size_ = fields_to_translate_length1;
	_tmp5_ = setlocale (LC_ALL, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	loc_backup = _tmp6_;
	_tmp7_ = g_getenv ("LANGUAGE");
	env = _tmp7_;
	_tmp8_ = env;
	_tmp9_ = g_strdup (_tmp8_);
	env_backup = _tmp9_;
	g_setenv ("LANGUAGE", locale, TRUE);
	setlocale (LC_ALL, "");
	_tmp10_ = self->priv->_standard;
	_tmp11_ = string_replace (_tmp10_, "-", "_");
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("iso_", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	domain = _tmp14_;
	_tmp15_ = fields_to_translate;
	_tmp15__length1 = fields_to_translate_length1;
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = _tmp15_;
		field_collection_length1 = _tmp15__length1;
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
			gchar* _tmp16_;
			gchar* field = NULL;
			_tmp16_ = g_strdup (field_collection[field_it]);
			field = _tmp16_;
			{
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp18_;
				_tmp18_ = field;
				if (gee_abstract_map_has_key ((GeeAbstractMap*) item, _tmp18_)) {
					const gchar* _tmp19_;
					gpointer _tmp20_;
					gchar* _tmp21_;
					_tmp19_ = field;
					_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) item, _tmp19_);
					_tmp21_ = (gchar*) _tmp20_;
					_tmp17_ = g_strcmp0 (_tmp21_, "") != 0;
					_g_free0 (_tmp21_);
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gpointer _tmp25_;
					gchar* _tmp26_;
					_tmp22_ = field;
					_tmp23_ = domain;
					_tmp24_ = field;
					_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) item, _tmp24_);
					_tmp26_ = (gchar*) _tmp25_;
					gee_abstract_map_set ((GeeAbstractMap*) item, _tmp22_, g_dgettext (_tmp23_, _tmp26_));
					_g_free0 (_tmp26_);
				}
				_g_free0 (field);
			}
		}
	}
	_tmp27_ = env_backup;
	if (_tmp27_ == NULL) {
		g_unsetenv ("LANGUAGE");
	} else {
		const gchar* _tmp28_;
		_tmp28_ = env_backup;
		g_setenv ("LANGUAGE", _tmp28_, TRUE);
	}
	_tmp29_ = loc_backup;
	setlocale (LC_ALL, _tmp29_);
	_g_free0 (domain);
	_g_free0 (env_backup);
	_g_free0 (loc_backup);
	fields_to_translate = (_vala_array_free (fields_to_translate, fields_to_translate_length1, (GDestroyNotify) g_free), NULL);
}

/**
         * Determine whether a given string represents a number.
         */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
_libisocodes_iso_codes_is_number (libisocodesISO_Codes* self,
                                  const gchar* text)
{
	gboolean contains_only_digits = FALSE;
	gint length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint index = 0;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	contains_only_digits = TRUE;
	_tmp0_ = strlen (text);
	_tmp1_ = _tmp0_;
	length = _tmp1_;
	index = 0;
	while (TRUE) {
		gint _tmp2_;
		if (!(index < length)) {
			break;
		}
		if (!g_ascii_isdigit (string_get (text, (glong) index))) {
			contains_only_digits = FALSE;
			break;
		}
		_tmp2_ = index;
		index = _tmp2_ + 1;
	}
	result = contains_only_digits;
	return result;
}

/**
         * Return all XPaths which should be tested with the given code.
         * 
         * @param string Code to search for, e.g. 'DE', 'DEU', '788'.
         * @return string[] Array of XPaths which are applicable to the code.
         */
static gchar**
libisocodes_iso_codes_real__get_xpaths (libisocodesISO_Codes* self,
                                        const gchar* code,
                                        gint* result_length1)
{
	g_critical ("Type `%s' does not implement abstract method `_libisocodes_iso_codes_get_xpaths'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar**
_libisocodes_iso_codes_get_xpaths (libisocodesISO_Codes* self,
                                   const gchar* code,
                                   gint* result_length1)
{
	g_return_val_if_fail (self != NULL, NULL);
	return LIBISOCODES_ISO_CODES_GET_CLASS (self)->_get_xpaths (self, code, result_length1);
}

/**
         * Return all fields of the current ISO standard.
         * 
         * This is needed for constructing the HashMap.
         * 
         * @return string[] Array with the names of all fields in the current standard.
         */
static gchar**
libisocodes_iso_codes_real__get_fields (libisocodesISO_Codes* self,
                                        gint* result_length1)
{
	g_critical ("Type `%s' does not implement abstract method `_libisocodes_iso_codes_get_fields'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar**
_libisocodes_iso_codes_get_fields (libisocodesISO_Codes* self,
                                   gint* result_length1)
{
	g_return_val_if_fail (self != NULL, NULL);
	return LIBISOCODES_ISO_CODES_GET_CLASS (self)->_get_fields (self, result_length1);
}

libisocodesISO_Codes*
libisocodes_iso_codes_construct (GType object_type)
{
	libisocodesISO_Codes * self = NULL;
	self = (libisocodesISO_Codes*) g_object_new (object_type, NULL);
	return self;
}

const gchar*
libisocodes_iso_codes_get_standard (libisocodesISO_Codes* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_standard;
	result = _tmp0_;
	return result;
}

void
libisocodes_iso_codes_set_standard (libisocodesISO_Codes* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = libisocodes_iso_codes_get_standard (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_standard);
		self->priv->_standard = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, libisocodes_iso_codes_properties[LIBISOCODES_ISO_CODES_STANDARD_PROPERTY]);
	}
}

static void
libisocodes_iso_codes_class_init (libisocodesISO_CodesClass * klass,
                                  gpointer klass_data)
{
	libisocodes_iso_codes_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &libisocodesISO_Codes_private_offset);
	((libisocodesISO_CodesClass *) klass)->_get_xpaths = (gchar** (*) (libisocodesISO_Codes*, const gchar*, gint*)) libisocodes_iso_codes_real__get_xpaths;
	((libisocodesISO_CodesClass *) klass)->_get_fields = (gchar** (*) (libisocodesISO_Codes*, gint*)) libisocodes_iso_codes_real__get_fields;
	G_OBJECT_CLASS (klass)->get_property = _vala_libisocodes_iso_codes_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_libisocodes_iso_codes_set_property;
	G_OBJECT_CLASS (klass)->finalize = libisocodes_iso_codes_finalize;
	/**
	         * The ISO standard currently in use.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIBISOCODES_ISO_CODES_STANDARD_PROPERTY, libisocodes_iso_codes_properties[LIBISOCODES_ISO_CODES_STANDARD_PROPERTY] = g_param_spec_string ("standard", "standard", "standard", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
libisocodes_iso_codes_instance_init (libisocodesISO_Codes * self,
                                     gpointer klass)
{
	gchar* _tmp0_;
	self->priv = libisocodes_iso_codes_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_iso_codes_xml_version = _tmp0_;
	self->priv->_xml = NULL;
	self->priv->_ctx = NULL;
}

static void
libisocodes_iso_codes_finalize (GObject * obj)
{
	libisocodesISO_Codes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes);
	_g_free0 (self->priv->_iso_codes_xml_version);
	_g_free0 (self->priv->_filepath);
	_g_free0 (self->priv->_standard);
	_g_free0 (self->priv->_locale);
	G_OBJECT_CLASS (libisocodes_iso_codes_parent_class)->finalize (obj);
}

static GType
libisocodes_iso_codes_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (libisocodesISO_CodesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) libisocodes_iso_codes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (libisocodesISO_Codes), 0, (GInstanceInitFunc) libisocodes_iso_codes_instance_init, NULL };
	GType libisocodes_iso_codes_type_id;
	libisocodes_iso_codes_type_id = g_type_register_static (G_TYPE_OBJECT, "libisocodesISO_Codes", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	libisocodesISO_Codes_private_offset = g_type_add_instance_private (libisocodes_iso_codes_type_id, sizeof (libisocodesISO_CodesPrivate));
	return libisocodes_iso_codes_type_id;
}

GType
libisocodes_iso_codes_get_type (void)
{
	static volatile gsize libisocodes_iso_codes_type_id__volatile = 0;
	if (g_once_init_enter (&libisocodes_iso_codes_type_id__volatile)) {
		GType libisocodes_iso_codes_type_id;
		libisocodes_iso_codes_type_id = libisocodes_iso_codes_get_type_once ();
		g_once_init_leave (&libisocodes_iso_codes_type_id__volatile, libisocodes_iso_codes_type_id);
	}
	return libisocodes_iso_codes_type_id__volatile;
}

static void
_vala_libisocodes_iso_codes_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	libisocodesISO_Codes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes);
	switch (property_id) {
		case LIBISOCODES_ISO_CODES_STANDARD_PROPERTY:
		g_value_set_string (value, libisocodes_iso_codes_get_standard (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_libisocodes_iso_codes_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	libisocodesISO_Codes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, LIBISOCODES_TYPE_ISO_CODES, libisocodesISO_Codes);
	switch (property_id) {
		case LIBISOCODES_ISO_CODES_STANDARD_PROPERTY:
		libisocodes_iso_codes_set_standard (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

