/*
 * @(#)DirectoryChannelLoggerUTest.java
 *
 * Copyright (C) 2003-2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.logger;

import java.io.File;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.codecoverage.v2.CCCreatorUtil;


/**
 * Tests the DirectoryChannelLogger class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/07/07 09:39:13 $
 * @since     January 22, 2003
 */
public class DirectoryChannelLoggerUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = DirectoryChannelLoggerUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public DirectoryChannelLoggerUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        new DirectoryChannelLogger( null );
    }
    
    
    public void testNullDir1()
    {
        DirectoryChannelLogger dcl = new DirectoryChannelLogger( null );
        short a = (short)1;
        dcl.cover( "a", a, a );
        dcl.cover( "b", a, a );
        dcl.cover( "c", a, a );
    }
    
    
    public void testCreateFile1()
    {
        // test the base directory + one up not existing
        File basedir = CCCreatorUtil.createNewDirectory();
        File otherDir = new File( basedir, "1" );
        otherDir = new File( otherDir, "2" );
        DirectoryChannelLogger dcl = new DirectoryChannelLogger( otherDir );
        dcl.cover( "a", (short)1, (short)1 );
        File outputFile = new File( otherDir, "a.class.log" );
        assertTrue(
            "Incorrectly was able to create output file.",
            !outputFile.exists() );
    }
    
    
    public void testCreateFile2()
    {
        // test the base directory already existing
        File basedir = CCCreatorUtil.createNewDirectory();
        DirectoryChannelLogger dcl = new DirectoryChannelLogger( basedir );
        dcl.cover( "a", (short)1, (short)1 );
        File outputFile = new File( basedir, "a.class.log" );
        assertTrue(
            "Did not create output file.",
            outputFile.exists() );
    }
    
    
    public void testCreateFile3()
    {
        // test the base directory not existing, but the one up does
        File basedir = CCCreatorUtil.createNewDirectory();
        File otherDir = new File( basedir, "1" );
        DirectoryChannelLogger dcl = new DirectoryChannelLogger( otherDir );
        dcl.cover( "a", (short)1, (short)1 );
        File outputFile = new File( otherDir, "a.class.log" );
        assertTrue(
            "Did not create output file.",
            outputFile.exists() );
    }
    
    
    public void testCreateCoverString1()
    {
        assertEquals(
            "Didn't convert right",
            "0001 0004\n",
            coverString( 0x1, 0x4 ) );
    }
    
    
    public void testCreateCoverString2()
    {
        assertEquals(
            "Didn't convert right",
            "0030 FFDD\n",
            coverString( 0x30, 0xFFDD ) );
    }
    
    
    public void testCreateCoverString3()
    {
        assertEquals(
            "Didn't convert right",
            "0000 0000\n",
            coverString( 0x0, 0x0 ) );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    protected String coverString( int a, int b )
    {
        char c[] = DirectoryChannelLogger.createCoverString(
            (short)a, (short)b );
        return new String( c );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();

       
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

