/*
 *  Copyright (C) 2017 - This file is part of libecc project
 *
 *  Authors:
 *      Ryad BENADJILA <ryadbenadjila@gmail.com>
 *      Arnaud EBALARD <arnaud.ebalard@ssi.gouv.fr>
 *      Jean-Pierre FLORI <jean-pierre.flori@ssi.gouv.fr>
 *
 *  Contributors:
 *      Nicolas VIVET <nicolas.vivet@ssi.gouv.fr>
 *      Karim KHALFALLAH <karim.khalfallah@ssi.gouv.fr>
 *
 *  This software is licensed under a dual BSD and GPL v2 license.
 *  See LICENSE file at the root folder of the project.
 */
#include "../../lib_ecc_config.h"
#ifdef WITH_CURVE_FRP256V1

#ifndef __EC_PARAMS_FRP256V1_H__
#define __EC_PARAMS_FRP256V1_H__
#include "ec_params_external.h"

static const u8 frp256v1_p[] = {
	0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f,
	0x10, 0x12, 0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b,
	0x39, 0x61, 0xad, 0xbc, 0xab, 0xc8, 0xca, 0x6d,
	0xe8, 0xfc, 0xf3, 0x53, 0xd8, 0x6e, 0x9c, 0x03
};

TO_EC_STR_PARAM(frp256v1_p);

#define CURVE_FRP256V1_P_BITLEN 256
static const u8 frp256v1_p_bitlen[] = { 0x01, 0x00 };

TO_EC_STR_PARAM(frp256v1_p_bitlen);

static const u8 frp256v1_r[] = {
	0x0e, 0x02, 0xe8, 0x73, 0xf4, 0xc5, 0x2a, 0x70,
	0xef, 0xed, 0x92, 0x17, 0x31, 0xbd, 0xbc, 0xa4,
	0xc6, 0x9e, 0x52, 0x43, 0x54, 0x37, 0x35, 0x92,
	0x17, 0x03, 0x0c, 0xac, 0x27, 0x91, 0x63, 0xfd
};

TO_EC_STR_PARAM(frp256v1_r);

static const u8 frp256v1_r_square[] = {
	0xb0, 0x2c, 0x8f, 0x9f, 0x88, 0xeb, 0x98, 0xac,
	0x62, 0xb7, 0x01, 0x2f, 0xce, 0x13, 0x7e, 0xee,
	0x84, 0x6f, 0x80, 0x83, 0x0c, 0x96, 0x0f, 0x92,
	0xb0, 0xc2, 0x4e, 0x77, 0xc9, 0x9f, 0x15, 0x13
};

TO_EC_STR_PARAM(frp256v1_r_square);

static const u8 frp256v1_mpinv[] = {
	0xc7, 0x97, 0x48, 0x3a, 0x16, 0x4e, 0x11, 0x55
};

TO_EC_STR_PARAM(frp256v1_mpinv);

static const u8 frp256v1_p_shift[] = {
	0x00
};

TO_EC_STR_PARAM(frp256v1_p_shift);

#if (WORD_BYTES == 8)		/* 64-bit words */
static const u8 frp256v1_p_reciprocal[] = {
	0x0e, 0xd2, 0x97, 0xdc, 0xc7, 0xd2, 0xb0, 0x40
};
#elif (WORD_BYTES == 4)		/* 32-bit words */
static const u8 frp256v1_p_reciprocal[] = {
	0x0e, 0xd2, 0x97, 0xdc
};
#elif (WORD_BYTES == 2)		/* 16-bit words */
static const u8 frp256v1_p_reciprocal[] = {
	0x0e, 0xd2
};
#else /* unknown word size */
#error "Unsupported word size"
#endif
TO_EC_STR_PARAM(frp256v1_p_reciprocal);

static const u8 frp256v1_a[] = {
	0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f,
	0x10, 0x12, 0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b,
	0x39, 0x61, 0xad, 0xbc, 0xab, 0xc8, 0xca, 0x6d,
	0xe8, 0xfc, 0xf3, 0x53, 0xd8, 0x6e, 0x9c, 0x00
};

TO_EC_STR_PARAM(frp256v1_a);

static const u8 frp256v1_b[] = {
	0xee, 0x35, 0x3f, 0xca, 0x54, 0x28, 0xa9, 0x30,
	0x0d, 0x4a, 0xba, 0x75, 0x4a, 0x44, 0xc0, 0x0f,
	0xdf, 0xec, 0x0c, 0x9a, 0xe4, 0xb1, 0xa1, 0x80,
	0x30, 0x75, 0xed, 0x96, 0x7b, 0x7b, 0xb7, 0x3f
};

TO_EC_STR_PARAM(frp256v1_b);

#define CURVE_FRP256V1_CURVE_ORDER_BITLEN 256
static const u8 frp256v1_curve_order[] = {
	0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f,
	0x10, 0x12, 0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b,
	0x53, 0xdc, 0x67, 0xe1, 0x40, 0xd2, 0xbf, 0x94,
	0x1f, 0xfd, 0xd4, 0x59, 0xc6, 0xd6, 0x55, 0xe1
};

TO_EC_STR_PARAM(frp256v1_curve_order);

static const u8 frp256v1_gx[] = {
	0xb6, 0xb3, 0xd4, 0xc3, 0x56, 0xc1, 0x39, 0xeb,
	0x31, 0x18, 0x3d, 0x47, 0x49, 0xd4, 0x23, 0x95,
	0x8c, 0x27, 0xd2, 0xdc, 0xaf, 0x98, 0xb7, 0x01,
	0x64, 0xc9, 0x7a, 0x2d, 0xd9, 0x8f, 0x5c, 0xff
};

TO_EC_STR_PARAM(frp256v1_gx);

static const u8 frp256v1_gy[] = {
	0x61, 0x42, 0xe0, 0xf7, 0xc8, 0xb2, 0x04, 0x91,
	0x1f, 0x92, 0x71, 0xf0, 0xf3, 0xec, 0xef, 0x8c,
	0x27, 0x01, 0xc3, 0x07, 0xe8, 0xe4, 0xc9, 0xe1,
	0x83, 0x11, 0x5a, 0x15, 0x54, 0x06, 0x2c, 0xfb
};

TO_EC_STR_PARAM(frp256v1_gy);

static const u8 frp256v1_gz[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
};

TO_EC_STR_PARAM(frp256v1_gz);

static const u8 frp256v1_gen_order[] = {
	0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f,
	0x10, 0x12, 0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b,
	0x53, 0xdc, 0x67, 0xe1, 0x40, 0xd2, 0xbf, 0x94,
	0x1f, 0xfd, 0xd4, 0x59, 0xc6, 0xd6, 0x55, 0xe1
};

TO_EC_STR_PARAM(frp256v1_gen_order);

#define CURVE_FRP256V1_Q_BITLEN 256
static const u8 frp256v1_gen_order_bitlen[] = { 0x01, 0x00 };

TO_EC_STR_PARAM(frp256v1_gen_order_bitlen);

static const u8 frp256v1_cofactor[] = { 0x01 };

TO_EC_STR_PARAM(frp256v1_cofactor);

static const u8 frp256v1_alpha_montgomery[] = {
	0x00,
};

TO_EC_STR_PARAM_FIXED_SIZE(frp256v1_alpha_montgomery, 0);

static const u8 frp256v1_gamma_montgomery[] = {
	0x00,
};

TO_EC_STR_PARAM_FIXED_SIZE(frp256v1_gamma_montgomery, 0);

static const u8 frp256v1_alpha_edwards[] = {
	0x00,
};

TO_EC_STR_PARAM_FIXED_SIZE(frp256v1_alpha_edwards, 0);

static const u8 frp256v1_oid[] = "1.2.250.1.223.101.256.1";
TO_EC_STR_PARAM(frp256v1_oid);

static const u8 frp256v1_name[] = "FRP256V1";
TO_EC_STR_PARAM(frp256v1_name);

static const ec_str_params frp256v1_str_params = {
	.p = &frp256v1_p_str_param,
	.p_bitlen = &frp256v1_p_bitlen_str_param,
	.r = &frp256v1_r_str_param,
	.r_square = &frp256v1_r_square_str_param,
	.mpinv = &frp256v1_mpinv_str_param,
	.p_shift = &frp256v1_p_shift_str_param,
	.p_normalized = &frp256v1_p_str_param,
	.p_reciprocal = &frp256v1_p_reciprocal_str_param,
	.a = &frp256v1_a_str_param,
	.b = &frp256v1_b_str_param,
	.curve_order = &frp256v1_curve_order_str_param,
	.gx = &frp256v1_gx_str_param,
	.gy = &frp256v1_gy_str_param,
	.gz = &frp256v1_gz_str_param,
	.gen_order = &frp256v1_gen_order_str_param,
	.gen_order_bitlen = &frp256v1_gen_order_bitlen_str_param,
	.cofactor = &frp256v1_cofactor_str_param,
	.alpha_montgomery = &frp256v1_alpha_montgomery_str_param,
	.gamma_montgomery = &frp256v1_gamma_montgomery_str_param,
	.alpha_edwards = &frp256v1_alpha_edwards_str_param,
	.oid = &frp256v1_oid_str_param,
	.name = &frp256v1_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN	0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_FRP256V1_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_FRP256V1_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN	0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_FRP256V1_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_FRP256V1_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN	0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_FRP256V1_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_FRP256V1_CURVE_ORDER_BITLEN
#endif

#endif /* __EC_PARAMS_FRP256V1_H__ */

#endif /* WITH_CURVE_FRP256V1 */
