#!/bin/sh
#
# simple wrapper shell script which selects appropriate fte executable
#

if [ -n "$DISPLAY" ]; then
	if which xfte >/dev/null; then
		exec xfte "$@"
	elif which sfte >/dev/null; then
		exec sfte "$@"
	elif which nfte >/dev/null; then
		exec nfte "$@"
	elif which vfte >/dev/null; then
		echo "Only Console version installed!"
	fi
else
	if [ "$TERM" = linux ] && tty | egrep '^/dev/tty[0-9]+$' >/dev/null && which vfte >/dev/null; then
		exec vfte "$@"
	elif which sfte >/dev/null; then
		exec sfte "$@"
	elif which nfte >/dev/null; then
		exec nfte "$@"
	elif which xfte >/dev/null; then
		echo "Only X-Window version installed!"
	fi

fi

echo "No binary executable from the FTE family has been found!"
echo "Please install one of them."
