#!/bin/sh -e

VERSION=$1
TAR=../dtd-parser_$VERSION.orig.tar.xz
DIR=dtd-parser-$VERSION
DATE=$(echo "$VERSION" | sed -e 's/^.*\+svn//;s/$/T2359Z/')
TAG=$(echo "dtd-parser-$VERSION" | sed -re's/~(alpha|beta)/-\1-/')

svn export -r {$DATE} https://svn.java.net/svn/dtd-parser~svn/trunk/dtd-parser $DIR
XZ_OPT=--best tar -c -J -f $TAR \
    --exclude '*.jar' \
    --exclude '*.class' \
    --exclude '*.ipr' \
    --exclude '*.iml' \
    --exclude '.settings' \
    --exclude '.project' \
    --exclude '.classpath' \
    $DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
