#!/bin/bash
#
# Written by Hugo Haas <hugo@debian.org> for ippl.
# Modified by Marc Haber <mh+debian-packages@zugschlus.de>.
# Adapted for dsc-collector by Marc Haber <mh+debian-packages@zugschlus.de>

### BEGIN INIT INFO
# Provides:          dsc-statistics-presenter
# Required-Start:    $local_fs $remote_fs
# Required-Stop:     $local_fs $remote_fs
# Should-Start:
# Should-Stop:
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: dsc-statistics-presenter
# Description:       A DNS Statistics Collector - Presenter component
### END INIT INFO

set -e

if ! [ -x "/lib/lsb/init-functions" ]; then
  . /lib/lsb/init-functions
else
  echo "E: /lib/lsb/init-functions not found, lsb-base (>= 3.0-6) needed"
  exit 1
fi

if [ -n "$DSCDEBUG" ]; then
  echo "now debugging $0 $@"
  set -x
fi

LANG=C
export LANG

NAME="dsc-presenter"
DESC="DNS Statistics Presenter"

start() {
  log_daemon_msg "Starting $DESC" "$NAME"

  lRUNDIR="/var/run/dsc-statistics-presenter"

  [ -e $lRUNDIR ] || mkdir -p $lRUNDIR
  chown Debian-dsc-statistics $lRUNDIR
  ret=$?

  log_end_msg $ret

  return $ret
}

case "$1" in
  start)
    start
    ;;
  stop)
    ;;
  restart|force-reload)
    start
    ;;
  status)
    ;;
  *)
    log_failure_msg "Usage: $0 {start|restart|force-reload}" >&2
    exit 1
    ;;
esac

exit 0
