<style>
.promo li a {
    float: left;
    width: 130px;
    height: 20px;
    text-align: center;
    margin: 10px 30px;
    padding: 150px 0 0 0;
    background-position: 0 50%;
    background-size: 130px auto;
    background-repeat: no-repeat;
    font-size: 120%;
    color: black;
}
.promo li {
    list-style: none;
}
</style>

# Django REST framework 3.6

The 3.6 release adds two major new features to REST framework.

1. Built-in interactive API documentation support.
2. A new JavaScript client&nbsp;library.

![API Documentation](/img/api-docs.gif)

*Above: The interactive API documentation.*

---

## Funding

The 3.6 release would not have been possible without our [backing from Mozilla](mozilla-grant.md) to the project, and our [collaborative funding&nbsp;model][funding].

If you use REST framework commercially and would like to see this work continue,
we strongly encourage you to invest in its continued development by
**[signing up for a paid&nbsp;plan][funding]**.

<ul class="premium-promo promo">
    <li><a href="http://jobs.rover.com/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/rover_130x130.png)">Rover.com</a></li>
    <li><a href="https://getsentry.com/welcome/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/sentry130.png)">Sentry</a></li>
    <li><a href="https://getstream.io/try-the-api/?utm_source=drf&utm_medium=banner&utm_campaign=drf" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/stream-130.png)">Stream</a></li>
    <li><a href="https://hello.machinalis.co.uk/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/Machinalis130.png)">Machinalis</a></li>
    <li><a href="https://rollbar.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/rollbar.png)">Rollbar</a></li>
    <li><a href="https://micropyramid.com/django-rest-framework-development-services/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/mp-text-logo.png)">MicroPyramid</a></li>
</ul>
<div style="clear: both; padding-bottom: 20px;"></div>

*Many thanks to all our [sponsors][sponsors], and in particular to our premium backers, [Rover](http://jobs.rover.com/), [Sentry](https://getsentry.com/welcome/), [Stream](https://getstream.io/?utm_source=drf&utm_medium=banner&utm_campaign=drf), [Machinalis](https://hello.machinalis.co.uk/), [Rollbar](https://rollbar.com), and [MicroPyramid](https://micropyramid.com/django-rest-framework-development-services/).*

---

## Interactive API documentation

REST framework's new API documentation supports a number of features:

* Live API interaction.
* Support for various authentication schemes.
* Code snippets for the Python, JavaScript, and Command Line clients.

The `coreapi` library is required as a dependancy for the API docs. Make sure
to install the latest version (2.3.0 or above). The `pygments` and `markdown`
libraries are optional but recommended.

To install the API documentation, you'll need to include it in your projects URLconf:

    from rest_framework.documentation import include_docs_urls

    API_TITLE = 'API title'
    API_DESCRIPTION = '...'

    urlpatterns = [
        ...
        url(r'^docs/', include_docs_urls(title=API_TITLE, description=API_DESCRIPTION))
    ]

Once installed you should see something a little like this:

![API Documentation](/img/api-docs.png)

We'll likely be making further refinements to the API documentation over the
coming weeks. Keep in mind that this is a new feature, and please do give
us feedback if you run into any issues or limitations.

For more information on documenting your API endpoints see the ["Documenting your API"][api-docs] section.

---

## JavaScript client library

The JavaScript client library allows you to load an API schema, and then interact
with that API at an application layer interface, rather than constructing fetch
requests explicitly.

Here's a brief example that demonstrates:

* Loading the client library and schema.
* Instantiating an authenticated client.
* Making an API request using the client.

**index.html**

    <html>
        <head>
            <script src="/static/rest_framework/js/coreapi-0.1.0.js"></script>
            <script src="/docs/schema.js"></script>
            <script>
                const coreapi = window.coreapi
                const schema = window.schema

                // Instantiate a client...
                let auth = coreapi.auth.TokenAuthentication({scheme: 'JWT', token: 'xxx'})
                let client = coreapi.Client({auth: auth})

                // Make an API request...
                client.action(schema, ['projects', 'list']).then(function(result) {
                    alert(result)
                })
            </script>
        </head>
    </html>

The JavaScript client library supports various authentication schemes, and can be
used by your project itself, or as an external client interacting with your API.

The client is not limited to usage with REST framework APIs, although it does
currently only support loading CoreJSON API schemas. Support for Swagger and
other API schemas is planned.

For more details see the [JavaScript client library documentation][js-docs].

## Authentication classes for the Python client library

Previous authentication support in the Python client library was limited to
allowing users to provide explicit header values.

We now have better support for handling the details of authentication, with
the introduction of the `BasicAuthentication`, `TokenAuthentication`, and
`SessionAuthentication` schemes.

You can include the authentication scheme when instantiating a new client.

    auth = coreapi.auth.TokenAuthentication(scheme='JWT', token='xxx-xxx-xxx')
    client = coreapi.Client(auth=auth)

For more information see the [Python client library documentation][py-docs].

---

## Deprecations

### Updating coreapi

If you're using REST framework's schema generation, or want to use the API docs,
then you'll need to update to the latest version of coreapi. (2.3.0)

### Generating schemas from Router

The 3.5 "pending deprecation" of router arguments for generating a schema view, such as `schema_title`, `schema_url` and `schema_renderers`, have now been escalated to a
"deprecated" warning.

Instead of using `DefaultRouter(schema_title='Example API')`, you should use the `get_schema_view()` function, and include the view explicitly in your URL conf.

### DjangoFilterBackend

The 3.5 "pending deprecation" warning of the built-in `DjangoFilterBackend` has now
been escalated to a "deprecated" warning.

You should change your imports and REST framework filter settings as follows:

* `rest_framework.filters.DjangoFilterBackend` becomes `django_filters.rest_framework.DjangoFilterBackend`.
* `rest_framework.filters.FilterSet` becomes `django_filters.rest_framework.FilterSet`.

---

## What's next

There are likely to be a number of refinements to the API documentation and
JavaScript client library over the coming weeks, which could include some of the following:

* Support for private API docs, requiring login.
* File upload and download support in the JavaScript client & API docs.
* Comprehensive documentation for the JavaScript client library.
* Automatically including authentication details in the API doc code snippets.
* Adding authentication support in the command line client.
* Support for loading Swagger and other schemas in the JavaScript client.
* Improved support for documenting parameter schemas and response schemas.
* Refining the API documentation interaction modal.

Once work on those refinements is complete, we'll be starting feature work
on realtime support, for the 3.7 release.

[sponsors]: https://fund.django-rest-framework.org/topics/funding/#our-sponsors
[funding]: funding.md
[api-docs]: documenting-your-api.md
[js-docs]: api-clients.md#javascript-client-library
[py-docs]: api-clients.md#python-client-library
