/*******************************************************************************

  Intel Data Center Bridging (DCB) Software
  Copyright(c) 2007-2009 Intel Corporation.

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

  The full GNU General Public License is included in this distribution in
  the file called "COPYING".

  Contact Information:
  e1000-eedc Mailing List <e1000-eedc@lists.sourceforge.net>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/

#include "includes.h"
#include <syslog.h>
#include <pthread.h>

#include "agent.h"
#include "ports.h"
#include "tlv.h"
#include "states.h"
#include "l2_packet.h"
#include "eloop.h"
#include "version.h"

static int initialize_agent(void);

struct unpacked_tlv *Type0 = NULL;

static void timer(void *eloop_data, void *user_ctx)
{
	struct port *port = porthead;

	while (port != NULL) {
		run_tx_sm(port, TRUE);
		run_rx_sm(port, TRUE);
		port = port->next;
	};
	/* Load new timer */
	eloop_register_timeout(1, 0, timer, NULL, NULL);
}

static int initialize_agent(void)
{
	/* Construct the End TLV. */
	Type0 = bld_end_tlv();
	if (!Type0)
		return 0;

	return 1;
} 

int start_lldp_agent(void)
{
	if (!initialize_agent()) {
		return 0;
	} else {
		eloop_register_timeout(1, 0, timer, NULL, NULL);
		return 1;
	}
}

void stop_lldp_agent(void)
{
	eloop_cancel_timeout(timer, NULL, NULL);
	remove_all_bond_ports();
	free_unpkd_tlv(Type0);
}
