pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;

package dbus_shared_h is


   DBUS_SERVICE_DBUS : aliased constant String := "org.freedesktop.DBus" & ASCII.NUL;  --  ../dbus/dbus-shared.h:76

   DBUS_PATH_DBUS : aliased constant String := "/org/freedesktop/DBus" & ASCII.NUL;  --  ../dbus/dbus-shared.h:80

   DBUS_PATH_LOCAL : aliased constant String := "/org/freedesktop/DBus/Local" & ASCII.NUL;  --  ../dbus/dbus-shared.h:82

   DBUS_INTERFACE_DBUS : aliased constant String := "org.freedesktop.DBus" & ASCII.NUL;  --  ../dbus/dbus-shared.h:88

   DBUS_INTERFACE_INTROSPECTABLE : aliased constant String := "org.freedesktop.DBus.Introspectable" & ASCII.NUL;  --  ../dbus/dbus-shared.h:90

   DBUS_INTERFACE_PROPERTIES : aliased constant String := "org.freedesktop.DBus.Properties" & ASCII.NUL;  --  ../dbus/dbus-shared.h:92

   DBUS_INTERFACE_PEER : aliased constant String := "org.freedesktop.DBus.Peer" & ASCII.NUL;  --  ../dbus/dbus-shared.h:94

   DBUS_INTERFACE_LOCAL : aliased constant String := "org.freedesktop.DBus.Local" & ASCII.NUL;  --  ../dbus/dbus-shared.h:100

   DBUS_NAME_FLAG_ALLOW_REPLACEMENT : constant := 16#1#;  --  ../dbus/dbus-shared.h:103
   DBUS_NAME_FLAG_REPLACE_EXISTING : constant := 16#2#;  --  ../dbus/dbus-shared.h:104
   DBUS_NAME_FLAG_DO_NOT_QUEUE : constant := 16#4#;  --  ../dbus/dbus-shared.h:105

   DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER : constant := 1;  --  ../dbus/dbus-shared.h:108
   DBUS_REQUEST_NAME_REPLY_IN_QUEUE : constant := 2;  --  ../dbus/dbus-shared.h:109
   DBUS_REQUEST_NAME_REPLY_EXISTS : constant := 3;  --  ../dbus/dbus-shared.h:110
   DBUS_REQUEST_NAME_REPLY_ALREADY_OWNER : constant := 4;  --  ../dbus/dbus-shared.h:111

   DBUS_RELEASE_NAME_REPLY_RELEASED : constant := 1;  --  ../dbus/dbus-shared.h:114
   DBUS_RELEASE_NAME_REPLY_NON_EXISTENT : constant := 2;  --  ../dbus/dbus-shared.h:115
   DBUS_RELEASE_NAME_REPLY_NOT_OWNER : constant := 3;  --  ../dbus/dbus-shared.h:116

   DBUS_START_REPLY_SUCCESS : constant := 1;  --  ../dbus/dbus-shared.h:119
   DBUS_START_REPLY_ALREADY_RUNNING : constant := 2;  --  ../dbus/dbus-shared.h:120

   subtype DBusBusType is unsigned;
   DBUS_BUS_SESSION : constant DBusBusType := 0;
   DBUS_BUS_SYSTEM : constant DBusBusType := 1;
   DBUS_BUS_STARTER : constant DBusBusType := 2;  -- ../dbus/dbus-shared.h:61:3

   subtype DBusHandlerResult is unsigned;
   DBUS_HANDLER_RESULT_HANDLED : constant DBusHandlerResult := 0;
   DBUS_HANDLER_RESULT_NOT_YET_HANDLED : constant DBusHandlerResult := 1;
   DBUS_HANDLER_RESULT_NEED_MEMORY : constant DBusHandlerResult := 2;  -- ../dbus/dbus-shared.h:71:3

end dbus_shared_h;
