#   debian-lintian.mk -- Install lintian files
#
#   Copyright
#
#	Copyright (C) 2008-2010 Jari Aalto <jari.aalto@cante.net>
#
#   License
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program. If not, see <http://www.gnu.org/licenses/>.
#
#   Description
#
#	This is GNU makefile part, that defines lintian override file
#       handling for packages.
#
#       If the override is for a source package, you have to place it at
#       debian/source.lintian-overrides. For binary, Write file
#       debian/<package>.lintian-overrides
#
#           <package> binary: <lintian-error> <file>
#
#      Add this to debian/rules
#
#          install:
#	       ...
#	       $(MAKE) install
#	       $(lintian-overrides)
#
#	NOTE: There is better way. Name the files /*.lintian-overrides
#	add rule 'dh_lintian' to target 'install:'

ifneq (,)
    This makefile requires GNU Make.
endif

PACKAGE		?= foo
PKGDIR		?= $(shell pwd)/debian/$(PACKAGE)
OVERRIDEDIR	= usr/share/lintian/overrides
PKGDIR_LINTIAN	= $(PKGDIR)/$(OVERRIDEDIR)

INSTALL		?= /usr/bin/install
INSTALL_DIR	= $(INSTALL) -m 755 -d
INSTALL_DATA	= $(INSTALL) -p -m 644

define lintian-overrides
	# Install Lintian override file
	$(INSTALL_DIR) $(PKGDIR_LINTIAN)
	$(INSTALL_DATA) debian/$(PACKAGE).lintian-overrides \
		$(PKGDIR_LINTIAN)/$(PACKAGE)

endef

# End of Makefile part
