/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.sigfile.F40Format;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.Writer;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class F40Writer
implements Writer {
    private Set features = new HashSet();
    protected Format format;
    private PrintWriter out;
    private boolean isConstantValuesSaved = true;
    private String apiVersion;
    private StringBuffer buf = new StringBuffer(512);
    private ArrayList members = new ArrayList();

    public F40Writer() {
        this.format = new F40Format();
    }

    public void init(PrintWriter out) {
        this.out = out;
    }

    public void addFeature(FeaturesHolder.Feature feature) {
        assert (this.format.isFeatureSupported(feature));
        this.features.add(feature);
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void writeHeader() {
        this.out.println(this.format.getVersion());
        this.out.println("#Version " + this.apiVersion);
        if (!this.features.contains(FeaturesHolder.ConstInfo)) {
            this.out.println(FeaturesHolder.ConstInfo);
            this.isConstantValuesSaved = false;
        }
        if (!this.features.contains(FeaturesHolder.TigerInfo)) {
            this.out.println(FeaturesHolder.TigerInfo);
        }
        this.out.println("");
    }

    public void write(ClassDescription classDescription) {
        this.buf.setLength(0);
        this.members.clear();
        String clsName = classDescription.getQualifiedName();
        Iterator e = classDescription.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if ((mr.isMethod() || mr.isField() || mr.isInner()) && !clsName.equals(mr.getDeclaringClassName()) || mr.isSuperInterface() && !((SuperInterface)mr).isDirect()) continue;
            this.write(this.buf, mr);
            this.members.add(this.buf.toString());
            this.buf.setLength(0);
        }
        Collections.sort(this.members);
        this.write(this.buf, classDescription);
        this.out.println(this.buf.toString());
        int size = this.members.size();
        for (int i = 0; i < size; ++i) {
            this.out.println(this.members.get(i));
        }
        if (this.format.isFeatureSupported(FeaturesHolder.ListOfHiders)) {
            this.writeHiders(classDescription, this.buf);
        }
        this.out.println("");
    }

    protected void writeHiders(ClassDescription classDescription, StringBuffer buf) {
        this.writeInternalMembers(buf, "hfds", classDescription.getInternalFields());
        this.writeInternalMembers(buf, "hcls", classDescription.getInternalClasses());
    }

    private void write(StringBuffer buf, MemberDescription m) {
        MemberType type = m.getMemberType();
        if (type == MemberType.CLASS) {
            this.write(buf, (ClassDescription)m);
        } else if (type == MemberType.CONSTRUCTOR) {
            this.write(buf, (ConstructorDescr)m);
        } else if (type == MemberType.METHOD) {
            this.write(buf, (MethodDescr)m);
        } else if (type == MemberType.FIELD) {
            this.write(buf, (FieldDescr)m);
        } else if (type == MemberType.SUPERCLASS) {
            this.write(buf, (SuperClass)m);
        } else if (type == MemberType.SUPERINTERFACE) {
            this.write(buf, (SuperInterface)m);
        } else if (type == MemberType.INNER) {
            this.write(buf, (InnerDescr)m);
        } else assert (false);
    }

    protected void write(StringBuffer buf, ClassDescription m) {
        MemberType memberType = m.getMemberType();
        buf.append(memberType);
        String modifiers = Modifier.toString(memberType, m.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        buf.append(' ');
        buf.append(m.getQualifiedName());
        String typeParameters = m.getTypeParameters();
        if (typeParameters != null) {
            buf.append(typeParameters);
        }
        AnnotationItem[] annoList = m.getAnnoList();
        for (int i = 0; i < annoList.length; ++i) {
            buf.append("\n ");
            buf.append(annoList[i]);
        }
    }

    private void write(StringBuffer buf, ConstructorDescr m) {
        String typeParameters;
        MemberType memberType = m.getMemberType();
        buf.append(memberType);
        String modifiers = Modifier.toString(memberType, m.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        if ((typeParameters = m.getTypeParameters()) != null) {
            buf.append(' ');
            buf.append(typeParameters);
        }
        buf.append(' ');
        buf.append(m.getName());
        buf.append('(');
        buf.append(m.getArgs());
        buf.append(')');
        String throwables = m.getThrowables();
        if (throwables.length() > 0) {
            buf.append(" throws ");
            buf.append(throwables);
        }
        AnnotationItem[] annoList = m.getAnnoList();
        for (int i = 0; i < annoList.length; ++i) {
            buf.append("\n ");
            buf.append(annoList[i]);
        }
    }

    private void write(StringBuffer buf, MethodDescr m) {
        String type;
        String typeParameters;
        MemberType memberType = m.getMemberType();
        buf.append(memberType);
        String modifiers = Modifier.toString(memberType, m.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        if ((typeParameters = m.getTypeParameters()) != null) {
            buf.append(' ');
            buf.append(typeParameters);
        }
        if ((type = m.getType()).length() != 0) {
            buf.append(' ');
            buf.append(type);
        }
        buf.append(' ');
        buf.append(m.getName());
        buf.append('(');
        buf.append(m.getArgs());
        buf.append(')');
        String throwables = m.getThrowables();
        if (throwables.length() > 0) {
            buf.append(" throws ");
            buf.append(throwables);
        }
        AnnotationItem[] annoList = m.getAnnoList();
        for (int i = 0; i < annoList.length; ++i) {
            buf.append("\n ");
            buf.append(annoList[i]);
        }
    }

    private void write(StringBuffer buf, FieldDescr m) {
        String type;
        MemberType memberType = m.getMemberType();
        buf.append(memberType);
        String modifiers = Modifier.toString(memberType, m.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        if ((type = m.getType()).length() != 0) {
            buf.append(' ');
            buf.append(type);
        }
        buf.append(' ');
        buf.append(m.getName());
        String typeParameters = m.getTypeParameters();
        if (typeParameters != null) {
            buf.append(typeParameters);
        }
        String constantValue = m.getConstantValue();
        if (this.isConstantValuesSaved && constantValue != null) {
            buf.append(" = ");
            buf.append(constantValue);
        }
        AnnotationItem[] annoList = m.getAnnoList();
        for (int i = 0; i < annoList.length; ++i) {
            buf.append("\n ");
            buf.append(annoList[i]);
        }
    }

    private void write(StringBuffer buf, InnerDescr m) {
        MemberType memberType = m.getMemberType();
        buf.append(memberType);
        String modifiers = Modifier.toString(memberType, m.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        buf.append(' ');
        buf.append(m.getName());
    }

    private void write(StringBuffer buf, SuperClass m) {
        MemberType memberType = m.getMemberType();
        buf.append(memberType);
        buf.append(' ');
        buf.append(m.getQualifiedName());
        String typeParameters = m.getTypeParameters();
        if (typeParameters != null) {
            buf.append(typeParameters);
        }
    }

    private void write(StringBuffer buf, SuperInterface m) {
        MemberType memberType = m.getMemberType();
        buf.append(memberType);
        buf.append(' ');
        buf.append(m.getQualifiedName());
        String typeParameters = m.getTypeParameters();
        if (typeParameters != null) {
            buf.append(typeParameters);
        }
    }

    protected void writeInternalMembers(StringBuffer buf, String prefix, Set internalMembers) {
        ArrayList intMembers = new ArrayList();
        intMembers.addAll(internalMembers);
        Collections.sort(intMembers);
        buf.setLength(0);
        buf.append(prefix);
        buf.append(" ");
        int count = 0;
        Iterator i = intMembers.iterator();
        while (i.hasNext()) {
            if (count != 0) {
                buf.append(',');
            }
            buf.append(i.next());
            ++count;
        }
        if (count == 0) {
            buf.setLength(0);
        }
        if (buf.length() > 0) {
            this.out.println(buf);
        }
    }

    public void close() {
        this.out.close();
    }
}

